<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payroll_Timesheet_Total_Hours_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: This element is a wrapper containing one sub-element for each Payroll Timesheet Total Hours that was returned by the search criteria in the web service Request.
 * @subpackage Structs
 */
class Payroll_Timesheet_Total_Hours_Response_DataType extends AbstractStructBase
{
    /**
     * The Payroll_Timesheet_Total_Hours
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Payroll_Timesheet_Total_HoursType[]
     */
    public $Payroll_Timesheet_Total_Hours;
    /**
     * Constructor method for Payroll_Timesheet_Total_Hours_Response_DataType
     * @uses Payroll_Timesheet_Total_Hours_Response_DataType::setPayroll_Timesheet_Total_Hours()
     * @param \StructType\Payroll_Timesheet_Total_HoursType[] $payroll_Timesheet_Total_Hours
     */
    public function __construct(array $payroll_Timesheet_Total_Hours = array())
    {
        $this
            ->setPayroll_Timesheet_Total_Hours($payroll_Timesheet_Total_Hours);
    }
    /**
     * Get Payroll_Timesheet_Total_Hours value
     * @return \StructType\Payroll_Timesheet_Total_HoursType[]|null
     */
    public function getPayroll_Timesheet_Total_Hours()
    {
        return $this->Payroll_Timesheet_Total_Hours;
    }
    /**
     * This method is responsible for validating the values passed to the setPayroll_Timesheet_Total_Hours method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPayroll_Timesheet_Total_Hours method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePayroll_Timesheet_Total_HoursForArrayConstraintsFromSetPayroll_Timesheet_Total_Hours(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $payroll_Timesheet_Total_Hours_Response_DataTypePayroll_Timesheet_Total_HoursItem) {
            // validation for constraint: itemType
            if (!$payroll_Timesheet_Total_Hours_Response_DataTypePayroll_Timesheet_Total_HoursItem instanceof \StructType\Payroll_Timesheet_Total_HoursType) {
                $invalidValues[] = is_object($payroll_Timesheet_Total_Hours_Response_DataTypePayroll_Timesheet_Total_HoursItem) ? get_class($payroll_Timesheet_Total_Hours_Response_DataTypePayroll_Timesheet_Total_HoursItem) : sprintf('%s(%s)', gettype($payroll_Timesheet_Total_Hours_Response_DataTypePayroll_Timesheet_Total_HoursItem), var_export($payroll_Timesheet_Total_Hours_Response_DataTypePayroll_Timesheet_Total_HoursItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Payroll_Timesheet_Total_Hours property can only contain items of type \StructType\Payroll_Timesheet_Total_HoursType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Payroll_Timesheet_Total_Hours value
     * @throws \InvalidArgumentException
     * @param \StructType\Payroll_Timesheet_Total_HoursType[] $payroll_Timesheet_Total_Hours
     * @return \StructType\Payroll_Timesheet_Total_Hours_Response_DataType
     */
    public function setPayroll_Timesheet_Total_Hours(array $payroll_Timesheet_Total_Hours = array())
    {
        // validation for constraint: array
        if ('' !== ($payroll_Timesheet_Total_HoursArrayErrorMessage = self::validatePayroll_Timesheet_Total_HoursForArrayConstraintsFromSetPayroll_Timesheet_Total_Hours($payroll_Timesheet_Total_Hours))) {
            throw new \InvalidArgumentException($payroll_Timesheet_Total_HoursArrayErrorMessage, __LINE__);
        }
        $this->Payroll_Timesheet_Total_Hours = $payroll_Timesheet_Total_Hours;
        return $this;
    }
    /**
     * Add item to Payroll_Timesheet_Total_Hours value
     * @throws \InvalidArgumentException
     * @param \StructType\Payroll_Timesheet_Total_HoursType $item
     * @return \StructType\Payroll_Timesheet_Total_Hours_Response_DataType
     */
    public function addToPayroll_Timesheet_Total_Hours(\StructType\Payroll_Timesheet_Total_HoursType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Payroll_Timesheet_Total_HoursType) {
            throw new \InvalidArgumentException(sprintf('The Payroll_Timesheet_Total_Hours property can only contain items of type \StructType\Payroll_Timesheet_Total_HoursType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Payroll_Timesheet_Total_Hours[] = $item;
        return $this;
    }
}
