<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payroll_Timesheet_Day_Time_In_Time_Out_Hours_WWSType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Time In cannot be later than Time Out | The time interval specified by Time In and Time Out cannot overlap with a time sequence on a current or previously entered Timesheet. | Element that encapsulates one interval of time worked
 * within a day on a Time In Time Out timesheet, including the Time In, Time Out, Time Code, and Memo.
 * @subpackage Structs
 */
class Payroll_Timesheet_Day_Time_In_Time_Out_Hours_WWSType extends AbstractStructBase
{
    /**
     * The Time_In
     * Meta information extracted from the WSDL
     * - documentation: The Time In (starting time) for this work interval.
     * - maxOccurs: 1
     * @var string
     */
    public $Time_In;
    /**
     * The Time_Out
     * Meta information extracted from the WSDL
     * - documentation: The Time Out (ending time) for this work interval.
     * - maxOccurs: 1
     * @var string
     */
    public $Time_Out;
    /**
     * The Time_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: Time Code selected must be used by Earnings. | A reference to the Time Code for this work interval.
     * @var \StructType\Time_Entry_CodeObjectType
     */
    public $Time_Code_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: An optional Memo for the work interval.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * Constructor method for Payroll_Timesheet_Day_Time_In_Time_Out_Hours_WWSType
     * @uses Payroll_Timesheet_Day_Time_In_Time_Out_Hours_WWSType::setTime_In()
     * @uses Payroll_Timesheet_Day_Time_In_Time_Out_Hours_WWSType::setTime_Out()
     * @uses Payroll_Timesheet_Day_Time_In_Time_Out_Hours_WWSType::setTime_Code_Reference()
     * @uses Payroll_Timesheet_Day_Time_In_Time_Out_Hours_WWSType::setMemo()
     * @param string $time_In
     * @param string $time_Out
     * @param \StructType\Time_Entry_CodeObjectType $time_Code_Reference
     * @param string $memo
     */
    public function __construct($time_In = null, $time_Out = null, \StructType\Time_Entry_CodeObjectType $time_Code_Reference = null, $memo = null)
    {
        $this
            ->setTime_In($time_In)
            ->setTime_Out($time_Out)
            ->setTime_Code_Reference($time_Code_Reference)
            ->setMemo($memo);
    }
    /**
     * Get Time_In value
     * @return string|null
     */
    public function getTime_In()
    {
        return $this->Time_In;
    }
    /**
     * Set Time_In value
     * @param string $time_In
     * @return \StructType\Payroll_Timesheet_Day_Time_In_Time_Out_Hours_WWSType
     */
    public function setTime_In($time_In = null)
    {
        // validation for constraint: string
        if (!is_null($time_In) && !is_string($time_In)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($time_In, true), gettype($time_In)), __LINE__);
        }
        $this->Time_In = $time_In;
        return $this;
    }
    /**
     * Get Time_Out value
     * @return string|null
     */
    public function getTime_Out()
    {
        return $this->Time_Out;
    }
    /**
     * Set Time_Out value
     * @param string $time_Out
     * @return \StructType\Payroll_Timesheet_Day_Time_In_Time_Out_Hours_WWSType
     */
    public function setTime_Out($time_Out = null)
    {
        // validation for constraint: string
        if (!is_null($time_Out) && !is_string($time_Out)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($time_Out, true), gettype($time_Out)), __LINE__);
        }
        $this->Time_Out = $time_Out;
        return $this;
    }
    /**
     * Get Time_Code_Reference value
     * @return \StructType\Time_Entry_CodeObjectType|null
     */
    public function getTime_Code_Reference()
    {
        return $this->Time_Code_Reference;
    }
    /**
     * Set Time_Code_Reference value
     * @param \StructType\Time_Entry_CodeObjectType $time_Code_Reference
     * @return \StructType\Payroll_Timesheet_Day_Time_In_Time_Out_Hours_WWSType
     */
    public function setTime_Code_Reference(\StructType\Time_Entry_CodeObjectType $time_Code_Reference = null)
    {
        $this->Time_Code_Reference = $time_Code_Reference;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Payroll_Timesheet_Day_Time_In_Time_Out_Hours_WWSType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
}
