<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Patient_Charge_Information_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element Containing Purchase Item HCPCS value and Patient Charge Information Row subelement
 * @subpackage Structs
 */
class Patient_Charge_Information_DataType extends AbstractStructBase
{
    /**
     * The Purchase_Item_ID
     * Meta information extracted from the WSDL
     * - documentation: Purchase Item ID. This is the Purchase Item unique identifier
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Purchase_Item_ID;
    /**
     * The HCPCS
     * Meta information extracted from the WSDL
     * - documentation: Purchase Item HCPCS Code
     * - base: xsd:string
     * - maxLength: 5
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HCPCS;
    /**
     * The Patient_Chargeable_Reference
     * Meta information extracted from the WSDL
     * - documentation: Added Patient Chargeable field on Purchase Item
     * - minOccurs: 0
     * @var \StructType\Patient_ChargeObjectType
     */
    public $Patient_Chargeable_Reference;
    /**
     * The Patient_Charge_Information_Row_Data
     * Meta information extracted from the WSDL
     * - documentation: Patient Charge Information Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Patient_Charge_Information_Row_DataType[]
     */
    public $Patient_Charge_Information_Row_Data;
    /**
     * Constructor method for Patient_Charge_Information_DataType
     * @uses Patient_Charge_Information_DataType::setPurchase_Item_ID()
     * @uses Patient_Charge_Information_DataType::setHCPCS()
     * @uses Patient_Charge_Information_DataType::setPatient_Chargeable_Reference()
     * @uses Patient_Charge_Information_DataType::setPatient_Charge_Information_Row_Data()
     * @param string $purchase_Item_ID
     * @param string $hCPCS
     * @param \StructType\Patient_ChargeObjectType $patient_Chargeable_Reference
     * @param \StructType\Patient_Charge_Information_Row_DataType[] $patient_Charge_Information_Row_Data
     */
    public function __construct($purchase_Item_ID = null, $hCPCS = null, \StructType\Patient_ChargeObjectType $patient_Chargeable_Reference = null, array $patient_Charge_Information_Row_Data = array())
    {
        $this
            ->setPurchase_Item_ID($purchase_Item_ID)
            ->setHCPCS($hCPCS)
            ->setPatient_Chargeable_Reference($patient_Chargeable_Reference)
            ->setPatient_Charge_Information_Row_Data($patient_Charge_Information_Row_Data);
    }
    /**
     * Get Purchase_Item_ID value
     * @return string|null
     */
    public function getPurchase_Item_ID()
    {
        return $this->Purchase_Item_ID;
    }
    /**
     * Set Purchase_Item_ID value
     * @param string $purchase_Item_ID
     * @return \StructType\Patient_Charge_Information_DataType
     */
    public function setPurchase_Item_ID($purchase_Item_ID = null)
    {
        // validation for constraint: string
        if (!is_null($purchase_Item_ID) && !is_string($purchase_Item_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchase_Item_ID, true), gettype($purchase_Item_ID)), __LINE__);
        }
        $this->Purchase_Item_ID = $purchase_Item_ID;
        return $this;
    }
    /**
     * Get HCPCS value
     * @return string|null
     */
    public function getHCPCS()
    {
        return $this->HCPCS;
    }
    /**
     * Set HCPCS value
     * @param string $hCPCS
     * @return \StructType\Patient_Charge_Information_DataType
     */
    public function setHCPCS($hCPCS = null)
    {
        // validation for constraint: string
        if (!is_null($hCPCS) && !is_string($hCPCS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hCPCS, true), gettype($hCPCS)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($hCPCS) && mb_strlen($hCPCS) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($hCPCS)), __LINE__);
        }
        $this->HCPCS = $hCPCS;
        return $this;
    }
    /**
     * Get Patient_Chargeable_Reference value
     * @return \StructType\Patient_ChargeObjectType|null
     */
    public function getPatient_Chargeable_Reference()
    {
        return $this->Patient_Chargeable_Reference;
    }
    /**
     * Set Patient_Chargeable_Reference value
     * @param \StructType\Patient_ChargeObjectType $patient_Chargeable_Reference
     * @return \StructType\Patient_Charge_Information_DataType
     */
    public function setPatient_Chargeable_Reference(\StructType\Patient_ChargeObjectType $patient_Chargeable_Reference = null)
    {
        $this->Patient_Chargeable_Reference = $patient_Chargeable_Reference;
        return $this;
    }
    /**
     * Get Patient_Charge_Information_Row_Data value
     * @return \StructType\Patient_Charge_Information_Row_DataType[]|null
     */
    public function getPatient_Charge_Information_Row_Data()
    {
        return $this->Patient_Charge_Information_Row_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setPatient_Charge_Information_Row_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPatient_Charge_Information_Row_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePatient_Charge_Information_Row_DataForArrayConstraintsFromSetPatient_Charge_Information_Row_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $patient_Charge_Information_DataTypePatient_Charge_Information_Row_DataItem) {
            // validation for constraint: itemType
            if (!$patient_Charge_Information_DataTypePatient_Charge_Information_Row_DataItem instanceof \StructType\Patient_Charge_Information_Row_DataType) {
                $invalidValues[] = is_object($patient_Charge_Information_DataTypePatient_Charge_Information_Row_DataItem) ? get_class($patient_Charge_Information_DataTypePatient_Charge_Information_Row_DataItem) : sprintf('%s(%s)', gettype($patient_Charge_Information_DataTypePatient_Charge_Information_Row_DataItem), var_export($patient_Charge_Information_DataTypePatient_Charge_Information_Row_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Patient_Charge_Information_Row_Data property can only contain items of type \StructType\Patient_Charge_Information_Row_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Patient_Charge_Information_Row_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Patient_Charge_Information_Row_DataType[] $patient_Charge_Information_Row_Data
     * @return \StructType\Patient_Charge_Information_DataType
     */
    public function setPatient_Charge_Information_Row_Data(array $patient_Charge_Information_Row_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($patient_Charge_Information_Row_DataArrayErrorMessage = self::validatePatient_Charge_Information_Row_DataForArrayConstraintsFromSetPatient_Charge_Information_Row_Data($patient_Charge_Information_Row_Data))) {
            throw new \InvalidArgumentException($patient_Charge_Information_Row_DataArrayErrorMessage, __LINE__);
        }
        $this->Patient_Charge_Information_Row_Data = $patient_Charge_Information_Row_Data;
        return $this;
    }
    /**
     * Add item to Patient_Charge_Information_Row_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Patient_Charge_Information_Row_DataType $item
     * @return \StructType\Patient_Charge_Information_DataType
     */
    public function addToPatient_Charge_Information_Row_Data(\StructType\Patient_Charge_Information_Row_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Patient_Charge_Information_Row_DataType) {
            throw new \InvalidArgumentException(sprintf('The Patient_Charge_Information_Row_Data property can only contain items of type \StructType\Patient_Charge_Information_Row_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Patient_Charge_Information_Row_Data[] = $item;
        return $this;
    }
}
