<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Netting_Transaction_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains reference instances for Netting Transactions
 * @subpackage Structs
 */
class Netting_Transaction_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Netting_Transaction_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Netting Transaction
     * - maxOccurs: unbounded
     * @var \StructType\Netting_TransactionObjectType[]
     */
    public $Netting_Transaction_Reference;
    /**
     * Constructor method for Netting_Transaction_Request_ReferencesType
     * @uses Netting_Transaction_Request_ReferencesType::setNetting_Transaction_Reference()
     * @param \StructType\Netting_TransactionObjectType[] $netting_Transaction_Reference
     */
    public function __construct(array $netting_Transaction_Reference = array())
    {
        $this
            ->setNetting_Transaction_Reference($netting_Transaction_Reference);
    }
    /**
     * Get Netting_Transaction_Reference value
     * @return \StructType\Netting_TransactionObjectType[]|null
     */
    public function getNetting_Transaction_Reference()
    {
        return $this->Netting_Transaction_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setNetting_Transaction_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNetting_Transaction_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNetting_Transaction_ReferenceForArrayConstraintsFromSetNetting_Transaction_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $netting_Transaction_Request_ReferencesTypeNetting_Transaction_ReferenceItem) {
            // validation for constraint: itemType
            if (!$netting_Transaction_Request_ReferencesTypeNetting_Transaction_ReferenceItem instanceof \StructType\Netting_TransactionObjectType) {
                $invalidValues[] = is_object($netting_Transaction_Request_ReferencesTypeNetting_Transaction_ReferenceItem) ? get_class($netting_Transaction_Request_ReferencesTypeNetting_Transaction_ReferenceItem) : sprintf('%s(%s)', gettype($netting_Transaction_Request_ReferencesTypeNetting_Transaction_ReferenceItem), var_export($netting_Transaction_Request_ReferencesTypeNetting_Transaction_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Netting_Transaction_Reference property can only contain items of type \StructType\Netting_TransactionObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Netting_Transaction_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Netting_TransactionObjectType[] $netting_Transaction_Reference
     * @return \StructType\Netting_Transaction_Request_ReferencesType
     */
    public function setNetting_Transaction_Reference(array $netting_Transaction_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($netting_Transaction_ReferenceArrayErrorMessage = self::validateNetting_Transaction_ReferenceForArrayConstraintsFromSetNetting_Transaction_Reference($netting_Transaction_Reference))) {
            throw new \InvalidArgumentException($netting_Transaction_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Netting_Transaction_Reference = $netting_Transaction_Reference;
        return $this;
    }
    /**
     * Add item to Netting_Transaction_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Netting_TransactionObjectType $item
     * @return \StructType\Netting_Transaction_Request_ReferencesType
     */
    public function addToNetting_Transaction_Reference(\StructType\Netting_TransactionObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Netting_TransactionObjectType) {
            throw new \InvalidArgumentException(sprintf('The Netting_Transaction_Reference property can only contain items of type \StructType\Netting_TransactionObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Netting_Transaction_Reference[] = $item;
        return $this;
    }
}
