<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Maintain_Asset_Shares_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Root element for the Response on the Put operation
 * @subpackage Structs
 */
class Maintain_Asset_Shares_ResponseType extends AbstractStructBase
{
    /**
     * The Asset_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the asset to which the asset shares apply.
     * - minOccurs: 0
     * @var \StructType\Business_AssetObjectType
     */
    public $Asset_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Maintain_Asset_Shares_ResponseType
     * @uses Maintain_Asset_Shares_ResponseType::setAsset_Reference()
     * @uses Maintain_Asset_Shares_ResponseType::setVersion()
     * @param \StructType\Business_AssetObjectType $asset_Reference
     * @param string $version
     */
    public function __construct(\StructType\Business_AssetObjectType $asset_Reference = null, $version = null)
    {
        $this
            ->setAsset_Reference($asset_Reference)
            ->setVersion($version);
    }
    /**
     * Get Asset_Reference value
     * @return \StructType\Business_AssetObjectType|null
     */
    public function getAsset_Reference()
    {
        return $this->Asset_Reference;
    }
    /**
     * Set Asset_Reference value
     * @param \StructType\Business_AssetObjectType $asset_Reference
     * @return \StructType\Maintain_Asset_Shares_ResponseType
     */
    public function setAsset_Reference(\StructType\Business_AssetObjectType $asset_Reference = null)
    {
        $this->Asset_Reference = $asset_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Maintain_Asset_Shares_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
