<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * Location_Customer_Account_Number_Detail_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: "References" element allowing the specification of specific object instances to be returned based on ID values.
 * @subpackage Structs
 */
class Location_Customer_Account_Number_Detail_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Location_Customer_Account_Number_Detail_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing Location Customer Account Number Details.
     * - maxOccurs: unbounded
     * @var \StructType\Location_Customer_Account_Number_DetailObjectType[]
     */
    public $Location_Customer_Account_Number_Detail_Reference;
    /**
     * Constructor method for
     * Location_Customer_Account_Number_Detail_Request_ReferencesType
     * @uses Location_Customer_Account_Number_Detail_Request_ReferencesType::setLocation_Customer_Account_Number_Detail_Reference()
     * @param \StructType\Location_Customer_Account_Number_DetailObjectType[] $location_Customer_Account_Number_Detail_Reference
     */
    public function __construct(array $location_Customer_Account_Number_Detail_Reference = array())
    {
        $this
            ->setLocation_Customer_Account_Number_Detail_Reference($location_Customer_Account_Number_Detail_Reference);
    }
    /**
     * Get Location_Customer_Account_Number_Detail_Reference value
     * @return \StructType\Location_Customer_Account_Number_DetailObjectType[]|null
     */
    public function getLocation_Customer_Account_Number_Detail_Reference()
    {
        return $this->Location_Customer_Account_Number_Detail_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setLocation_Customer_Account_Number_Detail_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocation_Customer_Account_Number_Detail_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocation_Customer_Account_Number_Detail_ReferenceForArrayConstraintsFromSetLocation_Customer_Account_Number_Detail_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $location_Customer_Account_Number_Detail_Request_ReferencesTypeLocation_Customer_Account_Number_Detail_ReferenceItem) {
            // validation for constraint: itemType
            if (!$location_Customer_Account_Number_Detail_Request_ReferencesTypeLocation_Customer_Account_Number_Detail_ReferenceItem instanceof \StructType\Location_Customer_Account_Number_DetailObjectType) {
                $invalidValues[] = is_object($location_Customer_Account_Number_Detail_Request_ReferencesTypeLocation_Customer_Account_Number_Detail_ReferenceItem) ? get_class($location_Customer_Account_Number_Detail_Request_ReferencesTypeLocation_Customer_Account_Number_Detail_ReferenceItem) : sprintf('%s(%s)', gettype($location_Customer_Account_Number_Detail_Request_ReferencesTypeLocation_Customer_Account_Number_Detail_ReferenceItem), var_export($location_Customer_Account_Number_Detail_Request_ReferencesTypeLocation_Customer_Account_Number_Detail_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Location_Customer_Account_Number_Detail_Reference property can only contain items of type \StructType\Location_Customer_Account_Number_DetailObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Location_Customer_Account_Number_Detail_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Location_Customer_Account_Number_DetailObjectType[] $location_Customer_Account_Number_Detail_Reference
     * @return \StructType\Location_Customer_Account_Number_Detail_Request_ReferencesType
     */
    public function setLocation_Customer_Account_Number_Detail_Reference(array $location_Customer_Account_Number_Detail_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($location_Customer_Account_Number_Detail_ReferenceArrayErrorMessage = self::validateLocation_Customer_Account_Number_Detail_ReferenceForArrayConstraintsFromSetLocation_Customer_Account_Number_Detail_Reference($location_Customer_Account_Number_Detail_Reference))) {
            throw new \InvalidArgumentException($location_Customer_Account_Number_Detail_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Location_Customer_Account_Number_Detail_Reference = $location_Customer_Account_Number_Detail_Reference;
        return $this;
    }
    /**
     * Add item to Location_Customer_Account_Number_Detail_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Location_Customer_Account_Number_DetailObjectType $item
     * @return \StructType\Location_Customer_Account_Number_Detail_Request_ReferencesType
     */
    public function addToLocation_Customer_Account_Number_Detail_Reference(\StructType\Location_Customer_Account_Number_DetailObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Location_Customer_Account_Number_DetailObjectType) {
            throw new \InvalidArgumentException(sprintf('The Location_Customer_Account_Number_Detail_Reference property can only contain items of type \StructType\Location_Customer_Account_Number_DetailObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Location_Customer_Account_Number_Detail_Reference[] = $item;
        return $this;
    }
}
