<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Item_Substitute_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Item Substitute for the purchase item.
 * @subpackage Structs
 */
class Item_Substitute_DataType extends AbstractStructBase
{
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company/Company Hierarchy for Item Substitution
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrganizationObjectType[]
     */
    public $Company_Reference;
    /**
     * The Deliver_To_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: Location/Location Hierarchy for Item Substitution
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_Location_or_Location_HierarchyObjectType[]
     */
    public $Deliver_To_Location_Reference;
    /**
     * The Substitute_Priority
     * Meta information extracted from the WSDL
     * - documentation: Ranking of Item Substitutes.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 6
     * @var float
     */
    public $Substitute_Priority;
    /**
     * The Item_Substitute_Reference
     * Meta information extracted from the WSDL
     * - documentation: Item Substitute
     * - minOccurs: 0
     * @var \StructType\Purchase_ItemObjectType
     */
    public $Item_Substitute_Reference;
    /**
     * The Exclude_Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: A company that does not accept the substitute item.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrganizationObjectType[]
     */
    public $Exclude_Company_Reference;
    /**
     * The Exclude_Deliver_To_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: A deliver-to location that does not accept the substitute item.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_Location_or_Location_HierarchyObjectType[]
     */
    public $Exclude_Deliver_To_Location_Reference;
    /**
     * The Usage_Reference
     * Meta information extracted from the WSDL
     * - documentation: Usages of Purchase Item substitute.
     * - maxOccurs: unbounded
     * @var \StructType\Item_Substitute_UsageObjectType[]
     */
    public $Usage_Reference;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Item Substitute Inactive
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * Constructor method for Item_Substitute_DataType
     * @uses Item_Substitute_DataType::setCompany_Reference()
     * @uses Item_Substitute_DataType::setDeliver_To_Location_Reference()
     * @uses Item_Substitute_DataType::setSubstitute_Priority()
     * @uses Item_Substitute_DataType::setItem_Substitute_Reference()
     * @uses Item_Substitute_DataType::setExclude_Company_Reference()
     * @uses Item_Substitute_DataType::setExclude_Deliver_To_Location_Reference()
     * @uses Item_Substitute_DataType::setUsage_Reference()
     * @uses Item_Substitute_DataType::setInactive()
     * @param \StructType\OrganizationObjectType[] $company_Reference
     * @param \StructType\Asset_Location_or_Location_HierarchyObjectType[] $deliver_To_Location_Reference
     * @param float $substitute_Priority
     * @param \StructType\Purchase_ItemObjectType $item_Substitute_Reference
     * @param \StructType\OrganizationObjectType[] $exclude_Company_Reference
     * @param \StructType\Asset_Location_or_Location_HierarchyObjectType[] $exclude_Deliver_To_Location_Reference
     * @param \StructType\Item_Substitute_UsageObjectType[] $usage_Reference
     * @param bool $inactive
     */
    public function __construct(array $company_Reference = array(), array $deliver_To_Location_Reference = array(), $substitute_Priority = null, \StructType\Purchase_ItemObjectType $item_Substitute_Reference = null, array $exclude_Company_Reference = array(), array $exclude_Deliver_To_Location_Reference = array(), array $usage_Reference = array(), $inactive = null)
    {
        $this
            ->setCompany_Reference($company_Reference)
            ->setDeliver_To_Location_Reference($deliver_To_Location_Reference)
            ->setSubstitute_Priority($substitute_Priority)
            ->setItem_Substitute_Reference($item_Substitute_Reference)
            ->setExclude_Company_Reference($exclude_Company_Reference)
            ->setExclude_Deliver_To_Location_Reference($exclude_Deliver_To_Location_Reference)
            ->setUsage_Reference($usage_Reference)
            ->setInactive($inactive);
    }
    /**
     * Get Company_Reference value
     * @return \StructType\OrganizationObjectType[]|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCompany_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $item_Substitute_DataTypeCompany_ReferenceItem) {
            // validation for constraint: itemType
            if (!$item_Substitute_DataTypeCompany_ReferenceItem instanceof \StructType\OrganizationObjectType) {
                $invalidValues[] = is_object($item_Substitute_DataTypeCompany_ReferenceItem) ? get_class($item_Substitute_DataTypeCompany_ReferenceItem) : sprintf('%s(%s)', gettype($item_Substitute_DataTypeCompany_ReferenceItem), var_export($item_Substitute_DataTypeCompany_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Company_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType[] $company_Reference
     * @return \StructType\Item_Substitute_DataType
     */
    public function setCompany_Reference(array $company_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($company_ReferenceArrayErrorMessage = self::validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference($company_Reference))) {
            throw new \InvalidArgumentException($company_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Add item to Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType $item
     * @return \StructType\Item_Substitute_DataType
     */
    public function addToCompany_Reference(\StructType\OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Company_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Company_Reference[] = $item;
        return $this;
    }
    /**
     * Get Deliver_To_Location_Reference value
     * @return \StructType\Asset_Location_or_Location_HierarchyObjectType[]|null
     */
    public function getDeliver_To_Location_Reference()
    {
        return $this->{'Deliver-To_Location_Reference'};
    }
    /**
     * This method is responsible for validating the values passed to the setDeliver_To_Location_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeliver_To_Location_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeliver_To_Location_ReferenceForArrayConstraintsFromSetDeliver_To_Location_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $item_Substitute_DataTypeDeliver_To_Location_ReferenceItem) {
            // validation for constraint: itemType
            if (!$item_Substitute_DataTypeDeliver_To_Location_ReferenceItem instanceof \StructType\Asset_Location_or_Location_HierarchyObjectType) {
                $invalidValues[] = is_object($item_Substitute_DataTypeDeliver_To_Location_ReferenceItem) ? get_class($item_Substitute_DataTypeDeliver_To_Location_ReferenceItem) : sprintf('%s(%s)', gettype($item_Substitute_DataTypeDeliver_To_Location_ReferenceItem), var_export($item_Substitute_DataTypeDeliver_To_Location_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Deliver_To_Location_Reference property can only contain items of type \StructType\Asset_Location_or_Location_HierarchyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Deliver_To_Location_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Location_or_Location_HierarchyObjectType[] $deliver_To_Location_Reference
     * @return \StructType\Item_Substitute_DataType
     */
    public function setDeliver_To_Location_Reference(array $deliver_To_Location_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($deliver_To_Location_ReferenceArrayErrorMessage = self::validateDeliver_To_Location_ReferenceForArrayConstraintsFromSetDeliver_To_Location_Reference($deliver_To_Location_Reference))) {
            throw new \InvalidArgumentException($deliver_To_Location_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Deliver_To_Location_Reference = $this->{'Deliver-To_Location_Reference'} = $deliver_To_Location_Reference;
        return $this;
    }
    /**
     * Add item to Deliver_To_Location_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Location_or_Location_HierarchyObjectType $item
     * @return \StructType\Item_Substitute_DataType
     */
    public function addToDeliver_To_Location_Reference(\StructType\Asset_Location_or_Location_HierarchyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_Location_or_Location_HierarchyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Deliver_To_Location_Reference property can only contain items of type \StructType\Asset_Location_or_Location_HierarchyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Deliver_To_Location_Reference[] = $this->{'Deliver-To_Location_Reference'}[] = $item;
        return $this;
    }
    /**
     * Get Substitute_Priority value
     * @return float|null
     */
    public function getSubstitute_Priority()
    {
        return $this->Substitute_Priority;
    }
    /**
     * Set Substitute_Priority value
     * @param float $substitute_Priority
     * @return \StructType\Item_Substitute_DataType
     */
    public function setSubstitute_Priority($substitute_Priority = null)
    {
        // validation for constraint: float
        if (!is_null($substitute_Priority) && !(is_float($substitute_Priority) || is_numeric($substitute_Priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($substitute_Priority, true), gettype($substitute_Priority)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($substitute_Priority) && mb_strlen(mb_substr($substitute_Priority, false !== mb_strpos($substitute_Priority, '.') ? mb_strpos($substitute_Priority, '.') + 1 : mb_strlen($substitute_Priority))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($substitute_Priority, true), mb_strlen(mb_substr($substitute_Priority, mb_strpos($substitute_Priority, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($substitute_Priority) && $substitute_Priority < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($substitute_Priority, true)), __LINE__);
        }
        // validation for constraint: totalDigits(6)
        if (!is_null($substitute_Priority) && mb_strlen(preg_replace('/(\D)/', '', $substitute_Priority)) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 6 digits, "%d" given', var_export($substitute_Priority, true), mb_strlen(preg_replace('/(\D)/', '', $substitute_Priority))), __LINE__);
        }
        $this->Substitute_Priority = $substitute_Priority;
        return $this;
    }
    /**
     * Get Item_Substitute_Reference value
     * @return \StructType\Purchase_ItemObjectType|null
     */
    public function getItem_Substitute_Reference()
    {
        return $this->Item_Substitute_Reference;
    }
    /**
     * Set Item_Substitute_Reference value
     * @param \StructType\Purchase_ItemObjectType $item_Substitute_Reference
     * @return \StructType\Item_Substitute_DataType
     */
    public function setItem_Substitute_Reference(\StructType\Purchase_ItemObjectType $item_Substitute_Reference = null)
    {
        $this->Item_Substitute_Reference = $item_Substitute_Reference;
        return $this;
    }
    /**
     * Get Exclude_Company_Reference value
     * @return \StructType\OrganizationObjectType[]|null
     */
    public function getExclude_Company_Reference()
    {
        return $this->Exclude_Company_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setExclude_Company_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExclude_Company_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExclude_Company_ReferenceForArrayConstraintsFromSetExclude_Company_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $item_Substitute_DataTypeExclude_Company_ReferenceItem) {
            // validation for constraint: itemType
            if (!$item_Substitute_DataTypeExclude_Company_ReferenceItem instanceof \StructType\OrganizationObjectType) {
                $invalidValues[] = is_object($item_Substitute_DataTypeExclude_Company_ReferenceItem) ? get_class($item_Substitute_DataTypeExclude_Company_ReferenceItem) : sprintf('%s(%s)', gettype($item_Substitute_DataTypeExclude_Company_ReferenceItem), var_export($item_Substitute_DataTypeExclude_Company_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Exclude_Company_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Exclude_Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType[] $exclude_Company_Reference
     * @return \StructType\Item_Substitute_DataType
     */
    public function setExclude_Company_Reference(array $exclude_Company_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($exclude_Company_ReferenceArrayErrorMessage = self::validateExclude_Company_ReferenceForArrayConstraintsFromSetExclude_Company_Reference($exclude_Company_Reference))) {
            throw new \InvalidArgumentException($exclude_Company_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Exclude_Company_Reference = $exclude_Company_Reference;
        return $this;
    }
    /**
     * Add item to Exclude_Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType $item
     * @return \StructType\Item_Substitute_DataType
     */
    public function addToExclude_Company_Reference(\StructType\OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Exclude_Company_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Exclude_Company_Reference[] = $item;
        return $this;
    }
    /**
     * Get Exclude_Deliver_To_Location_Reference value
     * @return \StructType\Asset_Location_or_Location_HierarchyObjectType[]|null
     */
    public function getExclude_Deliver_To_Location_Reference()
    {
        return $this->{'Exclude_Deliver-To_Location_Reference'};
    }
    /**
     * This method is responsible for validating the values passed to the setExclude_Deliver_To_Location_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExclude_Deliver_To_Location_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExclude_Deliver_To_Location_ReferenceForArrayConstraintsFromSetExclude_Deliver_To_Location_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $item_Substitute_DataTypeExclude_Deliver_To_Location_ReferenceItem) {
            // validation for constraint: itemType
            if (!$item_Substitute_DataTypeExclude_Deliver_To_Location_ReferenceItem instanceof \StructType\Asset_Location_or_Location_HierarchyObjectType) {
                $invalidValues[] = is_object($item_Substitute_DataTypeExclude_Deliver_To_Location_ReferenceItem) ? get_class($item_Substitute_DataTypeExclude_Deliver_To_Location_ReferenceItem) : sprintf('%s(%s)', gettype($item_Substitute_DataTypeExclude_Deliver_To_Location_ReferenceItem), var_export($item_Substitute_DataTypeExclude_Deliver_To_Location_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Exclude_Deliver_To_Location_Reference property can only contain items of type \StructType\Asset_Location_or_Location_HierarchyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Exclude_Deliver_To_Location_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Location_or_Location_HierarchyObjectType[] $exclude_Deliver_To_Location_Reference
     * @return \StructType\Item_Substitute_DataType
     */
    public function setExclude_Deliver_To_Location_Reference(array $exclude_Deliver_To_Location_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($exclude_Deliver_To_Location_ReferenceArrayErrorMessage = self::validateExclude_Deliver_To_Location_ReferenceForArrayConstraintsFromSetExclude_Deliver_To_Location_Reference($exclude_Deliver_To_Location_Reference))) {
            throw new \InvalidArgumentException($exclude_Deliver_To_Location_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Exclude_Deliver_To_Location_Reference = $this->{'Exclude_Deliver-To_Location_Reference'} = $exclude_Deliver_To_Location_Reference;
        return $this;
    }
    /**
     * Add item to Exclude_Deliver_To_Location_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Location_or_Location_HierarchyObjectType $item
     * @return \StructType\Item_Substitute_DataType
     */
    public function addToExclude_Deliver_To_Location_Reference(\StructType\Asset_Location_or_Location_HierarchyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_Location_or_Location_HierarchyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Exclude_Deliver_To_Location_Reference property can only contain items of type \StructType\Asset_Location_or_Location_HierarchyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Exclude_Deliver_To_Location_Reference[] = $this->{'Exclude_Deliver-To_Location_Reference'}[] = $item;
        return $this;
    }
    /**
     * Get Usage_Reference value
     * @return \StructType\Item_Substitute_UsageObjectType[]|null
     */
    public function getUsage_Reference()
    {
        return $this->Usage_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setUsage_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUsage_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUsage_ReferenceForArrayConstraintsFromSetUsage_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $item_Substitute_DataTypeUsage_ReferenceItem) {
            // validation for constraint: itemType
            if (!$item_Substitute_DataTypeUsage_ReferenceItem instanceof \StructType\Item_Substitute_UsageObjectType) {
                $invalidValues[] = is_object($item_Substitute_DataTypeUsage_ReferenceItem) ? get_class($item_Substitute_DataTypeUsage_ReferenceItem) : sprintf('%s(%s)', gettype($item_Substitute_DataTypeUsage_ReferenceItem), var_export($item_Substitute_DataTypeUsage_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Usage_Reference property can only contain items of type \StructType\Item_Substitute_UsageObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Usage_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_Substitute_UsageObjectType[] $usage_Reference
     * @return \StructType\Item_Substitute_DataType
     */
    public function setUsage_Reference(array $usage_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($usage_ReferenceArrayErrorMessage = self::validateUsage_ReferenceForArrayConstraintsFromSetUsage_Reference($usage_Reference))) {
            throw new \InvalidArgumentException($usage_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Usage_Reference = $usage_Reference;
        return $this;
    }
    /**
     * Add item to Usage_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_Substitute_UsageObjectType $item
     * @return \StructType\Item_Substitute_DataType
     */
    public function addToUsage_Reference(\StructType\Item_Substitute_UsageObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Item_Substitute_UsageObjectType) {
            throw new \InvalidArgumentException(sprintf('The Usage_Reference property can only contain items of type \StructType\Item_Substitute_UsageObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Usage_Reference[] = $item;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Item_Substitute_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
}
