<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Item_Identifier_Type_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: The response data element for item identifier type.
 * @subpackage Structs
 */
class Item_Identifier_Type_Response_DataType extends AbstractStructBase
{
    /**
     * The Item_Identifier_Type
     * Meta information extracted from the WSDL
     * - documentation: The element containing item identifier type reference and item identifier type data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Item_Identifier_TypeType[]
     */
    public $Item_Identifier_Type;
    /**
     * Constructor method for Item_Identifier_Type_Response_DataType
     * @uses Item_Identifier_Type_Response_DataType::setItem_Identifier_Type()
     * @param \StructType\Item_Identifier_TypeType[] $item_Identifier_Type
     */
    public function __construct(array $item_Identifier_Type = array())
    {
        $this
            ->setItem_Identifier_Type($item_Identifier_Type);
    }
    /**
     * Get Item_Identifier_Type value
     * @return \StructType\Item_Identifier_TypeType[]|null
     */
    public function getItem_Identifier_Type()
    {
        return $this->Item_Identifier_Type;
    }
    /**
     * This method is responsible for validating the values passed to the setItem_Identifier_Type method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem_Identifier_Type method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItem_Identifier_TypeForArrayConstraintsFromSetItem_Identifier_Type(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $item_Identifier_Type_Response_DataTypeItem_Identifier_TypeItem) {
            // validation for constraint: itemType
            if (!$item_Identifier_Type_Response_DataTypeItem_Identifier_TypeItem instanceof \StructType\Item_Identifier_TypeType) {
                $invalidValues[] = is_object($item_Identifier_Type_Response_DataTypeItem_Identifier_TypeItem) ? get_class($item_Identifier_Type_Response_DataTypeItem_Identifier_TypeItem) : sprintf('%s(%s)', gettype($item_Identifier_Type_Response_DataTypeItem_Identifier_TypeItem), var_export($item_Identifier_Type_Response_DataTypeItem_Identifier_TypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item_Identifier_Type property can only contain items of type \StructType\Item_Identifier_TypeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item_Identifier_Type value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_Identifier_TypeType[] $item_Identifier_Type
     * @return \StructType\Item_Identifier_Type_Response_DataType
     */
    public function setItem_Identifier_Type(array $item_Identifier_Type = array())
    {
        // validation for constraint: array
        if ('' !== ($item_Identifier_TypeArrayErrorMessage = self::validateItem_Identifier_TypeForArrayConstraintsFromSetItem_Identifier_Type($item_Identifier_Type))) {
            throw new \InvalidArgumentException($item_Identifier_TypeArrayErrorMessage, __LINE__);
        }
        $this->Item_Identifier_Type = $item_Identifier_Type;
        return $this;
    }
    /**
     * Add item to Item_Identifier_Type value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_Identifier_TypeType $item
     * @return \StructType\Item_Identifier_Type_Response_DataType
     */
    public function addToItem_Identifier_Type(\StructType\Item_Identifier_TypeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Item_Identifier_TypeType) {
            throw new \InvalidArgumentException(sprintf('The Item_Identifier_Type property can only contain items of type \StructType\Item_Identifier_TypeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item_Identifier_Type[] = $item;
        return $this;
    }
}
