<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Item_Identifier_TypeType StructType
 * Meta information extracted from the WSDL
 * - documentation: The element containing item identifier type.
 * @subpackage Structs
 */
class Item_Identifier_TypeType extends AbstractStructBase
{
    /**
     * The Item_Identifier_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: The item identifier type reverence.
     * - minOccurs: 0
     * @var \StructType\Item_Identifier_TypeObjectType
     */
    public $Item_Identifier_Type_Reference;
    /**
     * The Item_Identifier_Type_Data
     * Meta information extracted from the WSDL
     * - documentation: The element containing data associated with item identifier type.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Item_Identifier_Type_DataType[]
     */
    public $Item_Identifier_Type_Data;
    /**
     * Constructor method for Item_Identifier_TypeType
     * @uses Item_Identifier_TypeType::setItem_Identifier_Type_Reference()
     * @uses Item_Identifier_TypeType::setItem_Identifier_Type_Data()
     * @param \StructType\Item_Identifier_TypeObjectType $item_Identifier_Type_Reference
     * @param \StructType\Item_Identifier_Type_DataType[] $item_Identifier_Type_Data
     */
    public function __construct(\StructType\Item_Identifier_TypeObjectType $item_Identifier_Type_Reference = null, array $item_Identifier_Type_Data = array())
    {
        $this
            ->setItem_Identifier_Type_Reference($item_Identifier_Type_Reference)
            ->setItem_Identifier_Type_Data($item_Identifier_Type_Data);
    }
    /**
     * Get Item_Identifier_Type_Reference value
     * @return \StructType\Item_Identifier_TypeObjectType|null
     */
    public function getItem_Identifier_Type_Reference()
    {
        return $this->Item_Identifier_Type_Reference;
    }
    /**
     * Set Item_Identifier_Type_Reference value
     * @param \StructType\Item_Identifier_TypeObjectType $item_Identifier_Type_Reference
     * @return \StructType\Item_Identifier_TypeType
     */
    public function setItem_Identifier_Type_Reference(\StructType\Item_Identifier_TypeObjectType $item_Identifier_Type_Reference = null)
    {
        $this->Item_Identifier_Type_Reference = $item_Identifier_Type_Reference;
        return $this;
    }
    /**
     * Get Item_Identifier_Type_Data value
     * @return \StructType\Item_Identifier_Type_DataType[]|null
     */
    public function getItem_Identifier_Type_Data()
    {
        return $this->Item_Identifier_Type_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setItem_Identifier_Type_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem_Identifier_Type_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItem_Identifier_Type_DataForArrayConstraintsFromSetItem_Identifier_Type_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $item_Identifier_TypeTypeItem_Identifier_Type_DataItem) {
            // validation for constraint: itemType
            if (!$item_Identifier_TypeTypeItem_Identifier_Type_DataItem instanceof \StructType\Item_Identifier_Type_DataType) {
                $invalidValues[] = is_object($item_Identifier_TypeTypeItem_Identifier_Type_DataItem) ? get_class($item_Identifier_TypeTypeItem_Identifier_Type_DataItem) : sprintf('%s(%s)', gettype($item_Identifier_TypeTypeItem_Identifier_Type_DataItem), var_export($item_Identifier_TypeTypeItem_Identifier_Type_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item_Identifier_Type_Data property can only contain items of type \StructType\Item_Identifier_Type_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item_Identifier_Type_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_Identifier_Type_DataType[] $item_Identifier_Type_Data
     * @return \StructType\Item_Identifier_TypeType
     */
    public function setItem_Identifier_Type_Data(array $item_Identifier_Type_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($item_Identifier_Type_DataArrayErrorMessage = self::validateItem_Identifier_Type_DataForArrayConstraintsFromSetItem_Identifier_Type_Data($item_Identifier_Type_Data))) {
            throw new \InvalidArgumentException($item_Identifier_Type_DataArrayErrorMessage, __LINE__);
        }
        $this->Item_Identifier_Type_Data = $item_Identifier_Type_Data;
        return $this;
    }
    /**
     * Add item to Item_Identifier_Type_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_Identifier_Type_DataType $item
     * @return \StructType\Item_Identifier_TypeType
     */
    public function addToItem_Identifier_Type_Data(\StructType\Item_Identifier_Type_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Item_Identifier_Type_DataType) {
            throw new \InvalidArgumentException(sprintf('The Item_Identifier_Type_Data property can only contain items of type \StructType\Item_Identifier_Type_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item_Identifier_Type_Data[] = $item;
        return $this;
    }
}
