<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Import_Purchase_Order_Close_Lines_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: The container for the Import Purchase Order Close Lines request.
 * @subpackage Structs
 */
class Import_Purchase_Order_Close_Lines_RequestType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: The ID of the Import Purchase Order Close Lines request.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The Import_Memo
     * Meta information extracted from the WSDL
     * - documentation: The memo for the Import Purchase Order Close Lines request.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Import_Memo;
    /**
     * The Purchase_Order_Close_Lines_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Purchase_Order_Close_Lines__HV__DataType[]
     */
    public $Purchase_Order_Close_Lines_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Import_Purchase_Order_Close_Lines_RequestType
     * @uses Import_Purchase_Order_Close_Lines_RequestType::setID()
     * @uses Import_Purchase_Order_Close_Lines_RequestType::setImport_Memo()
     * @uses Import_Purchase_Order_Close_Lines_RequestType::setPurchase_Order_Close_Lines_Data()
     * @uses Import_Purchase_Order_Close_Lines_RequestType::setVersion()
     * @param string $iD
     * @param string $import_Memo
     * @param \StructType\Purchase_Order_Close_Lines__HV__DataType[] $purchase_Order_Close_Lines_Data
     * @param string $version
     */
    public function __construct($iD = null, $import_Memo = null, array $purchase_Order_Close_Lines_Data = array(), $version = null)
    {
        $this
            ->setID($iD)
            ->setImport_Memo($import_Memo)
            ->setPurchase_Order_Close_Lines_Data($purchase_Order_Close_Lines_Data)
            ->setVersion($version);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Import_Purchase_Order_Close_Lines_RequestType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Import_Memo value
     * @return string|null
     */
    public function getImport_Memo()
    {
        return $this->Import_Memo;
    }
    /**
     * Set Import_Memo value
     * @param string $import_Memo
     * @return \StructType\Import_Purchase_Order_Close_Lines_RequestType
     */
    public function setImport_Memo($import_Memo = null)
    {
        // validation for constraint: string
        if (!is_null($import_Memo) && !is_string($import_Memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($import_Memo, true), gettype($import_Memo)), __LINE__);
        }
        $this->Import_Memo = $import_Memo;
        return $this;
    }
    /**
     * Get Purchase_Order_Close_Lines_Data value
     * @return \StructType\Purchase_Order_Close_Lines__HV__DataType[]|null
     */
    public function getPurchase_Order_Close_Lines_Data()
    {
        return $this->Purchase_Order_Close_Lines_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Order_Close_Lines_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Order_Close_Lines_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Order_Close_Lines_DataForArrayConstraintsFromSetPurchase_Order_Close_Lines_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $import_Purchase_Order_Close_Lines_RequestTypePurchase_Order_Close_Lines_DataItem) {
            // validation for constraint: itemType
            if (!$import_Purchase_Order_Close_Lines_RequestTypePurchase_Order_Close_Lines_DataItem instanceof \StructType\Purchase_Order_Close_Lines__HV__DataType) {
                $invalidValues[] = is_object($import_Purchase_Order_Close_Lines_RequestTypePurchase_Order_Close_Lines_DataItem) ? get_class($import_Purchase_Order_Close_Lines_RequestTypePurchase_Order_Close_Lines_DataItem) : sprintf('%s(%s)', gettype($import_Purchase_Order_Close_Lines_RequestTypePurchase_Order_Close_Lines_DataItem), var_export($import_Purchase_Order_Close_Lines_RequestTypePurchase_Order_Close_Lines_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Order_Close_Lines_Data property can only contain items of type \StructType\Purchase_Order_Close_Lines__HV__DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Order_Close_Lines_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Order_Close_Lines__HV__DataType[] $purchase_Order_Close_Lines_Data
     * @return \StructType\Import_Purchase_Order_Close_Lines_RequestType
     */
    public function setPurchase_Order_Close_Lines_Data(array $purchase_Order_Close_Lines_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Order_Close_Lines_DataArrayErrorMessage = self::validatePurchase_Order_Close_Lines_DataForArrayConstraintsFromSetPurchase_Order_Close_Lines_Data($purchase_Order_Close_Lines_Data))) {
            throw new \InvalidArgumentException($purchase_Order_Close_Lines_DataArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Order_Close_Lines_Data = $purchase_Order_Close_Lines_Data;
        return $this;
    }
    /**
     * Add item to Purchase_Order_Close_Lines_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Order_Close_Lines__HV__DataType $item
     * @return \StructType\Import_Purchase_Order_Close_Lines_RequestType
     */
    public function addToPurchase_Order_Close_Lines_Data(\StructType\Purchase_Order_Close_Lines__HV__DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_Order_Close_Lines__HV__DataType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Order_Close_Lines_Data property can only contain items of type \StructType\Purchase_Order_Close_Lines__HV__DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Order_Close_Lines_Data[] = $item;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Import_Purchase_Order_Close_Lines_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
