<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Image_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Image Data
 * @subpackage Structs
 */
class Image_DataType extends AbstractStructBase
{
    /**
     * The Image_ID
     * Meta information extracted from the WSDL
     * - documentation: Reference ID of Image
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Image_ID;
    /**
     * The Filename
     * Meta information extracted from the WSDL
     * - documentation: Filename of Image | Text attribute identifying Filename of the Attachment.
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * @var string
     */
    public $Filename;
    /**
     * The File
     * Meta information extracted from the WSDL
     * - documentation: File associated with Image
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $File;
    /**
     * The Alternative_Text
     * Meta information extracted from the WSDL
     * - documentation: Specify an image description in the Alternative Text field for workers that use assistive technology. Character limit: 60.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Alternative_Text;
    /**
     * Constructor method for Image_DataType
     * @uses Image_DataType::setImage_ID()
     * @uses Image_DataType::setFilename()
     * @uses Image_DataType::setFile()
     * @uses Image_DataType::setAlternative_Text()
     * @param string $image_ID
     * @param string $filename
     * @param string $file
     * @param string $alternative_Text
     */
    public function __construct($image_ID = null, $filename = null, $file = null, $alternative_Text = null)
    {
        $this
            ->setImage_ID($image_ID)
            ->setFilename($filename)
            ->setFile($file)
            ->setAlternative_Text($alternative_Text);
    }
    /**
     * Get Image_ID value
     * @return string|null
     */
    public function getImage_ID()
    {
        return $this->Image_ID;
    }
    /**
     * Set Image_ID value
     * @param string $image_ID
     * @return \StructType\Image_DataType
     */
    public function setImage_ID($image_ID = null)
    {
        // validation for constraint: string
        if (!is_null($image_ID) && !is_string($image_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($image_ID, true), gettype($image_ID)), __LINE__);
        }
        $this->Image_ID = $image_ID;
        return $this;
    }
    /**
     * Get Filename value
     * @return string|null
     */
    public function getFilename()
    {
        return $this->Filename;
    }
    /**
     * Set Filename value
     * @param string $filename
     * @return \StructType\Image_DataType
     */
    public function setFilename($filename = null)
    {
        // validation for constraint: string
        if (!is_null($filename) && !is_string($filename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filename, true), gettype($filename)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($filename) && mb_strlen($filename) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($filename)), __LINE__);
        }
        $this->Filename = $filename;
        return $this;
    }
    /**
     * Get File value
     * @return string|null
     */
    public function getFile()
    {
        return $this->File;
    }
    /**
     * Set File value
     * @param string $file
     * @return \StructType\Image_DataType
     */
    public function setFile($file = null)
    {
        // validation for constraint: string
        if (!is_null($file) && !is_string($file)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($file, true), gettype($file)), __LINE__);
        }
        $this->File = $file;
        return $this;
    }
    /**
     * Get Alternative_Text value
     * @return string|null
     */
    public function getAlternative_Text()
    {
        return $this->Alternative_Text;
    }
    /**
     * Set Alternative_Text value
     * @param string $alternative_Text
     * @return \StructType\Image_DataType
     */
    public function setAlternative_Text($alternative_Text = null)
    {
        // validation for constraint: string
        if (!is_null($alternative_Text) && !is_string($alternative_Text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternative_Text, true), gettype($alternative_Text)), __LINE__);
        }
        $this->Alternative_Text = $alternative_Text;
        return $this;
    }
}
