<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Financials_Attachment_Widget_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: A wrapper element that contains data for Financial Attachments
 * @subpackage Structs
 */
class Financials_Attachment_Widget_DataType extends AbstractStructBase
{
    /**
     * The Attachment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Financials_Attachment_WWS_DataType[]
     */
    public $Attachment_Data;
    /**
     * The Replace_All
     * Meta information extracted from the WSDL
     * - documentation: Replace All boolean to replace (True) or update (False) Financial Attachment information for a Supplier.
     * @var bool
     */
    public $Replace_All;
    /**
     * Constructor method for Financials_Attachment_Widget_DataType
     * @uses Financials_Attachment_Widget_DataType::setAttachment_Data()
     * @uses Financials_Attachment_Widget_DataType::setReplace_All()
     * @param \StructType\Financials_Attachment_WWS_DataType[] $attachment_Data
     * @param bool $replace_All
     */
    public function __construct(array $attachment_Data = array(), $replace_All = null)
    {
        $this
            ->setAttachment_Data($attachment_Data)
            ->setReplace_All($replace_All);
    }
    /**
     * Get Attachment_Data value
     * @return \StructType\Financials_Attachment_WWS_DataType[]|null
     */
    public function getAttachment_Data()
    {
        return $this->Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachment_DataForArrayConstraintsFromSetAttachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $financials_Attachment_Widget_DataTypeAttachment_DataItem) {
            // validation for constraint: itemType
            if (!$financials_Attachment_Widget_DataTypeAttachment_DataItem instanceof \StructType\Financials_Attachment_WWS_DataType) {
                $invalidValues[] = is_object($financials_Attachment_Widget_DataTypeAttachment_DataItem) ? get_class($financials_Attachment_Widget_DataTypeAttachment_DataItem) : sprintf('%s(%s)', gettype($financials_Attachment_Widget_DataTypeAttachment_DataItem), var_export($financials_Attachment_Widget_DataTypeAttachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_WWS_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_WWS_DataType[] $attachment_Data
     * @return \StructType\Financials_Attachment_Widget_DataType
     */
    public function setAttachment_Data(array $attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($attachment_DataArrayErrorMessage = self::validateAttachment_DataForArrayConstraintsFromSetAttachment_Data($attachment_Data))) {
            throw new \InvalidArgumentException($attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Attachment_Data = $attachment_Data;
        return $this;
    }
    /**
     * Add item to Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_WWS_DataType $item
     * @return \StructType\Financials_Attachment_Widget_DataType
     */
    public function addToAttachment_Data(\StructType\Financials_Attachment_WWS_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Financials_Attachment_WWS_DataType) {
            throw new \InvalidArgumentException(sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_WWS_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attachment_Data[] = $item;
        return $this;
    }
    /**
     * Get Replace_All value
     * @return bool|null
     */
    public function getReplace_All()
    {
        return $this->Replace_All;
    }
    /**
     * Set Replace_All value
     * @param bool $replace_All
     * @return \StructType\Financials_Attachment_Widget_DataType
     */
    public function setReplace_All($replace_All = null)
    {
        // validation for constraint: boolean
        if (!is_null($replace_All) && !is_bool($replace_All)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replace_All, true), gettype($replace_All)), __LINE__);
        }
        $this->Replace_All = $replace_All;
        return $this;
    }
}
