<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Expense_Credit_Card_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Expense Credit Card Reference element contains the specific instance set containing the requested Expense Credit Card.
 * @subpackage Structs
 */
class Expense_Credit_Card_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Expense_Credit_Card_Reference
     * Meta information extracted from the WSDL
     * - documentation: Instance set containing the Expense Credit Card object.
     * - maxOccurs: unbounded
     * @var \StructType\Worker_Credit_CardObjectType[]
     */
    public $Expense_Credit_Card_Reference;
    /**
     * Constructor method for Expense_Credit_Card_Request_ReferencesType
     * @uses Expense_Credit_Card_Request_ReferencesType::setExpense_Credit_Card_Reference()
     * @param \StructType\Worker_Credit_CardObjectType[] $expense_Credit_Card_Reference
     */
    public function __construct(array $expense_Credit_Card_Reference = array())
    {
        $this
            ->setExpense_Credit_Card_Reference($expense_Credit_Card_Reference);
    }
    /**
     * Get Expense_Credit_Card_Reference value
     * @return \StructType\Worker_Credit_CardObjectType[]|null
     */
    public function getExpense_Credit_Card_Reference()
    {
        return $this->Expense_Credit_Card_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setExpense_Credit_Card_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense_Credit_Card_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpense_Credit_Card_ReferenceForArrayConstraintsFromSetExpense_Credit_Card_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Credit_Card_Request_ReferencesTypeExpense_Credit_Card_ReferenceItem) {
            // validation for constraint: itemType
            if (!$expense_Credit_Card_Request_ReferencesTypeExpense_Credit_Card_ReferenceItem instanceof \StructType\Worker_Credit_CardObjectType) {
                $invalidValues[] = is_object($expense_Credit_Card_Request_ReferencesTypeExpense_Credit_Card_ReferenceItem) ? get_class($expense_Credit_Card_Request_ReferencesTypeExpense_Credit_Card_ReferenceItem) : sprintf('%s(%s)', gettype($expense_Credit_Card_Request_ReferencesTypeExpense_Credit_Card_ReferenceItem), var_export($expense_Credit_Card_Request_ReferencesTypeExpense_Credit_Card_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Expense_Credit_Card_Reference property can only contain items of type \StructType\Worker_Credit_CardObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Expense_Credit_Card_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Worker_Credit_CardObjectType[] $expense_Credit_Card_Reference
     * @return \StructType\Expense_Credit_Card_Request_ReferencesType
     */
    public function setExpense_Credit_Card_Reference(array $expense_Credit_Card_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($expense_Credit_Card_ReferenceArrayErrorMessage = self::validateExpense_Credit_Card_ReferenceForArrayConstraintsFromSetExpense_Credit_Card_Reference($expense_Credit_Card_Reference))) {
            throw new \InvalidArgumentException($expense_Credit_Card_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Expense_Credit_Card_Reference = $expense_Credit_Card_Reference;
        return $this;
    }
    /**
     * Add item to Expense_Credit_Card_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Worker_Credit_CardObjectType $item
     * @return \StructType\Expense_Credit_Card_Request_ReferencesType
     */
    public function addToExpense_Credit_Card_Reference(\StructType\Worker_Credit_CardObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Worker_Credit_CardObjectType) {
            throw new \InvalidArgumentException(sprintf('The Expense_Credit_Card_Reference property can only contain items of type \StructType\Worker_Credit_CardObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Expense_Credit_Card_Reference[] = $item;
        return $this;
    }
}
