<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Credit_Card_Code_Mapping_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Credit Card Code Mapping Request References
 * @subpackage Structs
 */
class Credit_Card_Code_Mapping_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Expense_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Expense Item
     * - maxOccurs: unbounded
     * @var \StructType\Expense_ItemObjectType[]
     */
    public $Expense_Item_Reference;
    /**
     * Constructor method for Credit_Card_Code_Mapping_Request_ReferencesType
     * @uses Credit_Card_Code_Mapping_Request_ReferencesType::setExpense_Item_Reference()
     * @param \StructType\Expense_ItemObjectType[] $expense_Item_Reference
     */
    public function __construct(array $expense_Item_Reference = array())
    {
        $this
            ->setExpense_Item_Reference($expense_Item_Reference);
    }
    /**
     * Get Expense_Item_Reference value
     * @return \StructType\Expense_ItemObjectType[]|null
     */
    public function getExpense_Item_Reference()
    {
        return $this->Expense_Item_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setExpense_Item_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense_Item_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpense_Item_ReferenceForArrayConstraintsFromSetExpense_Item_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $credit_Card_Code_Mapping_Request_ReferencesTypeExpense_Item_ReferenceItem) {
            // validation for constraint: itemType
            if (!$credit_Card_Code_Mapping_Request_ReferencesTypeExpense_Item_ReferenceItem instanceof \StructType\Expense_ItemObjectType) {
                $invalidValues[] = is_object($credit_Card_Code_Mapping_Request_ReferencesTypeExpense_Item_ReferenceItem) ? get_class($credit_Card_Code_Mapping_Request_ReferencesTypeExpense_Item_ReferenceItem) : sprintf('%s(%s)', gettype($credit_Card_Code_Mapping_Request_ReferencesTypeExpense_Item_ReferenceItem), var_export($credit_Card_Code_Mapping_Request_ReferencesTypeExpense_Item_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Expense_Item_Reference property can only contain items of type \StructType\Expense_ItemObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Expense_Item_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_ItemObjectType[] $expense_Item_Reference
     * @return \StructType\Credit_Card_Code_Mapping_Request_ReferencesType
     */
    public function setExpense_Item_Reference(array $expense_Item_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($expense_Item_ReferenceArrayErrorMessage = self::validateExpense_Item_ReferenceForArrayConstraintsFromSetExpense_Item_Reference($expense_Item_Reference))) {
            throw new \InvalidArgumentException($expense_Item_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Expense_Item_Reference = $expense_Item_Reference;
        return $this;
    }
    /**
     * Add item to Expense_Item_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_ItemObjectType $item
     * @return \StructType\Credit_Card_Code_Mapping_Request_ReferencesType
     */
    public function addToExpense_Item_Reference(\StructType\Expense_ItemObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Expense_ItemObjectType) {
            throw new \InvalidArgumentException(sprintf('The Expense_Item_Reference property can only contain items of type \StructType\Expense_ItemObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Expense_Item_Reference[] = $item;
        return $this;
    }
}
