<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Contact_Information_Wrapper_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Supplier Contact Information Wrapper Data
 * @subpackage Structs
 */
class Contact_Information_Wrapper_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Reference_ID
     * Meta information extracted from the WSDL
     * - documentation: Supplier Reference ID - used for reference in iLoad, not for updating the ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Reference_ID;
    /**
     * The Contact_Information_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Contact_Information_DataType[]
     */
    public $Contact_Information_Data;
    /**
     * Constructor method for Contact_Information_Wrapper_DataType
     * @uses Contact_Information_Wrapper_DataType::setSupplier_Reference_ID()
     * @uses Contact_Information_Wrapper_DataType::setContact_Information_Data()
     * @param string $supplier_Reference_ID
     * @param \StructType\Contact_Information_DataType[] $contact_Information_Data
     */
    public function __construct($supplier_Reference_ID = null, array $contact_Information_Data = array())
    {
        $this
            ->setSupplier_Reference_ID($supplier_Reference_ID)
            ->setContact_Information_Data($contact_Information_Data);
    }
    /**
     * Get Supplier_Reference_ID value
     * @return string|null
     */
    public function getSupplier_Reference_ID()
    {
        return $this->Supplier_Reference_ID;
    }
    /**
     * Set Supplier_Reference_ID value
     * @param string $supplier_Reference_ID
     * @return \StructType\Contact_Information_Wrapper_DataType
     */
    public function setSupplier_Reference_ID($supplier_Reference_ID = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Reference_ID) && !is_string($supplier_Reference_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Reference_ID, true), gettype($supplier_Reference_ID)), __LINE__);
        }
        $this->Supplier_Reference_ID = $supplier_Reference_ID;
        return $this;
    }
    /**
     * Get Contact_Information_Data value
     * @return \StructType\Contact_Information_DataType[]|null
     */
    public function getContact_Information_Data()
    {
        return $this->Contact_Information_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setContact_Information_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContact_Information_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContact_Information_DataForArrayConstraintsFromSetContact_Information_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contact_Information_Wrapper_DataTypeContact_Information_DataItem) {
            // validation for constraint: itemType
            if (!$contact_Information_Wrapper_DataTypeContact_Information_DataItem instanceof \StructType\Contact_Information_DataType) {
                $invalidValues[] = is_object($contact_Information_Wrapper_DataTypeContact_Information_DataItem) ? get_class($contact_Information_Wrapper_DataTypeContact_Information_DataItem) : sprintf('%s(%s)', gettype($contact_Information_Wrapper_DataTypeContact_Information_DataItem), var_export($contact_Information_Wrapper_DataTypeContact_Information_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Contact_Information_Data property can only contain items of type \StructType\Contact_Information_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Contact_Information_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Contact_Information_DataType[] $contact_Information_Data
     * @return \StructType\Contact_Information_Wrapper_DataType
     */
    public function setContact_Information_Data(array $contact_Information_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($contact_Information_DataArrayErrorMessage = self::validateContact_Information_DataForArrayConstraintsFromSetContact_Information_Data($contact_Information_Data))) {
            throw new \InvalidArgumentException($contact_Information_DataArrayErrorMessage, __LINE__);
        }
        $this->Contact_Information_Data = $contact_Information_Data;
        return $this;
    }
    /**
     * Add item to Contact_Information_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Contact_Information_DataType $item
     * @return \StructType\Contact_Information_Wrapper_DataType
     */
    public function addToContact_Information_Data(\StructType\Contact_Information_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Contact_Information_DataType) {
            throw new \InvalidArgumentException(sprintf('The Contact_Information_Data property can only contain items of type \StructType\Contact_Information_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Contact_Information_Data[] = $item;
        return $this;
    }
}
