<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Change_Order_Line_Split_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Line Split Data on the Change Order Line.
 * @subpackage Structs
 */
class Change_Order_Line_Split_WWS_DataType extends AbstractStructBase
{
    /**
     * The Purchase_Order_Line_Split_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the PO Line Split being changed.
     * - minOccurs: 0
     * @var \StructType\Purchase_Order_Line_SplitObjectType
     */
    public $Purchase_Order_Line_Split_Reference;
    /**
     * The Change_Order_Line_Split_ID
     * Meta information extracted from the WSDL
     * - documentation: Reference ID on the PO Line Split on the change order. If provided, the ID needs to be different from the Reference ID of the purchase order line being changed.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Change_Order_Line_Split_ID;
    /**
     * The Business_Document_Line_Split_ID
     * Meta information extracted from the WSDL
     * - documentation: The value of Purchase Order Line Split Reference ID when change order is approved.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Business_Document_Line_Split_ID;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: The quantity of the Purchase Item ordered. Quantity will be defaulted to 1 if left blank. | Quantity for the expense report line. Leave blank if you are entering a credit card transaction. | Quantity to receive | Number of units to
     * assign. | Quantity for the Spend Authorization Line | You must enter a Quantity when Line Split Allocation Reference is Split by Quantity. | Quantity must be empty when Line Split Allocation Reference is Split by Amount. | The number of units |
     * Quantity. If you supply this value as an override, you must also enable the Override Line flag. | Although Supplier Invoice Schedules may distribute installments by Amount or Quantity, Purchase Order Schedules always distribute by Quantity. |
     * Quantity of the asset component. | Quantity Returned | If this is blank, Workday will automatically calculate quantity from unit cost and extended amount. But if the line references either a Purchase Order or Contract Line, the quantity must be blank
     * and extended amount will not be calculated. | Quantity on Request for Quote Line. | The quantity for the split line. This is optional and should be absent when we split by amount. | Quantity on Award Line Split. | The quantity of the Purchase Item
     * ordered. For new line, quantity will be defaulted to 1 if left blank. | The quantity for the split line. This is optional and should be absent when splitting by amount. | Quantity on the Internal Service Delivery Line. | The quantity for the split
     * line. This is optional and will not be populated when the Internal Service Delivery Line is split by amount. | Quantity on the Internal Service Delivery Line. If the Internal Service Delivery Line references a Catalog Item, then Quantity cannot be
     * blank. | Quantity on the Internal Service Delivery Line Split. This is optional and must not be included when the Internal Service Delivery Line is split by Amount. | Quantity on the Supplier Invoice Request Line | The quantity for the split line.
     * This is optional and will not be populated when the Supplier Invoice Request Line is split by amount. | Quantity for the Supplier Invoice Request Line | Quantity on the Supplier Invoice Request Line Split. This is optional and must not be included
     * when the Supplier Invoice Request Line is split by Amount. | Shipped Quantity for Lot | Refers to the supplier item quantity for the POA line. | Quantity for Purchase Order LinecXML Notes:Request/OrderRequest/OrderRequestHeader/ItemOut@quantity |
     * Quantity for Requisition Line | Quantity | Item Lot Quantity
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Quantity;
    /**
     * The Extended_Amount
     * Meta information extracted from the WSDL
     * - documentation: The Extended Amount for the Project-Based Order Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Order Line. | The Extended Amount for the Contingent Worker Order Line.
     * | The control value Entered for Extended Amount does not match calculated Extended Amount. Extended Amount is an optional field but it can be used to control the anticipated line amount. If you do not wish to control the line amount, please leave
     * this field blank. | The Extended Amount for the Project-Based Requisition Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Requisition Line. | This is the invoice line amount. If the
     * invoice line has a quantity and unit price, then Workday will automatically calculate extended amount. | Transaction Extended Amount | The Extended Amount for the Service Order Line. This value must be the same sign as the Requisition Line Reference
     * or zero, if present, and must be positive if there is a Supplier Contract Line Reference, if present. | The Extended Amount for the RFQ Goods line. This amount is automatically calculated by multiplying the Quantity by the Unit Cost in the currency
     * specified on the Goods Line. | Service Line Extended Amount should be greater than zero. | Amount to Receive | Extended amount for the split line. This is an optional field for split line. If value is present it must be equal to Quantity times Unit
     * Cost of parent line. | Extended Amount on Award Line Split | The extended amount for the split line. This is always required and must be correct (quantity * unit cost of parent line). | The Extended Amount for the Purchase Order line. This amount is
     * automatically calculated by multiplying the Quantity by the Unit Cost in the currency specified on the Purchase Order. | Extended Amount on the Internal Service Delivery Line. If Unit Cost and Quantity are present on the line, Extended Amount is
     * always equal to their product. | Extended amount for the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Internal Service Delivery Line. | Internal Service Delivery Line Amount. If Unit Cost and
     * Quantity are also specified on the Internal Service Delivery Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Internal Service Delivery Line Split. This is always required and the total Line Split amount must equal the
     * (Unit Cost * Quantity) of the parent Internal Service Delivery Line. | Extended Amount on the Supplier Invoice Request Line. If Unit Cost and Quantity are present on the line, Extended Amount is always equal to their product. | Extended amount for
     * the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Supplier Invoice Request Line. | Supplier Invoice Request Line Extended Amount. If Unit Cost and Quantity are also specified on the Supplier
     * Invoice Request Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Supplier Invoice Request Line Split. This is always required and the total Line Split amount must equal the (Unit Cost * Quantity) of the parent Supplier
     * Invoice Request Line. | Extended Amount on the Advanced Ship Notice Line. | Purchase Order Line Amount | The Extended Amount for the Service Line | The Extended Amount for the Requisition line. This amount is automatically calculated by multiplying
     * the Quantity by the Unit Cost in the currency specified on the Requisition. | Extended Amount | The Actual Quantity Received for this Line. | The Extended Amount for the Receipt Adjustment line. This amount is automatically calculated by multiplying
     * the Actual Quantity to Receive by the Unit Cost in the currency specified on the Receipt.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Extended_Amount;
    /**
     * The Budget_Date
     * Meta information extracted from the WSDL
     * - documentation: Use this field to override the Budget Date on a change order line split.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Budget_Date;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo for the Split line. This is free form text.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Storage_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing location for the item.
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Storage_Location_Reference;
    /**
     * The Worktag_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing worktags. Worktags are a way to mark tasks and business objects to make them easier to access and summarize.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Worktag_Reference;
    /**
     * Constructor method for Change_Order_Line_Split_WWS_DataType
     * @uses Change_Order_Line_Split_WWS_DataType::setPurchase_Order_Line_Split_Reference()
     * @uses Change_Order_Line_Split_WWS_DataType::setChange_Order_Line_Split_ID()
     * @uses Change_Order_Line_Split_WWS_DataType::setBusiness_Document_Line_Split_ID()
     * @uses Change_Order_Line_Split_WWS_DataType::setQuantity()
     * @uses Change_Order_Line_Split_WWS_DataType::setExtended_Amount()
     * @uses Change_Order_Line_Split_WWS_DataType::setBudget_Date()
     * @uses Change_Order_Line_Split_WWS_DataType::setMemo()
     * @uses Change_Order_Line_Split_WWS_DataType::setStorage_Location_Reference()
     * @uses Change_Order_Line_Split_WWS_DataType::setWorktag_Reference()
     * @param \StructType\Purchase_Order_Line_SplitObjectType $purchase_Order_Line_Split_Reference
     * @param string $change_Order_Line_Split_ID
     * @param string $business_Document_Line_Split_ID
     * @param float $quantity
     * @param float $extended_Amount
     * @param string $budget_Date
     * @param string $memo
     * @param \StructType\LocationObjectType $storage_Location_Reference
     * @param \StructType\Accounting_WorktagObjectType[] $worktag_Reference
     */
    public function __construct(\StructType\Purchase_Order_Line_SplitObjectType $purchase_Order_Line_Split_Reference = null, $change_Order_Line_Split_ID = null, $business_Document_Line_Split_ID = null, $quantity = null, $extended_Amount = null, $budget_Date = null, $memo = null, \StructType\LocationObjectType $storage_Location_Reference = null, array $worktag_Reference = array())
    {
        $this
            ->setPurchase_Order_Line_Split_Reference($purchase_Order_Line_Split_Reference)
            ->setChange_Order_Line_Split_ID($change_Order_Line_Split_ID)
            ->setBusiness_Document_Line_Split_ID($business_Document_Line_Split_ID)
            ->setQuantity($quantity)
            ->setExtended_Amount($extended_Amount)
            ->setBudget_Date($budget_Date)
            ->setMemo($memo)
            ->setStorage_Location_Reference($storage_Location_Reference)
            ->setWorktag_Reference($worktag_Reference);
    }
    /**
     * Get Purchase_Order_Line_Split_Reference value
     * @return \StructType\Purchase_Order_Line_SplitObjectType|null
     */
    public function getPurchase_Order_Line_Split_Reference()
    {
        return $this->Purchase_Order_Line_Split_Reference;
    }
    /**
     * Set Purchase_Order_Line_Split_Reference value
     * @param \StructType\Purchase_Order_Line_SplitObjectType $purchase_Order_Line_Split_Reference
     * @return \StructType\Change_Order_Line_Split_WWS_DataType
     */
    public function setPurchase_Order_Line_Split_Reference(\StructType\Purchase_Order_Line_SplitObjectType $purchase_Order_Line_Split_Reference = null)
    {
        $this->Purchase_Order_Line_Split_Reference = $purchase_Order_Line_Split_Reference;
        return $this;
    }
    /**
     * Get Change_Order_Line_Split_ID value
     * @return string|null
     */
    public function getChange_Order_Line_Split_ID()
    {
        return $this->Change_Order_Line_Split_ID;
    }
    /**
     * Set Change_Order_Line_Split_ID value
     * @param string $change_Order_Line_Split_ID
     * @return \StructType\Change_Order_Line_Split_WWS_DataType
     */
    public function setChange_Order_Line_Split_ID($change_Order_Line_Split_ID = null)
    {
        // validation for constraint: string
        if (!is_null($change_Order_Line_Split_ID) && !is_string($change_Order_Line_Split_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($change_Order_Line_Split_ID, true), gettype($change_Order_Line_Split_ID)), __LINE__);
        }
        $this->Change_Order_Line_Split_ID = $change_Order_Line_Split_ID;
        return $this;
    }
    /**
     * Get Business_Document_Line_Split_ID value
     * @return string|null
     */
    public function getBusiness_Document_Line_Split_ID()
    {
        return $this->Business_Document_Line_Split_ID;
    }
    /**
     * Set Business_Document_Line_Split_ID value
     * @param string $business_Document_Line_Split_ID
     * @return \StructType\Change_Order_Line_Split_WWS_DataType
     */
    public function setBusiness_Document_Line_Split_ID($business_Document_Line_Split_ID = null)
    {
        // validation for constraint: string
        if (!is_null($business_Document_Line_Split_ID) && !is_string($business_Document_Line_Split_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($business_Document_Line_Split_ID, true), gettype($business_Document_Line_Split_ID)), __LINE__);
        }
        $this->Business_Document_Line_Split_ID = $business_Document_Line_Split_ID;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\Change_Order_Line_Split_WWS_DataType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($quantity) && mb_strlen(mb_substr($quantity, false !== mb_strpos($quantity, '.') ? mb_strpos($quantity, '.') + 1 : mb_strlen($quantity))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($quantity, true), mb_strlen(mb_substr($quantity, mb_strpos($quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($quantity) && mb_strlen(preg_replace('/(\D)/', '', $quantity)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($quantity, true), mb_strlen(preg_replace('/(\D)/', '', $quantity))), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Extended_Amount value
     * @return float|null
     */
    public function getExtended_Amount()
    {
        return $this->Extended_Amount;
    }
    /**
     * Set Extended_Amount value
     * @param float $extended_Amount
     * @return \StructType\Change_Order_Line_Split_WWS_DataType
     */
    public function setExtended_Amount($extended_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($extended_Amount) && !(is_float($extended_Amount) || is_numeric($extended_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($extended_Amount, true), gettype($extended_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($extended_Amount) && mb_strlen(mb_substr($extended_Amount, false !== mb_strpos($extended_Amount, '.') ? mb_strpos($extended_Amount, '.') + 1 : mb_strlen($extended_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($extended_Amount, true), mb_strlen(mb_substr($extended_Amount, mb_strpos($extended_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($extended_Amount) && mb_strlen(preg_replace('/(\D)/', '', $extended_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($extended_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $extended_Amount))), __LINE__);
        }
        $this->Extended_Amount = $extended_Amount;
        return $this;
    }
    /**
     * Get Budget_Date value
     * @return string|null
     */
    public function getBudget_Date()
    {
        return $this->Budget_Date;
    }
    /**
     * Set Budget_Date value
     * @param string $budget_Date
     * @return \StructType\Change_Order_Line_Split_WWS_DataType
     */
    public function setBudget_Date($budget_Date = null)
    {
        // validation for constraint: string
        if (!is_null($budget_Date) && !is_string($budget_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($budget_Date, true), gettype($budget_Date)), __LINE__);
        }
        $this->Budget_Date = $budget_Date;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Change_Order_Line_Split_WWS_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Storage_Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getStorage_Location_Reference()
    {
        return $this->Storage_Location_Reference;
    }
    /**
     * Set Storage_Location_Reference value
     * @param \StructType\LocationObjectType $storage_Location_Reference
     * @return \StructType\Change_Order_Line_Split_WWS_DataType
     */
    public function setStorage_Location_Reference(\StructType\LocationObjectType $storage_Location_Reference = null)
    {
        $this->Storage_Location_Reference = $storage_Location_Reference;
        return $this;
    }
    /**
     * Get Worktag_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getWorktag_Reference()
    {
        return $this->Worktag_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktag_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktag_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $change_Order_Line_Split_WWS_DataTypeWorktag_ReferenceItem) {
            // validation for constraint: itemType
            if (!$change_Order_Line_Split_WWS_DataTypeWorktag_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($change_Order_Line_Split_WWS_DataTypeWorktag_ReferenceItem) ? get_class($change_Order_Line_Split_WWS_DataTypeWorktag_ReferenceItem) : sprintf('%s(%s)', gettype($change_Order_Line_Split_WWS_DataTypeWorktag_ReferenceItem), var_export($change_Order_Line_Split_WWS_DataTypeWorktag_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktag_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $worktag_Reference
     * @return \StructType\Change_Order_Line_Split_WWS_DataType
     */
    public function setWorktag_Reference(array $worktag_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktag_ReferenceArrayErrorMessage = self::validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference($worktag_Reference))) {
            throw new \InvalidArgumentException($worktag_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktag_Reference = $worktag_Reference;
        return $this;
    }
    /**
     * Add item to Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Change_Order_Line_Split_WWS_DataType
     */
    public function addToWorktag_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktag_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktag_Reference[] = $item;
        return $this;
    }
}
