<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Change_Depreciation_Accounting_Status_ResponseType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing the data Element for the Override Depreciation Period Response
 * @subpackage Structs
 */
class Change_Depreciation_Accounting_Status_ResponseType extends AbstractStructBase
{
    /**
     * The Override_Depreciation_Period_Status_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing the Processed Asset Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Override_Depreciation_Period_Status_Data_ResponseType[]
     */
    public $Override_Depreciation_Period_Status_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Change_Depreciation_Accounting_Status_ResponseType
     * @uses Change_Depreciation_Accounting_Status_ResponseType::setOverride_Depreciation_Period_Status_Data()
     * @uses Change_Depreciation_Accounting_Status_ResponseType::setVersion()
     * @param \StructType\Override_Depreciation_Period_Status_Data_ResponseType[] $override_Depreciation_Period_Status_Data
     * @param string $version
     */
    public function __construct(array $override_Depreciation_Period_Status_Data = array(), $version = null)
    {
        $this
            ->setOverride_Depreciation_Period_Status_Data($override_Depreciation_Period_Status_Data)
            ->setVersion($version);
    }
    /**
     * Get Override_Depreciation_Period_Status_Data value
     * @return \StructType\Override_Depreciation_Period_Status_Data_ResponseType[]|null
     */
    public function getOverride_Depreciation_Period_Status_Data()
    {
        return $this->Override_Depreciation_Period_Status_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setOverride_Depreciation_Period_Status_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOverride_Depreciation_Period_Status_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOverride_Depreciation_Period_Status_DataForArrayConstraintsFromSetOverride_Depreciation_Period_Status_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $change_Depreciation_Accounting_Status_ResponseTypeOverride_Depreciation_Period_Status_DataItem) {
            // validation for constraint: itemType
            if (!$change_Depreciation_Accounting_Status_ResponseTypeOverride_Depreciation_Period_Status_DataItem instanceof \StructType\Override_Depreciation_Period_Status_Data_ResponseType) {
                $invalidValues[] = is_object($change_Depreciation_Accounting_Status_ResponseTypeOverride_Depreciation_Period_Status_DataItem) ? get_class($change_Depreciation_Accounting_Status_ResponseTypeOverride_Depreciation_Period_Status_DataItem) : sprintf('%s(%s)', gettype($change_Depreciation_Accounting_Status_ResponseTypeOverride_Depreciation_Period_Status_DataItem), var_export($change_Depreciation_Accounting_Status_ResponseTypeOverride_Depreciation_Period_Status_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Override_Depreciation_Period_Status_Data property can only contain items of type \StructType\Override_Depreciation_Period_Status_Data_ResponseType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Override_Depreciation_Period_Status_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Override_Depreciation_Period_Status_Data_ResponseType[] $override_Depreciation_Period_Status_Data
     * @return \StructType\Change_Depreciation_Accounting_Status_ResponseType
     */
    public function setOverride_Depreciation_Period_Status_Data(array $override_Depreciation_Period_Status_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($override_Depreciation_Period_Status_DataArrayErrorMessage = self::validateOverride_Depreciation_Period_Status_DataForArrayConstraintsFromSetOverride_Depreciation_Period_Status_Data($override_Depreciation_Period_Status_Data))) {
            throw new \InvalidArgumentException($override_Depreciation_Period_Status_DataArrayErrorMessage, __LINE__);
        }
        $this->Override_Depreciation_Period_Status_Data = $override_Depreciation_Period_Status_Data;
        return $this;
    }
    /**
     * Add item to Override_Depreciation_Period_Status_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Override_Depreciation_Period_Status_Data_ResponseType $item
     * @return \StructType\Change_Depreciation_Accounting_Status_ResponseType
     */
    public function addToOverride_Depreciation_Period_Status_Data(\StructType\Override_Depreciation_Period_Status_Data_ResponseType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Override_Depreciation_Period_Status_Data_ResponseType) {
            throw new \InvalidArgumentException(sprintf('The Override_Depreciation_Period_Status_Data property can only contain items of type \StructType\Override_Depreciation_Period_Status_Data_ResponseType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Override_Depreciation_Period_Status_Data[] = $item;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Change_Depreciation_Accounting_Status_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
