<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Cancel_Spend_Authorization_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Only certain Spend Authorizations are cancelable. | Element encapsulating the reference to the spend authorization that should be canceled.
 * @subpackage Structs
 */
class Cancel_Spend_Authorization_RequestType extends AbstractStructBase
{
    /**
     * The Spend_Authorization_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the spend authorization that should be canceled.
     * @var \StructType\Spend_AuthorizationObjectType
     */
    public $Spend_Authorization_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Cancel_Spend_Authorization_RequestType
     * @uses Cancel_Spend_Authorization_RequestType::setSpend_Authorization_Reference()
     * @uses Cancel_Spend_Authorization_RequestType::setVersion()
     * @param \StructType\Spend_AuthorizationObjectType $spend_Authorization_Reference
     * @param string $version
     */
    public function __construct(\StructType\Spend_AuthorizationObjectType $spend_Authorization_Reference = null, $version = null)
    {
        $this
            ->setSpend_Authorization_Reference($spend_Authorization_Reference)
            ->setVersion($version);
    }
    /**
     * Get Spend_Authorization_Reference value
     * @return \StructType\Spend_AuthorizationObjectType|null
     */
    public function getSpend_Authorization_Reference()
    {
        return $this->Spend_Authorization_Reference;
    }
    /**
     * Set Spend_Authorization_Reference value
     * @param \StructType\Spend_AuthorizationObjectType $spend_Authorization_Reference
     * @return \StructType\Cancel_Spend_Authorization_RequestType
     */
    public function setSpend_Authorization_Reference(\StructType\Spend_AuthorizationObjectType $spend_Authorization_Reference = null)
    {
        $this->Spend_Authorization_Reference = $spend_Authorization_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Cancel_Spend_Authorization_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
