<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CC_Transaction_LineType StructType
 * Meta information extracted from the WSDL
 * - documentation: Credit Card Transaction Line Data
 * @subpackage Structs
 */
class CC_Transaction_LineType extends AbstractStructBase
{
    /**
     * The Credit_Card_Transaction_Line_ID
     * Meta information extracted from the WSDL
     * - documentation: Credit Card Transaction Line ID.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Credit_Card_Transaction_Line_ID;
    /**
     * The Purchase_Order_Line_Number
     * Meta information extracted from the WSDL
     * - documentation: The line number of the Purchase Order. | the Line Number of the Prepaid Purchase Order Line to include in the schedule
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 4
     * @var float
     */
    public $Purchase_Order_Line_Number;
    /**
     * The Item_Description
     * Meta information extracted from the WSDL
     * - documentation: Item Description
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Item_Description;
    /**
     * The UNSPSC_code
     * Meta information extracted from the WSDL
     * - documentation: UNSPSC Code
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $UNSPSC_code;
    /**
     * The UPC
     * Meta information extracted from the WSDL
     * - documentation: Universal Product Code
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UPC;
    /**
     * The Vendor_Part_Number
     * Meta information extracted from the WSDL
     * - documentation: Vendor Part Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Vendor_Part_Number;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: The quantity of the Purchase Item ordered. Quantity will be defaulted to 1 if left blank. | Quantity for the expense report line. Leave blank if you are entering a credit card transaction. | Quantity to receive | Number of units to
     * assign. | Quantity for the Spend Authorization Line | You must enter a Quantity when Line Split Allocation Reference is Split by Quantity. | Quantity must be empty when Line Split Allocation Reference is Split by Amount. | The number of units |
     * Quantity. If you supply this value as an override, you must also enable the Override Line flag. | Although Supplier Invoice Schedules may distribute installments by Amount or Quantity, Purchase Order Schedules always distribute by Quantity. |
     * Quantity of the asset component. | Quantity Returned | If this is blank, Workday will automatically calculate quantity from unit cost and extended amount. But if the line references either a Purchase Order or Contract Line, the quantity must be blank
     * and extended amount will not be calculated. | Quantity on Request for Quote Line. | The quantity for the split line. This is optional and should be absent when we split by amount. | Quantity on Award Line Split. | The quantity of the Purchase Item
     * ordered. For new line, quantity will be defaulted to 1 if left blank. | The quantity for the split line. This is optional and should be absent when splitting by amount. | Quantity on the Internal Service Delivery Line. | The quantity for the split
     * line. This is optional and will not be populated when the Internal Service Delivery Line is split by amount. | Quantity on the Internal Service Delivery Line. If the Internal Service Delivery Line references a Catalog Item, then Quantity cannot be
     * blank. | Quantity on the Internal Service Delivery Line Split. This is optional and must not be included when the Internal Service Delivery Line is split by Amount. | Quantity on the Supplier Invoice Request Line | The quantity for the split line.
     * This is optional and will not be populated when the Supplier Invoice Request Line is split by amount. | Quantity for the Supplier Invoice Request Line | Quantity on the Supplier Invoice Request Line Split. This is optional and must not be included
     * when the Supplier Invoice Request Line is split by Amount. | Shipped Quantity for Lot | Refers to the supplier item quantity for the POA line. | Quantity for Purchase Order LinecXML Notes:Request/OrderRequest/OrderRequestHeader/ItemOut@quantity |
     * Quantity for Requisition Line | Quantity | Item Lot Quantity
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Quantity;
    /**
     * The Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Unit of Measure
     * - minOccurs: 0
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Unit_of_Measure_Reference;
    /**
     * The Unit_Price
     * Meta information extracted from the WSDL
     * - documentation: Price of Catalog Item starting on the Effective Date. | Item Unit Price | Unit Cost of Purchase Item for the corresponding UOM. | Unit Price. | Unit Price for Advanced Pricing Rule. The currency is the same as the supplier
     * information detail. | Unit Price for the JIT UOM of the Catalog or Supplier Item. For Supplier items, this field can be updated at anytime, but for Catalog Items, this field can only be updated when you enable catalog data and pricing for your
     * purchase items. | Unit Price of the Ordering UOM of the Catalog or Supplier Item. For Supplier items, this field can be updated at anytime, but for Catalog Items, this field can only be updated when you enable catalog data and pricing for your
     * purchase items.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Unit_Price;
    /**
     * The Extended_Amount
     * Meta information extracted from the WSDL
     * - documentation: The Extended Amount for the Project-Based Order Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Order Line. | The Extended Amount for the Contingent Worker Order Line.
     * | The control value Entered for Extended Amount does not match calculated Extended Amount. Extended Amount is an optional field but it can be used to control the anticipated line amount. If you do not wish to control the line amount, please leave
     * this field blank. | The Extended Amount for the Project-Based Requisition Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Requisition Line. | This is the invoice line amount. If the
     * invoice line has a quantity and unit price, then Workday will automatically calculate extended amount. | Transaction Extended Amount | The Extended Amount for the Service Order Line. This value must be the same sign as the Requisition Line Reference
     * or zero, if present, and must be positive if there is a Supplier Contract Line Reference, if present. | The Extended Amount for the RFQ Goods line. This amount is automatically calculated by multiplying the Quantity by the Unit Cost in the currency
     * specified on the Goods Line. | Service Line Extended Amount should be greater than zero. | Amount to Receive | Extended amount for the split line. This is an optional field for split line. If value is present it must be equal to Quantity times Unit
     * Cost of parent line. | Extended Amount on Award Line Split | The extended amount for the split line. This is always required and must be correct (quantity * unit cost of parent line). | The Extended Amount for the Purchase Order line. This amount is
     * automatically calculated by multiplying the Quantity by the Unit Cost in the currency specified on the Purchase Order. | Extended Amount on the Internal Service Delivery Line. If Unit Cost and Quantity are present on the line, Extended Amount is
     * always equal to their product. | Extended amount for the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Internal Service Delivery Line. | Internal Service Delivery Line Amount. If Unit Cost and
     * Quantity are also specified on the Internal Service Delivery Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Internal Service Delivery Line Split. This is always required and the total Line Split amount must equal the
     * (Unit Cost * Quantity) of the parent Internal Service Delivery Line. | Extended Amount on the Supplier Invoice Request Line. If Unit Cost and Quantity are present on the line, Extended Amount is always equal to their product. | Extended amount for
     * the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Supplier Invoice Request Line. | Supplier Invoice Request Line Extended Amount. If Unit Cost and Quantity are also specified on the Supplier
     * Invoice Request Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Supplier Invoice Request Line Split. This is always required and the total Line Split amount must equal the (Unit Cost * Quantity) of the parent Supplier
     * Invoice Request Line. | Extended Amount on the Advanced Ship Notice Line. | Purchase Order Line Amount | The Extended Amount for the Service Line | The Extended Amount for the Requisition line. This amount is automatically calculated by multiplying
     * the Quantity by the Unit Cost in the currency specified on the Requisition. | Extended Amount | The Actual Quantity Received for this Line. | The Extended Amount for the Receipt Adjustment line. This amount is automatically calculated by multiplying
     * the Actual Quantity to Receive by the Unit Cost in the currency specified on the Receipt.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Extended_Amount;
    /**
     * The Tax_Rate
     * Meta information extracted from the WSDL
     * - documentation: Reference to Line Tax Rate
     * - base: xsd:decimal
     * - fractionDigits: 12
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 15
     * @var float
     */
    public $Tax_Rate;
    /**
     * The Tax_Amount
     * Meta information extracted from the WSDL
     * - documentation: Enter 1 or more lines with tax applicability on an invoice with Tax Amount. This tax applicability must be taxable, non-recoverable, and allocate non-recoverable tax. | Total Tax Amount for Tax Code and Tax Applicability | Tax Amount
     * for Expense Line | The tax amount to report for the expense. The tax code is defined on the itemized line. | Total Tax Amount for Tax Rate | Tax can only be entered if the Tax Option is Enter Tax Due to Supplier. | Expense Credit Card Extended Tax
     * Amount | Tax Amount
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Tax_Amount;
    /**
     * The Freight_Amount
     * Meta information extracted from the WSDL
     * - documentation: An optional addition of Freight Amount for the Requisition. | Freight charges incurred. | Freight Amount
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Freight_Amount;
    /**
     * The Handling_Amount
     * Meta information extracted from the WSDL
     * - documentation: Handling charges incurred.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Handling_Amount;
    /**
     * The Discount_Amount
     * Meta information extracted from the WSDL
     * - documentation: Amount of discount applied.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Discount_Amount;
    /**
     * The Flat_Rate_Amount
     * Meta information extracted from the WSDL
     * - documentation: Flat rate negotiated.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Flat_Rate_Amount;
    /**
     * The Lost_or_Damaged_Items_Amount
     * Meta information extracted from the WSDL
     * - documentation: Charges as a result of lost or damaged items.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Lost_or_Damaged_Items_Amount;
    /**
     * The One_Time_Miscellaneous_Charges_Amount
     * Meta information extracted from the WSDL
     * - documentation: One time only charges.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $One_Time_Miscellaneous_Charges_Amount;
    /**
     * The Other_Charges_Amount
     * Meta information extracted from the WSDL
     * - documentation: Other miscellaneous charges.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Other_Charges_Amount;
    /**
     * The Miscellaneous_Charges_Amount
     * Meta information extracted from the WSDL
     * - documentation: Sum of all other charges submitted.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Miscellaneous_Charges_Amount;
    /**
     * The Miscellaneous_Charges_Description
     * Meta information extracted from the WSDL
     * - documentation: Description of Miscellaneous Charges Amount.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Miscellaneous_Charges_Description;
    /**
     * Constructor method for CC_Transaction_LineType
     * @uses CC_Transaction_LineType::setCredit_Card_Transaction_Line_ID()
     * @uses CC_Transaction_LineType::setPurchase_Order_Line_Number()
     * @uses CC_Transaction_LineType::setItem_Description()
     * @uses CC_Transaction_LineType::setUNSPSC_code()
     * @uses CC_Transaction_LineType::setUPC()
     * @uses CC_Transaction_LineType::setVendor_Part_Number()
     * @uses CC_Transaction_LineType::setQuantity()
     * @uses CC_Transaction_LineType::setUnit_of_Measure_Reference()
     * @uses CC_Transaction_LineType::setUnit_Price()
     * @uses CC_Transaction_LineType::setExtended_Amount()
     * @uses CC_Transaction_LineType::setTax_Rate()
     * @uses CC_Transaction_LineType::setTax_Amount()
     * @uses CC_Transaction_LineType::setFreight_Amount()
     * @uses CC_Transaction_LineType::setHandling_Amount()
     * @uses CC_Transaction_LineType::setDiscount_Amount()
     * @uses CC_Transaction_LineType::setFlat_Rate_Amount()
     * @uses CC_Transaction_LineType::setLost_or_Damaged_Items_Amount()
     * @uses CC_Transaction_LineType::setOne_Time_Miscellaneous_Charges_Amount()
     * @uses CC_Transaction_LineType::setOther_Charges_Amount()
     * @uses CC_Transaction_LineType::setMiscellaneous_Charges_Amount()
     * @uses CC_Transaction_LineType::setMiscellaneous_Charges_Description()
     * @param float $credit_Card_Transaction_Line_ID
     * @param float $purchase_Order_Line_Number
     * @param string $item_Description
     * @param float $uNSPSC_code
     * @param string $uPC
     * @param string $vendor_Part_Number
     * @param float $quantity
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @param float $unit_Price
     * @param float $extended_Amount
     * @param float $tax_Rate
     * @param float $tax_Amount
     * @param float $freight_Amount
     * @param float $handling_Amount
     * @param float $discount_Amount
     * @param float $flat_Rate_Amount
     * @param float $lost_or_Damaged_Items_Amount
     * @param float $one_Time_Miscellaneous_Charges_Amount
     * @param float $other_Charges_Amount
     * @param float $miscellaneous_Charges_Amount
     * @param string $miscellaneous_Charges_Description
     */
    public function __construct($credit_Card_Transaction_Line_ID = null, $purchase_Order_Line_Number = null, $item_Description = null, $uNSPSC_code = null, $uPC = null, $vendor_Part_Number = null, $quantity = null, \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null, $unit_Price = null, $extended_Amount = null, $tax_Rate = null, $tax_Amount = null, $freight_Amount = null, $handling_Amount = null, $discount_Amount = null, $flat_Rate_Amount = null, $lost_or_Damaged_Items_Amount = null, $one_Time_Miscellaneous_Charges_Amount = null, $other_Charges_Amount = null, $miscellaneous_Charges_Amount = null, $miscellaneous_Charges_Description = null)
    {
        $this
            ->setCredit_Card_Transaction_Line_ID($credit_Card_Transaction_Line_ID)
            ->setPurchase_Order_Line_Number($purchase_Order_Line_Number)
            ->setItem_Description($item_Description)
            ->setUNSPSC_code($uNSPSC_code)
            ->setUPC($uPC)
            ->setVendor_Part_Number($vendor_Part_Number)
            ->setQuantity($quantity)
            ->setUnit_of_Measure_Reference($unit_of_Measure_Reference)
            ->setUnit_Price($unit_Price)
            ->setExtended_Amount($extended_Amount)
            ->setTax_Rate($tax_Rate)
            ->setTax_Amount($tax_Amount)
            ->setFreight_Amount($freight_Amount)
            ->setHandling_Amount($handling_Amount)
            ->setDiscount_Amount($discount_Amount)
            ->setFlat_Rate_Amount($flat_Rate_Amount)
            ->setLost_or_Damaged_Items_Amount($lost_or_Damaged_Items_Amount)
            ->setOne_Time_Miscellaneous_Charges_Amount($one_Time_Miscellaneous_Charges_Amount)
            ->setOther_Charges_Amount($other_Charges_Amount)
            ->setMiscellaneous_Charges_Amount($miscellaneous_Charges_Amount)
            ->setMiscellaneous_Charges_Description($miscellaneous_Charges_Description);
    }
    /**
     * Get Credit_Card_Transaction_Line_ID value
     * @return float|null
     */
    public function getCredit_Card_Transaction_Line_ID()
    {
        return $this->Credit_Card_Transaction_Line_ID;
    }
    /**
     * Set Credit_Card_Transaction_Line_ID value
     * @param float $credit_Card_Transaction_Line_ID
     * @return \StructType\CC_Transaction_LineType
     */
    public function setCredit_Card_Transaction_Line_ID($credit_Card_Transaction_Line_ID = null)
    {
        // validation for constraint: float
        if (!is_null($credit_Card_Transaction_Line_ID) && !(is_float($credit_Card_Transaction_Line_ID) || is_numeric($credit_Card_Transaction_Line_ID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($credit_Card_Transaction_Line_ID, true), gettype($credit_Card_Transaction_Line_ID)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($credit_Card_Transaction_Line_ID) && mb_strlen(mb_substr($credit_Card_Transaction_Line_ID, false !== mb_strpos($credit_Card_Transaction_Line_ID, '.') ? mb_strpos($credit_Card_Transaction_Line_ID, '.') + 1 : mb_strlen($credit_Card_Transaction_Line_ID))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($credit_Card_Transaction_Line_ID, true), mb_strlen(mb_substr($credit_Card_Transaction_Line_ID, mb_strpos($credit_Card_Transaction_Line_ID, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($credit_Card_Transaction_Line_ID) && $credit_Card_Transaction_Line_ID < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($credit_Card_Transaction_Line_ID, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($credit_Card_Transaction_Line_ID) && mb_strlen(preg_replace('/(\D)/', '', $credit_Card_Transaction_Line_ID)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($credit_Card_Transaction_Line_ID, true), mb_strlen(preg_replace('/(\D)/', '', $credit_Card_Transaction_Line_ID))), __LINE__);
        }
        $this->Credit_Card_Transaction_Line_ID = $credit_Card_Transaction_Line_ID;
        return $this;
    }
    /**
     * Get Purchase_Order_Line_Number value
     * @return float|null
     */
    public function getPurchase_Order_Line_Number()
    {
        return $this->Purchase_Order_Line_Number;
    }
    /**
     * Set Purchase_Order_Line_Number value
     * @param float $purchase_Order_Line_Number
     * @return \StructType\CC_Transaction_LineType
     */
    public function setPurchase_Order_Line_Number($purchase_Order_Line_Number = null)
    {
        // validation for constraint: float
        if (!is_null($purchase_Order_Line_Number) && !(is_float($purchase_Order_Line_Number) || is_numeric($purchase_Order_Line_Number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($purchase_Order_Line_Number, true), gettype($purchase_Order_Line_Number)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($purchase_Order_Line_Number) && mb_strlen(mb_substr($purchase_Order_Line_Number, false !== mb_strpos($purchase_Order_Line_Number, '.') ? mb_strpos($purchase_Order_Line_Number, '.') + 1 : mb_strlen($purchase_Order_Line_Number))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($purchase_Order_Line_Number, true), mb_strlen(mb_substr($purchase_Order_Line_Number, mb_strpos($purchase_Order_Line_Number, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($purchase_Order_Line_Number) && $purchase_Order_Line_Number < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($purchase_Order_Line_Number, true)), __LINE__);
        }
        // validation for constraint: totalDigits(4)
        if (!is_null($purchase_Order_Line_Number) && mb_strlen(preg_replace('/(\D)/', '', $purchase_Order_Line_Number)) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 4 digits, "%d" given', var_export($purchase_Order_Line_Number, true), mb_strlen(preg_replace('/(\D)/', '', $purchase_Order_Line_Number))), __LINE__);
        }
        $this->Purchase_Order_Line_Number = $purchase_Order_Line_Number;
        return $this;
    }
    /**
     * Get Item_Description value
     * @return string|null
     */
    public function getItem_Description()
    {
        return $this->Item_Description;
    }
    /**
     * Set Item_Description value
     * @param string $item_Description
     * @return \StructType\CC_Transaction_LineType
     */
    public function setItem_Description($item_Description = null)
    {
        // validation for constraint: string
        if (!is_null($item_Description) && !is_string($item_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_Description, true), gettype($item_Description)), __LINE__);
        }
        $this->Item_Description = $item_Description;
        return $this;
    }
    /**
     * Get UNSPSC_code value
     * @return float|null
     */
    public function getUNSPSC_code()
    {
        return $this->UNSPSC_code;
    }
    /**
     * Set UNSPSC_code value
     * @param float $uNSPSC_code
     * @return \StructType\CC_Transaction_LineType
     */
    public function setUNSPSC_code($uNSPSC_code = null)
    {
        // validation for constraint: float
        if (!is_null($uNSPSC_code) && !(is_float($uNSPSC_code) || is_numeric($uNSPSC_code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($uNSPSC_code, true), gettype($uNSPSC_code)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($uNSPSC_code) && mb_strlen(mb_substr($uNSPSC_code, false !== mb_strpos($uNSPSC_code, '.') ? mb_strpos($uNSPSC_code, '.') + 1 : mb_strlen($uNSPSC_code))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($uNSPSC_code, true), mb_strlen(mb_substr($uNSPSC_code, mb_strpos($uNSPSC_code, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($uNSPSC_code) && $uNSPSC_code < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($uNSPSC_code, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($uNSPSC_code) && mb_strlen(preg_replace('/(\D)/', '', $uNSPSC_code)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($uNSPSC_code, true), mb_strlen(preg_replace('/(\D)/', '', $uNSPSC_code))), __LINE__);
        }
        $this->UNSPSC_code = $uNSPSC_code;
        return $this;
    }
    /**
     * Get UPC value
     * @return string|null
     */
    public function getUPC()
    {
        return $this->UPC;
    }
    /**
     * Set UPC value
     * @param string $uPC
     * @return \StructType\CC_Transaction_LineType
     */
    public function setUPC($uPC = null)
    {
        // validation for constraint: string
        if (!is_null($uPC) && !is_string($uPC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uPC, true), gettype($uPC)), __LINE__);
        }
        $this->UPC = $uPC;
        return $this;
    }
    /**
     * Get Vendor_Part_Number value
     * @return string|null
     */
    public function getVendor_Part_Number()
    {
        return $this->Vendor_Part_Number;
    }
    /**
     * Set Vendor_Part_Number value
     * @param string $vendor_Part_Number
     * @return \StructType\CC_Transaction_LineType
     */
    public function setVendor_Part_Number($vendor_Part_Number = null)
    {
        // validation for constraint: string
        if (!is_null($vendor_Part_Number) && !is_string($vendor_Part_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendor_Part_Number, true), gettype($vendor_Part_Number)), __LINE__);
        }
        $this->Vendor_Part_Number = $vendor_Part_Number;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\CC_Transaction_LineType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($quantity) && mb_strlen(mb_substr($quantity, false !== mb_strpos($quantity, '.') ? mb_strpos($quantity, '.') + 1 : mb_strlen($quantity))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($quantity, true), mb_strlen(mb_substr($quantity, mb_strpos($quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($quantity) && mb_strlen(preg_replace('/(\D)/', '', $quantity)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($quantity, true), mb_strlen(preg_replace('/(\D)/', '', $quantity))), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Unit_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getUnit_of_Measure_Reference()
    {
        return $this->Unit_of_Measure_Reference;
    }
    /**
     * Set Unit_of_Measure_Reference value
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @return \StructType\CC_Transaction_LineType
     */
    public function setUnit_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null)
    {
        $this->Unit_of_Measure_Reference = $unit_of_Measure_Reference;
        return $this;
    }
    /**
     * Get Unit_Price value
     * @return float|null
     */
    public function getUnit_Price()
    {
        return $this->Unit_Price;
    }
    /**
     * Set Unit_Price value
     * @param float $unit_Price
     * @return \StructType\CC_Transaction_LineType
     */
    public function setUnit_Price($unit_Price = null)
    {
        // validation for constraint: float
        if (!is_null($unit_Price) && !(is_float($unit_Price) || is_numeric($unit_Price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unit_Price, true), gettype($unit_Price)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($unit_Price) && mb_strlen(mb_substr($unit_Price, false !== mb_strpos($unit_Price, '.') ? mb_strpos($unit_Price, '.') + 1 : mb_strlen($unit_Price))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($unit_Price, true), mb_strlen(mb_substr($unit_Price, mb_strpos($unit_Price, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($unit_Price) && mb_strlen(preg_replace('/(\D)/', '', $unit_Price)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($unit_Price, true), mb_strlen(preg_replace('/(\D)/', '', $unit_Price))), __LINE__);
        }
        $this->Unit_Price = $unit_Price;
        return $this;
    }
    /**
     * Get Extended_Amount value
     * @return float|null
     */
    public function getExtended_Amount()
    {
        return $this->Extended_Amount;
    }
    /**
     * Set Extended_Amount value
     * @param float $extended_Amount
     * @return \StructType\CC_Transaction_LineType
     */
    public function setExtended_Amount($extended_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($extended_Amount) && !(is_float($extended_Amount) || is_numeric($extended_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($extended_Amount, true), gettype($extended_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($extended_Amount) && mb_strlen(mb_substr($extended_Amount, false !== mb_strpos($extended_Amount, '.') ? mb_strpos($extended_Amount, '.') + 1 : mb_strlen($extended_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($extended_Amount, true), mb_strlen(mb_substr($extended_Amount, mb_strpos($extended_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($extended_Amount) && mb_strlen(preg_replace('/(\D)/', '', $extended_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($extended_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $extended_Amount))), __LINE__);
        }
        $this->Extended_Amount = $extended_Amount;
        return $this;
    }
    /**
     * Get Tax_Rate value
     * @return float|null
     */
    public function getTax_Rate()
    {
        return $this->Tax_Rate;
    }
    /**
     * Set Tax_Rate value
     * @param float $tax_Rate
     * @return \StructType\CC_Transaction_LineType
     */
    public function setTax_Rate($tax_Rate = null)
    {
        // validation for constraint: float
        if (!is_null($tax_Rate) && !(is_float($tax_Rate) || is_numeric($tax_Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax_Rate, true), gettype($tax_Rate)), __LINE__);
        }
        // validation for constraint: fractionDigits(12)
        if (!is_null($tax_Rate) && mb_strlen(mb_substr($tax_Rate, false !== mb_strpos($tax_Rate, '.') ? mb_strpos($tax_Rate, '.') + 1 : mb_strlen($tax_Rate))) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 12 fraction digits, %d given', var_export($tax_Rate, true), mb_strlen(mb_substr($tax_Rate, mb_strpos($tax_Rate, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($tax_Rate) && $tax_Rate < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($tax_Rate, true)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($tax_Rate) && mb_strlen(preg_replace('/(\D)/', '', $tax_Rate)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($tax_Rate, true), mb_strlen(preg_replace('/(\D)/', '', $tax_Rate))), __LINE__);
        }
        $this->Tax_Rate = $tax_Rate;
        return $this;
    }
    /**
     * Get Tax_Amount value
     * @return float|null
     */
    public function getTax_Amount()
    {
        return $this->Tax_Amount;
    }
    /**
     * Set Tax_Amount value
     * @param float $tax_Amount
     * @return \StructType\CC_Transaction_LineType
     */
    public function setTax_Amount($tax_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($tax_Amount) && !(is_float($tax_Amount) || is_numeric($tax_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax_Amount, true), gettype($tax_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($tax_Amount) && mb_strlen(mb_substr($tax_Amount, false !== mb_strpos($tax_Amount, '.') ? mb_strpos($tax_Amount, '.') + 1 : mb_strlen($tax_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($tax_Amount, true), mb_strlen(mb_substr($tax_Amount, mb_strpos($tax_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($tax_Amount) && mb_strlen(preg_replace('/(\D)/', '', $tax_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($tax_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $tax_Amount))), __LINE__);
        }
        $this->Tax_Amount = $tax_Amount;
        return $this;
    }
    /**
     * Get Freight_Amount value
     * @return float|null
     */
    public function getFreight_Amount()
    {
        return $this->Freight_Amount;
    }
    /**
     * Set Freight_Amount value
     * @param float $freight_Amount
     * @return \StructType\CC_Transaction_LineType
     */
    public function setFreight_Amount($freight_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($freight_Amount) && !(is_float($freight_Amount) || is_numeric($freight_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($freight_Amount, true), gettype($freight_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($freight_Amount) && mb_strlen(mb_substr($freight_Amount, false !== mb_strpos($freight_Amount, '.') ? mb_strpos($freight_Amount, '.') + 1 : mb_strlen($freight_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($freight_Amount, true), mb_strlen(mb_substr($freight_Amount, mb_strpos($freight_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($freight_Amount) && mb_strlen(preg_replace('/(\D)/', '', $freight_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($freight_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $freight_Amount))), __LINE__);
        }
        $this->Freight_Amount = $freight_Amount;
        return $this;
    }
    /**
     * Get Handling_Amount value
     * @return float|null
     */
    public function getHandling_Amount()
    {
        return $this->Handling_Amount;
    }
    /**
     * Set Handling_Amount value
     * @param float $handling_Amount
     * @return \StructType\CC_Transaction_LineType
     */
    public function setHandling_Amount($handling_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($handling_Amount) && !(is_float($handling_Amount) || is_numeric($handling_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($handling_Amount, true), gettype($handling_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($handling_Amount) && mb_strlen(mb_substr($handling_Amount, false !== mb_strpos($handling_Amount, '.') ? mb_strpos($handling_Amount, '.') + 1 : mb_strlen($handling_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($handling_Amount, true), mb_strlen(mb_substr($handling_Amount, mb_strpos($handling_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($handling_Amount) && mb_strlen(preg_replace('/(\D)/', '', $handling_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($handling_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $handling_Amount))), __LINE__);
        }
        $this->Handling_Amount = $handling_Amount;
        return $this;
    }
    /**
     * Get Discount_Amount value
     * @return float|null
     */
    public function getDiscount_Amount()
    {
        return $this->Discount_Amount;
    }
    /**
     * Set Discount_Amount value
     * @param float $discount_Amount
     * @return \StructType\CC_Transaction_LineType
     */
    public function setDiscount_Amount($discount_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($discount_Amount) && !(is_float($discount_Amount) || is_numeric($discount_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discount_Amount, true), gettype($discount_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($discount_Amount) && mb_strlen(mb_substr($discount_Amount, false !== mb_strpos($discount_Amount, '.') ? mb_strpos($discount_Amount, '.') + 1 : mb_strlen($discount_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($discount_Amount, true), mb_strlen(mb_substr($discount_Amount, mb_strpos($discount_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($discount_Amount) && mb_strlen(preg_replace('/(\D)/', '', $discount_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($discount_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $discount_Amount))), __LINE__);
        }
        $this->Discount_Amount = $discount_Amount;
        return $this;
    }
    /**
     * Get Flat_Rate_Amount value
     * @return float|null
     */
    public function getFlat_Rate_Amount()
    {
        return $this->Flat_Rate_Amount;
    }
    /**
     * Set Flat_Rate_Amount value
     * @param float $flat_Rate_Amount
     * @return \StructType\CC_Transaction_LineType
     */
    public function setFlat_Rate_Amount($flat_Rate_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($flat_Rate_Amount) && !(is_float($flat_Rate_Amount) || is_numeric($flat_Rate_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($flat_Rate_Amount, true), gettype($flat_Rate_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($flat_Rate_Amount) && mb_strlen(mb_substr($flat_Rate_Amount, false !== mb_strpos($flat_Rate_Amount, '.') ? mb_strpos($flat_Rate_Amount, '.') + 1 : mb_strlen($flat_Rate_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($flat_Rate_Amount, true), mb_strlen(mb_substr($flat_Rate_Amount, mb_strpos($flat_Rate_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($flat_Rate_Amount) && mb_strlen(preg_replace('/(\D)/', '', $flat_Rate_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($flat_Rate_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $flat_Rate_Amount))), __LINE__);
        }
        $this->Flat_Rate_Amount = $flat_Rate_Amount;
        return $this;
    }
    /**
     * Get Lost_or_Damaged_Items_Amount value
     * @return float|null
     */
    public function getLost_or_Damaged_Items_Amount()
    {
        return $this->Lost_or_Damaged_Items_Amount;
    }
    /**
     * Set Lost_or_Damaged_Items_Amount value
     * @param float $lost_or_Damaged_Items_Amount
     * @return \StructType\CC_Transaction_LineType
     */
    public function setLost_or_Damaged_Items_Amount($lost_or_Damaged_Items_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($lost_or_Damaged_Items_Amount) && !(is_float($lost_or_Damaged_Items_Amount) || is_numeric($lost_or_Damaged_Items_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lost_or_Damaged_Items_Amount, true), gettype($lost_or_Damaged_Items_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($lost_or_Damaged_Items_Amount) && mb_strlen(mb_substr($lost_or_Damaged_Items_Amount, false !== mb_strpos($lost_or_Damaged_Items_Amount, '.') ? mb_strpos($lost_or_Damaged_Items_Amount, '.') + 1 : mb_strlen($lost_or_Damaged_Items_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($lost_or_Damaged_Items_Amount, true), mb_strlen(mb_substr($lost_or_Damaged_Items_Amount, mb_strpos($lost_or_Damaged_Items_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($lost_or_Damaged_Items_Amount) && mb_strlen(preg_replace('/(\D)/', '', $lost_or_Damaged_Items_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($lost_or_Damaged_Items_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $lost_or_Damaged_Items_Amount))), __LINE__);
        }
        $this->Lost_or_Damaged_Items_Amount = $lost_or_Damaged_Items_Amount;
        return $this;
    }
    /**
     * Get One_Time_Miscellaneous_Charges_Amount value
     * @return float|null
     */
    public function getOne_Time_Miscellaneous_Charges_Amount()
    {
        return $this->One_Time_Miscellaneous_Charges_Amount;
    }
    /**
     * Set One_Time_Miscellaneous_Charges_Amount value
     * @param float $one_Time_Miscellaneous_Charges_Amount
     * @return \StructType\CC_Transaction_LineType
     */
    public function setOne_Time_Miscellaneous_Charges_Amount($one_Time_Miscellaneous_Charges_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($one_Time_Miscellaneous_Charges_Amount) && !(is_float($one_Time_Miscellaneous_Charges_Amount) || is_numeric($one_Time_Miscellaneous_Charges_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($one_Time_Miscellaneous_Charges_Amount, true), gettype($one_Time_Miscellaneous_Charges_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($one_Time_Miscellaneous_Charges_Amount) && mb_strlen(mb_substr($one_Time_Miscellaneous_Charges_Amount, false !== mb_strpos($one_Time_Miscellaneous_Charges_Amount, '.') ? mb_strpos($one_Time_Miscellaneous_Charges_Amount, '.') + 1 : mb_strlen($one_Time_Miscellaneous_Charges_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($one_Time_Miscellaneous_Charges_Amount, true), mb_strlen(mb_substr($one_Time_Miscellaneous_Charges_Amount, mb_strpos($one_Time_Miscellaneous_Charges_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($one_Time_Miscellaneous_Charges_Amount) && mb_strlen(preg_replace('/(\D)/', '', $one_Time_Miscellaneous_Charges_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($one_Time_Miscellaneous_Charges_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $one_Time_Miscellaneous_Charges_Amount))), __LINE__);
        }
        $this->One_Time_Miscellaneous_Charges_Amount = $one_Time_Miscellaneous_Charges_Amount;
        return $this;
    }
    /**
     * Get Other_Charges_Amount value
     * @return float|null
     */
    public function getOther_Charges_Amount()
    {
        return $this->Other_Charges_Amount;
    }
    /**
     * Set Other_Charges_Amount value
     * @param float $other_Charges_Amount
     * @return \StructType\CC_Transaction_LineType
     */
    public function setOther_Charges_Amount($other_Charges_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($other_Charges_Amount) && !(is_float($other_Charges_Amount) || is_numeric($other_Charges_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($other_Charges_Amount, true), gettype($other_Charges_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($other_Charges_Amount) && mb_strlen(mb_substr($other_Charges_Amount, false !== mb_strpos($other_Charges_Amount, '.') ? mb_strpos($other_Charges_Amount, '.') + 1 : mb_strlen($other_Charges_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($other_Charges_Amount, true), mb_strlen(mb_substr($other_Charges_Amount, mb_strpos($other_Charges_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($other_Charges_Amount) && mb_strlen(preg_replace('/(\D)/', '', $other_Charges_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($other_Charges_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $other_Charges_Amount))), __LINE__);
        }
        $this->Other_Charges_Amount = $other_Charges_Amount;
        return $this;
    }
    /**
     * Get Miscellaneous_Charges_Amount value
     * @return float|null
     */
    public function getMiscellaneous_Charges_Amount()
    {
        return $this->Miscellaneous_Charges_Amount;
    }
    /**
     * Set Miscellaneous_Charges_Amount value
     * @param float $miscellaneous_Charges_Amount
     * @return \StructType\CC_Transaction_LineType
     */
    public function setMiscellaneous_Charges_Amount($miscellaneous_Charges_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($miscellaneous_Charges_Amount) && !(is_float($miscellaneous_Charges_Amount) || is_numeric($miscellaneous_Charges_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($miscellaneous_Charges_Amount, true), gettype($miscellaneous_Charges_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($miscellaneous_Charges_Amount) && mb_strlen(mb_substr($miscellaneous_Charges_Amount, false !== mb_strpos($miscellaneous_Charges_Amount, '.') ? mb_strpos($miscellaneous_Charges_Amount, '.') + 1 : mb_strlen($miscellaneous_Charges_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($miscellaneous_Charges_Amount, true), mb_strlen(mb_substr($miscellaneous_Charges_Amount, mb_strpos($miscellaneous_Charges_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($miscellaneous_Charges_Amount) && mb_strlen(preg_replace('/(\D)/', '', $miscellaneous_Charges_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($miscellaneous_Charges_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $miscellaneous_Charges_Amount))), __LINE__);
        }
        $this->Miscellaneous_Charges_Amount = $miscellaneous_Charges_Amount;
        return $this;
    }
    /**
     * Get Miscellaneous_Charges_Description value
     * @return string|null
     */
    public function getMiscellaneous_Charges_Description()
    {
        return $this->Miscellaneous_Charges_Description;
    }
    /**
     * Set Miscellaneous_Charges_Description value
     * @param string $miscellaneous_Charges_Description
     * @return \StructType\CC_Transaction_LineType
     */
    public function setMiscellaneous_Charges_Description($miscellaneous_Charges_Description = null)
    {
        // validation for constraint: string
        if (!is_null($miscellaneous_Charges_Description) && !is_string($miscellaneous_Charges_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($miscellaneous_Charges_Description, true), gettype($miscellaneous_Charges_Description)), __LINE__);
        }
        $this->Miscellaneous_Charges_Description = $miscellaneous_Charges_Description;
        return $this;
    }
}
