<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_Shares_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing request criteria for the asset shares operation
 * @subpackage Structs
 */
class Asset_Shares_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Business_Assets_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing shared business asset to which the asset shares data applies
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Business_AssetObjectType[]
     */
    public $Business_Assets_Reference;
    /**
     * Constructor method for Asset_Shares_Request_CriteriaType
     * @uses Asset_Shares_Request_CriteriaType::setBusiness_Assets_Reference()
     * @param \StructType\Business_AssetObjectType[] $business_Assets_Reference
     */
    public function __construct(array $business_Assets_Reference = array())
    {
        $this
            ->setBusiness_Assets_Reference($business_Assets_Reference);
    }
    /**
     * Get Business_Assets_Reference value
     * @return \StructType\Business_AssetObjectType[]|null
     */
    public function getBusiness_Assets_Reference()
    {
        return $this->Business_Assets_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setBusiness_Assets_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusiness_Assets_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusiness_Assets_ReferenceForArrayConstraintsFromSetBusiness_Assets_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Shares_Request_CriteriaTypeBusiness_Assets_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Shares_Request_CriteriaTypeBusiness_Assets_ReferenceItem instanceof \StructType\Business_AssetObjectType) {
                $invalidValues[] = is_object($asset_Shares_Request_CriteriaTypeBusiness_Assets_ReferenceItem) ? get_class($asset_Shares_Request_CriteriaTypeBusiness_Assets_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Shares_Request_CriteriaTypeBusiness_Assets_ReferenceItem), var_export($asset_Shares_Request_CriteriaTypeBusiness_Assets_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Business_Assets_Reference property can only contain items of type \StructType\Business_AssetObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Business_Assets_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_AssetObjectType[] $business_Assets_Reference
     * @return \StructType\Asset_Shares_Request_CriteriaType
     */
    public function setBusiness_Assets_Reference(array $business_Assets_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($business_Assets_ReferenceArrayErrorMessage = self::validateBusiness_Assets_ReferenceForArrayConstraintsFromSetBusiness_Assets_Reference($business_Assets_Reference))) {
            throw new \InvalidArgumentException($business_Assets_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Business_Assets_Reference = $business_Assets_Reference;
        return $this;
    }
    /**
     * Add item to Business_Assets_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_AssetObjectType $item
     * @return \StructType\Asset_Shares_Request_CriteriaType
     */
    public function addToBusiness_Assets_Reference(\StructType\Business_AssetObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business_AssetObjectType) {
            throw new \InvalidArgumentException(sprintf('The Business_Assets_Reference property can only contain items of type \StructType\Business_AssetObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Business_Assets_Reference[] = $item;
        return $this;
    }
}
