<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_Depreciation_Detail_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains data for deprecation detail transactions for this asset.
 * @subpackage Structs
 */
class Asset_Depreciation_Detail_DataType extends AbstractStructBase
{
    /**
     * The Depreciation_Detail_Line_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_Depreciation_Detail_Line_DataType[]
     */
    public $Depreciation_Detail_Line_Data;
    /**
     * Constructor method for Asset_Depreciation_Detail_DataType
     * @uses Asset_Depreciation_Detail_DataType::setDepreciation_Detail_Line_Data()
     * @param \StructType\Asset_Depreciation_Detail_Line_DataType[] $depreciation_Detail_Line_Data
     */
    public function __construct(array $depreciation_Detail_Line_Data = array())
    {
        $this
            ->setDepreciation_Detail_Line_Data($depreciation_Detail_Line_Data);
    }
    /**
     * Get Depreciation_Detail_Line_Data value
     * @return \StructType\Asset_Depreciation_Detail_Line_DataType[]|null
     */
    public function getDepreciation_Detail_Line_Data()
    {
        return $this->Depreciation_Detail_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setDepreciation_Detail_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDepreciation_Detail_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDepreciation_Detail_Line_DataForArrayConstraintsFromSetDepreciation_Detail_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Depreciation_Detail_DataTypeDepreciation_Detail_Line_DataItem) {
            // validation for constraint: itemType
            if (!$asset_Depreciation_Detail_DataTypeDepreciation_Detail_Line_DataItem instanceof \StructType\Asset_Depreciation_Detail_Line_DataType) {
                $invalidValues[] = is_object($asset_Depreciation_Detail_DataTypeDepreciation_Detail_Line_DataItem) ? get_class($asset_Depreciation_Detail_DataTypeDepreciation_Detail_Line_DataItem) : sprintf('%s(%s)', gettype($asset_Depreciation_Detail_DataTypeDepreciation_Detail_Line_DataItem), var_export($asset_Depreciation_Detail_DataTypeDepreciation_Detail_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Depreciation_Detail_Line_Data property can only contain items of type \StructType\Asset_Depreciation_Detail_Line_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Depreciation_Detail_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Depreciation_Detail_Line_DataType[] $depreciation_Detail_Line_Data
     * @return \StructType\Asset_Depreciation_Detail_DataType
     */
    public function setDepreciation_Detail_Line_Data(array $depreciation_Detail_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($depreciation_Detail_Line_DataArrayErrorMessage = self::validateDepreciation_Detail_Line_DataForArrayConstraintsFromSetDepreciation_Detail_Line_Data($depreciation_Detail_Line_Data))) {
            throw new \InvalidArgumentException($depreciation_Detail_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->Depreciation_Detail_Line_Data = $depreciation_Detail_Line_Data;
        return $this;
    }
    /**
     * Add item to Depreciation_Detail_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Depreciation_Detail_Line_DataType $item
     * @return \StructType\Asset_Depreciation_Detail_DataType
     */
    public function addToDepreciation_Detail_Line_Data(\StructType\Asset_Depreciation_Detail_Line_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_Depreciation_Detail_Line_DataType) {
            throw new \InvalidArgumentException(sprintf('The Depreciation_Detail_Line_Data property can only contain items of type \StructType\Asset_Depreciation_Detail_Line_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Depreciation_Detail_Line_Data[] = $item;
        return $this;
    }
}
