<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirlineType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper Element for Airline Data
 * @subpackage Structs
 */
class AirlineType extends AbstractStructBase
{
    /**
     * The Airline_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Airline
     * - minOccurs: 0
     * @var \StructType\AirlineObjectType
     */
    public $Airline_Reference;
    /**
     * The Airline_Data
     * Meta information extracted from the WSDL
     * - documentation: Airline Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Airline_DataType[]
     */
    public $Airline_Data;
    /**
     * Constructor method for AirlineType
     * @uses AirlineType::setAirline_Reference()
     * @uses AirlineType::setAirline_Data()
     * @param \StructType\AirlineObjectType $airline_Reference
     * @param \StructType\Airline_DataType[] $airline_Data
     */
    public function __construct(\StructType\AirlineObjectType $airline_Reference = null, array $airline_Data = array())
    {
        $this
            ->setAirline_Reference($airline_Reference)
            ->setAirline_Data($airline_Data);
    }
    /**
     * Get Airline_Reference value
     * @return \StructType\AirlineObjectType|null
     */
    public function getAirline_Reference()
    {
        return $this->Airline_Reference;
    }
    /**
     * Set Airline_Reference value
     * @param \StructType\AirlineObjectType $airline_Reference
     * @return \StructType\AirlineType
     */
    public function setAirline_Reference(\StructType\AirlineObjectType $airline_Reference = null)
    {
        $this->Airline_Reference = $airline_Reference;
        return $this;
    }
    /**
     * Get Airline_Data value
     * @return \StructType\Airline_DataType[]|null
     */
    public function getAirline_Data()
    {
        return $this->Airline_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAirline_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirline_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirline_DataForArrayConstraintsFromSetAirline_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlineTypeAirline_DataItem) {
            // validation for constraint: itemType
            if (!$airlineTypeAirline_DataItem instanceof \StructType\Airline_DataType) {
                $invalidValues[] = is_object($airlineTypeAirline_DataItem) ? get_class($airlineTypeAirline_DataItem) : sprintf('%s(%s)', gettype($airlineTypeAirline_DataItem), var_export($airlineTypeAirline_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Airline_Data property can only contain items of type \StructType\Airline_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Airline_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Airline_DataType[] $airline_Data
     * @return \StructType\AirlineType
     */
    public function setAirline_Data(array $airline_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($airline_DataArrayErrorMessage = self::validateAirline_DataForArrayConstraintsFromSetAirline_Data($airline_Data))) {
            throw new \InvalidArgumentException($airline_DataArrayErrorMessage, __LINE__);
        }
        $this->Airline_Data = $airline_Data;
        return $this;
    }
    /**
     * Add item to Airline_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Airline_DataType $item
     * @return \StructType\AirlineType
     */
    public function addToAirline_Data(\StructType\Airline_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Airline_DataType) {
            throw new \InvalidArgumentException(sprintf('The Airline_Data property can only contain items of type \StructType\Airline_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Airline_Data[] = $item;
        return $this;
    }
}
