<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cancel ServiceType
 * @subpackage Services
 */
class Cancel extends AbstractSoapClientBase
{
    /**
     * Sets the Workday_Common_Header SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\Workday_Common_HeaderType $workday_Common_Header
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderWorkday_Common_Header(\StructType\Workday_Common_HeaderType $workday_Common_Header, $nameSpace = 'urn:com.workday/bsvc', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Workday_Common_Header', $workday_Common_Header, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named Cancel_Supplier_Invoice
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service will cancel a Supplier InvoiceNo Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Cancel_Supplier_Invoice_RequestType $body
     * @return \StructType\Cancel_Supplier_Invoice_ResponseType|bool
     */
    public function Cancel_Supplier_Invoice(\StructType\Cancel_Supplier_Invoice_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Cancel_Supplier_Invoice($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Cancel_Supplier_Invoice_Adjustment
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service will cancel a Supplier Invoice AdjustmentNo Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Cancel_Supplier_Invoice_Adjustment_RequestType $body
     * @return \StructType\Cancel_Supplier_Invoice_Adjustment_ResponseType|bool
     */
    public function Cancel_Supplier_Invoice_Adjustment(\StructType\Cancel_Supplier_Invoice_Adjustment_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Cancel_Supplier_Invoice_Adjustment($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Cancel_Expense_Report
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will cancel an Expense Report.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Cancel_Expense_Report_RequestType $body
     * @return \StructType\Cancel_Expense_Report_ResponseType|bool
     */
    public function Cancel_Expense_Report(\StructType\Cancel_Expense_Report_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Cancel_Expense_Report($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Cancel_Timesheet
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will cancel a Timesheet.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Cancel_Timesheet_RequestType $body
     * @return \StructType\Cancel_Timesheet_ResponseType|bool
     */
    public function Cancel_Timesheet(\StructType\Cancel_Timesheet_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Cancel_Timesheet($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Cancel_Purchase_Order
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service will cancel a Purchase OrderNo Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Cancel_Purchase_Order_RequestType $body
     * @return \StructType\Cancel_Purchase_Order_ResponseType|bool
     */
    public function Cancel_Purchase_Order(\StructType\Cancel_Purchase_Order_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Cancel_Purchase_Order($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Cancel_Requisition
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This Service will cancel a Requisition.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Cancel_Requisition_RequestType $body
     * @return \StructType\Cancel_Requisition_ResponseType|bool
     */
    public function Cancel_Requisition(\StructType\Cancel_Requisition_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Cancel_Requisition($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Cancel_Receipt
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service will cancel a valid ReceiptNo Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Cancel_Receipt_RequestType $body
     * @return \StructType\Cancel_Receipt_ResponseType|bool
     */
    public function Cancel_Receipt(\StructType\Cancel_Receipt_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Cancel_Receipt($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Cancel_Request_for_Quote_Response
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service will cancel a Request for Quote Response.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Cancel_Request_for_Quote_Response_RequestType $body
     * @return \StructType\Cancel_Request_for_Quote_Response_ResponseType|bool
     */
    public function Cancel_Request_for_Quote_Response(\StructType\Cancel_Request_for_Quote_Response_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Cancel_Request_for_Quote_Response($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Cancel_Internal_Service_Delivery
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This Web service operation is used to cancel an existing Internal Service Delivery.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Cancel_Internal_Service_Delivery_RequestType $body
     * @return \StructType\Cancel_Internal_Service_Delivery_ResponseType|bool
     */
    public function Cancel_Internal_Service_Delivery(\StructType\Cancel_Internal_Service_Delivery_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Cancel_Internal_Service_Delivery($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Cancel_Advanced_Ship_Notice
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service will cancel an Advanced Ship NoticeNo Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Cancel_Advanced_Ship_Notice_RequestType $body
     * @return \StructType\Cancel_Advanced_Ship_Notice_ResponseType|bool
     */
    public function Cancel_Advanced_Ship_Notice(\StructType\Cancel_Advanced_Ship_Notice_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Cancel_Advanced_Ship_Notice($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Cancel_Purchase_Order_Acknowledgement
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service will cancel a Purchase Order AcknowledgementNo Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Cancel_Purchase_Order_Acknowledgement_RequestType $body
     * @return \StructType\Cancel_Purchase_Order_Acknowledgement_ResponseType|bool
     */
    public function Cancel_Purchase_Order_Acknowledgement(\StructType\Cancel_Purchase_Order_Acknowledgement_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Cancel_Purchase_Order_Acknowledgement($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * Cancel_Procurement_Card_Transaction_Verification
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service will cancel a Procurement Card Transaction VerificationNo Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Cancel_Procurement_Card_Transaction_Verification_RequestType $body
     * @return \StructType\Cancel_Procurement_Card_Transaction_Verification_ResponseType|bool
     */
    public function Cancel_Procurement_Card_Transaction_Verification(\StructType\Cancel_Procurement_Card_Transaction_Verification_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Cancel_Procurement_Card_Transaction_Verification($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Cancel_Pending_Supplier_Change
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: Cancels pending changes to a Supplier.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Cancel_Pending_Supplier_Change_RequestType $body
     * @return \StructType\Cancel_Pending_Supplier_Change_ResponseType|bool
     */
    public function Cancel_Pending_Supplier_Change(\StructType\Cancel_Pending_Supplier_Change_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Cancel_Pending_Supplier_Change($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Cancel_Spend_Authorization
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service operation will cancel a Spend Authorization.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Cancel_Spend_Authorization_RequestType $body
     * @return \StructType\Cancel_Spend_Authorization_ResponseType|bool
     */
    public function Cancel_Spend_Authorization(\StructType\Cancel_Spend_Authorization_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Cancel_Spend_Authorization($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Cancel_Receipt_Adjustment
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service will cancel a Receipt AdjustmentNo Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Cancel_Receipt_Adjustment_RequestType $body
     * @return \StructType\Cancel_Receipt_Adjustment_ResponseType|bool
     */
    public function Cancel_Receipt_Adjustment(\StructType\Cancel_Receipt_Adjustment_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Cancel_Receipt_Adjustment($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Cancel_Netting_Transaction
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service will cancel a Netting TransactionNo Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Cancel_Netting_Transaction_RequestType $body
     * @return \StructType\Cancel_Netting_Transaction_ResponseType|bool
     */
    public function Cancel_Netting_Transaction(\StructType\Cancel_Netting_Transaction_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Cancel_Netting_Transaction($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named Cancel_Supplier_Payment
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Workday_Common_Header
     * - SOAPHeaderNamespaces: urn:com.workday/bsvc
     * - SOAPHeaderTypes: \StructType\Workday_Common_HeaderType
     * - SOAPHeaders: required
     * - documentation: This service will cancel a Supplier Payment.No Information
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Cancel_Supplier_Payment_RequestType $body
     * @return \StructType\Cancel_Supplier_Payment_ResponseType|bool
     */
    public function Cancel_Supplier_Payment(\StructType\Cancel_Supplier_Payment_RequestType $body)
    {
        try {
            $this->setResult($this->getSoapClient()->Cancel_Supplier_Payment($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Cancel_Advanced_Ship_Notice_ResponseType|\StructType\Cancel_Expense_Report_ResponseType|\StructType\Cancel_Internal_Service_Delivery_ResponseType|\StructType\Cancel_Netting_Transaction_ResponseType|\StructType\Cancel_Pending_Supplier_Change_ResponseType|\StructType\Cancel_Procurement_Card_Transaction_Verification_ResponseType|\StructType\Cancel_Purchase_Order_Acknowledgement_ResponseType|\StructType\Cancel_Purchase_Order_ResponseType|\StructType\Cancel_Receipt_Adjustment_ResponseType|\StructType\Cancel_Receipt_ResponseType|\StructType\Cancel_Request_for_Quote_Response_ResponseType|\StructType\Cancel_Requisition_ResponseType|\StructType\Cancel_Spend_Authorization_ResponseType|\StructType\Cancel_Supplier_Invoice_Adjustment_ResponseType|\StructType\Cancel_Supplier_Invoice_ResponseType|\StructType\Cancel_Supplier_Payment_ResponseType|\StructType\Cancel_Timesheet_ResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
