<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Transfer_Pricing_Rate_Sheet_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains transfer pricing rate sheet data based on the request parameters or submits data.
 * @subpackage Structs
 */
class Transfer_Pricing_Rate_Sheet_DataType extends AbstractStructBase
{
    /**
     * The Transfer_Pricing_Rate_Sheet_ID
     * Meta information extracted from the WSDL
     * - documentation: ID of the transfer pricing rate sheet.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Transfer_Pricing_Rate_Sheet_ID;
    /**
     * The Transfer_Pricing_Rate_Sheet_Name
     * Meta information extracted from the WSDL
     * - documentation: The unique name of the transfer pricing rate sheet.
     * - maxOccurs: 1
     * @var string
     */
    public $Transfer_Pricing_Rate_Sheet_Name;
    /**
     * The Rate_Sheet_Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: The currency for this transfer pricing rate sheet. Required for the Put web service.
     * @var \StructType\CurrencyObjectType
     */
    public $Rate_Sheet_Currency_Reference;
    /**
     * The Transfer_Pricing_Rate_Sheet_Snapshot_Data
     * Meta information extracted from the WSDL
     * - documentation: Contains the snapshot of the transfer pricing rate sheet data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Transfer_Pricing_Rate_Sheet_Snapshot_DataType[]
     */
    public $Transfer_Pricing_Rate_Sheet_Snapshot_Data;
    /**
     * Constructor method for Transfer_Pricing_Rate_Sheet_DataType
     * @uses Transfer_Pricing_Rate_Sheet_DataType::setTransfer_Pricing_Rate_Sheet_ID()
     * @uses Transfer_Pricing_Rate_Sheet_DataType::setTransfer_Pricing_Rate_Sheet_Name()
     * @uses Transfer_Pricing_Rate_Sheet_DataType::setRate_Sheet_Currency_Reference()
     * @uses Transfer_Pricing_Rate_Sheet_DataType::setTransfer_Pricing_Rate_Sheet_Snapshot_Data()
     * @param string $transfer_Pricing_Rate_Sheet_ID
     * @param string $transfer_Pricing_Rate_Sheet_Name
     * @param \StructType\CurrencyObjectType $rate_Sheet_Currency_Reference
     * @param \StructType\Transfer_Pricing_Rate_Sheet_Snapshot_DataType[] $transfer_Pricing_Rate_Sheet_Snapshot_Data
     */
    public function __construct($transfer_Pricing_Rate_Sheet_ID = null, $transfer_Pricing_Rate_Sheet_Name = null, \StructType\CurrencyObjectType $rate_Sheet_Currency_Reference = null, array $transfer_Pricing_Rate_Sheet_Snapshot_Data = array())
    {
        $this
            ->setTransfer_Pricing_Rate_Sheet_ID($transfer_Pricing_Rate_Sheet_ID)
            ->setTransfer_Pricing_Rate_Sheet_Name($transfer_Pricing_Rate_Sheet_Name)
            ->setRate_Sheet_Currency_Reference($rate_Sheet_Currency_Reference)
            ->setTransfer_Pricing_Rate_Sheet_Snapshot_Data($transfer_Pricing_Rate_Sheet_Snapshot_Data);
    }
    /**
     * Get Transfer_Pricing_Rate_Sheet_ID value
     * @return string|null
     */
    public function getTransfer_Pricing_Rate_Sheet_ID()
    {
        return $this->Transfer_Pricing_Rate_Sheet_ID;
    }
    /**
     * Set Transfer_Pricing_Rate_Sheet_ID value
     * @param string $transfer_Pricing_Rate_Sheet_ID
     * @return \StructType\Transfer_Pricing_Rate_Sheet_DataType
     */
    public function setTransfer_Pricing_Rate_Sheet_ID($transfer_Pricing_Rate_Sheet_ID = null)
    {
        // validation for constraint: string
        if (!is_null($transfer_Pricing_Rate_Sheet_ID) && !is_string($transfer_Pricing_Rate_Sheet_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transfer_Pricing_Rate_Sheet_ID, true), gettype($transfer_Pricing_Rate_Sheet_ID)), __LINE__);
        }
        $this->Transfer_Pricing_Rate_Sheet_ID = $transfer_Pricing_Rate_Sheet_ID;
        return $this;
    }
    /**
     * Get Transfer_Pricing_Rate_Sheet_Name value
     * @return string|null
     */
    public function getTransfer_Pricing_Rate_Sheet_Name()
    {
        return $this->Transfer_Pricing_Rate_Sheet_Name;
    }
    /**
     * Set Transfer_Pricing_Rate_Sheet_Name value
     * @param string $transfer_Pricing_Rate_Sheet_Name
     * @return \StructType\Transfer_Pricing_Rate_Sheet_DataType
     */
    public function setTransfer_Pricing_Rate_Sheet_Name($transfer_Pricing_Rate_Sheet_Name = null)
    {
        // validation for constraint: string
        if (!is_null($transfer_Pricing_Rate_Sheet_Name) && !is_string($transfer_Pricing_Rate_Sheet_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transfer_Pricing_Rate_Sheet_Name, true), gettype($transfer_Pricing_Rate_Sheet_Name)), __LINE__);
        }
        $this->Transfer_Pricing_Rate_Sheet_Name = $transfer_Pricing_Rate_Sheet_Name;
        return $this;
    }
    /**
     * Get Rate_Sheet_Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getRate_Sheet_Currency_Reference()
    {
        return $this->Rate_Sheet_Currency_Reference;
    }
    /**
     * Set Rate_Sheet_Currency_Reference value
     * @param \StructType\CurrencyObjectType $rate_Sheet_Currency_Reference
     * @return \StructType\Transfer_Pricing_Rate_Sheet_DataType
     */
    public function setRate_Sheet_Currency_Reference(\StructType\CurrencyObjectType $rate_Sheet_Currency_Reference = null)
    {
        $this->Rate_Sheet_Currency_Reference = $rate_Sheet_Currency_Reference;
        return $this;
    }
    /**
     * Get Transfer_Pricing_Rate_Sheet_Snapshot_Data value
     * @return \StructType\Transfer_Pricing_Rate_Sheet_Snapshot_DataType[]|null
     */
    public function getTransfer_Pricing_Rate_Sheet_Snapshot_Data()
    {
        return $this->Transfer_Pricing_Rate_Sheet_Snapshot_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setTransfer_Pricing_Rate_Sheet_Snapshot_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransfer_Pricing_Rate_Sheet_Snapshot_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransfer_Pricing_Rate_Sheet_Snapshot_DataForArrayConstraintsFromSetTransfer_Pricing_Rate_Sheet_Snapshot_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transfer_Pricing_Rate_Sheet_DataTypeTransfer_Pricing_Rate_Sheet_Snapshot_DataItem) {
            // validation for constraint: itemType
            if (!$transfer_Pricing_Rate_Sheet_DataTypeTransfer_Pricing_Rate_Sheet_Snapshot_DataItem instanceof \StructType\Transfer_Pricing_Rate_Sheet_Snapshot_DataType) {
                $invalidValues[] = is_object($transfer_Pricing_Rate_Sheet_DataTypeTransfer_Pricing_Rate_Sheet_Snapshot_DataItem) ? get_class($transfer_Pricing_Rate_Sheet_DataTypeTransfer_Pricing_Rate_Sheet_Snapshot_DataItem) : sprintf('%s(%s)', gettype($transfer_Pricing_Rate_Sheet_DataTypeTransfer_Pricing_Rate_Sheet_Snapshot_DataItem), var_export($transfer_Pricing_Rate_Sheet_DataTypeTransfer_Pricing_Rate_Sheet_Snapshot_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Transfer_Pricing_Rate_Sheet_Snapshot_Data property can only contain items of type \StructType\Transfer_Pricing_Rate_Sheet_Snapshot_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Transfer_Pricing_Rate_Sheet_Snapshot_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Transfer_Pricing_Rate_Sheet_Snapshot_DataType[] $transfer_Pricing_Rate_Sheet_Snapshot_Data
     * @return \StructType\Transfer_Pricing_Rate_Sheet_DataType
     */
    public function setTransfer_Pricing_Rate_Sheet_Snapshot_Data(array $transfer_Pricing_Rate_Sheet_Snapshot_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($transfer_Pricing_Rate_Sheet_Snapshot_DataArrayErrorMessage = self::validateTransfer_Pricing_Rate_Sheet_Snapshot_DataForArrayConstraintsFromSetTransfer_Pricing_Rate_Sheet_Snapshot_Data($transfer_Pricing_Rate_Sheet_Snapshot_Data))) {
            throw new \InvalidArgumentException($transfer_Pricing_Rate_Sheet_Snapshot_DataArrayErrorMessage, __LINE__);
        }
        $this->Transfer_Pricing_Rate_Sheet_Snapshot_Data = $transfer_Pricing_Rate_Sheet_Snapshot_Data;
        return $this;
    }
    /**
     * Add item to Transfer_Pricing_Rate_Sheet_Snapshot_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Transfer_Pricing_Rate_Sheet_Snapshot_DataType $item
     * @return \StructType\Transfer_Pricing_Rate_Sheet_DataType
     */
    public function addToTransfer_Pricing_Rate_Sheet_Snapshot_Data(\StructType\Transfer_Pricing_Rate_Sheet_Snapshot_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Transfer_Pricing_Rate_Sheet_Snapshot_DataType) {
            throw new \InvalidArgumentException(sprintf('The Transfer_Pricing_Rate_Sheet_Snapshot_Data property can only contain items of type \StructType\Transfer_Pricing_Rate_Sheet_Snapshot_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Transfer_Pricing_Rate_Sheet_Snapshot_Data[] = $item;
        return $this;
    }
}
