<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_RefundType StructType
 * Meta information extracted from the WSDL
 * - documentation: Supplier Refund Response Data
 * @subpackage Structs
 */
class Supplier_RefundType extends AbstractStructBase
{
    /**
     * The Supplier_Refund_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Refund Reference
     * - minOccurs: 0
     * @var \StructType\Supplier_RefundObjectType
     */
    public $Supplier_Refund_Reference;
    /**
     * The Supplier_Refund_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Refund_DataType[]
     */
    public $Supplier_Refund_Data;
    /**
     * Constructor method for Supplier_RefundType
     * @uses Supplier_RefundType::setSupplier_Refund_Reference()
     * @uses Supplier_RefundType::setSupplier_Refund_Data()
     * @param \StructType\Supplier_RefundObjectType $supplier_Refund_Reference
     * @param \StructType\Supplier_Refund_DataType[] $supplier_Refund_Data
     */
    public function __construct(\StructType\Supplier_RefundObjectType $supplier_Refund_Reference = null, array $supplier_Refund_Data = array())
    {
        $this
            ->setSupplier_Refund_Reference($supplier_Refund_Reference)
            ->setSupplier_Refund_Data($supplier_Refund_Data);
    }
    /**
     * Get Supplier_Refund_Reference value
     * @return \StructType\Supplier_RefundObjectType|null
     */
    public function getSupplier_Refund_Reference()
    {
        return $this->Supplier_Refund_Reference;
    }
    /**
     * Set Supplier_Refund_Reference value
     * @param \StructType\Supplier_RefundObjectType $supplier_Refund_Reference
     * @return \StructType\Supplier_RefundType
     */
    public function setSupplier_Refund_Reference(\StructType\Supplier_RefundObjectType $supplier_Refund_Reference = null)
    {
        $this->Supplier_Refund_Reference = $supplier_Refund_Reference;
        return $this;
    }
    /**
     * Get Supplier_Refund_Data value
     * @return \StructType\Supplier_Refund_DataType[]|null
     */
    public function getSupplier_Refund_Data()
    {
        return $this->Supplier_Refund_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Refund_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Refund_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Refund_DataForArrayConstraintsFromSetSupplier_Refund_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_RefundTypeSupplier_Refund_DataItem) {
            // validation for constraint: itemType
            if (!$supplier_RefundTypeSupplier_Refund_DataItem instanceof \StructType\Supplier_Refund_DataType) {
                $invalidValues[] = is_object($supplier_RefundTypeSupplier_Refund_DataItem) ? get_class($supplier_RefundTypeSupplier_Refund_DataItem) : sprintf('%s(%s)', gettype($supplier_RefundTypeSupplier_Refund_DataItem), var_export($supplier_RefundTypeSupplier_Refund_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Refund_Data property can only contain items of type \StructType\Supplier_Refund_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Refund_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Refund_DataType[] $supplier_Refund_Data
     * @return \StructType\Supplier_RefundType
     */
    public function setSupplier_Refund_Data(array $supplier_Refund_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Refund_DataArrayErrorMessage = self::validateSupplier_Refund_DataForArrayConstraintsFromSetSupplier_Refund_Data($supplier_Refund_Data))) {
            throw new \InvalidArgumentException($supplier_Refund_DataArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Refund_Data = $supplier_Refund_Data;
        return $this;
    }
    /**
     * Add item to Supplier_Refund_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Refund_DataType $item
     * @return \StructType\Supplier_RefundType
     */
    public function addToSupplier_Refund_Data(\StructType\Supplier_Refund_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Refund_DataType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Refund_Data property can only contain items of type \StructType\Supplier_Refund_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Refund_Data[] = $item;
        return $this;
    }
}
