<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Supplier_Invoice_Work_Queue_Information_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: References all the information related to the Supplier Invoice Work Queue tab.
 * @subpackage Structs
 */
class Supplier_Invoice_Work_Queue_Information_DataType extends AbstractStructBase
{
    /**
     * The Processed_by_OCR
     * Meta information extracted from the WSDL
     * - documentation: True if this is an invoice processed by Supplier Invoice OCR. You can't specify a value in this field.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Processed_by_OCR;
    /**
     * The Created_from_Multi_Invoice_File
     * Meta information extracted from the WSDL
     * - documentation: True if this is an invoice processed by Supplier Invoice OCR and created from a file that contains multiple invoices in a single attachment. You can't specify a value in this field.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Created_from_Multi_Invoice_File;
    /**
     * The Originating_Supplier_Invoice_Document_Reference
     * Meta information extracted from the WSDL
     * - documentation: The invoice document that originated the converted supplier invoice or supplier invoice adjustment. You can't specify a value in this field.
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_DocumentObjectType
     */
    public $Originating_Supplier_Invoice_Document_Reference;
    /**
     * The Resulting_Supplier_Invoice_Document_Reference
     * Meta information extracted from the WSDL
     * - documentation: The invoice document that resulted from the converted supplier invoice or supplier invoice adjustment. You can't specify a value in this field.
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_DocumentObjectType
     */
    public $Resulting_Supplier_Invoice_Document_Reference;
    /**
     * The Assignee_Reference
     * Meta information extracted from the WSDL
     * - documentation: Use this field to override the Assignee in the Supplier Invoice Work Queue. Leave blank to default the value from the Supplier Invoice Assignment Rules. When there aren't assignment rules set up, Workday populates the user submitting
     * the request.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Assignee_Reference;
    /**
     * The Work_Queue_Tags_Reference
     * Meta information extracted from the WSDL
     * - documentation: Use this field to override the Work Queue Tags in the Supplier Invoice Work Queue. Leave blank to default the value from the Supplier Invoice Work Queue Tag Assignment Rules. When there aren't assignment rules set up, Workday leaves
     * the field blank.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_Work_Queue_TagObjectType[]
     */
    public $Work_Queue_Tags_Reference;
    /**
     * The Work_Queue_Notes
     * Meta information extracted from the WSDL
     * - documentation: Adds notes related to the supplier invoice in the work queue.
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Work_Queue_Notes;
    /**
     * Constructor method for Supplier_Invoice_Work_Queue_Information_DataType
     * @uses Supplier_Invoice_Work_Queue_Information_DataType::setProcessed_by_OCR()
     * @uses Supplier_Invoice_Work_Queue_Information_DataType::setCreated_from_Multi_Invoice_File()
     * @uses Supplier_Invoice_Work_Queue_Information_DataType::setOriginating_Supplier_Invoice_Document_Reference()
     * @uses Supplier_Invoice_Work_Queue_Information_DataType::setResulting_Supplier_Invoice_Document_Reference()
     * @uses Supplier_Invoice_Work_Queue_Information_DataType::setAssignee_Reference()
     * @uses Supplier_Invoice_Work_Queue_Information_DataType::setWork_Queue_Tags_Reference()
     * @uses Supplier_Invoice_Work_Queue_Information_DataType::setWork_Queue_Notes()
     * @param bool $processed_by_OCR
     * @param bool $created_from_Multi_Invoice_File
     * @param \StructType\Supplier_Invoice_DocumentObjectType $originating_Supplier_Invoice_Document_Reference
     * @param \StructType\Supplier_Invoice_DocumentObjectType $resulting_Supplier_Invoice_Document_Reference
     * @param \StructType\WorkerObjectType $assignee_Reference
     * @param \StructType\Supplier_Invoice_Work_Queue_TagObjectType[] $work_Queue_Tags_Reference
     * @param string $work_Queue_Notes
     */
    public function __construct($processed_by_OCR = null, $created_from_Multi_Invoice_File = null, \StructType\Supplier_Invoice_DocumentObjectType $originating_Supplier_Invoice_Document_Reference = null, \StructType\Supplier_Invoice_DocumentObjectType $resulting_Supplier_Invoice_Document_Reference = null, \StructType\WorkerObjectType $assignee_Reference = null, array $work_Queue_Tags_Reference = array(), $work_Queue_Notes = null)
    {
        $this
            ->setProcessed_by_OCR($processed_by_OCR)
            ->setCreated_from_Multi_Invoice_File($created_from_Multi_Invoice_File)
            ->setOriginating_Supplier_Invoice_Document_Reference($originating_Supplier_Invoice_Document_Reference)
            ->setResulting_Supplier_Invoice_Document_Reference($resulting_Supplier_Invoice_Document_Reference)
            ->setAssignee_Reference($assignee_Reference)
            ->setWork_Queue_Tags_Reference($work_Queue_Tags_Reference)
            ->setWork_Queue_Notes($work_Queue_Notes);
    }
    /**
     * Get Processed_by_OCR value
     * @return bool|null
     */
    public function getProcessed_by_OCR()
    {
        return $this->Processed_by_OCR;
    }
    /**
     * Set Processed_by_OCR value
     * @param bool $processed_by_OCR
     * @return \StructType\Supplier_Invoice_Work_Queue_Information_DataType
     */
    public function setProcessed_by_OCR($processed_by_OCR = null)
    {
        // validation for constraint: boolean
        if (!is_null($processed_by_OCR) && !is_bool($processed_by_OCR)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($processed_by_OCR, true), gettype($processed_by_OCR)), __LINE__);
        }
        $this->Processed_by_OCR = $processed_by_OCR;
        return $this;
    }
    /**
     * Get Created_from_Multi_Invoice_File value
     * @return bool|null
     */
    public function getCreated_from_Multi_Invoice_File()
    {
        return $this->{'Created_from_Multi-Invoice_File'};
    }
    /**
     * Set Created_from_Multi_Invoice_File value
     * @param bool $created_from_Multi_Invoice_File
     * @return \StructType\Supplier_Invoice_Work_Queue_Information_DataType
     */
    public function setCreated_from_Multi_Invoice_File($created_from_Multi_Invoice_File = null)
    {
        // validation for constraint: boolean
        if (!is_null($created_from_Multi_Invoice_File) && !is_bool($created_from_Multi_Invoice_File)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($created_from_Multi_Invoice_File, true), gettype($created_from_Multi_Invoice_File)), __LINE__);
        }
        $this->Created_from_Multi_Invoice_File = $this->{'Created_from_Multi-Invoice_File'} = $created_from_Multi_Invoice_File;
        return $this;
    }
    /**
     * Get Originating_Supplier_Invoice_Document_Reference value
     * @return \StructType\Supplier_Invoice_DocumentObjectType|null
     */
    public function getOriginating_Supplier_Invoice_Document_Reference()
    {
        return $this->Originating_Supplier_Invoice_Document_Reference;
    }
    /**
     * Set Originating_Supplier_Invoice_Document_Reference value
     * @param \StructType\Supplier_Invoice_DocumentObjectType $originating_Supplier_Invoice_Document_Reference
     * @return \StructType\Supplier_Invoice_Work_Queue_Information_DataType
     */
    public function setOriginating_Supplier_Invoice_Document_Reference(\StructType\Supplier_Invoice_DocumentObjectType $originating_Supplier_Invoice_Document_Reference = null)
    {
        $this->Originating_Supplier_Invoice_Document_Reference = $originating_Supplier_Invoice_Document_Reference;
        return $this;
    }
    /**
     * Get Resulting_Supplier_Invoice_Document_Reference value
     * @return \StructType\Supplier_Invoice_DocumentObjectType|null
     */
    public function getResulting_Supplier_Invoice_Document_Reference()
    {
        return $this->Resulting_Supplier_Invoice_Document_Reference;
    }
    /**
     * Set Resulting_Supplier_Invoice_Document_Reference value
     * @param \StructType\Supplier_Invoice_DocumentObjectType $resulting_Supplier_Invoice_Document_Reference
     * @return \StructType\Supplier_Invoice_Work_Queue_Information_DataType
     */
    public function setResulting_Supplier_Invoice_Document_Reference(\StructType\Supplier_Invoice_DocumentObjectType $resulting_Supplier_Invoice_Document_Reference = null)
    {
        $this->Resulting_Supplier_Invoice_Document_Reference = $resulting_Supplier_Invoice_Document_Reference;
        return $this;
    }
    /**
     * Get Assignee_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getAssignee_Reference()
    {
        return $this->Assignee_Reference;
    }
    /**
     * Set Assignee_Reference value
     * @param \StructType\WorkerObjectType $assignee_Reference
     * @return \StructType\Supplier_Invoice_Work_Queue_Information_DataType
     */
    public function setAssignee_Reference(\StructType\WorkerObjectType $assignee_Reference = null)
    {
        $this->Assignee_Reference = $assignee_Reference;
        return $this;
    }
    /**
     * Get Work_Queue_Tags_Reference value
     * @return \StructType\Supplier_Invoice_Work_Queue_TagObjectType[]|null
     */
    public function getWork_Queue_Tags_Reference()
    {
        return $this->Work_Queue_Tags_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWork_Queue_Tags_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWork_Queue_Tags_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWork_Queue_Tags_ReferenceForArrayConstraintsFromSetWork_Queue_Tags_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supplier_Invoice_Work_Queue_Information_DataTypeWork_Queue_Tags_ReferenceItem) {
            // validation for constraint: itemType
            if (!$supplier_Invoice_Work_Queue_Information_DataTypeWork_Queue_Tags_ReferenceItem instanceof \StructType\Supplier_Invoice_Work_Queue_TagObjectType) {
                $invalidValues[] = is_object($supplier_Invoice_Work_Queue_Information_DataTypeWork_Queue_Tags_ReferenceItem) ? get_class($supplier_Invoice_Work_Queue_Information_DataTypeWork_Queue_Tags_ReferenceItem) : sprintf('%s(%s)', gettype($supplier_Invoice_Work_Queue_Information_DataTypeWork_Queue_Tags_ReferenceItem), var_export($supplier_Invoice_Work_Queue_Information_DataTypeWork_Queue_Tags_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Work_Queue_Tags_Reference property can only contain items of type \StructType\Supplier_Invoice_Work_Queue_TagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Work_Queue_Tags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Work_Queue_TagObjectType[] $work_Queue_Tags_Reference
     * @return \StructType\Supplier_Invoice_Work_Queue_Information_DataType
     */
    public function setWork_Queue_Tags_Reference(array $work_Queue_Tags_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($work_Queue_Tags_ReferenceArrayErrorMessage = self::validateWork_Queue_Tags_ReferenceForArrayConstraintsFromSetWork_Queue_Tags_Reference($work_Queue_Tags_Reference))) {
            throw new \InvalidArgumentException($work_Queue_Tags_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Work_Queue_Tags_Reference = $work_Queue_Tags_Reference;
        return $this;
    }
    /**
     * Add item to Work_Queue_Tags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Work_Queue_TagObjectType $item
     * @return \StructType\Supplier_Invoice_Work_Queue_Information_DataType
     */
    public function addToWork_Queue_Tags_Reference(\StructType\Supplier_Invoice_Work_Queue_TagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Invoice_Work_Queue_TagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Work_Queue_Tags_Reference property can only contain items of type \StructType\Supplier_Invoice_Work_Queue_TagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Work_Queue_Tags_Reference[] = $item;
        return $this;
    }
    /**
     * Get Work_Queue_Notes value
     * @return string|null
     */
    public function getWork_Queue_Notes()
    {
        return $this->Work_Queue_Notes;
    }
    /**
     * Set Work_Queue_Notes value
     * @param string $work_Queue_Notes
     * @return \StructType\Supplier_Invoice_Work_Queue_Information_DataType
     */
    public function setWork_Queue_Notes($work_Queue_Notes = null)
    {
        // validation for constraint: string
        if (!is_null($work_Queue_Notes) && !is_string($work_Queue_Notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($work_Queue_Notes, true), gettype($work_Queue_Notes)), __LINE__);
        }
        $this->Work_Queue_Notes = $work_Queue_Notes;
        return $this;
    }
}
