<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submit_Request_for_Quote_Response_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Topmost element to record RFQ Response Document. Includes header, lines and bid responses.
 * @subpackage Structs
 */
class Submit_Request_for_Quote_Response_RequestType extends AbstractStructBase
{
    /**
     * The Request_for_Quote_Response_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to RFQ Response Document to edit.
     * - minOccurs: 0
     * @var \StructType\Request_for_Quote_ResponseObjectType
     */
    public $Request_for_Quote_Response_Reference;
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Request_for_Quote_Response_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RFQ_Response_Data_InboundType
     */
    public $Request_for_Quote_Response_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Submit_Request_for_Quote_Response_RequestType
     * @uses Submit_Request_for_Quote_Response_RequestType::setRequest_for_Quote_Response_Reference()
     * @uses Submit_Request_for_Quote_Response_RequestType::setBusiness_Process_Parameters()
     * @uses Submit_Request_for_Quote_Response_RequestType::setRequest_for_Quote_Response_Data()
     * @uses Submit_Request_for_Quote_Response_RequestType::setAdd_Only()
     * @uses Submit_Request_for_Quote_Response_RequestType::setVersion()
     * @param \StructType\Request_for_Quote_ResponseObjectType $request_for_Quote_Response_Reference
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @param \StructType\RFQ_Response_Data_InboundType $request_for_Quote_Response_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Request_for_Quote_ResponseObjectType $request_for_Quote_Response_Reference = null, \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null, \StructType\RFQ_Response_Data_InboundType $request_for_Quote_Response_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setRequest_for_Quote_Response_Reference($request_for_Quote_Response_Reference)
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setRequest_for_Quote_Response_Data($request_for_Quote_Response_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Request_for_Quote_Response_Reference value
     * @return \StructType\Request_for_Quote_ResponseObjectType|null
     */
    public function getRequest_for_Quote_Response_Reference()
    {
        return $this->Request_for_Quote_Response_Reference;
    }
    /**
     * Set Request_for_Quote_Response_Reference value
     * @param \StructType\Request_for_Quote_ResponseObjectType $request_for_Quote_Response_Reference
     * @return \StructType\Submit_Request_for_Quote_Response_RequestType
     */
    public function setRequest_for_Quote_Response_Reference(\StructType\Request_for_Quote_ResponseObjectType $request_for_Quote_Response_Reference = null)
    {
        $this->Request_for_Quote_Response_Reference = $request_for_Quote_Response_Reference;
        return $this;
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Submit_Request_for_Quote_Response_RequestType
     */
    public function setBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Request_for_Quote_Response_Data value
     * @return \StructType\RFQ_Response_Data_InboundType|null
     */
    public function getRequest_for_Quote_Response_Data()
    {
        return $this->Request_for_Quote_Response_Data;
    }
    /**
     * Set Request_for_Quote_Response_Data value
     * @param \StructType\RFQ_Response_Data_InboundType $request_for_Quote_Response_Data
     * @return \StructType\Submit_Request_for_Quote_Response_RequestType
     */
    public function setRequest_for_Quote_Response_Data(\StructType\RFQ_Response_Data_InboundType $request_for_Quote_Response_Data = null)
    {
        $this->Request_for_Quote_Response_Data = $request_for_Quote_Response_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Submit_Request_for_Quote_Response_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Submit_Request_for_Quote_Response_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
