<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Restricted_Purchase_Item_List_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing all Restricted Purchase Item List data
 * @subpackage Structs
 */
class Restricted_Purchase_Item_List_DataType extends AbstractStructBase
{
    /**
     * The Purchase_Item_List_ID
     * Meta information extracted from the WSDL
     * - documentation: Unique Identifier for the Restricted Purchase Item List.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Purchase_Item_List_ID;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Restricted Purchase Item List Name.
     * - maxOccurs: 1
     * @var string
     */
    public $Name;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Flag to indicate that the Restricted Purchase Item List is Inactive.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * The Purchase_Items_Reference
     * Meta information extracted from the WSDL
     * - documentation: Purchase Items for the Restricted Purchase Item List.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Purchase_ItemObjectType[]
     */
    public $Purchase_Items_Reference;
    /**
     * The Requesting_Entities_Reference
     * Meta information extracted from the WSDL
     * - documentation: Requesting Entities related to the Restricted Purchase Item List.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Requesting_EntityObjectType[]
     */
    public $Requesting_Entities_Reference;
    /**
     * Constructor method for Restricted_Purchase_Item_List_DataType
     * @uses Restricted_Purchase_Item_List_DataType::setPurchase_Item_List_ID()
     * @uses Restricted_Purchase_Item_List_DataType::setName()
     * @uses Restricted_Purchase_Item_List_DataType::setInactive()
     * @uses Restricted_Purchase_Item_List_DataType::setPurchase_Items_Reference()
     * @uses Restricted_Purchase_Item_List_DataType::setRequesting_Entities_Reference()
     * @param string $purchase_Item_List_ID
     * @param string $name
     * @param bool $inactive
     * @param \StructType\Purchase_ItemObjectType[] $purchase_Items_Reference
     * @param \StructType\Requesting_EntityObjectType[] $requesting_Entities_Reference
     */
    public function __construct($purchase_Item_List_ID = null, $name = null, $inactive = null, array $purchase_Items_Reference = array(), array $requesting_Entities_Reference = array())
    {
        $this
            ->setPurchase_Item_List_ID($purchase_Item_List_ID)
            ->setName($name)
            ->setInactive($inactive)
            ->setPurchase_Items_Reference($purchase_Items_Reference)
            ->setRequesting_Entities_Reference($requesting_Entities_Reference);
    }
    /**
     * Get Purchase_Item_List_ID value
     * @return string|null
     */
    public function getPurchase_Item_List_ID()
    {
        return $this->Purchase_Item_List_ID;
    }
    /**
     * Set Purchase_Item_List_ID value
     * @param string $purchase_Item_List_ID
     * @return \StructType\Restricted_Purchase_Item_List_DataType
     */
    public function setPurchase_Item_List_ID($purchase_Item_List_ID = null)
    {
        // validation for constraint: string
        if (!is_null($purchase_Item_List_ID) && !is_string($purchase_Item_List_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchase_Item_List_ID, true), gettype($purchase_Item_List_ID)), __LINE__);
        }
        $this->Purchase_Item_List_ID = $purchase_Item_List_ID;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Restricted_Purchase_Item_List_DataType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Restricted_Purchase_Item_List_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
    /**
     * Get Purchase_Items_Reference value
     * @return \StructType\Purchase_ItemObjectType[]|null
     */
    public function getPurchase_Items_Reference()
    {
        return $this->Purchase_Items_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Items_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Items_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Items_ReferenceForArrayConstraintsFromSetPurchase_Items_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $restricted_Purchase_Item_List_DataTypePurchase_Items_ReferenceItem) {
            // validation for constraint: itemType
            if (!$restricted_Purchase_Item_List_DataTypePurchase_Items_ReferenceItem instanceof \StructType\Purchase_ItemObjectType) {
                $invalidValues[] = is_object($restricted_Purchase_Item_List_DataTypePurchase_Items_ReferenceItem) ? get_class($restricted_Purchase_Item_List_DataTypePurchase_Items_ReferenceItem) : sprintf('%s(%s)', gettype($restricted_Purchase_Item_List_DataTypePurchase_Items_ReferenceItem), var_export($restricted_Purchase_Item_List_DataTypePurchase_Items_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Items_Reference property can only contain items of type \StructType\Purchase_ItemObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Items_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_ItemObjectType[] $purchase_Items_Reference
     * @return \StructType\Restricted_Purchase_Item_List_DataType
     */
    public function setPurchase_Items_Reference(array $purchase_Items_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Items_ReferenceArrayErrorMessage = self::validatePurchase_Items_ReferenceForArrayConstraintsFromSetPurchase_Items_Reference($purchase_Items_Reference))) {
            throw new \InvalidArgumentException($purchase_Items_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Items_Reference = $purchase_Items_Reference;
        return $this;
    }
    /**
     * Add item to Purchase_Items_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_ItemObjectType $item
     * @return \StructType\Restricted_Purchase_Item_List_DataType
     */
    public function addToPurchase_Items_Reference(\StructType\Purchase_ItemObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_ItemObjectType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Items_Reference property can only contain items of type \StructType\Purchase_ItemObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Items_Reference[] = $item;
        return $this;
    }
    /**
     * Get Requesting_Entities_Reference value
     * @return \StructType\Requesting_EntityObjectType[]|null
     */
    public function getRequesting_Entities_Reference()
    {
        return $this->Requesting_Entities_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRequesting_Entities_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequesting_Entities_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequesting_Entities_ReferenceForArrayConstraintsFromSetRequesting_Entities_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $restricted_Purchase_Item_List_DataTypeRequesting_Entities_ReferenceItem) {
            // validation for constraint: itemType
            if (!$restricted_Purchase_Item_List_DataTypeRequesting_Entities_ReferenceItem instanceof \StructType\Requesting_EntityObjectType) {
                $invalidValues[] = is_object($restricted_Purchase_Item_List_DataTypeRequesting_Entities_ReferenceItem) ? get_class($restricted_Purchase_Item_List_DataTypeRequesting_Entities_ReferenceItem) : sprintf('%s(%s)', gettype($restricted_Purchase_Item_List_DataTypeRequesting_Entities_ReferenceItem), var_export($restricted_Purchase_Item_List_DataTypeRequesting_Entities_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Requesting_Entities_Reference property can only contain items of type \StructType\Requesting_EntityObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Requesting_Entities_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Requesting_EntityObjectType[] $requesting_Entities_Reference
     * @return \StructType\Restricted_Purchase_Item_List_DataType
     */
    public function setRequesting_Entities_Reference(array $requesting_Entities_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($requesting_Entities_ReferenceArrayErrorMessage = self::validateRequesting_Entities_ReferenceForArrayConstraintsFromSetRequesting_Entities_Reference($requesting_Entities_Reference))) {
            throw new \InvalidArgumentException($requesting_Entities_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Requesting_Entities_Reference = $requesting_Entities_Reference;
        return $this;
    }
    /**
     * Add item to Requesting_Entities_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Requesting_EntityObjectType $item
     * @return \StructType\Restricted_Purchase_Item_List_DataType
     */
    public function addToRequesting_Entities_Reference(\StructType\Requesting_EntityObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Requesting_EntityObjectType) {
            throw new \InvalidArgumentException(sprintf('The Requesting_Entities_Reference property can only contain items of type \StructType\Requesting_EntityObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Requesting_Entities_Reference[] = $item;
        return $this;
    }
}
