<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Remove_Supplier_Contract_Line_Hold_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that Contains Remove Supplier Contract Line Hold Data
 * @subpackage Structs
 */
class Remove_Supplier_Contract_Line_Hold_DataType extends AbstractStructBase
{
    /**
     * The Supplier_Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Contract Reference
     * @var \StructType\Supplier_ContractObjectType
     */
    public $Supplier_Contract_Reference;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency Reference
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Goods_Line_Remove_Hold_Data
     * Meta information extracted from the WSDL
     * - documentation: Supplier Contract Goods Line Hold Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Contract_Line_Replacement_DataType[]
     */
    public $Goods_Line_Remove_Hold_Data;
    /**
     * The Service_Line_Remove_Hold_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Contract_Service_Line_Replacement_DataType[]
     */
    public $Service_Line_Remove_Hold_Data;
    /**
     * Constructor method for Remove_Supplier_Contract_Line_Hold_DataType
     * @uses Remove_Supplier_Contract_Line_Hold_DataType::setSupplier_Contract_Reference()
     * @uses Remove_Supplier_Contract_Line_Hold_DataType::setCurrency_Reference()
     * @uses Remove_Supplier_Contract_Line_Hold_DataType::setGoods_Line_Remove_Hold_Data()
     * @uses Remove_Supplier_Contract_Line_Hold_DataType::setService_Line_Remove_Hold_Data()
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param \StructType\Supplier_Contract_Line_Replacement_DataType[] $goods_Line_Remove_Hold_Data
     * @param \StructType\Supplier_Contract_Service_Line_Replacement_DataType[] $service_Line_Remove_Hold_Data
     */
    public function __construct(\StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null, \StructType\CurrencyObjectType $currency_Reference = null, array $goods_Line_Remove_Hold_Data = array(), array $service_Line_Remove_Hold_Data = array())
    {
        $this
            ->setSupplier_Contract_Reference($supplier_Contract_Reference)
            ->setCurrency_Reference($currency_Reference)
            ->setGoods_Line_Remove_Hold_Data($goods_Line_Remove_Hold_Data)
            ->setService_Line_Remove_Hold_Data($service_Line_Remove_Hold_Data);
    }
    /**
     * Get Supplier_Contract_Reference value
     * @return \StructType\Supplier_ContractObjectType|null
     */
    public function getSupplier_Contract_Reference()
    {
        return $this->Supplier_Contract_Reference;
    }
    /**
     * Set Supplier_Contract_Reference value
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @return \StructType\Remove_Supplier_Contract_Line_Hold_DataType
     */
    public function setSupplier_Contract_Reference(\StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null)
    {
        $this->Supplier_Contract_Reference = $supplier_Contract_Reference;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Remove_Supplier_Contract_Line_Hold_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Goods_Line_Remove_Hold_Data value
     * @return \StructType\Supplier_Contract_Line_Replacement_DataType[]|null
     */
    public function getGoods_Line_Remove_Hold_Data()
    {
        return $this->Goods_Line_Remove_Hold_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setGoods_Line_Remove_Hold_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGoods_Line_Remove_Hold_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGoods_Line_Remove_Hold_DataForArrayConstraintsFromSetGoods_Line_Remove_Hold_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $remove_Supplier_Contract_Line_Hold_DataTypeGoods_Line_Remove_Hold_DataItem) {
            // validation for constraint: itemType
            if (!$remove_Supplier_Contract_Line_Hold_DataTypeGoods_Line_Remove_Hold_DataItem instanceof \StructType\Supplier_Contract_Line_Replacement_DataType) {
                $invalidValues[] = is_object($remove_Supplier_Contract_Line_Hold_DataTypeGoods_Line_Remove_Hold_DataItem) ? get_class($remove_Supplier_Contract_Line_Hold_DataTypeGoods_Line_Remove_Hold_DataItem) : sprintf('%s(%s)', gettype($remove_Supplier_Contract_Line_Hold_DataTypeGoods_Line_Remove_Hold_DataItem), var_export($remove_Supplier_Contract_Line_Hold_DataTypeGoods_Line_Remove_Hold_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Goods_Line_Remove_Hold_Data property can only contain items of type \StructType\Supplier_Contract_Line_Replacement_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Goods_Line_Remove_Hold_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Contract_Line_Replacement_DataType[] $goods_Line_Remove_Hold_Data
     * @return \StructType\Remove_Supplier_Contract_Line_Hold_DataType
     */
    public function setGoods_Line_Remove_Hold_Data(array $goods_Line_Remove_Hold_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($goods_Line_Remove_Hold_DataArrayErrorMessage = self::validateGoods_Line_Remove_Hold_DataForArrayConstraintsFromSetGoods_Line_Remove_Hold_Data($goods_Line_Remove_Hold_Data))) {
            throw new \InvalidArgumentException($goods_Line_Remove_Hold_DataArrayErrorMessage, __LINE__);
        }
        $this->Goods_Line_Remove_Hold_Data = $goods_Line_Remove_Hold_Data;
        return $this;
    }
    /**
     * Add item to Goods_Line_Remove_Hold_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Contract_Line_Replacement_DataType $item
     * @return \StructType\Remove_Supplier_Contract_Line_Hold_DataType
     */
    public function addToGoods_Line_Remove_Hold_Data(\StructType\Supplier_Contract_Line_Replacement_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Contract_Line_Replacement_DataType) {
            throw new \InvalidArgumentException(sprintf('The Goods_Line_Remove_Hold_Data property can only contain items of type \StructType\Supplier_Contract_Line_Replacement_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Goods_Line_Remove_Hold_Data[] = $item;
        return $this;
    }
    /**
     * Get Service_Line_Remove_Hold_Data value
     * @return \StructType\Supplier_Contract_Service_Line_Replacement_DataType[]|null
     */
    public function getService_Line_Remove_Hold_Data()
    {
        return $this->Service_Line_Remove_Hold_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setService_Line_Remove_Hold_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setService_Line_Remove_Hold_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateService_Line_Remove_Hold_DataForArrayConstraintsFromSetService_Line_Remove_Hold_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $remove_Supplier_Contract_Line_Hold_DataTypeService_Line_Remove_Hold_DataItem) {
            // validation for constraint: itemType
            if (!$remove_Supplier_Contract_Line_Hold_DataTypeService_Line_Remove_Hold_DataItem instanceof \StructType\Supplier_Contract_Service_Line_Replacement_DataType) {
                $invalidValues[] = is_object($remove_Supplier_Contract_Line_Hold_DataTypeService_Line_Remove_Hold_DataItem) ? get_class($remove_Supplier_Contract_Line_Hold_DataTypeService_Line_Remove_Hold_DataItem) : sprintf('%s(%s)', gettype($remove_Supplier_Contract_Line_Hold_DataTypeService_Line_Remove_Hold_DataItem), var_export($remove_Supplier_Contract_Line_Hold_DataTypeService_Line_Remove_Hold_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Service_Line_Remove_Hold_Data property can only contain items of type \StructType\Supplier_Contract_Service_Line_Replacement_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Service_Line_Remove_Hold_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Contract_Service_Line_Replacement_DataType[] $service_Line_Remove_Hold_Data
     * @return \StructType\Remove_Supplier_Contract_Line_Hold_DataType
     */
    public function setService_Line_Remove_Hold_Data(array $service_Line_Remove_Hold_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($service_Line_Remove_Hold_DataArrayErrorMessage = self::validateService_Line_Remove_Hold_DataForArrayConstraintsFromSetService_Line_Remove_Hold_Data($service_Line_Remove_Hold_Data))) {
            throw new \InvalidArgumentException($service_Line_Remove_Hold_DataArrayErrorMessage, __LINE__);
        }
        $this->Service_Line_Remove_Hold_Data = $service_Line_Remove_Hold_Data;
        return $this;
    }
    /**
     * Add item to Service_Line_Remove_Hold_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Contract_Service_Line_Replacement_DataType $item
     * @return \StructType\Remove_Supplier_Contract_Line_Hold_DataType
     */
    public function addToService_Line_Remove_Hold_Data(\StructType\Supplier_Contract_Service_Line_Replacement_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Contract_Service_Line_Replacement_DataType) {
            throw new \InvalidArgumentException(sprintf('The Service_Line_Remove_Hold_Data property can only contain items of type \StructType\Supplier_Contract_Service_Line_Replacement_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Service_Line_Remove_Hold_Data[] = $item;
        return $this;
    }
}
