<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Supplier_Catalog_ResponseType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Supplier Catalog response data.
 * @subpackage Structs
 */
class Put_Supplier_Catalog_ResponseType extends AbstractStructBase
{
    /**
     * The Supplier_Catalog_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Catalog.
     * - minOccurs: 0
     * @var \StructType\Supplier_CatalogObjectType
     */
    public $Supplier_Catalog_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Supplier_Catalog_ResponseType
     * @uses Put_Supplier_Catalog_ResponseType::setSupplier_Catalog_Reference()
     * @uses Put_Supplier_Catalog_ResponseType::setVersion()
     * @param \StructType\Supplier_CatalogObjectType $supplier_Catalog_Reference
     * @param string $version
     */
    public function __construct(\StructType\Supplier_CatalogObjectType $supplier_Catalog_Reference = null, $version = null)
    {
        $this
            ->setSupplier_Catalog_Reference($supplier_Catalog_Reference)
            ->setVersion($version);
    }
    /**
     * Get Supplier_Catalog_Reference value
     * @return \StructType\Supplier_CatalogObjectType|null
     */
    public function getSupplier_Catalog_Reference()
    {
        return $this->Supplier_Catalog_Reference;
    }
    /**
     * Set Supplier_Catalog_Reference value
     * @param \StructType\Supplier_CatalogObjectType $supplier_Catalog_Reference
     * @return \StructType\Put_Supplier_Catalog_ResponseType
     */
    public function setSupplier_Catalog_Reference(\StructType\Supplier_CatalogObjectType $supplier_Catalog_Reference = null)
    {
        $this->Supplier_Catalog_Reference = $supplier_Catalog_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Supplier_Catalog_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
