<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Location_Customer_Account_Number_Detail_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Location Customer Account Number Detail Data.
 * @subpackage Structs
 */
class Location_Customer_Account_Number_Detail_DataType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: Location Customer Account Number Detail ID.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier.
     * - minOccurs: 0
     * @var \StructType\SupplierObjectType
     */
    public $Supplier_Reference;
    /**
     * The Order_From_Connection_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Order-From Supplier Connections for the Supplier
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Order_From_Supplier_ConnectionObjectType[]
     */
    public $Order_From_Connection_Reference;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Company or Company Hierarchies
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrganizationObjectType[]
     */
    public $Company_Reference;
    /**
     * The Bill_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Bill-To Reference
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Bill_To_Address_Reference;
    /**
     * The Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Location.
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Location_Reference;
    /**
     * The Customer_Account_Number
     * Meta information extracted from the WSDL
     * - documentation: Location Customer Account Number | Customer Account Number.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Customer_Account_Number;
    /**
     * The Just_In_Time_Customer_Account_Number
     * Meta information extracted from the WSDL
     * - documentation: Enter the Just in Time Customer Account Number for this Supplier or Location
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Just_In_Time_Customer_Account_Number;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Inactive
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - documentation: Flag to indicate that whether the Location Customer Account Number should be deleted.
     * @var bool
     */
    public $Delete;
    /**
     * Constructor method for Location_Customer_Account_Number_Detail_DataType
     * @uses Location_Customer_Account_Number_Detail_DataType::setID()
     * @uses Location_Customer_Account_Number_Detail_DataType::setSupplier_Reference()
     * @uses Location_Customer_Account_Number_Detail_DataType::setOrder_From_Connection_Reference()
     * @uses Location_Customer_Account_Number_Detail_DataType::setCompany_Reference()
     * @uses Location_Customer_Account_Number_Detail_DataType::setBill_To_Address_Reference()
     * @uses Location_Customer_Account_Number_Detail_DataType::setLocation_Reference()
     * @uses Location_Customer_Account_Number_Detail_DataType::setCustomer_Account_Number()
     * @uses Location_Customer_Account_Number_Detail_DataType::setJust_In_Time_Customer_Account_Number()
     * @uses Location_Customer_Account_Number_Detail_DataType::setInactive()
     * @uses Location_Customer_Account_Number_Detail_DataType::setDelete()
     * @param string $iD
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @param \StructType\Order_From_Supplier_ConnectionObjectType[] $order_From_Connection_Reference
     * @param \StructType\OrganizationObjectType[] $company_Reference
     * @param \StructType\Unique_IdentifierObjectType $bill_To_Address_Reference
     * @param \StructType\LocationObjectType $location_Reference
     * @param string $customer_Account_Number
     * @param string $just_In_Time_Customer_Account_Number
     * @param bool $inactive
     * @param bool $delete
     */
    public function __construct($iD = null, \StructType\SupplierObjectType $supplier_Reference = null, array $order_From_Connection_Reference = array(), array $company_Reference = array(), \StructType\Unique_IdentifierObjectType $bill_To_Address_Reference = null, \StructType\LocationObjectType $location_Reference = null, $customer_Account_Number = null, $just_In_Time_Customer_Account_Number = null, $inactive = null, $delete = null)
    {
        $this
            ->setID($iD)
            ->setSupplier_Reference($supplier_Reference)
            ->setOrder_From_Connection_Reference($order_From_Connection_Reference)
            ->setCompany_Reference($company_Reference)
            ->setBill_To_Address_Reference($bill_To_Address_Reference)
            ->setLocation_Reference($location_Reference)
            ->setCustomer_Account_Number($customer_Account_Number)
            ->setJust_In_Time_Customer_Account_Number($just_In_Time_Customer_Account_Number)
            ->setInactive($inactive)
            ->setDelete($delete);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Location_Customer_Account_Number_Detail_DataType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\SupplierObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\SupplierObjectType $supplier_Reference
     * @return \StructType\Location_Customer_Account_Number_Detail_DataType
     */
    public function setSupplier_Reference(\StructType\SupplierObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get Order_From_Connection_Reference value
     * @return \StructType\Order_From_Supplier_ConnectionObjectType[]|null
     */
    public function getOrder_From_Connection_Reference()
    {
        return $this->{'Order-From_Connection_Reference'};
    }
    /**
     * This method is responsible for validating the values passed to the setOrder_From_Connection_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrder_From_Connection_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrder_From_Connection_ReferenceForArrayConstraintsFromSetOrder_From_Connection_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $location_Customer_Account_Number_Detail_DataTypeOrder_From_Connection_ReferenceItem) {
            // validation for constraint: itemType
            if (!$location_Customer_Account_Number_Detail_DataTypeOrder_From_Connection_ReferenceItem instanceof \StructType\Order_From_Supplier_ConnectionObjectType) {
                $invalidValues[] = is_object($location_Customer_Account_Number_Detail_DataTypeOrder_From_Connection_ReferenceItem) ? get_class($location_Customer_Account_Number_Detail_DataTypeOrder_From_Connection_ReferenceItem) : sprintf('%s(%s)', gettype($location_Customer_Account_Number_Detail_DataTypeOrder_From_Connection_ReferenceItem), var_export($location_Customer_Account_Number_Detail_DataTypeOrder_From_Connection_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Order_From_Connection_Reference property can only contain items of type \StructType\Order_From_Supplier_ConnectionObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Order_From_Connection_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Order_From_Supplier_ConnectionObjectType[] $order_From_Connection_Reference
     * @return \StructType\Location_Customer_Account_Number_Detail_DataType
     */
    public function setOrder_From_Connection_Reference(array $order_From_Connection_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($order_From_Connection_ReferenceArrayErrorMessage = self::validateOrder_From_Connection_ReferenceForArrayConstraintsFromSetOrder_From_Connection_Reference($order_From_Connection_Reference))) {
            throw new \InvalidArgumentException($order_From_Connection_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Order_From_Connection_Reference = $this->{'Order-From_Connection_Reference'} = $order_From_Connection_Reference;
        return $this;
    }
    /**
     * Add item to Order_From_Connection_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Order_From_Supplier_ConnectionObjectType $item
     * @return \StructType\Location_Customer_Account_Number_Detail_DataType
     */
    public function addToOrder_From_Connection_Reference(\StructType\Order_From_Supplier_ConnectionObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Order_From_Supplier_ConnectionObjectType) {
            throw new \InvalidArgumentException(sprintf('The Order_From_Connection_Reference property can only contain items of type \StructType\Order_From_Supplier_ConnectionObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Order_From_Connection_Reference[] = $this->{'Order-From_Connection_Reference'}[] = $item;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\OrganizationObjectType[]|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCompany_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $location_Customer_Account_Number_Detail_DataTypeCompany_ReferenceItem) {
            // validation for constraint: itemType
            if (!$location_Customer_Account_Number_Detail_DataTypeCompany_ReferenceItem instanceof \StructType\OrganizationObjectType) {
                $invalidValues[] = is_object($location_Customer_Account_Number_Detail_DataTypeCompany_ReferenceItem) ? get_class($location_Customer_Account_Number_Detail_DataTypeCompany_ReferenceItem) : sprintf('%s(%s)', gettype($location_Customer_Account_Number_Detail_DataTypeCompany_ReferenceItem), var_export($location_Customer_Account_Number_Detail_DataTypeCompany_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Company_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType[] $company_Reference
     * @return \StructType\Location_Customer_Account_Number_Detail_DataType
     */
    public function setCompany_Reference(array $company_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($company_ReferenceArrayErrorMessage = self::validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference($company_Reference))) {
            throw new \InvalidArgumentException($company_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Add item to Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType $item
     * @return \StructType\Location_Customer_Account_Number_Detail_DataType
     */
    public function addToCompany_Reference(\StructType\OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Company_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Company_Reference[] = $item;
        return $this;
    }
    /**
     * Get Bill_To_Address_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getBill_To_Address_Reference()
    {
        return $this->{'Bill-To_Address_Reference'};
    }
    /**
     * Set Bill_To_Address_Reference value
     * @param \StructType\Unique_IdentifierObjectType $bill_To_Address_Reference
     * @return \StructType\Location_Customer_Account_Number_Detail_DataType
     */
    public function setBill_To_Address_Reference(\StructType\Unique_IdentifierObjectType $bill_To_Address_Reference = null)
    {
        $this->Bill_To_Address_Reference = $this->{'Bill-To_Address_Reference'} = $bill_To_Address_Reference;
        return $this;
    }
    /**
     * Get Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getLocation_Reference()
    {
        return $this->Location_Reference;
    }
    /**
     * Set Location_Reference value
     * @param \StructType\LocationObjectType $location_Reference
     * @return \StructType\Location_Customer_Account_Number_Detail_DataType
     */
    public function setLocation_Reference(\StructType\LocationObjectType $location_Reference = null)
    {
        $this->Location_Reference = $location_Reference;
        return $this;
    }
    /**
     * Get Customer_Account_Number value
     * @return string|null
     */
    public function getCustomer_Account_Number()
    {
        return $this->Customer_Account_Number;
    }
    /**
     * Set Customer_Account_Number value
     * @param string $customer_Account_Number
     * @return \StructType\Location_Customer_Account_Number_Detail_DataType
     */
    public function setCustomer_Account_Number($customer_Account_Number = null)
    {
        // validation for constraint: string
        if (!is_null($customer_Account_Number) && !is_string($customer_Account_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customer_Account_Number, true), gettype($customer_Account_Number)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($customer_Account_Number) && mb_strlen($customer_Account_Number) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($customer_Account_Number)), __LINE__);
        }
        $this->Customer_Account_Number = $customer_Account_Number;
        return $this;
    }
    /**
     * Get Just_In_Time_Customer_Account_Number value
     * @return string|null
     */
    public function getJust_In_Time_Customer_Account_Number()
    {
        return $this->Just_In_Time_Customer_Account_Number;
    }
    /**
     * Set Just_In_Time_Customer_Account_Number value
     * @param string $just_In_Time_Customer_Account_Number
     * @return \StructType\Location_Customer_Account_Number_Detail_DataType
     */
    public function setJust_In_Time_Customer_Account_Number($just_In_Time_Customer_Account_Number = null)
    {
        // validation for constraint: string
        if (!is_null($just_In_Time_Customer_Account_Number) && !is_string($just_In_Time_Customer_Account_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($just_In_Time_Customer_Account_Number, true), gettype($just_In_Time_Customer_Account_Number)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($just_In_Time_Customer_Account_Number) && mb_strlen($just_In_Time_Customer_Account_Number) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($just_In_Time_Customer_Account_Number)), __LINE__);
        }
        $this->Just_In_Time_Customer_Account_Number = $just_In_Time_Customer_Account_Number;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Location_Customer_Account_Number_Detail_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Location_Customer_Account_Number_Detail_DataType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
}
