<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Internal_Service_ProviderType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that represents the Reference to the Internal Service Provider along with its content.
 * @subpackage Structs
 */
class Internal_Service_ProviderType extends AbstractStructBase
{
    /**
     * The Internal_Service_Provider_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Internal Service Provider.
     * - minOccurs: 0
     * @var \StructType\Internal_Service_ProviderObjectType
     */
    public $Internal_Service_Provider_Reference;
    /**
     * The Internal_Service_Provider_Data
     * Meta information extracted from the WSDL
     * - documentation: Element that represents the contents of the Internal Service Provider.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Internal_Service_Provider_DataType[]
     */
    public $Internal_Service_Provider_Data;
    /**
     * Constructor method for Internal_Service_ProviderType
     * @uses Internal_Service_ProviderType::setInternal_Service_Provider_Reference()
     * @uses Internal_Service_ProviderType::setInternal_Service_Provider_Data()
     * @param \StructType\Internal_Service_ProviderObjectType $internal_Service_Provider_Reference
     * @param \StructType\Internal_Service_Provider_DataType[] $internal_Service_Provider_Data
     */
    public function __construct(\StructType\Internal_Service_ProviderObjectType $internal_Service_Provider_Reference = null, array $internal_Service_Provider_Data = array())
    {
        $this
            ->setInternal_Service_Provider_Reference($internal_Service_Provider_Reference)
            ->setInternal_Service_Provider_Data($internal_Service_Provider_Data);
    }
    /**
     * Get Internal_Service_Provider_Reference value
     * @return \StructType\Internal_Service_ProviderObjectType|null
     */
    public function getInternal_Service_Provider_Reference()
    {
        return $this->Internal_Service_Provider_Reference;
    }
    /**
     * Set Internal_Service_Provider_Reference value
     * @param \StructType\Internal_Service_ProviderObjectType $internal_Service_Provider_Reference
     * @return \StructType\Internal_Service_ProviderType
     */
    public function setInternal_Service_Provider_Reference(\StructType\Internal_Service_ProviderObjectType $internal_Service_Provider_Reference = null)
    {
        $this->Internal_Service_Provider_Reference = $internal_Service_Provider_Reference;
        return $this;
    }
    /**
     * Get Internal_Service_Provider_Data value
     * @return \StructType\Internal_Service_Provider_DataType[]|null
     */
    public function getInternal_Service_Provider_Data()
    {
        return $this->Internal_Service_Provider_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setInternal_Service_Provider_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternal_Service_Provider_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternal_Service_Provider_DataForArrayConstraintsFromSetInternal_Service_Provider_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $internal_Service_ProviderTypeInternal_Service_Provider_DataItem) {
            // validation for constraint: itemType
            if (!$internal_Service_ProviderTypeInternal_Service_Provider_DataItem instanceof \StructType\Internal_Service_Provider_DataType) {
                $invalidValues[] = is_object($internal_Service_ProviderTypeInternal_Service_Provider_DataItem) ? get_class($internal_Service_ProviderTypeInternal_Service_Provider_DataItem) : sprintf('%s(%s)', gettype($internal_Service_ProviderTypeInternal_Service_Provider_DataItem), var_export($internal_Service_ProviderTypeInternal_Service_Provider_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Internal_Service_Provider_Data property can only contain items of type \StructType\Internal_Service_Provider_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Internal_Service_Provider_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Internal_Service_Provider_DataType[] $internal_Service_Provider_Data
     * @return \StructType\Internal_Service_ProviderType
     */
    public function setInternal_Service_Provider_Data(array $internal_Service_Provider_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($internal_Service_Provider_DataArrayErrorMessage = self::validateInternal_Service_Provider_DataForArrayConstraintsFromSetInternal_Service_Provider_Data($internal_Service_Provider_Data))) {
            throw new \InvalidArgumentException($internal_Service_Provider_DataArrayErrorMessage, __LINE__);
        }
        $this->Internal_Service_Provider_Data = $internal_Service_Provider_Data;
        return $this;
    }
    /**
     * Add item to Internal_Service_Provider_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Internal_Service_Provider_DataType $item
     * @return \StructType\Internal_Service_ProviderType
     */
    public function addToInternal_Service_Provider_Data(\StructType\Internal_Service_Provider_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Internal_Service_Provider_DataType) {
            throw new \InvalidArgumentException(sprintf('The Internal_Service_Provider_Data property can only contain items of type \StructType\Internal_Service_Provider_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Internal_Service_Provider_Data[] = $item;
        return $this;
    }
}
