<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Expense_Credit_Card_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element containing expense credit card response data for requested references or criteria and for requested response group
 * @subpackage Structs
 */
class Expense_Credit_Card_Response_DataType extends AbstractStructBase
{
    /**
     * The Expense_Credit_Card
     * Meta information extracted from the WSDL
     * - documentation: Wrapper element that includes expense credit card instance and data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Expense_Credit_CardType[]
     */
    public $Expense_Credit_Card;
    /**
     * Constructor method for Expense_Credit_Card_Response_DataType
     * @uses Expense_Credit_Card_Response_DataType::setExpense_Credit_Card()
     * @param \StructType\Expense_Credit_CardType[] $expense_Credit_Card
     */
    public function __construct(array $expense_Credit_Card = array())
    {
        $this
            ->setExpense_Credit_Card($expense_Credit_Card);
    }
    /**
     * Get Expense_Credit_Card value
     * @return \StructType\Expense_Credit_CardType[]|null
     */
    public function getExpense_Credit_Card()
    {
        return $this->Expense_Credit_Card;
    }
    /**
     * This method is responsible for validating the values passed to the setExpense_Credit_Card method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense_Credit_Card method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpense_Credit_CardForArrayConstraintsFromSetExpense_Credit_Card(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Credit_Card_Response_DataTypeExpense_Credit_CardItem) {
            // validation for constraint: itemType
            if (!$expense_Credit_Card_Response_DataTypeExpense_Credit_CardItem instanceof \StructType\Expense_Credit_CardType) {
                $invalidValues[] = is_object($expense_Credit_Card_Response_DataTypeExpense_Credit_CardItem) ? get_class($expense_Credit_Card_Response_DataTypeExpense_Credit_CardItem) : sprintf('%s(%s)', gettype($expense_Credit_Card_Response_DataTypeExpense_Credit_CardItem), var_export($expense_Credit_Card_Response_DataTypeExpense_Credit_CardItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Expense_Credit_Card property can only contain items of type \StructType\Expense_Credit_CardType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Expense_Credit_Card value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_Credit_CardType[] $expense_Credit_Card
     * @return \StructType\Expense_Credit_Card_Response_DataType
     */
    public function setExpense_Credit_Card(array $expense_Credit_Card = array())
    {
        // validation for constraint: array
        if ('' !== ($expense_Credit_CardArrayErrorMessage = self::validateExpense_Credit_CardForArrayConstraintsFromSetExpense_Credit_Card($expense_Credit_Card))) {
            throw new \InvalidArgumentException($expense_Credit_CardArrayErrorMessage, __LINE__);
        }
        $this->Expense_Credit_Card = $expense_Credit_Card;
        return $this;
    }
    /**
     * Add item to Expense_Credit_Card value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_Credit_CardType $item
     * @return \StructType\Expense_Credit_Card_Response_DataType
     */
    public function addToExpense_Credit_Card(\StructType\Expense_Credit_CardType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Expense_Credit_CardType) {
            throw new \InvalidArgumentException(sprintf('The Expense_Credit_Card property can only contain items of type \StructType\Expense_Credit_CardType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Expense_Credit_Card[] = $item;
        return $this;
    }
}
