<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Tax_Rate_Options_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Tax Rate Recoverabilities data for Tax Code.
 * @subpackage Structs
 */
class Tax_Rate_Options_DataType extends AbstractStructBase
{
    /**
     * The Tax_Rate_1_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Tax Rate for Tax Code.
     * - minOccurs: 0
     * @var \StructType\Tax_RateObjectType
     */
    public $Tax_Rate_1_Reference;
    /**
     * The Tax_Recoverability_1_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for Tax Recoverability for Tax Rate.
     * - minOccurs: 0
     * @var \StructType\Tax_RecoverabilityObjectType
     */
    public $Tax_Recoverability_1_Reference;
    /**
     * The Tax_Option_1_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for Tax Option for Tax Rate.
     * - minOccurs: 0
     * @var \StructType\Tax_OptionObjectType
     */
    public $Tax_Option_1_Reference;
    /**
     * The Tax_Rate_2_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Tax Rate for Tax Code.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Tax_RateObjectType[]
     */
    public $Tax_Rate_2_Reference;
    /**
     * The Tax_Recoverability_2_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for Tax Recoverability for Tax Rate.
     * - minOccurs: 0
     * @var \StructType\Tax_RecoverabilityObjectType
     */
    public $Tax_Recoverability_2_Reference;
    /**
     * The Tax_Option_2_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for Tax Option for Tax Rate.
     * - minOccurs: 0
     * @var \StructType\Tax_OptionObjectType
     */
    public $Tax_Option_2_Reference;
    /**
     * The Tax_Rate_3_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Tax Rate for Tax Code.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Tax_RateObjectType[]
     */
    public $Tax_Rate_3_Reference;
    /**
     * The Tax_Recoverability_3_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for Tax Recoverability for Tax Rate.
     * - minOccurs: 0
     * @var \StructType\Tax_RecoverabilityObjectType
     */
    public $Tax_Recoverability_3_Reference;
    /**
     * The Tax_Option_3_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for Tax Option for Tax Rate.
     * - minOccurs: 0
     * @var \StructType\Tax_OptionObjectType
     */
    public $Tax_Option_3_Reference;
    /**
     * The Tax_Rate_4_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Tax Rate for Tax Code.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Tax_RateObjectType[]
     */
    public $Tax_Rate_4_Reference;
    /**
     * The Tax_Recoverability_4_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for Tax Recoverability for Tax Rate.
     * - minOccurs: 0
     * @var \StructType\Tax_RecoverabilityObjectType
     */
    public $Tax_Recoverability_4_Reference;
    /**
     * The Tax_Option_4_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for Tax Option for Tax Rate.
     * - minOccurs: 0
     * @var \StructType\Tax_OptionObjectType
     */
    public $Tax_Option_4_Reference;
    /**
     * The Tax_Rate_5_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Tax Rate for Tax Code.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Tax_RateObjectType[]
     */
    public $Tax_Rate_5_Reference;
    /**
     * The Tax_Recoverability_5_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for Tax Recoverability for Tax Rate.
     * - minOccurs: 0
     * @var \StructType\Tax_RecoverabilityObjectType
     */
    public $Tax_Recoverability_5_Reference;
    /**
     * The Tax_Option_5_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for Tax Option for Tax Rate.
     * - minOccurs: 0
     * @var \StructType\Tax_OptionObjectType
     */
    public $Tax_Option_5_Reference;
    /**
     * The Tax_Rate_6_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Tax Rate for Tax Code.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Tax_RateObjectType[]
     */
    public $Tax_Rate_6_Reference;
    /**
     * The Tax_Recoverability_6_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for Tax Recoverability for Tax Rate.
     * - minOccurs: 0
     * @var \StructType\Tax_RecoverabilityObjectType
     */
    public $Tax_Recoverability_6_Reference;
    /**
     * The Tax_Option_6_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference for Tax Option for Tax Rate.
     * - minOccurs: 0
     * @var \StructType\Tax_OptionObjectType
     */
    public $Tax_Option_6_Reference;
    /**
     * Constructor method for Tax_Rate_Options_DataType
     * @uses Tax_Rate_Options_DataType::setTax_Rate_1_Reference()
     * @uses Tax_Rate_Options_DataType::setTax_Recoverability_1_Reference()
     * @uses Tax_Rate_Options_DataType::setTax_Option_1_Reference()
     * @uses Tax_Rate_Options_DataType::setTax_Rate_2_Reference()
     * @uses Tax_Rate_Options_DataType::setTax_Recoverability_2_Reference()
     * @uses Tax_Rate_Options_DataType::setTax_Option_2_Reference()
     * @uses Tax_Rate_Options_DataType::setTax_Rate_3_Reference()
     * @uses Tax_Rate_Options_DataType::setTax_Recoverability_3_Reference()
     * @uses Tax_Rate_Options_DataType::setTax_Option_3_Reference()
     * @uses Tax_Rate_Options_DataType::setTax_Rate_4_Reference()
     * @uses Tax_Rate_Options_DataType::setTax_Recoverability_4_Reference()
     * @uses Tax_Rate_Options_DataType::setTax_Option_4_Reference()
     * @uses Tax_Rate_Options_DataType::setTax_Rate_5_Reference()
     * @uses Tax_Rate_Options_DataType::setTax_Recoverability_5_Reference()
     * @uses Tax_Rate_Options_DataType::setTax_Option_5_Reference()
     * @uses Tax_Rate_Options_DataType::setTax_Rate_6_Reference()
     * @uses Tax_Rate_Options_DataType::setTax_Recoverability_6_Reference()
     * @uses Tax_Rate_Options_DataType::setTax_Option_6_Reference()
     * @param \StructType\Tax_RateObjectType $tax_Rate_1_Reference
     * @param \StructType\Tax_RecoverabilityObjectType $tax_Recoverability_1_Reference
     * @param \StructType\Tax_OptionObjectType $tax_Option_1_Reference
     * @param \StructType\Tax_RateObjectType[] $tax_Rate_2_Reference
     * @param \StructType\Tax_RecoverabilityObjectType $tax_Recoverability_2_Reference
     * @param \StructType\Tax_OptionObjectType $tax_Option_2_Reference
     * @param \StructType\Tax_RateObjectType[] $tax_Rate_3_Reference
     * @param \StructType\Tax_RecoverabilityObjectType $tax_Recoverability_3_Reference
     * @param \StructType\Tax_OptionObjectType $tax_Option_3_Reference
     * @param \StructType\Tax_RateObjectType[] $tax_Rate_4_Reference
     * @param \StructType\Tax_RecoverabilityObjectType $tax_Recoverability_4_Reference
     * @param \StructType\Tax_OptionObjectType $tax_Option_4_Reference
     * @param \StructType\Tax_RateObjectType[] $tax_Rate_5_Reference
     * @param \StructType\Tax_RecoverabilityObjectType $tax_Recoverability_5_Reference
     * @param \StructType\Tax_OptionObjectType $tax_Option_5_Reference
     * @param \StructType\Tax_RateObjectType[] $tax_Rate_6_Reference
     * @param \StructType\Tax_RecoverabilityObjectType $tax_Recoverability_6_Reference
     * @param \StructType\Tax_OptionObjectType $tax_Option_6_Reference
     */
    public function __construct(\StructType\Tax_RateObjectType $tax_Rate_1_Reference = null, \StructType\Tax_RecoverabilityObjectType $tax_Recoverability_1_Reference = null, \StructType\Tax_OptionObjectType $tax_Option_1_Reference = null, array $tax_Rate_2_Reference = array(), \StructType\Tax_RecoverabilityObjectType $tax_Recoverability_2_Reference = null, \StructType\Tax_OptionObjectType $tax_Option_2_Reference = null, array $tax_Rate_3_Reference = array(), \StructType\Tax_RecoverabilityObjectType $tax_Recoverability_3_Reference = null, \StructType\Tax_OptionObjectType $tax_Option_3_Reference = null, array $tax_Rate_4_Reference = array(), \StructType\Tax_RecoverabilityObjectType $tax_Recoverability_4_Reference = null, \StructType\Tax_OptionObjectType $tax_Option_4_Reference = null, array $tax_Rate_5_Reference = array(), \StructType\Tax_RecoverabilityObjectType $tax_Recoverability_5_Reference = null, \StructType\Tax_OptionObjectType $tax_Option_5_Reference = null, array $tax_Rate_6_Reference = array(), \StructType\Tax_RecoverabilityObjectType $tax_Recoverability_6_Reference = null, \StructType\Tax_OptionObjectType $tax_Option_6_Reference = null)
    {
        $this
            ->setTax_Rate_1_Reference($tax_Rate_1_Reference)
            ->setTax_Recoverability_1_Reference($tax_Recoverability_1_Reference)
            ->setTax_Option_1_Reference($tax_Option_1_Reference)
            ->setTax_Rate_2_Reference($tax_Rate_2_Reference)
            ->setTax_Recoverability_2_Reference($tax_Recoverability_2_Reference)
            ->setTax_Option_2_Reference($tax_Option_2_Reference)
            ->setTax_Rate_3_Reference($tax_Rate_3_Reference)
            ->setTax_Recoverability_3_Reference($tax_Recoverability_3_Reference)
            ->setTax_Option_3_Reference($tax_Option_3_Reference)
            ->setTax_Rate_4_Reference($tax_Rate_4_Reference)
            ->setTax_Recoverability_4_Reference($tax_Recoverability_4_Reference)
            ->setTax_Option_4_Reference($tax_Option_4_Reference)
            ->setTax_Rate_5_Reference($tax_Rate_5_Reference)
            ->setTax_Recoverability_5_Reference($tax_Recoverability_5_Reference)
            ->setTax_Option_5_Reference($tax_Option_5_Reference)
            ->setTax_Rate_6_Reference($tax_Rate_6_Reference)
            ->setTax_Recoverability_6_Reference($tax_Recoverability_6_Reference)
            ->setTax_Option_6_Reference($tax_Option_6_Reference);
    }
    /**
     * Get tax_Rate_Reference value
     * @return tax_Rate_Reference
     */
    public function getTax_Rate_1_Reference()
    {
        return $this->Tax_Rate_1_Reference;
    }
    /**
     * Set tax_Rate_Reference value
     * @param tax_Rate_Reference $tax_Rate_Reference
     * @return \StructType\Tax_Rate_Options_DataType
     */
    public function setTax_Rate_1_Reference(\StructType\Tax_RateObjectType $tax_Rate_1_Reference = null)
    {
        $this->Tax_Rate_1_Reference = $tax_Rate_1_Reference;
        return $this;
    }
    /**
     * Get tax_Recoverability_Reference value
     * @return tax_Recoverability_Reference
     */
    public function getTax_Recoverability_1_Reference()
    {
        return $this->Tax_Recoverability_1_Reference;
    }
    /**
     * Set tax_Recoverability_Reference value
     * @param tax_Recoverability_Reference $tax_Recoverability_Reference
     * @return \StructType\Tax_Rate_Options_DataType
     */
    public function setTax_Recoverability_1_Reference(\StructType\Tax_RecoverabilityObjectType $tax_Recoverability_1_Reference = null)
    {
        $this->Tax_Recoverability_1_Reference = $tax_Recoverability_1_Reference;
        return $this;
    }
    /**
     * Get tax_Option_Reference value
     * @return tax_Option_Reference
     */
    public function getTax_Option_1_Reference()
    {
        return $this->Tax_Option_1_Reference;
    }
    /**
     * Set tax_Option_Reference value
     * @param tax_Option_Reference $tax_Option_Reference
     * @return \StructType\Tax_Rate_Options_DataType
     */
    public function setTax_Option_1_Reference(\StructType\Tax_OptionObjectType $tax_Option_1_Reference = null)
    {
        $this->Tax_Option_1_Reference = $tax_Option_1_Reference;
        return $this;
    }
    /**
     * Get tax_Rate_Reference value
     * @return tax_Rate_Reference
     */
    public function getTax_Rate_2_Reference()
    {
        return $this->Tax_Rate_2_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setTax_Rate_2_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTax_Rate_2_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTax_Rate_2_ReferenceForArrayConstraintsFromSetTax_Rate_2_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tax_Rate_Options_DataTypeTax_Rate_2_ReferenceItem) {
            // validation for constraint: itemType
            if (!$tax_Rate_Options_DataTypeTax_Rate_2_ReferenceItem instanceof \StructType\Tax_RateObjectType) {
                $invalidValues[] = is_object($tax_Rate_Options_DataTypeTax_Rate_2_ReferenceItem) ? get_class($tax_Rate_Options_DataTypeTax_Rate_2_ReferenceItem) : sprintf('%s(%s)', gettype($tax_Rate_Options_DataTypeTax_Rate_2_ReferenceItem), var_export($tax_Rate_Options_DataTypeTax_Rate_2_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Tax_Rate_2_Reference property can only contain items of type \StructType\Tax_RateObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set tax_Rate_Reference value
     * @param tax_Rate_Reference $tax_Rate_Reference
     * @return \StructType\Tax_Rate_Options_DataType
     */
    public function setTax_Rate_2_Reference(array $tax_Rate_2_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($tax_Rate_2_ReferenceArrayErrorMessage = self::validateTax_Rate_2_ReferenceForArrayConstraintsFromSetTax_Rate_2_Reference($tax_Rate_2_Reference))) {
            throw new \InvalidArgumentException($tax_Rate_2_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Tax_Rate_2_Reference = $tax_Rate_2_Reference;
        return $this;
    }
    /**
     * Add item to Tax_Rate_2_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Tax_RateObjectType $item
     * @return \StructType\Tax_Rate_Options_DataType
     */
    public function addToTax_Rate_2_Reference(\StructType\Tax_RateObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Tax_RateObjectType) {
            throw new \InvalidArgumentException(sprintf('The Tax_Rate_2_Reference property can only contain items of type \StructType\Tax_RateObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Tax_Rate_2_Reference[] = $item;
        return $this;
    }
    /**
     * Get tax_Recoverability_Reference value
     * @return tax_Recoverability_Reference
     */
    public function getTax_Recoverability_2_Reference()
    {
        return $this->Tax_Recoverability_2_Reference;
    }
    /**
     * Set tax_Recoverability_Reference value
     * @param tax_Recoverability_Reference $tax_Recoverability_Reference
     * @return \StructType\Tax_Rate_Options_DataType
     */
    public function setTax_Recoverability_2_Reference(\StructType\Tax_RecoverabilityObjectType $tax_Recoverability_2_Reference = null)
    {
        $this->Tax_Recoverability_2_Reference = $tax_Recoverability_2_Reference;
        return $this;
    }
    /**
     * Get tax_Option_Reference value
     * @return tax_Option_Reference
     */
    public function getTax_Option_2_Reference()
    {
        return $this->Tax_Option_2_Reference;
    }
    /**
     * Set tax_Option_Reference value
     * @param tax_Option_Reference $tax_Option_Reference
     * @return \StructType\Tax_Rate_Options_DataType
     */
    public function setTax_Option_2_Reference(\StructType\Tax_OptionObjectType $tax_Option_2_Reference = null)
    {
        $this->Tax_Option_2_Reference = $tax_Option_2_Reference;
        return $this;
    }
    /**
     * Get tax_Rate_Reference value
     * @return tax_Rate_Reference
     */
    public function getTax_Rate_3_Reference()
    {
        return $this->Tax_Rate_3_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setTax_Rate_3_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTax_Rate_3_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTax_Rate_3_ReferenceForArrayConstraintsFromSetTax_Rate_3_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tax_Rate_Options_DataTypeTax_Rate_3_ReferenceItem) {
            // validation for constraint: itemType
            if (!$tax_Rate_Options_DataTypeTax_Rate_3_ReferenceItem instanceof \StructType\Tax_RateObjectType) {
                $invalidValues[] = is_object($tax_Rate_Options_DataTypeTax_Rate_3_ReferenceItem) ? get_class($tax_Rate_Options_DataTypeTax_Rate_3_ReferenceItem) : sprintf('%s(%s)', gettype($tax_Rate_Options_DataTypeTax_Rate_3_ReferenceItem), var_export($tax_Rate_Options_DataTypeTax_Rate_3_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Tax_Rate_3_Reference property can only contain items of type \StructType\Tax_RateObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set tax_Rate_Reference value
     * @param tax_Rate_Reference $tax_Rate_Reference
     * @return \StructType\Tax_Rate_Options_DataType
     */
    public function setTax_Rate_3_Reference(array $tax_Rate_3_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($tax_Rate_3_ReferenceArrayErrorMessage = self::validateTax_Rate_3_ReferenceForArrayConstraintsFromSetTax_Rate_3_Reference($tax_Rate_3_Reference))) {
            throw new \InvalidArgumentException($tax_Rate_3_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Tax_Rate_3_Reference = $tax_Rate_3_Reference;
        return $this;
    }
    /**
     * Add item to Tax_Rate_3_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Tax_RateObjectType $item
     * @return \StructType\Tax_Rate_Options_DataType
     */
    public function addToTax_Rate_3_Reference(\StructType\Tax_RateObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Tax_RateObjectType) {
            throw new \InvalidArgumentException(sprintf('The Tax_Rate_3_Reference property can only contain items of type \StructType\Tax_RateObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Tax_Rate_3_Reference[] = $item;
        return $this;
    }
    /**
     * Get tax_Recoverability_Reference value
     * @return tax_Recoverability_Reference
     */
    public function getTax_Recoverability_3_Reference()
    {
        return $this->Tax_Recoverability_3_Reference;
    }
    /**
     * Set tax_Recoverability_Reference value
     * @param tax_Recoverability_Reference $tax_Recoverability_Reference
     * @return \StructType\Tax_Rate_Options_DataType
     */
    public function setTax_Recoverability_3_Reference(\StructType\Tax_RecoverabilityObjectType $tax_Recoverability_3_Reference = null)
    {
        $this->Tax_Recoverability_3_Reference = $tax_Recoverability_3_Reference;
        return $this;
    }
    /**
     * Get tax_Option_Reference value
     * @return tax_Option_Reference
     */
    public function getTax_Option_3_Reference()
    {
        return $this->Tax_Option_3_Reference;
    }
    /**
     * Set tax_Option_Reference value
     * @param tax_Option_Reference $tax_Option_Reference
     * @return \StructType\Tax_Rate_Options_DataType
     */
    public function setTax_Option_3_Reference(\StructType\Tax_OptionObjectType $tax_Option_3_Reference = null)
    {
        $this->Tax_Option_3_Reference = $tax_Option_3_Reference;
        return $this;
    }
    /**
     * Get tax_Rate_Reference value
     * @return tax_Rate_Reference
     */
    public function getTax_Rate_4_Reference()
    {
        return $this->Tax_Rate_4_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setTax_Rate_4_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTax_Rate_4_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTax_Rate_4_ReferenceForArrayConstraintsFromSetTax_Rate_4_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tax_Rate_Options_DataTypeTax_Rate_4_ReferenceItem) {
            // validation for constraint: itemType
            if (!$tax_Rate_Options_DataTypeTax_Rate_4_ReferenceItem instanceof \StructType\Tax_RateObjectType) {
                $invalidValues[] = is_object($tax_Rate_Options_DataTypeTax_Rate_4_ReferenceItem) ? get_class($tax_Rate_Options_DataTypeTax_Rate_4_ReferenceItem) : sprintf('%s(%s)', gettype($tax_Rate_Options_DataTypeTax_Rate_4_ReferenceItem), var_export($tax_Rate_Options_DataTypeTax_Rate_4_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Tax_Rate_4_Reference property can only contain items of type \StructType\Tax_RateObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set tax_Rate_Reference value
     * @param tax_Rate_Reference $tax_Rate_Reference
     * @return \StructType\Tax_Rate_Options_DataType
     */
    public function setTax_Rate_4_Reference(array $tax_Rate_4_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($tax_Rate_4_ReferenceArrayErrorMessage = self::validateTax_Rate_4_ReferenceForArrayConstraintsFromSetTax_Rate_4_Reference($tax_Rate_4_Reference))) {
            throw new \InvalidArgumentException($tax_Rate_4_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Tax_Rate_4_Reference = $tax_Rate_4_Reference;
        return $this;
    }
    /**
     * Add item to Tax_Rate_4_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Tax_RateObjectType $item
     * @return \StructType\Tax_Rate_Options_DataType
     */
    public function addToTax_Rate_4_Reference(\StructType\Tax_RateObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Tax_RateObjectType) {
            throw new \InvalidArgumentException(sprintf('The Tax_Rate_4_Reference property can only contain items of type \StructType\Tax_RateObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Tax_Rate_4_Reference[] = $item;
        return $this;
    }
    /**
     * Get tax_Recoverability_Reference value
     * @return tax_Recoverability_Reference
     */
    public function getTax_Recoverability_4_Reference()
    {
        return $this->Tax_Recoverability_4_Reference;
    }
    /**
     * Set tax_Recoverability_Reference value
     * @param tax_Recoverability_Reference $tax_Recoverability_Reference
     * @return \StructType\Tax_Rate_Options_DataType
     */
    public function setTax_Recoverability_4_Reference(\StructType\Tax_RecoverabilityObjectType $tax_Recoverability_4_Reference = null)
    {
        $this->Tax_Recoverability_4_Reference = $tax_Recoverability_4_Reference;
        return $this;
    }
    /**
     * Get tax_Option_Reference value
     * @return tax_Option_Reference
     */
    public function getTax_Option_4_Reference()
    {
        return $this->Tax_Option_4_Reference;
    }
    /**
     * Set tax_Option_Reference value
     * @param tax_Option_Reference $tax_Option_Reference
     * @return \StructType\Tax_Rate_Options_DataType
     */
    public function setTax_Option_4_Reference(\StructType\Tax_OptionObjectType $tax_Option_4_Reference = null)
    {
        $this->Tax_Option_4_Reference = $tax_Option_4_Reference;
        return $this;
    }
    /**
     * Get tax_Rate_Reference value
     * @return tax_Rate_Reference
     */
    public function getTax_Rate_5_Reference()
    {
        return $this->Tax_Rate_5_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setTax_Rate_5_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTax_Rate_5_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTax_Rate_5_ReferenceForArrayConstraintsFromSetTax_Rate_5_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tax_Rate_Options_DataTypeTax_Rate_5_ReferenceItem) {
            // validation for constraint: itemType
            if (!$tax_Rate_Options_DataTypeTax_Rate_5_ReferenceItem instanceof \StructType\Tax_RateObjectType) {
                $invalidValues[] = is_object($tax_Rate_Options_DataTypeTax_Rate_5_ReferenceItem) ? get_class($tax_Rate_Options_DataTypeTax_Rate_5_ReferenceItem) : sprintf('%s(%s)', gettype($tax_Rate_Options_DataTypeTax_Rate_5_ReferenceItem), var_export($tax_Rate_Options_DataTypeTax_Rate_5_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Tax_Rate_5_Reference property can only contain items of type \StructType\Tax_RateObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set tax_Rate_Reference value
     * @param tax_Rate_Reference $tax_Rate_Reference
     * @return \StructType\Tax_Rate_Options_DataType
     */
    public function setTax_Rate_5_Reference(array $tax_Rate_5_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($tax_Rate_5_ReferenceArrayErrorMessage = self::validateTax_Rate_5_ReferenceForArrayConstraintsFromSetTax_Rate_5_Reference($tax_Rate_5_Reference))) {
            throw new \InvalidArgumentException($tax_Rate_5_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Tax_Rate_5_Reference = $tax_Rate_5_Reference;
        return $this;
    }
    /**
     * Add item to Tax_Rate_5_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Tax_RateObjectType $item
     * @return \StructType\Tax_Rate_Options_DataType
     */
    public function addToTax_Rate_5_Reference(\StructType\Tax_RateObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Tax_RateObjectType) {
            throw new \InvalidArgumentException(sprintf('The Tax_Rate_5_Reference property can only contain items of type \StructType\Tax_RateObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Tax_Rate_5_Reference[] = $item;
        return $this;
    }
    /**
     * Get tax_Recoverability_Reference value
     * @return tax_Recoverability_Reference
     */
    public function getTax_Recoverability_5_Reference()
    {
        return $this->Tax_Recoverability_5_Reference;
    }
    /**
     * Set tax_Recoverability_Reference value
     * @param tax_Recoverability_Reference $tax_Recoverability_Reference
     * @return \StructType\Tax_Rate_Options_DataType
     */
    public function setTax_Recoverability_5_Reference(\StructType\Tax_RecoverabilityObjectType $tax_Recoverability_5_Reference = null)
    {
        $this->Tax_Recoverability_5_Reference = $tax_Recoverability_5_Reference;
        return $this;
    }
    /**
     * Get tax_Option_Reference value
     * @return tax_Option_Reference
     */
    public function getTax_Option_5_Reference()
    {
        return $this->Tax_Option_5_Reference;
    }
    /**
     * Set tax_Option_Reference value
     * @param tax_Option_Reference $tax_Option_Reference
     * @return \StructType\Tax_Rate_Options_DataType
     */
    public function setTax_Option_5_Reference(\StructType\Tax_OptionObjectType $tax_Option_5_Reference = null)
    {
        $this->Tax_Option_5_Reference = $tax_Option_5_Reference;
        return $this;
    }
    /**
     * Get tax_Rate_Reference value
     * @return tax_Rate_Reference
     */
    public function getTax_Rate_6_Reference()
    {
        return $this->Tax_Rate_6_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setTax_Rate_6_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTax_Rate_6_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTax_Rate_6_ReferenceForArrayConstraintsFromSetTax_Rate_6_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $tax_Rate_Options_DataTypeTax_Rate_6_ReferenceItem) {
            // validation for constraint: itemType
            if (!$tax_Rate_Options_DataTypeTax_Rate_6_ReferenceItem instanceof \StructType\Tax_RateObjectType) {
                $invalidValues[] = is_object($tax_Rate_Options_DataTypeTax_Rate_6_ReferenceItem) ? get_class($tax_Rate_Options_DataTypeTax_Rate_6_ReferenceItem) : sprintf('%s(%s)', gettype($tax_Rate_Options_DataTypeTax_Rate_6_ReferenceItem), var_export($tax_Rate_Options_DataTypeTax_Rate_6_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Tax_Rate_6_Reference property can only contain items of type \StructType\Tax_RateObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set tax_Rate_Reference value
     * @param tax_Rate_Reference $tax_Rate_Reference
     * @return \StructType\Tax_Rate_Options_DataType
     */
    public function setTax_Rate_6_Reference(array $tax_Rate_6_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($tax_Rate_6_ReferenceArrayErrorMessage = self::validateTax_Rate_6_ReferenceForArrayConstraintsFromSetTax_Rate_6_Reference($tax_Rate_6_Reference))) {
            throw new \InvalidArgumentException($tax_Rate_6_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Tax_Rate_6_Reference = $tax_Rate_6_Reference;
        return $this;
    }
    /**
     * Add item to Tax_Rate_6_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Tax_RateObjectType $item
     * @return \StructType\Tax_Rate_Options_DataType
     */
    public function addToTax_Rate_6_Reference(\StructType\Tax_RateObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Tax_RateObjectType) {
            throw new \InvalidArgumentException(sprintf('The Tax_Rate_6_Reference property can only contain items of type \StructType\Tax_RateObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Tax_Rate_6_Reference[] = $item;
        return $this;
    }
    /**
     * Get tax_Recoverability_Reference value
     * @return tax_Recoverability_Reference
     */
    public function getTax_Recoverability_6_Reference()
    {
        return $this->Tax_Recoverability_6_Reference;
    }
    /**
     * Set tax_Recoverability_Reference value
     * @param tax_Recoverability_Reference $tax_Recoverability_Reference
     * @return \StructType\Tax_Rate_Options_DataType
     */
    public function setTax_Recoverability_6_Reference(\StructType\Tax_RecoverabilityObjectType $tax_Recoverability_6_Reference = null)
    {
        $this->Tax_Recoverability_6_Reference = $tax_Recoverability_6_Reference;
        return $this;
    }
    /**
     * Get tax_Option_Reference value
     * @return tax_Option_Reference
     */
    public function getTax_Option_6_Reference()
    {
        return $this->Tax_Option_6_Reference;
    }
    /**
     * Set tax_Option_Reference value
     * @param tax_Option_Reference $tax_Option_Reference
     * @return \StructType\Tax_Rate_Options_DataType
     */
    public function setTax_Option_6_Reference(\StructType\Tax_OptionObjectType $tax_Option_6_Reference = null)
    {
        $this->Tax_Option_6_Reference = $tax_Option_6_Reference;
        return $this;
    }
}
