<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Restricted_Purchase_Item_List_Request_ReferencesType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing reference instances for a Restricted Purchase Item List
 * @subpackage Structs
 */
class Restricted_Purchase_Item_List_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Purchase_Item_List_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Restricted Purchase Item List.
     * - maxOccurs: unbounded
     * @var \StructType\Restricted_Purchase_Item_ListObjectType[]
     */
    public $Purchase_Item_List_Reference;
    /**
     * Constructor method for Restricted_Purchase_Item_List_Request_ReferencesType
     * @uses Restricted_Purchase_Item_List_Request_ReferencesType::setPurchase_Item_List_Reference()
     * @param \StructType\Restricted_Purchase_Item_ListObjectType[] $purchase_Item_List_Reference
     */
    public function __construct(array $purchase_Item_List_Reference = array())
    {
        $this
            ->setPurchase_Item_List_Reference($purchase_Item_List_Reference);
    }
    /**
     * Get Purchase_Item_List_Reference value
     * @return \StructType\Restricted_Purchase_Item_ListObjectType[]|null
     */
    public function getPurchase_Item_List_Reference()
    {
        return $this->Purchase_Item_List_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Item_List_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Item_List_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Item_List_ReferenceForArrayConstraintsFromSetPurchase_Item_List_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $restricted_Purchase_Item_List_Request_ReferencesTypePurchase_Item_List_ReferenceItem) {
            // validation for constraint: itemType
            if (!$restricted_Purchase_Item_List_Request_ReferencesTypePurchase_Item_List_ReferenceItem instanceof \StructType\Restricted_Purchase_Item_ListObjectType) {
                $invalidValues[] = is_object($restricted_Purchase_Item_List_Request_ReferencesTypePurchase_Item_List_ReferenceItem) ? get_class($restricted_Purchase_Item_List_Request_ReferencesTypePurchase_Item_List_ReferenceItem) : sprintf('%s(%s)', gettype($restricted_Purchase_Item_List_Request_ReferencesTypePurchase_Item_List_ReferenceItem), var_export($restricted_Purchase_Item_List_Request_ReferencesTypePurchase_Item_List_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Item_List_Reference property can only contain items of type \StructType\Restricted_Purchase_Item_ListObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Item_List_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Restricted_Purchase_Item_ListObjectType[] $purchase_Item_List_Reference
     * @return \StructType\Restricted_Purchase_Item_List_Request_ReferencesType
     */
    public function setPurchase_Item_List_Reference(array $purchase_Item_List_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Item_List_ReferenceArrayErrorMessage = self::validatePurchase_Item_List_ReferenceForArrayConstraintsFromSetPurchase_Item_List_Reference($purchase_Item_List_Reference))) {
            throw new \InvalidArgumentException($purchase_Item_List_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Item_List_Reference = $purchase_Item_List_Reference;
        return $this;
    }
    /**
     * Add item to Purchase_Item_List_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Restricted_Purchase_Item_ListObjectType $item
     * @return \StructType\Restricted_Purchase_Item_List_Request_ReferencesType
     */
    public function addToPurchase_Item_List_Reference(\StructType\Restricted_Purchase_Item_ListObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Restricted_Purchase_Item_ListObjectType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Item_List_Reference property can only contain items of type \StructType\Restricted_Purchase_Item_ListObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Item_List_Reference[] = $item;
        return $this;
    }
}
