<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Replenishment_Policy_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Attributes related to Replenishment for the purchase item/site combination.
 * @subpackage Structs
 */
class Replenishment_Policy_DataType extends AbstractStructBase
{
    /**
     * The Replenishment_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Replenishment type for the specified site for the purchase item.
     * - minOccurs: 0
     * @var \StructType\Replenishment_TypeObjectType
     */
    public $Replenishment_Type_Reference;
    /**
     * The Average_Daily_Usage
     * Meta information extracted from the WSDL
     * - documentation: Inventory Average Daily Usage for item
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Average_Daily_Usage;
    /**
     * The Preferred_Supplier_Lead_Time
     * Meta information extracted from the WSDL
     * - documentation: Preferred Supplier Lead Time for the specified site for the purchase item.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Preferred_Supplier_Lead_Time;
    /**
     * The Reorder_Point_Quantity
     * Meta information extracted from the WSDL
     * - documentation: Reorder point in base UOM.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Reorder_Point_Quantity;
    /**
     * The Maximum_Quantity
     * Meta information extracted from the WSDL
     * - documentation: Maximum quantity in base UOM - only applicable if the replenishment policy is min-max.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Maximum_Quantity;
    /**
     * The Safety_Stock
     * Meta information extracted from the WSDL
     * - documentation: Safety Stock for Replenishment Optimization.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Safety_Stock;
    /**
     * The Target_Days_on_Hand
     * Meta information extracted from the WSDL
     * - documentation: Target Days on Hand for Replenishment Optimization.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Target_Days_on_Hand;
    /**
     * The Maximum_Target_Days_on_Hand
     * Meta information extracted from the WSDL
     * - documentation: Maximum Target Days on Hand for Replenishment Optimization.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Maximum_Target_Days_on_Hand;
    /**
     * The Replenishment_Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: Replenishment Unit of Measure for the policy
     * - minOccurs: 0
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Replenishment_Unit_of_Measure_Reference;
    /**
     * The Economic_Order_Quantity
     * Meta information extracted from the WSDL
     * - documentation: Economic Order Quantity value in the UOM specified by Replenishment Unit of Measure - only applicable if the replenishment policy is Fixed Reorder Quantity.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Economic_Order_Quantity;
    /**
     * The Fixed_Reorder_Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: Unit of Measure for Economic Order Quantity - only applicable if the replenishment policy is Fixed Reorder Quantity.
     * - minOccurs: 0
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Fixed_Reorder_Unit_of_Measure_Reference;
    /**
     * Constructor method for Replenishment_Policy_DataType
     * @uses Replenishment_Policy_DataType::setReplenishment_Type_Reference()
     * @uses Replenishment_Policy_DataType::setAverage_Daily_Usage()
     * @uses Replenishment_Policy_DataType::setPreferred_Supplier_Lead_Time()
     * @uses Replenishment_Policy_DataType::setReorder_Point_Quantity()
     * @uses Replenishment_Policy_DataType::setMaximum_Quantity()
     * @uses Replenishment_Policy_DataType::setSafety_Stock()
     * @uses Replenishment_Policy_DataType::setTarget_Days_on_Hand()
     * @uses Replenishment_Policy_DataType::setMaximum_Target_Days_on_Hand()
     * @uses Replenishment_Policy_DataType::setReplenishment_Unit_of_Measure_Reference()
     * @uses Replenishment_Policy_DataType::setEconomic_Order_Quantity()
     * @uses Replenishment_Policy_DataType::setFixed_Reorder_Unit_of_Measure_Reference()
     * @param \StructType\Replenishment_TypeObjectType $replenishment_Type_Reference
     * @param float $average_Daily_Usage
     * @param float $preferred_Supplier_Lead_Time
     * @param float $reorder_Point_Quantity
     * @param float $maximum_Quantity
     * @param float $safety_Stock
     * @param float $target_Days_on_Hand
     * @param float $maximum_Target_Days_on_Hand
     * @param \StructType\Unit_of_MeasureObjectType $replenishment_Unit_of_Measure_Reference
     * @param float $economic_Order_Quantity
     * @param \StructType\Unit_of_MeasureObjectType $fixed_Reorder_Unit_of_Measure_Reference
     */
    public function __construct(\StructType\Replenishment_TypeObjectType $replenishment_Type_Reference = null, $average_Daily_Usage = null, $preferred_Supplier_Lead_Time = null, $reorder_Point_Quantity = null, $maximum_Quantity = null, $safety_Stock = null, $target_Days_on_Hand = null, $maximum_Target_Days_on_Hand = null, \StructType\Unit_of_MeasureObjectType $replenishment_Unit_of_Measure_Reference = null, $economic_Order_Quantity = null, \StructType\Unit_of_MeasureObjectType $fixed_Reorder_Unit_of_Measure_Reference = null)
    {
        $this
            ->setReplenishment_Type_Reference($replenishment_Type_Reference)
            ->setAverage_Daily_Usage($average_Daily_Usage)
            ->setPreferred_Supplier_Lead_Time($preferred_Supplier_Lead_Time)
            ->setReorder_Point_Quantity($reorder_Point_Quantity)
            ->setMaximum_Quantity($maximum_Quantity)
            ->setSafety_Stock($safety_Stock)
            ->setTarget_Days_on_Hand($target_Days_on_Hand)
            ->setMaximum_Target_Days_on_Hand($maximum_Target_Days_on_Hand)
            ->setReplenishment_Unit_of_Measure_Reference($replenishment_Unit_of_Measure_Reference)
            ->setEconomic_Order_Quantity($economic_Order_Quantity)
            ->setFixed_Reorder_Unit_of_Measure_Reference($fixed_Reorder_Unit_of_Measure_Reference);
    }
    /**
     * Get Replenishment_Type_Reference value
     * @return \StructType\Replenishment_TypeObjectType|null
     */
    public function getReplenishment_Type_Reference()
    {
        return $this->Replenishment_Type_Reference;
    }
    /**
     * Set Replenishment_Type_Reference value
     * @param \StructType\Replenishment_TypeObjectType $replenishment_Type_Reference
     * @return \StructType\Replenishment_Policy_DataType
     */
    public function setReplenishment_Type_Reference(\StructType\Replenishment_TypeObjectType $replenishment_Type_Reference = null)
    {
        $this->Replenishment_Type_Reference = $replenishment_Type_Reference;
        return $this;
    }
    /**
     * Get Average_Daily_Usage value
     * @return float|null
     */
    public function getAverage_Daily_Usage()
    {
        return $this->Average_Daily_Usage;
    }
    /**
     * Set Average_Daily_Usage value
     * @param float $average_Daily_Usage
     * @return \StructType\Replenishment_Policy_DataType
     */
    public function setAverage_Daily_Usage($average_Daily_Usage = null)
    {
        // validation for constraint: float
        if (!is_null($average_Daily_Usage) && !(is_float($average_Daily_Usage) || is_numeric($average_Daily_Usage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($average_Daily_Usage, true), gettype($average_Daily_Usage)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($average_Daily_Usage) && mb_strlen(mb_substr($average_Daily_Usage, false !== mb_strpos($average_Daily_Usage, '.') ? mb_strpos($average_Daily_Usage, '.') + 1 : mb_strlen($average_Daily_Usage))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($average_Daily_Usage, true), mb_strlen(mb_substr($average_Daily_Usage, mb_strpos($average_Daily_Usage, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($average_Daily_Usage) && $average_Daily_Usage < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($average_Daily_Usage, true)), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($average_Daily_Usage) && mb_strlen(preg_replace('/(\D)/', '', $average_Daily_Usage)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($average_Daily_Usage, true), mb_strlen(preg_replace('/(\D)/', '', $average_Daily_Usage))), __LINE__);
        }
        $this->Average_Daily_Usage = $average_Daily_Usage;
        return $this;
    }
    /**
     * Get Preferred_Supplier_Lead_Time value
     * @return float|null
     */
    public function getPreferred_Supplier_Lead_Time()
    {
        return $this->Preferred_Supplier_Lead_Time;
    }
    /**
     * Set Preferred_Supplier_Lead_Time value
     * @param float $preferred_Supplier_Lead_Time
     * @return \StructType\Replenishment_Policy_DataType
     */
    public function setPreferred_Supplier_Lead_Time($preferred_Supplier_Lead_Time = null)
    {
        // validation for constraint: float
        if (!is_null($preferred_Supplier_Lead_Time) && !(is_float($preferred_Supplier_Lead_Time) || is_numeric($preferred_Supplier_Lead_Time))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($preferred_Supplier_Lead_Time, true), gettype($preferred_Supplier_Lead_Time)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($preferred_Supplier_Lead_Time) && mb_strlen(mb_substr($preferred_Supplier_Lead_Time, false !== mb_strpos($preferred_Supplier_Lead_Time, '.') ? mb_strpos($preferred_Supplier_Lead_Time, '.') + 1 : mb_strlen($preferred_Supplier_Lead_Time))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($preferred_Supplier_Lead_Time, true), mb_strlen(mb_substr($preferred_Supplier_Lead_Time, mb_strpos($preferred_Supplier_Lead_Time, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($preferred_Supplier_Lead_Time) && $preferred_Supplier_Lead_Time < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($preferred_Supplier_Lead_Time, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($preferred_Supplier_Lead_Time) && mb_strlen(preg_replace('/(\D)/', '', $preferred_Supplier_Lead_Time)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($preferred_Supplier_Lead_Time, true), mb_strlen(preg_replace('/(\D)/', '', $preferred_Supplier_Lead_Time))), __LINE__);
        }
        $this->Preferred_Supplier_Lead_Time = $preferred_Supplier_Lead_Time;
        return $this;
    }
    /**
     * Get Reorder_Point_Quantity value
     * @return float|null
     */
    public function getReorder_Point_Quantity()
    {
        return $this->Reorder_Point_Quantity;
    }
    /**
     * Set Reorder_Point_Quantity value
     * @param float $reorder_Point_Quantity
     * @return \StructType\Replenishment_Policy_DataType
     */
    public function setReorder_Point_Quantity($reorder_Point_Quantity = null)
    {
        // validation for constraint: float
        if (!is_null($reorder_Point_Quantity) && !(is_float($reorder_Point_Quantity) || is_numeric($reorder_Point_Quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($reorder_Point_Quantity, true), gettype($reorder_Point_Quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($reorder_Point_Quantity) && mb_strlen(mb_substr($reorder_Point_Quantity, false !== mb_strpos($reorder_Point_Quantity, '.') ? mb_strpos($reorder_Point_Quantity, '.') + 1 : mb_strlen($reorder_Point_Quantity))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($reorder_Point_Quantity, true), mb_strlen(mb_substr($reorder_Point_Quantity, mb_strpos($reorder_Point_Quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($reorder_Point_Quantity) && $reorder_Point_Quantity < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($reorder_Point_Quantity, true)), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($reorder_Point_Quantity) && mb_strlen(preg_replace('/(\D)/', '', $reorder_Point_Quantity)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($reorder_Point_Quantity, true), mb_strlen(preg_replace('/(\D)/', '', $reorder_Point_Quantity))), __LINE__);
        }
        $this->Reorder_Point_Quantity = $reorder_Point_Quantity;
        return $this;
    }
    /**
     * Get Maximum_Quantity value
     * @return float|null
     */
    public function getMaximum_Quantity()
    {
        return $this->Maximum_Quantity;
    }
    /**
     * Set Maximum_Quantity value
     * @param float $maximum_Quantity
     * @return \StructType\Replenishment_Policy_DataType
     */
    public function setMaximum_Quantity($maximum_Quantity = null)
    {
        // validation for constraint: float
        if (!is_null($maximum_Quantity) && !(is_float($maximum_Quantity) || is_numeric($maximum_Quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maximum_Quantity, true), gettype($maximum_Quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($maximum_Quantity) && mb_strlen(mb_substr($maximum_Quantity, false !== mb_strpos($maximum_Quantity, '.') ? mb_strpos($maximum_Quantity, '.') + 1 : mb_strlen($maximum_Quantity))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($maximum_Quantity, true), mb_strlen(mb_substr($maximum_Quantity, mb_strpos($maximum_Quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($maximum_Quantity) && $maximum_Quantity < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($maximum_Quantity, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($maximum_Quantity) && mb_strlen(preg_replace('/(\D)/', '', $maximum_Quantity)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($maximum_Quantity, true), mb_strlen(preg_replace('/(\D)/', '', $maximum_Quantity))), __LINE__);
        }
        $this->Maximum_Quantity = $maximum_Quantity;
        return $this;
    }
    /**
     * Get Safety_Stock value
     * @return float|null
     */
    public function getSafety_Stock()
    {
        return $this->Safety_Stock;
    }
    /**
     * Set Safety_Stock value
     * @param float $safety_Stock
     * @return \StructType\Replenishment_Policy_DataType
     */
    public function setSafety_Stock($safety_Stock = null)
    {
        // validation for constraint: float
        if (!is_null($safety_Stock) && !(is_float($safety_Stock) || is_numeric($safety_Stock))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($safety_Stock, true), gettype($safety_Stock)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($safety_Stock) && mb_strlen(mb_substr($safety_Stock, false !== mb_strpos($safety_Stock, '.') ? mb_strpos($safety_Stock, '.') + 1 : mb_strlen($safety_Stock))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($safety_Stock, true), mb_strlen(mb_substr($safety_Stock, mb_strpos($safety_Stock, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($safety_Stock) && $safety_Stock < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($safety_Stock, true)), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($safety_Stock) && mb_strlen(preg_replace('/(\D)/', '', $safety_Stock)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($safety_Stock, true), mb_strlen(preg_replace('/(\D)/', '', $safety_Stock))), __LINE__);
        }
        $this->Safety_Stock = $safety_Stock;
        return $this;
    }
    /**
     * Get Target_Days_on_Hand value
     * @return float|null
     */
    public function getTarget_Days_on_Hand()
    {
        return $this->Target_Days_on_Hand;
    }
    /**
     * Set Target_Days_on_Hand value
     * @param float $target_Days_on_Hand
     * @return \StructType\Replenishment_Policy_DataType
     */
    public function setTarget_Days_on_Hand($target_Days_on_Hand = null)
    {
        // validation for constraint: float
        if (!is_null($target_Days_on_Hand) && !(is_float($target_Days_on_Hand) || is_numeric($target_Days_on_Hand))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($target_Days_on_Hand, true), gettype($target_Days_on_Hand)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($target_Days_on_Hand) && mb_strlen(mb_substr($target_Days_on_Hand, false !== mb_strpos($target_Days_on_Hand, '.') ? mb_strpos($target_Days_on_Hand, '.') + 1 : mb_strlen($target_Days_on_Hand))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($target_Days_on_Hand, true), mb_strlen(mb_substr($target_Days_on_Hand, mb_strpos($target_Days_on_Hand, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($target_Days_on_Hand) && $target_Days_on_Hand < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($target_Days_on_Hand, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($target_Days_on_Hand) && mb_strlen(preg_replace('/(\D)/', '', $target_Days_on_Hand)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($target_Days_on_Hand, true), mb_strlen(preg_replace('/(\D)/', '', $target_Days_on_Hand))), __LINE__);
        }
        $this->Target_Days_on_Hand = $target_Days_on_Hand;
        return $this;
    }
    /**
     * Get Maximum_Target_Days_on_Hand value
     * @return float|null
     */
    public function getMaximum_Target_Days_on_Hand()
    {
        return $this->Maximum_Target_Days_on_Hand;
    }
    /**
     * Set Maximum_Target_Days_on_Hand value
     * @param float $maximum_Target_Days_on_Hand
     * @return \StructType\Replenishment_Policy_DataType
     */
    public function setMaximum_Target_Days_on_Hand($maximum_Target_Days_on_Hand = null)
    {
        // validation for constraint: float
        if (!is_null($maximum_Target_Days_on_Hand) && !(is_float($maximum_Target_Days_on_Hand) || is_numeric($maximum_Target_Days_on_Hand))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maximum_Target_Days_on_Hand, true), gettype($maximum_Target_Days_on_Hand)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($maximum_Target_Days_on_Hand) && mb_strlen(mb_substr($maximum_Target_Days_on_Hand, false !== mb_strpos($maximum_Target_Days_on_Hand, '.') ? mb_strpos($maximum_Target_Days_on_Hand, '.') + 1 : mb_strlen($maximum_Target_Days_on_Hand))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($maximum_Target_Days_on_Hand, true), mb_strlen(mb_substr($maximum_Target_Days_on_Hand, mb_strpos($maximum_Target_Days_on_Hand, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($maximum_Target_Days_on_Hand) && $maximum_Target_Days_on_Hand < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($maximum_Target_Days_on_Hand, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($maximum_Target_Days_on_Hand) && mb_strlen(preg_replace('/(\D)/', '', $maximum_Target_Days_on_Hand)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($maximum_Target_Days_on_Hand, true), mb_strlen(preg_replace('/(\D)/', '', $maximum_Target_Days_on_Hand))), __LINE__);
        }
        $this->Maximum_Target_Days_on_Hand = $maximum_Target_Days_on_Hand;
        return $this;
    }
    /**
     * Get Replenishment_Unit_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getReplenishment_Unit_of_Measure_Reference()
    {
        return $this->Replenishment_Unit_of_Measure_Reference;
    }
    /**
     * Set Replenishment_Unit_of_Measure_Reference value
     * @param \StructType\Unit_of_MeasureObjectType $replenishment_Unit_of_Measure_Reference
     * @return \StructType\Replenishment_Policy_DataType
     */
    public function setReplenishment_Unit_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $replenishment_Unit_of_Measure_Reference = null)
    {
        $this->Replenishment_Unit_of_Measure_Reference = $replenishment_Unit_of_Measure_Reference;
        return $this;
    }
    /**
     * Get Economic_Order_Quantity value
     * @return float|null
     */
    public function getEconomic_Order_Quantity()
    {
        return $this->Economic_Order_Quantity;
    }
    /**
     * Set Economic_Order_Quantity value
     * @param float $economic_Order_Quantity
     * @return \StructType\Replenishment_Policy_DataType
     */
    public function setEconomic_Order_Quantity($economic_Order_Quantity = null)
    {
        // validation for constraint: float
        if (!is_null($economic_Order_Quantity) && !(is_float($economic_Order_Quantity) || is_numeric($economic_Order_Quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($economic_Order_Quantity, true), gettype($economic_Order_Quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($economic_Order_Quantity) && mb_strlen(mb_substr($economic_Order_Quantity, false !== mb_strpos($economic_Order_Quantity, '.') ? mb_strpos($economic_Order_Quantity, '.') + 1 : mb_strlen($economic_Order_Quantity))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($economic_Order_Quantity, true), mb_strlen(mb_substr($economic_Order_Quantity, mb_strpos($economic_Order_Quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($economic_Order_Quantity) && $economic_Order_Quantity < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($economic_Order_Quantity, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($economic_Order_Quantity) && mb_strlen(preg_replace('/(\D)/', '', $economic_Order_Quantity)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($economic_Order_Quantity, true), mb_strlen(preg_replace('/(\D)/', '', $economic_Order_Quantity))), __LINE__);
        }
        $this->Economic_Order_Quantity = $economic_Order_Quantity;
        return $this;
    }
    /**
     * Get Fixed_Reorder_Unit_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getFixed_Reorder_Unit_of_Measure_Reference()
    {
        return $this->Fixed_Reorder_Unit_of_Measure_Reference;
    }
    /**
     * Set Fixed_Reorder_Unit_of_Measure_Reference value
     * @param \StructType\Unit_of_MeasureObjectType $fixed_Reorder_Unit_of_Measure_Reference
     * @return \StructType\Replenishment_Policy_DataType
     */
    public function setFixed_Reorder_Unit_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $fixed_Reorder_Unit_of_Measure_Reference = null)
    {
        $this->Fixed_Reorder_Unit_of_Measure_Reference = $fixed_Reorder_Unit_of_Measure_Reference;
        return $this;
    }
}
