<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Purchase_Order_Line_Additional_Data_Request_CriteriaType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: This element is the wrapper around a list of elements representing the purchase order-specific criteria
 * @subpackage Structs
 */
class Purchase_Order_Line_Additional_Data_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Purchase_Order_Reference
     * Meta information extracted from the WSDL
     * - documentation: The purchase order reference
     * - maxOccurs: unbounded
     * @var \StructType\Purchase_OrderObjectType[]
     */
    public $Purchase_Order_Reference;
    /**
     * Constructor method for Purchase_Order_Line_Additional_Data_Request_CriteriaType
     * @uses Purchase_Order_Line_Additional_Data_Request_CriteriaType::setPurchase_Order_Reference()
     * @param \StructType\Purchase_OrderObjectType[] $purchase_Order_Reference
     */
    public function __construct(array $purchase_Order_Reference = array())
    {
        $this
            ->setPurchase_Order_Reference($purchase_Order_Reference);
    }
    /**
     * Get Purchase_Order_Reference value
     * @return \StructType\Purchase_OrderObjectType[]|null
     */
    public function getPurchase_Order_Reference()
    {
        return $this->Purchase_Order_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Order_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Order_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Order_ReferenceForArrayConstraintsFromSetPurchase_Order_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Order_Line_Additional_Data_Request_CriteriaTypePurchase_Order_ReferenceItem) {
            // validation for constraint: itemType
            if (!$purchase_Order_Line_Additional_Data_Request_CriteriaTypePurchase_Order_ReferenceItem instanceof \StructType\Purchase_OrderObjectType) {
                $invalidValues[] = is_object($purchase_Order_Line_Additional_Data_Request_CriteriaTypePurchase_Order_ReferenceItem) ? get_class($purchase_Order_Line_Additional_Data_Request_CriteriaTypePurchase_Order_ReferenceItem) : sprintf('%s(%s)', gettype($purchase_Order_Line_Additional_Data_Request_CriteriaTypePurchase_Order_ReferenceItem), var_export($purchase_Order_Line_Additional_Data_Request_CriteriaTypePurchase_Order_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Order_Reference property can only contain items of type \StructType\Purchase_OrderObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Order_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_OrderObjectType[] $purchase_Order_Reference
     * @return \StructType\Purchase_Order_Line_Additional_Data_Request_CriteriaType
     */
    public function setPurchase_Order_Reference(array $purchase_Order_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Order_ReferenceArrayErrorMessage = self::validatePurchase_Order_ReferenceForArrayConstraintsFromSetPurchase_Order_Reference($purchase_Order_Reference))) {
            throw new \InvalidArgumentException($purchase_Order_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Order_Reference = $purchase_Order_Reference;
        return $this;
    }
    /**
     * Add item to Purchase_Order_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_OrderObjectType $item
     * @return \StructType\Purchase_Order_Line_Additional_Data_Request_CriteriaType
     */
    public function addToPurchase_Order_Reference(\StructType\Purchase_OrderObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_OrderObjectType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Order_Reference property can only contain items of type \StructType\Purchase_OrderObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Order_Reference[] = $item;
        return $this;
    }
}
