<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Credit_Card_Transaction__HV__DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing all Credit Card Transaction data
 * @subpackage Structs
 */
class Credit_Card_Transaction__HV__DataType extends AbstractStructBase
{
    /**
     * The Transaction_Number
     * Meta information extracted from the WSDL
     * - documentation: Expense Credit Card Transaction Number. This is the Expense Credit Card Transaction unique identifier
     * - maxOccurs: 1
     * @var string
     */
    public $Transaction_Number;
    /**
     * The Credit_Card_Transaction_Reference
     * Meta information extracted from the WSDL
     * - documentation: Workday ID of the credit card transaction
     * - minOccurs: 0
     * @var \StructType\Credit_Card_TransactionObjectType
     */
    public $Credit_Card_Transaction_Reference;
    /**
     * The Transaction_Date
     * Meta information extracted from the WSDL
     * - documentation: Expense Transaction Date
     * - maxOccurs: 1
     * @var string
     */
    public $Transaction_Date;
    /**
     * The Credit_Card_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Credit Card Category for Credit Card Transaction
     * - minOccurs: 0
     * @var \StructType\Credit_Card_CategoryObjectType
     */
    public $Credit_Card_Category_Reference;
    /**
     * The Expense_Payee
     * Meta information extracted from the WSDL
     * - documentation: Expense Payee Employee Number for the Credit Card Transaction
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Expense_Payee;
    /**
     * The Billing_Date
     * Meta information extracted from the WSDL
     * - documentation: Expense Credit Card Billing Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Billing_Date;
    /**
     * The Posted_Date
     * Meta information extracted from the WSDL
     * - documentation: Transaction Posted Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Posted_Date;
    /**
     * The Merchant_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: Merchant Code Reference
     * - minOccurs: 0
     * @var \StructType\Merchant_CodeObjectType
     */
    public $Merchant_Code_Reference;
    /**
     * The Merchant_Code
     * Meta information extracted from the WSDL
     * - documentation: Merchant Code
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Merchant_Code;
    /**
     * The Merchant_Tax_ID
     * Meta information extracted from the WSDL
     * - documentation: Merchant Tax ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Merchant_Tax_ID;
    /**
     * The MIS_Industry_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: MIS Merchant Code Reference
     * - minOccurs: 0
     * @var \StructType\Merchant_CodeObjectType
     */
    public $MIS_Industry_Code_Reference;
    /**
     * The MIS_Industry_Code
     * Meta information extracted from the WSDL
     * - documentation: MIS Merchant Code
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MIS_Industry_Code;
    /**
     * The Market_Code
     * Meta information extracted from the WSDL
     * - documentation: Market Code
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Market_Code;
    /**
     * The Supplier_Reference_Number
     * Meta information extracted from the WSDL
     * - documentation: Supplier Reference Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Reference_Number;
    /**
     * The DUNS_Number_for_Supplier
     * Meta information extracted from the WSDL
     * - documentation: DUNS Number that uniquely identifies the Supplier.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DUNS_Number_for_Supplier;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: The amount for the project subtask. | Unit cost for the expense report line. Leave blank if you are entering a credit card transaction. | The amount of the installment line. | Transaction Extended Amount | The payment amount for this
     * lease payment line.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Amount;
    /**
     * The Tax_Amount
     * Meta information extracted from the WSDL
     * - documentation: Enter 1 or more lines with tax applicability on an invoice with Tax Amount. This tax applicability must be taxable, non-recoverable, and allocate non-recoverable tax. | Total Tax Amount for Tax Code and Tax Applicability | Tax Amount
     * for Expense Line | The tax amount to report for the expense. The tax code is defined on the itemized line. | Total Tax Amount for Tax Rate | Tax can only be entered if the Tax Option is Enter Tax Due to Supplier. | Expense Credit Card Extended Tax
     * Amount | Tax Amount
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Tax_Amount;
    /**
     * The Sales_Taxes_Collected
     * Meta information extracted from the WSDL
     * - documentation: Shows whether Sales Taxes were collected.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Sales_Taxes_Collected;
    /**
     * The Source_Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Source Currency Reference
     * @var \StructType\CurrencyObjectType
     */
    public $Source_Currency_Reference;
    /**
     * The Currency_Exchange_Rate
     * Meta information extracted from the WSDL
     * - documentation: Currency exchange rate from the transaction currency to the billing currency | Expense Credit Card Currency Exchange Rate
     * - base: xsd:decimal
     * - fractionDigits: 12
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 32
     * @var float
     */
    public $Currency_Exchange_Rate;
    /**
     * The Converted_Amount
     * Meta information extracted from the WSDL
     * - documentation: The amount the expense is converted to if it was incurred in a different currency. This cannot be used if you are entering the currency rate. Leave blank if you are entering a credit card transaction. | Converted AmountThis
     * information is for outbound purposes only and is not processed on inbound Workday Web Services requests. | Expense Credit Card Converted Amount
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Converted_Amount;
    /**
     * The Converted_Tax_Amount
     * Meta information extracted from the WSDL
     * - documentation: Expense Credit Card Converted Tax Amount
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Converted_Tax_Amount;
    /**
     * The Converted_Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Converted Currency Reference
     * @var \StructType\CurrencyObjectType
     */
    public $Converted_Currency_Reference;
    /**
     * The Euro_Billed_Amount
     * Meta information extracted from the WSDL
     * - documentation: Expense Credit Card Euro Billed Amount
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Euro_Billed_Amount;
    /**
     * The Euro_Billed_Tax_Amount
     * Meta information extracted from the WSDL
     * - documentation: Expense Credit Card Euro Billed Tax Amount
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Euro_Billed_Tax_Amount;
    /**
     * The Transaction_Type_Code
     * Meta information extracted from the WSDL
     * - documentation: Expense Credit Card Transaction Type Code
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Transaction_Type_Code;
    /**
     * The Transaction_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Expense Credit Card Transaction Type
     * - minOccurs: 0
     * @var \StructType\Credit_Card_Transaction_TypeObjectType
     */
    public $Transaction_Type_Reference;
    /**
     * The Financial_Category_Code
     * Meta information extracted from the WSDL
     * - documentation: Expense Credit Card Financial Category Code
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Financial_Category_Code;
    /**
     * The Charge_Description_Line_1
     * Meta information extracted from the WSDL
     * - documentation: Charge Description Line 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Charge_Description_Line_1;
    /**
     * The Charge_Description_Line_2
     * Meta information extracted from the WSDL
     * - documentation: Charge Description Line 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Charge_Description_Line_2;
    /**
     * The Cost_Center_Reference
     * Meta information extracted from the WSDL
     * - documentation: Cost Center Reference for Credit Card Transaction
     * - minOccurs: 0
     * @var \StructType\Cost_CenterObjectType
     */
    public $Cost_Center_Reference;
    /**
     * The Purchase_Order_Number
     * Meta information extracted from the WSDL
     * - documentation: A unique Workday system generated Purchase Order Number. This number can be used to reference the instance of the Purchase Order.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Purchase_Order_Number;
    /**
     * The Release_Number
     * Meta information extracted from the WSDL
     * - documentation: Release Number against Purchase Order previously placed.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Release_Number;
    /**
     * The Expense_Credit_Card_ID
     * Meta information extracted from the WSDL
     * - documentation: Expense Credit Card ID for Expense Credit Card used in Expense Credit Card Transaction
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Expense_Credit_Card_ID;
    /**
     * The Expense_Credit_Card_Token
     * Meta information extracted from the WSDL
     * - documentation: Expense Credit Card Token for Expense Credit Card used in Expense Credit Card Transaction
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Expense_Credit_Card_Token;
    /**
     * The Corporate_Account_Reference
     * Meta information extracted from the WSDL
     * - documentation: Corporate Account Reference for Expense Credit Card in Expense Credit Card Transaction
     * @var \StructType\Corporate_Credit_Card_AccountObjectType
     */
    public $Corporate_Account_Reference;
    /**
     * The Cardholder_ID
     * Meta information extracted from the WSDL
     * - documentation: Cardholder ID for Credit Card Holder
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Cardholder_ID;
    /**
     * The Cardholder_Name
     * Meta information extracted from the WSDL
     * - documentation: Cardholder Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Cardholder_Name;
    /**
     * The Account_Number
     * Meta information extracted from the WSDL
     * - documentation: Account Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Account_Number;
    /**
     * The Charge_Description
     * Meta information extracted from the WSDL
     * - documentation: Charge Description
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Charge_Description;
    /**
     * The Number_of_Days_or_Nights
     * Meta information extracted from the WSDL
     * - documentation: Number of Days or Nights
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Number_of_Days_or_Nights;
    /**
     * The Credit_Card_Merchant_Name
     * Meta information extracted from the WSDL
     * - documentation: Credit Card Merchant Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Credit_Card_Merchant_Name;
    /**
     * The Credit_Card_Merchant_Location
     * Meta information extracted from the WSDL
     * - documentation: Credit Card Merchant Location
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Credit_Card_Merchant_Location;
    /**
     * The Merchant_Address
     * Meta information extracted from the WSDL
     * - documentation: Merchant Address
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Merchant_Address;
    /**
     * The Merchant_City
     * Meta information extracted from the WSDL
     * - documentation: Merchant City
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Merchant_City;
    /**
     * The Merchant_Country_Region
     * Meta information extracted from the WSDL
     * - documentation: Merchant Country Region
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Merchant_Country_Region;
    /**
     * The Merchant_Country
     * Meta information extracted from the WSDL
     * - documentation: Merchant Country
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Merchant_Country;
    /**
     * The Merchant_Postal_Code
     * Meta information extracted from the WSDL
     * - documentation: Merchant Postal Code
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Merchant_Postal_Code;
    /**
     * The Merchant_Document_Number
     * Meta information extracted from the WSDL
     * - documentation: Document Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Merchant_Document_Number;
    /**
     * The Arrival_Date
     * Meta information extracted from the WSDL
     * - documentation: Expense Credit Card Arrival Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Arrival_Date;
    /**
     * The Departure_Date
     * Meta information extracted from the WSDL
     * - documentation: Expense Credit Card Departure Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Departure_Date;
    /**
     * The Reference_Number
     * Meta information extracted from the WSDL
     * - documentation: Expense Credit Card Reference Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reference_Number;
    /**
     * The Participant_Name
     * Meta information extracted from the WSDL
     * - documentation: Expense Credit Card Participant Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Participant_Name;
    /**
     * The Daily_Rate
     * Meta information extracted from the WSDL
     * - documentation: Text representing the daily rate for the expense. | Daily Rate
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Daily_Rate;
    /**
     * The Domestic
     * Meta information extracted from the WSDL
     * - documentation: Expense Credit Card Domestic
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Domestic;
    /**
     * The Ticket_Number
     * Meta information extracted from the WSDL
     * - documentation: Ticket Number
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ticket_Number;
    /**
     * The Class_of_Service
     * Meta information extracted from the WSDL
     * - documentation: Class of Service
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Class_of_Service;
    /**
     * The Air_Routing
     * Meta information extracted from the WSDL
     * - documentation: Air Routing
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Air_Routing;
    /**
     * The Air_Carrier_Code
     * Meta information extracted from the WSDL
     * - documentation: Air Carrier Code
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Air_Carrier_Code;
    /**
     * The Origination_City
     * Meta information extracted from the WSDL
     * - documentation: Origination City
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Origination_City;
    /**
     * The Origination_State
     * Meta information extracted from the WSDL
     * - documentation: Origination State
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Origination_State;
    /**
     * The Origination_Country
     * Meta information extracted from the WSDL
     * - documentation: Origination Country
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Origination_Country;
    /**
     * The Origination_Airport_Code
     * Meta information extracted from the WSDL
     * - documentation: Air Travel Origination Airport Code for Credit Card Transaction
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Origination_Airport_Code;
    /**
     * The Destination_City
     * Meta information extracted from the WSDL
     * - documentation: Destination City
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Destination_City;
    /**
     * The Destination_State
     * Meta information extracted from the WSDL
     * - documentation: Destination State
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Destination_State;
    /**
     * The Destination_Country
     * Meta information extracted from the WSDL
     * - documentation: Destination Country
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Destination_Country;
    /**
     * The Destination_Airport_Code
     * Meta information extracted from the WSDL
     * - documentation: Air Travel Destination Airport Code for Credit Card Transaction
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Destination_Airport_Code;
    /**
     * The Class_of_Service_Reference
     * Meta information extracted from the WSDL
     * - documentation: Class of Service Reference for Expense Credit Card Transaction
     * - minOccurs: 0
     * @var \StructType\Class_of_ServiceObjectType
     */
    public $Class_of_Service_Reference;
    /**
     * The Credit_Card_Transaction_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Credit Card Transaction Status Reference
     * - minOccurs: 0
     * @var \StructType\Expense_StatusObjectType
     */
    public $Credit_Card_Transaction_Status_Reference;
    /**
     * The Credit_Card_Transaction_Line_Data
     * Meta information extracted from the WSDL
     * - documentation: Credit Card Transaction Line Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CC_Transaction_LineType[]
     */
    public $Credit_Card_Transaction_Line_Data;
    /**
     * The Name_Match_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing Credit Card Transaction Name matches for Travel Cities and Merchants.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Credit_Card_Transaction_Name_Match_DataType[]
     */
    public $Name_Match_Data;
    /**
     * The Ticket_Details_Data
     * Meta information extracted from the WSDL
     * - documentation: Ticket Details Data for a Credit Card Transaction of Air Travel.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Ticket_Details_DataType[]
     */
    public $Ticket_Details_Data;
    /**
     * Constructor method for Credit_Card_Transaction__HV__DataType
     * @uses Credit_Card_Transaction__HV__DataType::setTransaction_Number()
     * @uses Credit_Card_Transaction__HV__DataType::setCredit_Card_Transaction_Reference()
     * @uses Credit_Card_Transaction__HV__DataType::setTransaction_Date()
     * @uses Credit_Card_Transaction__HV__DataType::setCredit_Card_Category_Reference()
     * @uses Credit_Card_Transaction__HV__DataType::setExpense_Payee()
     * @uses Credit_Card_Transaction__HV__DataType::setBilling_Date()
     * @uses Credit_Card_Transaction__HV__DataType::setPosted_Date()
     * @uses Credit_Card_Transaction__HV__DataType::setMerchant_Code_Reference()
     * @uses Credit_Card_Transaction__HV__DataType::setMerchant_Code()
     * @uses Credit_Card_Transaction__HV__DataType::setMerchant_Tax_ID()
     * @uses Credit_Card_Transaction__HV__DataType::setMIS_Industry_Code_Reference()
     * @uses Credit_Card_Transaction__HV__DataType::setMIS_Industry_Code()
     * @uses Credit_Card_Transaction__HV__DataType::setMarket_Code()
     * @uses Credit_Card_Transaction__HV__DataType::setSupplier_Reference_Number()
     * @uses Credit_Card_Transaction__HV__DataType::setDUNS_Number_for_Supplier()
     * @uses Credit_Card_Transaction__HV__DataType::setAmount()
     * @uses Credit_Card_Transaction__HV__DataType::setTax_Amount()
     * @uses Credit_Card_Transaction__HV__DataType::setSales_Taxes_Collected()
     * @uses Credit_Card_Transaction__HV__DataType::setSource_Currency_Reference()
     * @uses Credit_Card_Transaction__HV__DataType::setCurrency_Exchange_Rate()
     * @uses Credit_Card_Transaction__HV__DataType::setConverted_Amount()
     * @uses Credit_Card_Transaction__HV__DataType::setConverted_Tax_Amount()
     * @uses Credit_Card_Transaction__HV__DataType::setConverted_Currency_Reference()
     * @uses Credit_Card_Transaction__HV__DataType::setEuro_Billed_Amount()
     * @uses Credit_Card_Transaction__HV__DataType::setEuro_Billed_Tax_Amount()
     * @uses Credit_Card_Transaction__HV__DataType::setTransaction_Type_Code()
     * @uses Credit_Card_Transaction__HV__DataType::setTransaction_Type_Reference()
     * @uses Credit_Card_Transaction__HV__DataType::setFinancial_Category_Code()
     * @uses Credit_Card_Transaction__HV__DataType::setCharge_Description_Line_1()
     * @uses Credit_Card_Transaction__HV__DataType::setCharge_Description_Line_2()
     * @uses Credit_Card_Transaction__HV__DataType::setCost_Center_Reference()
     * @uses Credit_Card_Transaction__HV__DataType::setPurchase_Order_Number()
     * @uses Credit_Card_Transaction__HV__DataType::setRelease_Number()
     * @uses Credit_Card_Transaction__HV__DataType::setExpense_Credit_Card_ID()
     * @uses Credit_Card_Transaction__HV__DataType::setExpense_Credit_Card_Token()
     * @uses Credit_Card_Transaction__HV__DataType::setCorporate_Account_Reference()
     * @uses Credit_Card_Transaction__HV__DataType::setCardholder_ID()
     * @uses Credit_Card_Transaction__HV__DataType::setCardholder_Name()
     * @uses Credit_Card_Transaction__HV__DataType::setAccount_Number()
     * @uses Credit_Card_Transaction__HV__DataType::setCharge_Description()
     * @uses Credit_Card_Transaction__HV__DataType::setNumber_of_Days_or_Nights()
     * @uses Credit_Card_Transaction__HV__DataType::setCredit_Card_Merchant_Name()
     * @uses Credit_Card_Transaction__HV__DataType::setCredit_Card_Merchant_Location()
     * @uses Credit_Card_Transaction__HV__DataType::setMerchant_Address()
     * @uses Credit_Card_Transaction__HV__DataType::setMerchant_City()
     * @uses Credit_Card_Transaction__HV__DataType::setMerchant_Country_Region()
     * @uses Credit_Card_Transaction__HV__DataType::setMerchant_Country()
     * @uses Credit_Card_Transaction__HV__DataType::setMerchant_Postal_Code()
     * @uses Credit_Card_Transaction__HV__DataType::setMerchant_Document_Number()
     * @uses Credit_Card_Transaction__HV__DataType::setArrival_Date()
     * @uses Credit_Card_Transaction__HV__DataType::setDeparture_Date()
     * @uses Credit_Card_Transaction__HV__DataType::setReference_Number()
     * @uses Credit_Card_Transaction__HV__DataType::setParticipant_Name()
     * @uses Credit_Card_Transaction__HV__DataType::setDaily_Rate()
     * @uses Credit_Card_Transaction__HV__DataType::setDomestic()
     * @uses Credit_Card_Transaction__HV__DataType::setTicket_Number()
     * @uses Credit_Card_Transaction__HV__DataType::setClass_of_Service()
     * @uses Credit_Card_Transaction__HV__DataType::setAir_Routing()
     * @uses Credit_Card_Transaction__HV__DataType::setAir_Carrier_Code()
     * @uses Credit_Card_Transaction__HV__DataType::setOrigination_City()
     * @uses Credit_Card_Transaction__HV__DataType::setOrigination_State()
     * @uses Credit_Card_Transaction__HV__DataType::setOrigination_Country()
     * @uses Credit_Card_Transaction__HV__DataType::setOrigination_Airport_Code()
     * @uses Credit_Card_Transaction__HV__DataType::setDestination_City()
     * @uses Credit_Card_Transaction__HV__DataType::setDestination_State()
     * @uses Credit_Card_Transaction__HV__DataType::setDestination_Country()
     * @uses Credit_Card_Transaction__HV__DataType::setDestination_Airport_Code()
     * @uses Credit_Card_Transaction__HV__DataType::setClass_of_Service_Reference()
     * @uses Credit_Card_Transaction__HV__DataType::setCredit_Card_Transaction_Status_Reference()
     * @uses Credit_Card_Transaction__HV__DataType::setCredit_Card_Transaction_Line_Data()
     * @uses Credit_Card_Transaction__HV__DataType::setName_Match_Data()
     * @uses Credit_Card_Transaction__HV__DataType::setTicket_Details_Data()
     * @param string $transaction_Number
     * @param \StructType\Credit_Card_TransactionObjectType $credit_Card_Transaction_Reference
     * @param string $transaction_Date
     * @param \StructType\Credit_Card_CategoryObjectType $credit_Card_Category_Reference
     * @param string $expense_Payee
     * @param string $billing_Date
     * @param string $posted_Date
     * @param \StructType\Merchant_CodeObjectType $merchant_Code_Reference
     * @param string $merchant_Code
     * @param string $merchant_Tax_ID
     * @param \StructType\Merchant_CodeObjectType $mIS_Industry_Code_Reference
     * @param string $mIS_Industry_Code
     * @param string $market_Code
     * @param string $supplier_Reference_Number
     * @param string $dUNS_Number_for_Supplier
     * @param float $amount
     * @param float $tax_Amount
     * @param bool $sales_Taxes_Collected
     * @param \StructType\CurrencyObjectType $source_Currency_Reference
     * @param float $currency_Exchange_Rate
     * @param float $converted_Amount
     * @param float $converted_Tax_Amount
     * @param \StructType\CurrencyObjectType $converted_Currency_Reference
     * @param float $euro_Billed_Amount
     * @param float $euro_Billed_Tax_Amount
     * @param string $transaction_Type_Code
     * @param \StructType\Credit_Card_Transaction_TypeObjectType $transaction_Type_Reference
     * @param string $financial_Category_Code
     * @param string $charge_Description_Line_1
     * @param string $charge_Description_Line_2
     * @param \StructType\Cost_CenterObjectType $cost_Center_Reference
     * @param string $purchase_Order_Number
     * @param string $release_Number
     * @param string $expense_Credit_Card_ID
     * @param string $expense_Credit_Card_Token
     * @param \StructType\Corporate_Credit_Card_AccountObjectType $corporate_Account_Reference
     * @param string $cardholder_ID
     * @param string $cardholder_Name
     * @param string $account_Number
     * @param string $charge_Description
     * @param float $number_of_Days_or_Nights
     * @param string $credit_Card_Merchant_Name
     * @param string $credit_Card_Merchant_Location
     * @param string $merchant_Address
     * @param string $merchant_City
     * @param string $merchant_Country_Region
     * @param string $merchant_Country
     * @param string $merchant_Postal_Code
     * @param string $merchant_Document_Number
     * @param string $arrival_Date
     * @param string $departure_Date
     * @param string $reference_Number
     * @param string $participant_Name
     * @param float $daily_Rate
     * @param bool $domestic
     * @param string $ticket_Number
     * @param string $class_of_Service
     * @param string $air_Routing
     * @param string $air_Carrier_Code
     * @param string $origination_City
     * @param string $origination_State
     * @param string $origination_Country
     * @param string $origination_Airport_Code
     * @param string $destination_City
     * @param string $destination_State
     * @param string $destination_Country
     * @param string $destination_Airport_Code
     * @param \StructType\Class_of_ServiceObjectType $class_of_Service_Reference
     * @param \StructType\Expense_StatusObjectType $credit_Card_Transaction_Status_Reference
     * @param \StructType\CC_Transaction_LineType[] $credit_Card_Transaction_Line_Data
     * @param \StructType\Credit_Card_Transaction_Name_Match_DataType[] $name_Match_Data
     * @param \StructType\Ticket_Details_DataType[] $ticket_Details_Data
     */
    public function __construct($transaction_Number = null, \StructType\Credit_Card_TransactionObjectType $credit_Card_Transaction_Reference = null, $transaction_Date = null, \StructType\Credit_Card_CategoryObjectType $credit_Card_Category_Reference = null, $expense_Payee = null, $billing_Date = null, $posted_Date = null, \StructType\Merchant_CodeObjectType $merchant_Code_Reference = null, $merchant_Code = null, $merchant_Tax_ID = null, \StructType\Merchant_CodeObjectType $mIS_Industry_Code_Reference = null, $mIS_Industry_Code = null, $market_Code = null, $supplier_Reference_Number = null, $dUNS_Number_for_Supplier = null, $amount = null, $tax_Amount = null, $sales_Taxes_Collected = null, \StructType\CurrencyObjectType $source_Currency_Reference = null, $currency_Exchange_Rate = null, $converted_Amount = null, $converted_Tax_Amount = null, \StructType\CurrencyObjectType $converted_Currency_Reference = null, $euro_Billed_Amount = null, $euro_Billed_Tax_Amount = null, $transaction_Type_Code = null, \StructType\Credit_Card_Transaction_TypeObjectType $transaction_Type_Reference = null, $financial_Category_Code = null, $charge_Description_Line_1 = null, $charge_Description_Line_2 = null, \StructType\Cost_CenterObjectType $cost_Center_Reference = null, $purchase_Order_Number = null, $release_Number = null, $expense_Credit_Card_ID = null, $expense_Credit_Card_Token = null, \StructType\Corporate_Credit_Card_AccountObjectType $corporate_Account_Reference = null, $cardholder_ID = null, $cardholder_Name = null, $account_Number = null, $charge_Description = null, $number_of_Days_or_Nights = null, $credit_Card_Merchant_Name = null, $credit_Card_Merchant_Location = null, $merchant_Address = null, $merchant_City = null, $merchant_Country_Region = null, $merchant_Country = null, $merchant_Postal_Code = null, $merchant_Document_Number = null, $arrival_Date = null, $departure_Date = null, $reference_Number = null, $participant_Name = null, $daily_Rate = null, $domestic = null, $ticket_Number = null, $class_of_Service = null, $air_Routing = null, $air_Carrier_Code = null, $origination_City = null, $origination_State = null, $origination_Country = null, $origination_Airport_Code = null, $destination_City = null, $destination_State = null, $destination_Country = null, $destination_Airport_Code = null, \StructType\Class_of_ServiceObjectType $class_of_Service_Reference = null, \StructType\Expense_StatusObjectType $credit_Card_Transaction_Status_Reference = null, array $credit_Card_Transaction_Line_Data = array(), array $name_Match_Data = array(), array $ticket_Details_Data = array())
    {
        $this
            ->setTransaction_Number($transaction_Number)
            ->setCredit_Card_Transaction_Reference($credit_Card_Transaction_Reference)
            ->setTransaction_Date($transaction_Date)
            ->setCredit_Card_Category_Reference($credit_Card_Category_Reference)
            ->setExpense_Payee($expense_Payee)
            ->setBilling_Date($billing_Date)
            ->setPosted_Date($posted_Date)
            ->setMerchant_Code_Reference($merchant_Code_Reference)
            ->setMerchant_Code($merchant_Code)
            ->setMerchant_Tax_ID($merchant_Tax_ID)
            ->setMIS_Industry_Code_Reference($mIS_Industry_Code_Reference)
            ->setMIS_Industry_Code($mIS_Industry_Code)
            ->setMarket_Code($market_Code)
            ->setSupplier_Reference_Number($supplier_Reference_Number)
            ->setDUNS_Number_for_Supplier($dUNS_Number_for_Supplier)
            ->setAmount($amount)
            ->setTax_Amount($tax_Amount)
            ->setSales_Taxes_Collected($sales_Taxes_Collected)
            ->setSource_Currency_Reference($source_Currency_Reference)
            ->setCurrency_Exchange_Rate($currency_Exchange_Rate)
            ->setConverted_Amount($converted_Amount)
            ->setConverted_Tax_Amount($converted_Tax_Amount)
            ->setConverted_Currency_Reference($converted_Currency_Reference)
            ->setEuro_Billed_Amount($euro_Billed_Amount)
            ->setEuro_Billed_Tax_Amount($euro_Billed_Tax_Amount)
            ->setTransaction_Type_Code($transaction_Type_Code)
            ->setTransaction_Type_Reference($transaction_Type_Reference)
            ->setFinancial_Category_Code($financial_Category_Code)
            ->setCharge_Description_Line_1($charge_Description_Line_1)
            ->setCharge_Description_Line_2($charge_Description_Line_2)
            ->setCost_Center_Reference($cost_Center_Reference)
            ->setPurchase_Order_Number($purchase_Order_Number)
            ->setRelease_Number($release_Number)
            ->setExpense_Credit_Card_ID($expense_Credit_Card_ID)
            ->setExpense_Credit_Card_Token($expense_Credit_Card_Token)
            ->setCorporate_Account_Reference($corporate_Account_Reference)
            ->setCardholder_ID($cardholder_ID)
            ->setCardholder_Name($cardholder_Name)
            ->setAccount_Number($account_Number)
            ->setCharge_Description($charge_Description)
            ->setNumber_of_Days_or_Nights($number_of_Days_or_Nights)
            ->setCredit_Card_Merchant_Name($credit_Card_Merchant_Name)
            ->setCredit_Card_Merchant_Location($credit_Card_Merchant_Location)
            ->setMerchant_Address($merchant_Address)
            ->setMerchant_City($merchant_City)
            ->setMerchant_Country_Region($merchant_Country_Region)
            ->setMerchant_Country($merchant_Country)
            ->setMerchant_Postal_Code($merchant_Postal_Code)
            ->setMerchant_Document_Number($merchant_Document_Number)
            ->setArrival_Date($arrival_Date)
            ->setDeparture_Date($departure_Date)
            ->setReference_Number($reference_Number)
            ->setParticipant_Name($participant_Name)
            ->setDaily_Rate($daily_Rate)
            ->setDomestic($domestic)
            ->setTicket_Number($ticket_Number)
            ->setClass_of_Service($class_of_Service)
            ->setAir_Routing($air_Routing)
            ->setAir_Carrier_Code($air_Carrier_Code)
            ->setOrigination_City($origination_City)
            ->setOrigination_State($origination_State)
            ->setOrigination_Country($origination_Country)
            ->setOrigination_Airport_Code($origination_Airport_Code)
            ->setDestination_City($destination_City)
            ->setDestination_State($destination_State)
            ->setDestination_Country($destination_Country)
            ->setDestination_Airport_Code($destination_Airport_Code)
            ->setClass_of_Service_Reference($class_of_Service_Reference)
            ->setCredit_Card_Transaction_Status_Reference($credit_Card_Transaction_Status_Reference)
            ->setCredit_Card_Transaction_Line_Data($credit_Card_Transaction_Line_Data)
            ->setName_Match_Data($name_Match_Data)
            ->setTicket_Details_Data($ticket_Details_Data);
    }
    /**
     * Get Transaction_Number value
     * @return string|null
     */
    public function getTransaction_Number()
    {
        return $this->Transaction_Number;
    }
    /**
     * Set Transaction_Number value
     * @param string $transaction_Number
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setTransaction_Number($transaction_Number = null)
    {
        // validation for constraint: string
        if (!is_null($transaction_Number) && !is_string($transaction_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transaction_Number, true), gettype($transaction_Number)), __LINE__);
        }
        $this->Transaction_Number = $transaction_Number;
        return $this;
    }
    /**
     * Get Credit_Card_Transaction_Reference value
     * @return \StructType\Credit_Card_TransactionObjectType|null
     */
    public function getCredit_Card_Transaction_Reference()
    {
        return $this->Credit_Card_Transaction_Reference;
    }
    /**
     * Set Credit_Card_Transaction_Reference value
     * @param \StructType\Credit_Card_TransactionObjectType $credit_Card_Transaction_Reference
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setCredit_Card_Transaction_Reference(\StructType\Credit_Card_TransactionObjectType $credit_Card_Transaction_Reference = null)
    {
        $this->Credit_Card_Transaction_Reference = $credit_Card_Transaction_Reference;
        return $this;
    }
    /**
     * Get Transaction_Date value
     * @return string|null
     */
    public function getTransaction_Date()
    {
        return $this->Transaction_Date;
    }
    /**
     * Set Transaction_Date value
     * @param string $transaction_Date
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setTransaction_Date($transaction_Date = null)
    {
        // validation for constraint: string
        if (!is_null($transaction_Date) && !is_string($transaction_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transaction_Date, true), gettype($transaction_Date)), __LINE__);
        }
        $this->Transaction_Date = $transaction_Date;
        return $this;
    }
    /**
     * Get Credit_Card_Category_Reference value
     * @return \StructType\Credit_Card_CategoryObjectType|null
     */
    public function getCredit_Card_Category_Reference()
    {
        return $this->Credit_Card_Category_Reference;
    }
    /**
     * Set Credit_Card_Category_Reference value
     * @param \StructType\Credit_Card_CategoryObjectType $credit_Card_Category_Reference
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setCredit_Card_Category_Reference(\StructType\Credit_Card_CategoryObjectType $credit_Card_Category_Reference = null)
    {
        $this->Credit_Card_Category_Reference = $credit_Card_Category_Reference;
        return $this;
    }
    /**
     * Get Expense_Payee value
     * @return string|null
     */
    public function getExpense_Payee()
    {
        return $this->Expense_Payee;
    }
    /**
     * Set Expense_Payee value
     * @param string $expense_Payee
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setExpense_Payee($expense_Payee = null)
    {
        // validation for constraint: string
        if (!is_null($expense_Payee) && !is_string($expense_Payee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expense_Payee, true), gettype($expense_Payee)), __LINE__);
        }
        $this->Expense_Payee = $expense_Payee;
        return $this;
    }
    /**
     * Get Billing_Date value
     * @return string|null
     */
    public function getBilling_Date()
    {
        return $this->Billing_Date;
    }
    /**
     * Set Billing_Date value
     * @param string $billing_Date
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setBilling_Date($billing_Date = null)
    {
        // validation for constraint: string
        if (!is_null($billing_Date) && !is_string($billing_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billing_Date, true), gettype($billing_Date)), __LINE__);
        }
        $this->Billing_Date = $billing_Date;
        return $this;
    }
    /**
     * Get Posted_Date value
     * @return string|null
     */
    public function getPosted_Date()
    {
        return $this->Posted_Date;
    }
    /**
     * Set Posted_Date value
     * @param string $posted_Date
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setPosted_Date($posted_Date = null)
    {
        // validation for constraint: string
        if (!is_null($posted_Date) && !is_string($posted_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($posted_Date, true), gettype($posted_Date)), __LINE__);
        }
        $this->Posted_Date = $posted_Date;
        return $this;
    }
    /**
     * Get Merchant_Code_Reference value
     * @return \StructType\Merchant_CodeObjectType|null
     */
    public function getMerchant_Code_Reference()
    {
        return $this->Merchant_Code_Reference;
    }
    /**
     * Set Merchant_Code_Reference value
     * @param \StructType\Merchant_CodeObjectType $merchant_Code_Reference
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setMerchant_Code_Reference(\StructType\Merchant_CodeObjectType $merchant_Code_Reference = null)
    {
        $this->Merchant_Code_Reference = $merchant_Code_Reference;
        return $this;
    }
    /**
     * Get Merchant_Code value
     * @return string|null
     */
    public function getMerchant_Code()
    {
        return $this->Merchant_Code;
    }
    /**
     * Set Merchant_Code value
     * @param string $merchant_Code
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setMerchant_Code($merchant_Code = null)
    {
        // validation for constraint: string
        if (!is_null($merchant_Code) && !is_string($merchant_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchant_Code, true), gettype($merchant_Code)), __LINE__);
        }
        $this->Merchant_Code = $merchant_Code;
        return $this;
    }
    /**
     * Get Merchant_Tax_ID value
     * @return string|null
     */
    public function getMerchant_Tax_ID()
    {
        return $this->Merchant_Tax_ID;
    }
    /**
     * Set Merchant_Tax_ID value
     * @param string $merchant_Tax_ID
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setMerchant_Tax_ID($merchant_Tax_ID = null)
    {
        // validation for constraint: string
        if (!is_null($merchant_Tax_ID) && !is_string($merchant_Tax_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchant_Tax_ID, true), gettype($merchant_Tax_ID)), __LINE__);
        }
        $this->Merchant_Tax_ID = $merchant_Tax_ID;
        return $this;
    }
    /**
     * Get MIS_Industry_Code_Reference value
     * @return \StructType\Merchant_CodeObjectType|null
     */
    public function getMIS_Industry_Code_Reference()
    {
        return $this->MIS_Industry_Code_Reference;
    }
    /**
     * Set MIS_Industry_Code_Reference value
     * @param \StructType\Merchant_CodeObjectType $mIS_Industry_Code_Reference
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setMIS_Industry_Code_Reference(\StructType\Merchant_CodeObjectType $mIS_Industry_Code_Reference = null)
    {
        $this->MIS_Industry_Code_Reference = $mIS_Industry_Code_Reference;
        return $this;
    }
    /**
     * Get MIS_Industry_Code value
     * @return string|null
     */
    public function getMIS_Industry_Code()
    {
        return $this->MIS_Industry_Code;
    }
    /**
     * Set MIS_Industry_Code value
     * @param string $mIS_Industry_Code
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setMIS_Industry_Code($mIS_Industry_Code = null)
    {
        // validation for constraint: string
        if (!is_null($mIS_Industry_Code) && !is_string($mIS_Industry_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mIS_Industry_Code, true), gettype($mIS_Industry_Code)), __LINE__);
        }
        $this->MIS_Industry_Code = $mIS_Industry_Code;
        return $this;
    }
    /**
     * Get Market_Code value
     * @return string|null
     */
    public function getMarket_Code()
    {
        return $this->Market_Code;
    }
    /**
     * Set Market_Code value
     * @param string $market_Code
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setMarket_Code($market_Code = null)
    {
        // validation for constraint: string
        if (!is_null($market_Code) && !is_string($market_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($market_Code, true), gettype($market_Code)), __LINE__);
        }
        $this->Market_Code = $market_Code;
        return $this;
    }
    /**
     * Get Supplier_Reference_Number value
     * @return string|null
     */
    public function getSupplier_Reference_Number()
    {
        return $this->Supplier_Reference_Number;
    }
    /**
     * Set Supplier_Reference_Number value
     * @param string $supplier_Reference_Number
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setSupplier_Reference_Number($supplier_Reference_Number = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Reference_Number) && !is_string($supplier_Reference_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Reference_Number, true), gettype($supplier_Reference_Number)), __LINE__);
        }
        $this->Supplier_Reference_Number = $supplier_Reference_Number;
        return $this;
    }
    /**
     * Get DUNS_Number_for_Supplier value
     * @return string|null
     */
    public function getDUNS_Number_for_Supplier()
    {
        return $this->DUNS_Number_for_Supplier;
    }
    /**
     * Set DUNS_Number_for_Supplier value
     * @param string $dUNS_Number_for_Supplier
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setDUNS_Number_for_Supplier($dUNS_Number_for_Supplier = null)
    {
        // validation for constraint: string
        if (!is_null($dUNS_Number_for_Supplier) && !is_string($dUNS_Number_for_Supplier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dUNS_Number_for_Supplier, true), gettype($dUNS_Number_for_Supplier)), __LINE__);
        }
        $this->DUNS_Number_for_Supplier = $dUNS_Number_for_Supplier;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($amount) && mb_strlen(mb_substr($amount, false !== mb_strpos($amount, '.') ? mb_strpos($amount, '.') + 1 : mb_strlen($amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($amount, true), mb_strlen(mb_substr($amount, mb_strpos($amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($amount) && mb_strlen(preg_replace('/(\D)/', '', $amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($amount, true), mb_strlen(preg_replace('/(\D)/', '', $amount))), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Tax_Amount value
     * @return float|null
     */
    public function getTax_Amount()
    {
        return $this->Tax_Amount;
    }
    /**
     * Set Tax_Amount value
     * @param float $tax_Amount
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setTax_Amount($tax_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($tax_Amount) && !(is_float($tax_Amount) || is_numeric($tax_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax_Amount, true), gettype($tax_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($tax_Amount) && mb_strlen(mb_substr($tax_Amount, false !== mb_strpos($tax_Amount, '.') ? mb_strpos($tax_Amount, '.') + 1 : mb_strlen($tax_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($tax_Amount, true), mb_strlen(mb_substr($tax_Amount, mb_strpos($tax_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($tax_Amount) && mb_strlen(preg_replace('/(\D)/', '', $tax_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($tax_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $tax_Amount))), __LINE__);
        }
        $this->Tax_Amount = $tax_Amount;
        return $this;
    }
    /**
     * Get Sales_Taxes_Collected value
     * @return bool|null
     */
    public function getSales_Taxes_Collected()
    {
        return $this->Sales_Taxes_Collected;
    }
    /**
     * Set Sales_Taxes_Collected value
     * @param bool $sales_Taxes_Collected
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setSales_Taxes_Collected($sales_Taxes_Collected = null)
    {
        // validation for constraint: boolean
        if (!is_null($sales_Taxes_Collected) && !is_bool($sales_Taxes_Collected)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sales_Taxes_Collected, true), gettype($sales_Taxes_Collected)), __LINE__);
        }
        $this->Sales_Taxes_Collected = $sales_Taxes_Collected;
        return $this;
    }
    /**
     * Get Source_Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getSource_Currency_Reference()
    {
        return $this->Source_Currency_Reference;
    }
    /**
     * Set Source_Currency_Reference value
     * @param \StructType\CurrencyObjectType $source_Currency_Reference
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setSource_Currency_Reference(\StructType\CurrencyObjectType $source_Currency_Reference = null)
    {
        $this->Source_Currency_Reference = $source_Currency_Reference;
        return $this;
    }
    /**
     * Get Currency_Exchange_Rate value
     * @return float|null
     */
    public function getCurrency_Exchange_Rate()
    {
        return $this->Currency_Exchange_Rate;
    }
    /**
     * Set Currency_Exchange_Rate value
     * @param float $currency_Exchange_Rate
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setCurrency_Exchange_Rate($currency_Exchange_Rate = null)
    {
        // validation for constraint: float
        if (!is_null($currency_Exchange_Rate) && !(is_float($currency_Exchange_Rate) || is_numeric($currency_Exchange_Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($currency_Exchange_Rate, true), gettype($currency_Exchange_Rate)), __LINE__);
        }
        // validation for constraint: fractionDigits(12)
        if (!is_null($currency_Exchange_Rate) && mb_strlen(mb_substr($currency_Exchange_Rate, false !== mb_strpos($currency_Exchange_Rate, '.') ? mb_strpos($currency_Exchange_Rate, '.') + 1 : mb_strlen($currency_Exchange_Rate))) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 12 fraction digits, %d given', var_export($currency_Exchange_Rate, true), mb_strlen(mb_substr($currency_Exchange_Rate, mb_strpos($currency_Exchange_Rate, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($currency_Exchange_Rate) && $currency_Exchange_Rate < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($currency_Exchange_Rate, true)), __LINE__);
        }
        // validation for constraint: totalDigits(32)
        if (!is_null($currency_Exchange_Rate) && mb_strlen(preg_replace('/(\D)/', '', $currency_Exchange_Rate)) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 32 digits, "%d" given', var_export($currency_Exchange_Rate, true), mb_strlen(preg_replace('/(\D)/', '', $currency_Exchange_Rate))), __LINE__);
        }
        $this->Currency_Exchange_Rate = $currency_Exchange_Rate;
        return $this;
    }
    /**
     * Get Converted_Amount value
     * @return float|null
     */
    public function getConverted_Amount()
    {
        return $this->Converted_Amount;
    }
    /**
     * Set Converted_Amount value
     * @param float $converted_Amount
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setConverted_Amount($converted_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($converted_Amount) && !(is_float($converted_Amount) || is_numeric($converted_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($converted_Amount, true), gettype($converted_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($converted_Amount) && mb_strlen(mb_substr($converted_Amount, false !== mb_strpos($converted_Amount, '.') ? mb_strpos($converted_Amount, '.') + 1 : mb_strlen($converted_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($converted_Amount, true), mb_strlen(mb_substr($converted_Amount, mb_strpos($converted_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($converted_Amount) && mb_strlen(preg_replace('/(\D)/', '', $converted_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($converted_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $converted_Amount))), __LINE__);
        }
        $this->Converted_Amount = $converted_Amount;
        return $this;
    }
    /**
     * Get Converted_Tax_Amount value
     * @return float|null
     */
    public function getConverted_Tax_Amount()
    {
        return $this->Converted_Tax_Amount;
    }
    /**
     * Set Converted_Tax_Amount value
     * @param float $converted_Tax_Amount
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setConverted_Tax_Amount($converted_Tax_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($converted_Tax_Amount) && !(is_float($converted_Tax_Amount) || is_numeric($converted_Tax_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($converted_Tax_Amount, true), gettype($converted_Tax_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($converted_Tax_Amount) && mb_strlen(mb_substr($converted_Tax_Amount, false !== mb_strpos($converted_Tax_Amount, '.') ? mb_strpos($converted_Tax_Amount, '.') + 1 : mb_strlen($converted_Tax_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($converted_Tax_Amount, true), mb_strlen(mb_substr($converted_Tax_Amount, mb_strpos($converted_Tax_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($converted_Tax_Amount) && mb_strlen(preg_replace('/(\D)/', '', $converted_Tax_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($converted_Tax_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $converted_Tax_Amount))), __LINE__);
        }
        $this->Converted_Tax_Amount = $converted_Tax_Amount;
        return $this;
    }
    /**
     * Get Converted_Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getConverted_Currency_Reference()
    {
        return $this->Converted_Currency_Reference;
    }
    /**
     * Set Converted_Currency_Reference value
     * @param \StructType\CurrencyObjectType $converted_Currency_Reference
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setConverted_Currency_Reference(\StructType\CurrencyObjectType $converted_Currency_Reference = null)
    {
        $this->Converted_Currency_Reference = $converted_Currency_Reference;
        return $this;
    }
    /**
     * Get Euro_Billed_Amount value
     * @return float|null
     */
    public function getEuro_Billed_Amount()
    {
        return $this->Euro_Billed_Amount;
    }
    /**
     * Set Euro_Billed_Amount value
     * @param float $euro_Billed_Amount
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setEuro_Billed_Amount($euro_Billed_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($euro_Billed_Amount) && !(is_float($euro_Billed_Amount) || is_numeric($euro_Billed_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($euro_Billed_Amount, true), gettype($euro_Billed_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($euro_Billed_Amount) && mb_strlen(mb_substr($euro_Billed_Amount, false !== mb_strpos($euro_Billed_Amount, '.') ? mb_strpos($euro_Billed_Amount, '.') + 1 : mb_strlen($euro_Billed_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($euro_Billed_Amount, true), mb_strlen(mb_substr($euro_Billed_Amount, mb_strpos($euro_Billed_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($euro_Billed_Amount) && mb_strlen(preg_replace('/(\D)/', '', $euro_Billed_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($euro_Billed_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $euro_Billed_Amount))), __LINE__);
        }
        $this->Euro_Billed_Amount = $euro_Billed_Amount;
        return $this;
    }
    /**
     * Get Euro_Billed_Tax_Amount value
     * @return float|null
     */
    public function getEuro_Billed_Tax_Amount()
    {
        return $this->Euro_Billed_Tax_Amount;
    }
    /**
     * Set Euro_Billed_Tax_Amount value
     * @param float $euro_Billed_Tax_Amount
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setEuro_Billed_Tax_Amount($euro_Billed_Tax_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($euro_Billed_Tax_Amount) && !(is_float($euro_Billed_Tax_Amount) || is_numeric($euro_Billed_Tax_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($euro_Billed_Tax_Amount, true), gettype($euro_Billed_Tax_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($euro_Billed_Tax_Amount) && mb_strlen(mb_substr($euro_Billed_Tax_Amount, false !== mb_strpos($euro_Billed_Tax_Amount, '.') ? mb_strpos($euro_Billed_Tax_Amount, '.') + 1 : mb_strlen($euro_Billed_Tax_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($euro_Billed_Tax_Amount, true), mb_strlen(mb_substr($euro_Billed_Tax_Amount, mb_strpos($euro_Billed_Tax_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($euro_Billed_Tax_Amount) && mb_strlen(preg_replace('/(\D)/', '', $euro_Billed_Tax_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($euro_Billed_Tax_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $euro_Billed_Tax_Amount))), __LINE__);
        }
        $this->Euro_Billed_Tax_Amount = $euro_Billed_Tax_Amount;
        return $this;
    }
    /**
     * Get Transaction_Type_Code value
     * @return string|null
     */
    public function getTransaction_Type_Code()
    {
        return $this->Transaction_Type_Code;
    }
    /**
     * Set Transaction_Type_Code value
     * @param string $transaction_Type_Code
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setTransaction_Type_Code($transaction_Type_Code = null)
    {
        // validation for constraint: string
        if (!is_null($transaction_Type_Code) && !is_string($transaction_Type_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transaction_Type_Code, true), gettype($transaction_Type_Code)), __LINE__);
        }
        $this->Transaction_Type_Code = $transaction_Type_Code;
        return $this;
    }
    /**
     * Get Transaction_Type_Reference value
     * @return \StructType\Credit_Card_Transaction_TypeObjectType|null
     */
    public function getTransaction_Type_Reference()
    {
        return $this->Transaction_Type_Reference;
    }
    /**
     * Set Transaction_Type_Reference value
     * @param \StructType\Credit_Card_Transaction_TypeObjectType $transaction_Type_Reference
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setTransaction_Type_Reference(\StructType\Credit_Card_Transaction_TypeObjectType $transaction_Type_Reference = null)
    {
        $this->Transaction_Type_Reference = $transaction_Type_Reference;
        return $this;
    }
    /**
     * Get Financial_Category_Code value
     * @return string|null
     */
    public function getFinancial_Category_Code()
    {
        return $this->Financial_Category_Code;
    }
    /**
     * Set Financial_Category_Code value
     * @param string $financial_Category_Code
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setFinancial_Category_Code($financial_Category_Code = null)
    {
        // validation for constraint: string
        if (!is_null($financial_Category_Code) && !is_string($financial_Category_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($financial_Category_Code, true), gettype($financial_Category_Code)), __LINE__);
        }
        $this->Financial_Category_Code = $financial_Category_Code;
        return $this;
    }
    /**
     * Get charge_Description_Line value
     * @return charge_Description_Line
     */
    public function getCharge_Description_Line_1()
    {
        return $this->Charge_Description_Line_1;
    }
    /**
     * Set charge_Description_Line value
     * @param charge_Description_Line $charge_Description_Line
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setCharge_Description_Line_1($charge_Description_Line_1 = null)
    {
        // validation for constraint: string
        if (!is_null($charge_Description_Line_1) && !is_string($charge_Description_Line_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($charge_Description_Line_1, true), gettype($charge_Description_Line_1)), __LINE__);
        }
        $this->Charge_Description_Line_1 = $charge_Description_Line_1;
        return $this;
    }
    /**
     * Get charge_Description_Line value
     * @return charge_Description_Line
     */
    public function getCharge_Description_Line_2()
    {
        return $this->Charge_Description_Line_2;
    }
    /**
     * Set charge_Description_Line value
     * @param charge_Description_Line $charge_Description_Line
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setCharge_Description_Line_2($charge_Description_Line_2 = null)
    {
        // validation for constraint: string
        if (!is_null($charge_Description_Line_2) && !is_string($charge_Description_Line_2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($charge_Description_Line_2, true), gettype($charge_Description_Line_2)), __LINE__);
        }
        $this->Charge_Description_Line_2 = $charge_Description_Line_2;
        return $this;
    }
    /**
     * Get Cost_Center_Reference value
     * @return \StructType\Cost_CenterObjectType|null
     */
    public function getCost_Center_Reference()
    {
        return $this->Cost_Center_Reference;
    }
    /**
     * Set Cost_Center_Reference value
     * @param \StructType\Cost_CenterObjectType $cost_Center_Reference
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setCost_Center_Reference(\StructType\Cost_CenterObjectType $cost_Center_Reference = null)
    {
        $this->Cost_Center_Reference = $cost_Center_Reference;
        return $this;
    }
    /**
     * Get Purchase_Order_Number value
     * @return string|null
     */
    public function getPurchase_Order_Number()
    {
        return $this->Purchase_Order_Number;
    }
    /**
     * Set Purchase_Order_Number value
     * @param string $purchase_Order_Number
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setPurchase_Order_Number($purchase_Order_Number = null)
    {
        // validation for constraint: string
        if (!is_null($purchase_Order_Number) && !is_string($purchase_Order_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchase_Order_Number, true), gettype($purchase_Order_Number)), __LINE__);
        }
        $this->Purchase_Order_Number = $purchase_Order_Number;
        return $this;
    }
    /**
     * Get Release_Number value
     * @return string|null
     */
    public function getRelease_Number()
    {
        return $this->Release_Number;
    }
    /**
     * Set Release_Number value
     * @param string $release_Number
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setRelease_Number($release_Number = null)
    {
        // validation for constraint: string
        if (!is_null($release_Number) && !is_string($release_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($release_Number, true), gettype($release_Number)), __LINE__);
        }
        $this->Release_Number = $release_Number;
        return $this;
    }
    /**
     * Get Expense_Credit_Card_ID value
     * @return string|null
     */
    public function getExpense_Credit_Card_ID()
    {
        return $this->Expense_Credit_Card_ID;
    }
    /**
     * Set Expense_Credit_Card_ID value
     * @param string $expense_Credit_Card_ID
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setExpense_Credit_Card_ID($expense_Credit_Card_ID = null)
    {
        // validation for constraint: string
        if (!is_null($expense_Credit_Card_ID) && !is_string($expense_Credit_Card_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expense_Credit_Card_ID, true), gettype($expense_Credit_Card_ID)), __LINE__);
        }
        $this->Expense_Credit_Card_ID = $expense_Credit_Card_ID;
        return $this;
    }
    /**
     * Get Expense_Credit_Card_Token value
     * @return string|null
     */
    public function getExpense_Credit_Card_Token()
    {
        return $this->Expense_Credit_Card_Token;
    }
    /**
     * Set Expense_Credit_Card_Token value
     * @param string $expense_Credit_Card_Token
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setExpense_Credit_Card_Token($expense_Credit_Card_Token = null)
    {
        // validation for constraint: string
        if (!is_null($expense_Credit_Card_Token) && !is_string($expense_Credit_Card_Token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expense_Credit_Card_Token, true), gettype($expense_Credit_Card_Token)), __LINE__);
        }
        $this->Expense_Credit_Card_Token = $expense_Credit_Card_Token;
        return $this;
    }
    /**
     * Get Corporate_Account_Reference value
     * @return \StructType\Corporate_Credit_Card_AccountObjectType|null
     */
    public function getCorporate_Account_Reference()
    {
        return $this->Corporate_Account_Reference;
    }
    /**
     * Set Corporate_Account_Reference value
     * @param \StructType\Corporate_Credit_Card_AccountObjectType $corporate_Account_Reference
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setCorporate_Account_Reference(\StructType\Corporate_Credit_Card_AccountObjectType $corporate_Account_Reference = null)
    {
        $this->Corporate_Account_Reference = $corporate_Account_Reference;
        return $this;
    }
    /**
     * Get Cardholder_ID value
     * @return string|null
     */
    public function getCardholder_ID()
    {
        return $this->Cardholder_ID;
    }
    /**
     * Set Cardholder_ID value
     * @param string $cardholder_ID
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setCardholder_ID($cardholder_ID = null)
    {
        // validation for constraint: string
        if (!is_null($cardholder_ID) && !is_string($cardholder_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardholder_ID, true), gettype($cardholder_ID)), __LINE__);
        }
        $this->Cardholder_ID = $cardholder_ID;
        return $this;
    }
    /**
     * Get Cardholder_Name value
     * @return string|null
     */
    public function getCardholder_Name()
    {
        return $this->Cardholder_Name;
    }
    /**
     * Set Cardholder_Name value
     * @param string $cardholder_Name
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setCardholder_Name($cardholder_Name = null)
    {
        // validation for constraint: string
        if (!is_null($cardholder_Name) && !is_string($cardholder_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardholder_Name, true), gettype($cardholder_Name)), __LINE__);
        }
        $this->Cardholder_Name = $cardholder_Name;
        return $this;
    }
    /**
     * Get Account_Number value
     * @return string|null
     */
    public function getAccount_Number()
    {
        return $this->Account_Number;
    }
    /**
     * Set Account_Number value
     * @param string $account_Number
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setAccount_Number($account_Number = null)
    {
        // validation for constraint: string
        if (!is_null($account_Number) && !is_string($account_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($account_Number, true), gettype($account_Number)), __LINE__);
        }
        $this->Account_Number = $account_Number;
        return $this;
    }
    /**
     * Get Charge_Description value
     * @return string|null
     */
    public function getCharge_Description()
    {
        return $this->Charge_Description;
    }
    /**
     * Set Charge_Description value
     * @param string $charge_Description
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setCharge_Description($charge_Description = null)
    {
        // validation for constraint: string
        if (!is_null($charge_Description) && !is_string($charge_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($charge_Description, true), gettype($charge_Description)), __LINE__);
        }
        $this->Charge_Description = $charge_Description;
        return $this;
    }
    /**
     * Get Number_of_Days_or_Nights value
     * @return float|null
     */
    public function getNumber_of_Days_or_Nights()
    {
        return $this->Number_of_Days_or_Nights;
    }
    /**
     * Set Number_of_Days_or_Nights value
     * @param float $number_of_Days_or_Nights
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setNumber_of_Days_or_Nights($number_of_Days_or_Nights = null)
    {
        // validation for constraint: float
        if (!is_null($number_of_Days_or_Nights) && !(is_float($number_of_Days_or_Nights) || is_numeric($number_of_Days_or_Nights))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($number_of_Days_or_Nights, true), gettype($number_of_Days_or_Nights)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($number_of_Days_or_Nights) && mb_strlen(mb_substr($number_of_Days_or_Nights, false !== mb_strpos($number_of_Days_or_Nights, '.') ? mb_strpos($number_of_Days_or_Nights, '.') + 1 : mb_strlen($number_of_Days_or_Nights))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($number_of_Days_or_Nights, true), mb_strlen(mb_substr($number_of_Days_or_Nights, mb_strpos($number_of_Days_or_Nights, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($number_of_Days_or_Nights) && $number_of_Days_or_Nights < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($number_of_Days_or_Nights, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($number_of_Days_or_Nights) && mb_strlen(preg_replace('/(\D)/', '', $number_of_Days_or_Nights)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($number_of_Days_or_Nights, true), mb_strlen(preg_replace('/(\D)/', '', $number_of_Days_or_Nights))), __LINE__);
        }
        $this->Number_of_Days_or_Nights = $number_of_Days_or_Nights;
        return $this;
    }
    /**
     * Get Credit_Card_Merchant_Name value
     * @return string|null
     */
    public function getCredit_Card_Merchant_Name()
    {
        return $this->Credit_Card_Merchant_Name;
    }
    /**
     * Set Credit_Card_Merchant_Name value
     * @param string $credit_Card_Merchant_Name
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setCredit_Card_Merchant_Name($credit_Card_Merchant_Name = null)
    {
        // validation for constraint: string
        if (!is_null($credit_Card_Merchant_Name) && !is_string($credit_Card_Merchant_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($credit_Card_Merchant_Name, true), gettype($credit_Card_Merchant_Name)), __LINE__);
        }
        $this->Credit_Card_Merchant_Name = $credit_Card_Merchant_Name;
        return $this;
    }
    /**
     * Get Credit_Card_Merchant_Location value
     * @return string|null
     */
    public function getCredit_Card_Merchant_Location()
    {
        return $this->Credit_Card_Merchant_Location;
    }
    /**
     * Set Credit_Card_Merchant_Location value
     * @param string $credit_Card_Merchant_Location
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setCredit_Card_Merchant_Location($credit_Card_Merchant_Location = null)
    {
        // validation for constraint: string
        if (!is_null($credit_Card_Merchant_Location) && !is_string($credit_Card_Merchant_Location)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($credit_Card_Merchant_Location, true), gettype($credit_Card_Merchant_Location)), __LINE__);
        }
        $this->Credit_Card_Merchant_Location = $credit_Card_Merchant_Location;
        return $this;
    }
    /**
     * Get Merchant_Address value
     * @return string|null
     */
    public function getMerchant_Address()
    {
        return $this->Merchant_Address;
    }
    /**
     * Set Merchant_Address value
     * @param string $merchant_Address
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setMerchant_Address($merchant_Address = null)
    {
        // validation for constraint: string
        if (!is_null($merchant_Address) && !is_string($merchant_Address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchant_Address, true), gettype($merchant_Address)), __LINE__);
        }
        $this->Merchant_Address = $merchant_Address;
        return $this;
    }
    /**
     * Get Merchant_City value
     * @return string|null
     */
    public function getMerchant_City()
    {
        return $this->Merchant_City;
    }
    /**
     * Set Merchant_City value
     * @param string $merchant_City
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setMerchant_City($merchant_City = null)
    {
        // validation for constraint: string
        if (!is_null($merchant_City) && !is_string($merchant_City)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchant_City, true), gettype($merchant_City)), __LINE__);
        }
        $this->Merchant_City = $merchant_City;
        return $this;
    }
    /**
     * Get Merchant_Country_Region value
     * @return string|null
     */
    public function getMerchant_Country_Region()
    {
        return $this->Merchant_Country_Region;
    }
    /**
     * Set Merchant_Country_Region value
     * @param string $merchant_Country_Region
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setMerchant_Country_Region($merchant_Country_Region = null)
    {
        // validation for constraint: string
        if (!is_null($merchant_Country_Region) && !is_string($merchant_Country_Region)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchant_Country_Region, true), gettype($merchant_Country_Region)), __LINE__);
        }
        $this->Merchant_Country_Region = $merchant_Country_Region;
        return $this;
    }
    /**
     * Get Merchant_Country value
     * @return string|null
     */
    public function getMerchant_Country()
    {
        return $this->Merchant_Country;
    }
    /**
     * Set Merchant_Country value
     * @param string $merchant_Country
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setMerchant_Country($merchant_Country = null)
    {
        // validation for constraint: string
        if (!is_null($merchant_Country) && !is_string($merchant_Country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchant_Country, true), gettype($merchant_Country)), __LINE__);
        }
        $this->Merchant_Country = $merchant_Country;
        return $this;
    }
    /**
     * Get Merchant_Postal_Code value
     * @return string|null
     */
    public function getMerchant_Postal_Code()
    {
        return $this->Merchant_Postal_Code;
    }
    /**
     * Set Merchant_Postal_Code value
     * @param string $merchant_Postal_Code
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setMerchant_Postal_Code($merchant_Postal_Code = null)
    {
        // validation for constraint: string
        if (!is_null($merchant_Postal_Code) && !is_string($merchant_Postal_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchant_Postal_Code, true), gettype($merchant_Postal_Code)), __LINE__);
        }
        $this->Merchant_Postal_Code = $merchant_Postal_Code;
        return $this;
    }
    /**
     * Get Merchant_Document_Number value
     * @return string|null
     */
    public function getMerchant_Document_Number()
    {
        return $this->Merchant_Document_Number;
    }
    /**
     * Set Merchant_Document_Number value
     * @param string $merchant_Document_Number
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setMerchant_Document_Number($merchant_Document_Number = null)
    {
        // validation for constraint: string
        if (!is_null($merchant_Document_Number) && !is_string($merchant_Document_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchant_Document_Number, true), gettype($merchant_Document_Number)), __LINE__);
        }
        $this->Merchant_Document_Number = $merchant_Document_Number;
        return $this;
    }
    /**
     * Get Arrival_Date value
     * @return string|null
     */
    public function getArrival_Date()
    {
        return $this->Arrival_Date;
    }
    /**
     * Set Arrival_Date value
     * @param string $arrival_Date
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setArrival_Date($arrival_Date = null)
    {
        // validation for constraint: string
        if (!is_null($arrival_Date) && !is_string($arrival_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrival_Date, true), gettype($arrival_Date)), __LINE__);
        }
        $this->Arrival_Date = $arrival_Date;
        return $this;
    }
    /**
     * Get Departure_Date value
     * @return string|null
     */
    public function getDeparture_Date()
    {
        return $this->Departure_Date;
    }
    /**
     * Set Departure_Date value
     * @param string $departure_Date
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setDeparture_Date($departure_Date = null)
    {
        // validation for constraint: string
        if (!is_null($departure_Date) && !is_string($departure_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departure_Date, true), gettype($departure_Date)), __LINE__);
        }
        $this->Departure_Date = $departure_Date;
        return $this;
    }
    /**
     * Get Reference_Number value
     * @return string|null
     */
    public function getReference_Number()
    {
        return $this->Reference_Number;
    }
    /**
     * Set Reference_Number value
     * @param string $reference_Number
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setReference_Number($reference_Number = null)
    {
        // validation for constraint: string
        if (!is_null($reference_Number) && !is_string($reference_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference_Number, true), gettype($reference_Number)), __LINE__);
        }
        $this->Reference_Number = $reference_Number;
        return $this;
    }
    /**
     * Get Participant_Name value
     * @return string|null
     */
    public function getParticipant_Name()
    {
        return $this->Participant_Name;
    }
    /**
     * Set Participant_Name value
     * @param string $participant_Name
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setParticipant_Name($participant_Name = null)
    {
        // validation for constraint: string
        if (!is_null($participant_Name) && !is_string($participant_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($participant_Name, true), gettype($participant_Name)), __LINE__);
        }
        $this->Participant_Name = $participant_Name;
        return $this;
    }
    /**
     * Get Daily_Rate value
     * @return float|null
     */
    public function getDaily_Rate()
    {
        return $this->Daily_Rate;
    }
    /**
     * Set Daily_Rate value
     * @param float $daily_Rate
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setDaily_Rate($daily_Rate = null)
    {
        // validation for constraint: float
        if (!is_null($daily_Rate) && !(is_float($daily_Rate) || is_numeric($daily_Rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($daily_Rate, true), gettype($daily_Rate)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($daily_Rate) && mb_strlen(mb_substr($daily_Rate, false !== mb_strpos($daily_Rate, '.') ? mb_strpos($daily_Rate, '.') + 1 : mb_strlen($daily_Rate))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($daily_Rate, true), mb_strlen(mb_substr($daily_Rate, mb_strpos($daily_Rate, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($daily_Rate) && mb_strlen(preg_replace('/(\D)/', '', $daily_Rate)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($daily_Rate, true), mb_strlen(preg_replace('/(\D)/', '', $daily_Rate))), __LINE__);
        }
        $this->Daily_Rate = $daily_Rate;
        return $this;
    }
    /**
     * Get Domestic value
     * @return bool|null
     */
    public function getDomestic()
    {
        return $this->Domestic;
    }
    /**
     * Set Domestic value
     * @param bool $domestic
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setDomestic($domestic = null)
    {
        // validation for constraint: boolean
        if (!is_null($domestic) && !is_bool($domestic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($domestic, true), gettype($domestic)), __LINE__);
        }
        $this->Domestic = $domestic;
        return $this;
    }
    /**
     * Get Ticket_Number value
     * @return string|null
     */
    public function getTicket_Number()
    {
        return $this->Ticket_Number;
    }
    /**
     * Set Ticket_Number value
     * @param string $ticket_Number
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setTicket_Number($ticket_Number = null)
    {
        // validation for constraint: string
        if (!is_null($ticket_Number) && !is_string($ticket_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticket_Number, true), gettype($ticket_Number)), __LINE__);
        }
        $this->Ticket_Number = $ticket_Number;
        return $this;
    }
    /**
     * Get Class_of_Service value
     * @return string|null
     */
    public function getClass_of_Service()
    {
        return $this->Class_of_Service;
    }
    /**
     * Set Class_of_Service value
     * @param string $class_of_Service
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setClass_of_Service($class_of_Service = null)
    {
        // validation for constraint: string
        if (!is_null($class_of_Service) && !is_string($class_of_Service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($class_of_Service, true), gettype($class_of_Service)), __LINE__);
        }
        $this->Class_of_Service = $class_of_Service;
        return $this;
    }
    /**
     * Get Air_Routing value
     * @return string|null
     */
    public function getAir_Routing()
    {
        return $this->Air_Routing;
    }
    /**
     * Set Air_Routing value
     * @param string $air_Routing
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setAir_Routing($air_Routing = null)
    {
        // validation for constraint: string
        if (!is_null($air_Routing) && !is_string($air_Routing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($air_Routing, true), gettype($air_Routing)), __LINE__);
        }
        $this->Air_Routing = $air_Routing;
        return $this;
    }
    /**
     * Get Air_Carrier_Code value
     * @return string|null
     */
    public function getAir_Carrier_Code()
    {
        return $this->Air_Carrier_Code;
    }
    /**
     * Set Air_Carrier_Code value
     * @param string $air_Carrier_Code
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setAir_Carrier_Code($air_Carrier_Code = null)
    {
        // validation for constraint: string
        if (!is_null($air_Carrier_Code) && !is_string($air_Carrier_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($air_Carrier_Code, true), gettype($air_Carrier_Code)), __LINE__);
        }
        $this->Air_Carrier_Code = $air_Carrier_Code;
        return $this;
    }
    /**
     * Get Origination_City value
     * @return string|null
     */
    public function getOrigination_City()
    {
        return $this->Origination_City;
    }
    /**
     * Set Origination_City value
     * @param string $origination_City
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setOrigination_City($origination_City = null)
    {
        // validation for constraint: string
        if (!is_null($origination_City) && !is_string($origination_City)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origination_City, true), gettype($origination_City)), __LINE__);
        }
        $this->Origination_City = $origination_City;
        return $this;
    }
    /**
     * Get Origination_State value
     * @return string|null
     */
    public function getOrigination_State()
    {
        return $this->Origination_State;
    }
    /**
     * Set Origination_State value
     * @param string $origination_State
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setOrigination_State($origination_State = null)
    {
        // validation for constraint: string
        if (!is_null($origination_State) && !is_string($origination_State)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origination_State, true), gettype($origination_State)), __LINE__);
        }
        $this->Origination_State = $origination_State;
        return $this;
    }
    /**
     * Get Origination_Country value
     * @return string|null
     */
    public function getOrigination_Country()
    {
        return $this->Origination_Country;
    }
    /**
     * Set Origination_Country value
     * @param string $origination_Country
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setOrigination_Country($origination_Country = null)
    {
        // validation for constraint: string
        if (!is_null($origination_Country) && !is_string($origination_Country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origination_Country, true), gettype($origination_Country)), __LINE__);
        }
        $this->Origination_Country = $origination_Country;
        return $this;
    }
    /**
     * Get Origination_Airport_Code value
     * @return string|null
     */
    public function getOrigination_Airport_Code()
    {
        return $this->Origination_Airport_Code;
    }
    /**
     * Set Origination_Airport_Code value
     * @param string $origination_Airport_Code
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setOrigination_Airport_Code($origination_Airport_Code = null)
    {
        // validation for constraint: string
        if (!is_null($origination_Airport_Code) && !is_string($origination_Airport_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origination_Airport_Code, true), gettype($origination_Airport_Code)), __LINE__);
        }
        $this->Origination_Airport_Code = $origination_Airport_Code;
        return $this;
    }
    /**
     * Get Destination_City value
     * @return string|null
     */
    public function getDestination_City()
    {
        return $this->Destination_City;
    }
    /**
     * Set Destination_City value
     * @param string $destination_City
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setDestination_City($destination_City = null)
    {
        // validation for constraint: string
        if (!is_null($destination_City) && !is_string($destination_City)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination_City, true), gettype($destination_City)), __LINE__);
        }
        $this->Destination_City = $destination_City;
        return $this;
    }
    /**
     * Get Destination_State value
     * @return string|null
     */
    public function getDestination_State()
    {
        return $this->Destination_State;
    }
    /**
     * Set Destination_State value
     * @param string $destination_State
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setDestination_State($destination_State = null)
    {
        // validation for constraint: string
        if (!is_null($destination_State) && !is_string($destination_State)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination_State, true), gettype($destination_State)), __LINE__);
        }
        $this->Destination_State = $destination_State;
        return $this;
    }
    /**
     * Get Destination_Country value
     * @return string|null
     */
    public function getDestination_Country()
    {
        return $this->Destination_Country;
    }
    /**
     * Set Destination_Country value
     * @param string $destination_Country
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setDestination_Country($destination_Country = null)
    {
        // validation for constraint: string
        if (!is_null($destination_Country) && !is_string($destination_Country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination_Country, true), gettype($destination_Country)), __LINE__);
        }
        $this->Destination_Country = $destination_Country;
        return $this;
    }
    /**
     * Get Destination_Airport_Code value
     * @return string|null
     */
    public function getDestination_Airport_Code()
    {
        return $this->Destination_Airport_Code;
    }
    /**
     * Set Destination_Airport_Code value
     * @param string $destination_Airport_Code
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setDestination_Airport_Code($destination_Airport_Code = null)
    {
        // validation for constraint: string
        if (!is_null($destination_Airport_Code) && !is_string($destination_Airport_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destination_Airport_Code, true), gettype($destination_Airport_Code)), __LINE__);
        }
        $this->Destination_Airport_Code = $destination_Airport_Code;
        return $this;
    }
    /**
     * Get Class_of_Service_Reference value
     * @return \StructType\Class_of_ServiceObjectType|null
     */
    public function getClass_of_Service_Reference()
    {
        return $this->Class_of_Service_Reference;
    }
    /**
     * Set Class_of_Service_Reference value
     * @param \StructType\Class_of_ServiceObjectType $class_of_Service_Reference
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setClass_of_Service_Reference(\StructType\Class_of_ServiceObjectType $class_of_Service_Reference = null)
    {
        $this->Class_of_Service_Reference = $class_of_Service_Reference;
        return $this;
    }
    /**
     * Get Credit_Card_Transaction_Status_Reference value
     * @return \StructType\Expense_StatusObjectType|null
     */
    public function getCredit_Card_Transaction_Status_Reference()
    {
        return $this->Credit_Card_Transaction_Status_Reference;
    }
    /**
     * Set Credit_Card_Transaction_Status_Reference value
     * @param \StructType\Expense_StatusObjectType $credit_Card_Transaction_Status_Reference
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setCredit_Card_Transaction_Status_Reference(\StructType\Expense_StatusObjectType $credit_Card_Transaction_Status_Reference = null)
    {
        $this->Credit_Card_Transaction_Status_Reference = $credit_Card_Transaction_Status_Reference;
        return $this;
    }
    /**
     * Get Credit_Card_Transaction_Line_Data value
     * @return \StructType\CC_Transaction_LineType[]|null
     */
    public function getCredit_Card_Transaction_Line_Data()
    {
        return $this->Credit_Card_Transaction_Line_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setCredit_Card_Transaction_Line_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCredit_Card_Transaction_Line_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCredit_Card_Transaction_Line_DataForArrayConstraintsFromSetCredit_Card_Transaction_Line_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $credit_Card_Transaction_HV_DataTypeCredit_Card_Transaction_Line_DataItem) {
            // validation for constraint: itemType
            if (!$credit_Card_Transaction_HV_DataTypeCredit_Card_Transaction_Line_DataItem instanceof \StructType\CC_Transaction_LineType) {
                $invalidValues[] = is_object($credit_Card_Transaction_HV_DataTypeCredit_Card_Transaction_Line_DataItem) ? get_class($credit_Card_Transaction_HV_DataTypeCredit_Card_Transaction_Line_DataItem) : sprintf('%s(%s)', gettype($credit_Card_Transaction_HV_DataTypeCredit_Card_Transaction_Line_DataItem), var_export($credit_Card_Transaction_HV_DataTypeCredit_Card_Transaction_Line_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Credit_Card_Transaction_Line_Data property can only contain items of type \StructType\CC_Transaction_LineType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Credit_Card_Transaction_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\CC_Transaction_LineType[] $credit_Card_Transaction_Line_Data
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setCredit_Card_Transaction_Line_Data(array $credit_Card_Transaction_Line_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($credit_Card_Transaction_Line_DataArrayErrorMessage = self::validateCredit_Card_Transaction_Line_DataForArrayConstraintsFromSetCredit_Card_Transaction_Line_Data($credit_Card_Transaction_Line_Data))) {
            throw new \InvalidArgumentException($credit_Card_Transaction_Line_DataArrayErrorMessage, __LINE__);
        }
        $this->Credit_Card_Transaction_Line_Data = $credit_Card_Transaction_Line_Data;
        return $this;
    }
    /**
     * Add item to Credit_Card_Transaction_Line_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\CC_Transaction_LineType $item
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function addToCredit_Card_Transaction_Line_Data(\StructType\CC_Transaction_LineType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CC_Transaction_LineType) {
            throw new \InvalidArgumentException(sprintf('The Credit_Card_Transaction_Line_Data property can only contain items of type \StructType\CC_Transaction_LineType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Credit_Card_Transaction_Line_Data[] = $item;
        return $this;
    }
    /**
     * Get Name_Match_Data value
     * @return \StructType\Credit_Card_Transaction_Name_Match_DataType[]|null
     */
    public function getName_Match_Data()
    {
        return $this->Name_Match_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setName_Match_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setName_Match_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateName_Match_DataForArrayConstraintsFromSetName_Match_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $credit_Card_Transaction_HV_DataTypeName_Match_DataItem) {
            // validation for constraint: itemType
            if (!$credit_Card_Transaction_HV_DataTypeName_Match_DataItem instanceof \StructType\Credit_Card_Transaction_Name_Match_DataType) {
                $invalidValues[] = is_object($credit_Card_Transaction_HV_DataTypeName_Match_DataItem) ? get_class($credit_Card_Transaction_HV_DataTypeName_Match_DataItem) : sprintf('%s(%s)', gettype($credit_Card_Transaction_HV_DataTypeName_Match_DataItem), var_export($credit_Card_Transaction_HV_DataTypeName_Match_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Name_Match_Data property can only contain items of type \StructType\Credit_Card_Transaction_Name_Match_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Name_Match_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Credit_Card_Transaction_Name_Match_DataType[] $name_Match_Data
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setName_Match_Data(array $name_Match_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($name_Match_DataArrayErrorMessage = self::validateName_Match_DataForArrayConstraintsFromSetName_Match_Data($name_Match_Data))) {
            throw new \InvalidArgumentException($name_Match_DataArrayErrorMessage, __LINE__);
        }
        $this->Name_Match_Data = $name_Match_Data;
        return $this;
    }
    /**
     * Add item to Name_Match_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Credit_Card_Transaction_Name_Match_DataType $item
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function addToName_Match_Data(\StructType\Credit_Card_Transaction_Name_Match_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Credit_Card_Transaction_Name_Match_DataType) {
            throw new \InvalidArgumentException(sprintf('The Name_Match_Data property can only contain items of type \StructType\Credit_Card_Transaction_Name_Match_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Name_Match_Data[] = $item;
        return $this;
    }
    /**
     * Get Ticket_Details_Data value
     * @return \StructType\Ticket_Details_DataType[]|null
     */
    public function getTicket_Details_Data()
    {
        return $this->Ticket_Details_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setTicket_Details_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTicket_Details_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTicket_Details_DataForArrayConstraintsFromSetTicket_Details_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $credit_Card_Transaction_HV_DataTypeTicket_Details_DataItem) {
            // validation for constraint: itemType
            if (!$credit_Card_Transaction_HV_DataTypeTicket_Details_DataItem instanceof \StructType\Ticket_Details_DataType) {
                $invalidValues[] = is_object($credit_Card_Transaction_HV_DataTypeTicket_Details_DataItem) ? get_class($credit_Card_Transaction_HV_DataTypeTicket_Details_DataItem) : sprintf('%s(%s)', gettype($credit_Card_Transaction_HV_DataTypeTicket_Details_DataItem), var_export($credit_Card_Transaction_HV_DataTypeTicket_Details_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Ticket_Details_Data property can only contain items of type \StructType\Ticket_Details_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Ticket_Details_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Ticket_Details_DataType[] $ticket_Details_Data
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function setTicket_Details_Data(array $ticket_Details_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($ticket_Details_DataArrayErrorMessage = self::validateTicket_Details_DataForArrayConstraintsFromSetTicket_Details_Data($ticket_Details_Data))) {
            throw new \InvalidArgumentException($ticket_Details_DataArrayErrorMessage, __LINE__);
        }
        $this->Ticket_Details_Data = $ticket_Details_Data;
        return $this;
    }
    /**
     * Add item to Ticket_Details_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Ticket_Details_DataType $item
     * @return \StructType\Credit_Card_Transaction__HV__DataType
     */
    public function addToTicket_Details_Data(\StructType\Ticket_Details_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Ticket_Details_DataType) {
            throw new \InvalidArgumentException(sprintf('The Ticket_Details_Data property can only contain items of type \StructType\Ticket_Details_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Ticket_Details_Data[] = $item;
        return $this;
    }
}
