<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Contingent_Worker_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contingent Worker Reference element contains the specific instance set containing the requested Continget Worker. The ID is either the Lookup ID or the Workday ID (GUID).
 * @subpackage Structs
 */
class Contingent_Worker_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Contingent_Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: Contingent Worker Reference
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Contingent_WorkerObjectType[]
     */
    public $Contingent_Worker_Reference;
    /**
     * Constructor method for Contingent_Worker_Request_ReferencesType
     * @uses Contingent_Worker_Request_ReferencesType::setContingent_Worker_Reference()
     * @param \StructType\Contingent_WorkerObjectType[] $contingent_Worker_Reference
     */
    public function __construct(array $contingent_Worker_Reference = array())
    {
        $this
            ->setContingent_Worker_Reference($contingent_Worker_Reference);
    }
    /**
     * Get Contingent_Worker_Reference value
     * @return \StructType\Contingent_WorkerObjectType[]|null
     */
    public function getContingent_Worker_Reference()
    {
        return $this->Contingent_Worker_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setContingent_Worker_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContingent_Worker_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContingent_Worker_ReferenceForArrayConstraintsFromSetContingent_Worker_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contingent_Worker_Request_ReferencesTypeContingent_Worker_ReferenceItem) {
            // validation for constraint: itemType
            if (!$contingent_Worker_Request_ReferencesTypeContingent_Worker_ReferenceItem instanceof \StructType\Contingent_WorkerObjectType) {
                $invalidValues[] = is_object($contingent_Worker_Request_ReferencesTypeContingent_Worker_ReferenceItem) ? get_class($contingent_Worker_Request_ReferencesTypeContingent_Worker_ReferenceItem) : sprintf('%s(%s)', gettype($contingent_Worker_Request_ReferencesTypeContingent_Worker_ReferenceItem), var_export($contingent_Worker_Request_ReferencesTypeContingent_Worker_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Contingent_Worker_Reference property can only contain items of type \StructType\Contingent_WorkerObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Contingent_Worker_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Contingent_WorkerObjectType[] $contingent_Worker_Reference
     * @return \StructType\Contingent_Worker_Request_ReferencesType
     */
    public function setContingent_Worker_Reference(array $contingent_Worker_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($contingent_Worker_ReferenceArrayErrorMessage = self::validateContingent_Worker_ReferenceForArrayConstraintsFromSetContingent_Worker_Reference($contingent_Worker_Reference))) {
            throw new \InvalidArgumentException($contingent_Worker_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Contingent_Worker_Reference = $contingent_Worker_Reference;
        return $this;
    }
    /**
     * Add item to Contingent_Worker_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Contingent_WorkerObjectType $item
     * @return \StructType\Contingent_Worker_Request_ReferencesType
     */
    public function addToContingent_Worker_Reference(\StructType\Contingent_WorkerObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Contingent_WorkerObjectType) {
            throw new \InvalidArgumentException(sprintf('The Contingent_Worker_Reference property can only contain items of type \StructType\Contingent_WorkerObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Contingent_Worker_Reference[] = $item;
        return $this;
    }
}
