<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Card_Holder_Listing_File_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing all Card Holder Listing File data
 * @subpackage Structs
 */
class Card_Holder_Listing_File_DataType extends AbstractStructBase
{
    /**
     * The Card_Holder_Listing_File_Number
     * Meta information extracted from the WSDL
     * - documentation: Card Holder Listing File Number. This is the Card Holder Listing File unique identifier
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Card_Holder_Listing_File_Number;
    /**
     * The Card_Holder_Listing_File_Name
     * Meta information extracted from the WSDL
     * - documentation: Card Holder Listing File Name
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Card_Holder_Listing_File_Name;
    /**
     * The Card_Holder_Listing_File_Date
     * Meta information extracted from the WSDL
     * - documentation: Card Holder Listing File Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Card_Holder_Listing_File_Date;
    /**
     * The Data_Load_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Data Load Status Reference which will represent the loading status of all Expense Credit Cards for a Card Holder Listing File.
     * @var \StructType\Data_Load_StatusObjectType
     */
    public $Data_Load_Status_Reference;
    /**
     * Constructor method for Card_Holder_Listing_File_DataType
     * @uses Card_Holder_Listing_File_DataType::setCard_Holder_Listing_File_Number()
     * @uses Card_Holder_Listing_File_DataType::setCard_Holder_Listing_File_Name()
     * @uses Card_Holder_Listing_File_DataType::setCard_Holder_Listing_File_Date()
     * @uses Card_Holder_Listing_File_DataType::setData_Load_Status_Reference()
     * @param string $card_Holder_Listing_File_Number
     * @param string $card_Holder_Listing_File_Name
     * @param string $card_Holder_Listing_File_Date
     * @param \StructType\Data_Load_StatusObjectType $data_Load_Status_Reference
     */
    public function __construct($card_Holder_Listing_File_Number = null, $card_Holder_Listing_File_Name = null, $card_Holder_Listing_File_Date = null, \StructType\Data_Load_StatusObjectType $data_Load_Status_Reference = null)
    {
        $this
            ->setCard_Holder_Listing_File_Number($card_Holder_Listing_File_Number)
            ->setCard_Holder_Listing_File_Name($card_Holder_Listing_File_Name)
            ->setCard_Holder_Listing_File_Date($card_Holder_Listing_File_Date)
            ->setData_Load_Status_Reference($data_Load_Status_Reference);
    }
    /**
     * Get Card_Holder_Listing_File_Number value
     * @return string|null
     */
    public function getCard_Holder_Listing_File_Number()
    {
        return $this->Card_Holder_Listing_File_Number;
    }
    /**
     * Set Card_Holder_Listing_File_Number value
     * @param string $card_Holder_Listing_File_Number
     * @return \StructType\Card_Holder_Listing_File_DataType
     */
    public function setCard_Holder_Listing_File_Number($card_Holder_Listing_File_Number = null)
    {
        // validation for constraint: string
        if (!is_null($card_Holder_Listing_File_Number) && !is_string($card_Holder_Listing_File_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($card_Holder_Listing_File_Number, true), gettype($card_Holder_Listing_File_Number)), __LINE__);
        }
        $this->Card_Holder_Listing_File_Number = $card_Holder_Listing_File_Number;
        return $this;
    }
    /**
     * Get Card_Holder_Listing_File_Name value
     * @return string|null
     */
    public function getCard_Holder_Listing_File_Name()
    {
        return $this->Card_Holder_Listing_File_Name;
    }
    /**
     * Set Card_Holder_Listing_File_Name value
     * @param string $card_Holder_Listing_File_Name
     * @return \StructType\Card_Holder_Listing_File_DataType
     */
    public function setCard_Holder_Listing_File_Name($card_Holder_Listing_File_Name = null)
    {
        // validation for constraint: string
        if (!is_null($card_Holder_Listing_File_Name) && !is_string($card_Holder_Listing_File_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($card_Holder_Listing_File_Name, true), gettype($card_Holder_Listing_File_Name)), __LINE__);
        }
        $this->Card_Holder_Listing_File_Name = $card_Holder_Listing_File_Name;
        return $this;
    }
    /**
     * Get Card_Holder_Listing_File_Date value
     * @return string|null
     */
    public function getCard_Holder_Listing_File_Date()
    {
        return $this->Card_Holder_Listing_File_Date;
    }
    /**
     * Set Card_Holder_Listing_File_Date value
     * @param string $card_Holder_Listing_File_Date
     * @return \StructType\Card_Holder_Listing_File_DataType
     */
    public function setCard_Holder_Listing_File_Date($card_Holder_Listing_File_Date = null)
    {
        // validation for constraint: string
        if (!is_null($card_Holder_Listing_File_Date) && !is_string($card_Holder_Listing_File_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($card_Holder_Listing_File_Date, true), gettype($card_Holder_Listing_File_Date)), __LINE__);
        }
        $this->Card_Holder_Listing_File_Date = $card_Holder_Listing_File_Date;
        return $this;
    }
    /**
     * Get Data_Load_Status_Reference value
     * @return \StructType\Data_Load_StatusObjectType|null
     */
    public function getData_Load_Status_Reference()
    {
        return $this->Data_Load_Status_Reference;
    }
    /**
     * Set Data_Load_Status_Reference value
     * @param \StructType\Data_Load_StatusObjectType $data_Load_Status_Reference
     * @return \StructType\Card_Holder_Listing_File_DataType
     */
    public function setData_Load_Status_Reference(\StructType\Data_Load_StatusObjectType $data_Load_Status_Reference = null)
    {
        $this->Data_Load_Status_Reference = $data_Load_Status_Reference;
        return $this;
    }
}
