<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Project_Task_Resources_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Root element for the Request on the Put operation.
 * @subpackage Structs
 */
class Put_Project_Task_Resources_RequestType extends AbstractStructBase
{
    /**
     * The Project_Reference
     * Meta information extracted from the WSDL
     * - documentation: Project Reference related to which Project Task Resources should be processed by the wws
     * - minOccurs: 0
     * @var \StructType\ProjectObjectType
     */
    public $Project_Reference;
    /**
     * The Project_Task_Resources_Data
     * Meta information extracted from the WSDL
     * - documentation: Wrapper Element for Put Task Resource Line Data Element
     * - minOccurs: 0
     * @var \StructType\Project_Task_Resources_DataType
     */
    public $Project_Task_Resources_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Project_Task_Resources_RequestType
     * @uses Put_Project_Task_Resources_RequestType::setProject_Reference()
     * @uses Put_Project_Task_Resources_RequestType::setProject_Task_Resources_Data()
     * @uses Put_Project_Task_Resources_RequestType::setVersion()
     * @param \StructType\ProjectObjectType $project_Reference
     * @param \StructType\Project_Task_Resources_DataType $project_Task_Resources_Data
     * @param string $version
     */
    public function __construct(\StructType\ProjectObjectType $project_Reference = null, \StructType\Project_Task_Resources_DataType $project_Task_Resources_Data = null, $version = null)
    {
        $this
            ->setProject_Reference($project_Reference)
            ->setProject_Task_Resources_Data($project_Task_Resources_Data)
            ->setVersion($version);
    }
    /**
     * Get Project_Reference value
     * @return \StructType\ProjectObjectType|null
     */
    public function getProject_Reference()
    {
        return $this->Project_Reference;
    }
    /**
     * Set Project_Reference value
     * @param \StructType\ProjectObjectType $project_Reference
     * @return \StructType\Put_Project_Task_Resources_RequestType
     */
    public function setProject_Reference(\StructType\ProjectObjectType $project_Reference = null)
    {
        $this->Project_Reference = $project_Reference;
        return $this;
    }
    /**
     * Get Project_Task_Resources_Data value
     * @return \StructType\Project_Task_Resources_DataType|null
     */
    public function getProject_Task_Resources_Data()
    {
        return $this->Project_Task_Resources_Data;
    }
    /**
     * Set Project_Task_Resources_Data value
     * @param \StructType\Project_Task_Resources_DataType $project_Task_Resources_Data
     * @return \StructType\Put_Project_Task_Resources_RequestType
     */
    public function setProject_Task_Resources_Data(\StructType\Project_Task_Resources_DataType $project_Task_Resources_Data = null)
    {
        $this->Project_Task_Resources_Data = $project_Task_Resources_Data;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Project_Task_Resources_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
