<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OCR_Supplier_Invoice_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing all OCR Supplier Invoice data
 * @subpackage Structs
 */
class OCR_Supplier_Invoice_DataType extends AbstractStructBase
{
    /**
     * The Received_Date
     * Meta information extracted from the WSDL
     * - documentation: Field to store the Invoice Received Date value
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Received_Date;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: This is the company that tranasction is for. This is the reference id value of the company.
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Assignee_Reference
     * Meta information extracted from the WSDL
     * - documentation: Assignee for OCR Supplier Invoice.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Assignee_Reference;
    /**
     * The Urgent
     * Meta information extracted from the WSDL
     * - documentation: If set to 'True', this OCR Supplier Invoice will be prioritized for scanning.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Urgent;
    /**
     * The Attachment_Reference
     * Meta information extracted from the WSDL
     * - documentation: Attachment Data
     * @var \StructType\Financials_Attachment_DataType
     */
    public $Attachment_Reference;
    /**
     * The External_Supplier_Invoice_Source_Reference
     * Meta information extracted from the WSDL
     * - documentation: The External Supplier Invoice Source. Defaults to Web Service, but you can override it.
     * - minOccurs: 0
     * @var \StructType\External_Transaction_Source__All_ObjectType
     */
    public $External_Supplier_Invoice_Source_Reference;
    /**
     * The Work_Queue_Notes
     * Meta information extracted from the WSDL
     * - documentation: Work queue notes for the ocr supplier invoice
     * - base: xsd:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Work_Queue_Notes;
    /**
     * The Additional_Fields_Data
     * Meta information extracted from the WSDL
     * - documentation: Specify a unique Configurable Attribute Reference. You can't use the same Configurable Attribute Reference more than once. | Encapsulating element containing additional fields data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Configurable_Attributes_DataType[]
     */
    public $Additional_Fields_Data;
    /**
     * Constructor method for OCR_Supplier_Invoice_DataType
     * @uses OCR_Supplier_Invoice_DataType::setReceived_Date()
     * @uses OCR_Supplier_Invoice_DataType::setCompany_Reference()
     * @uses OCR_Supplier_Invoice_DataType::setAssignee_Reference()
     * @uses OCR_Supplier_Invoice_DataType::setUrgent()
     * @uses OCR_Supplier_Invoice_DataType::setAttachment_Reference()
     * @uses OCR_Supplier_Invoice_DataType::setExternal_Supplier_Invoice_Source_Reference()
     * @uses OCR_Supplier_Invoice_DataType::setWork_Queue_Notes()
     * @uses OCR_Supplier_Invoice_DataType::setAdditional_Fields_Data()
     * @param string $received_Date
     * @param \StructType\CompanyObjectType $company_Reference
     * @param \StructType\WorkerObjectType $assignee_Reference
     * @param bool $urgent
     * @param \StructType\Financials_Attachment_DataType $attachment_Reference
     * @param \StructType\External_Transaction_Source__All_ObjectType $external_Supplier_Invoice_Source_Reference
     * @param string $work_Queue_Notes
     * @param \StructType\Configurable_Attributes_DataType[] $additional_Fields_Data
     */
    public function __construct($received_Date = null, \StructType\CompanyObjectType $company_Reference = null, \StructType\WorkerObjectType $assignee_Reference = null, $urgent = null, \StructType\Financials_Attachment_DataType $attachment_Reference = null, \StructType\External_Transaction_Source__All_ObjectType $external_Supplier_Invoice_Source_Reference = null, $work_Queue_Notes = null, array $additional_Fields_Data = array())
    {
        $this
            ->setReceived_Date($received_Date)
            ->setCompany_Reference($company_Reference)
            ->setAssignee_Reference($assignee_Reference)
            ->setUrgent($urgent)
            ->setAttachment_Reference($attachment_Reference)
            ->setExternal_Supplier_Invoice_Source_Reference($external_Supplier_Invoice_Source_Reference)
            ->setWork_Queue_Notes($work_Queue_Notes)
            ->setAdditional_Fields_Data($additional_Fields_Data);
    }
    /**
     * Get Received_Date value
     * @return string|null
     */
    public function getReceived_Date()
    {
        return $this->Received_Date;
    }
    /**
     * Set Received_Date value
     * @param string $received_Date
     * @return \StructType\OCR_Supplier_Invoice_DataType
     */
    public function setReceived_Date($received_Date = null)
    {
        // validation for constraint: string
        if (!is_null($received_Date) && !is_string($received_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($received_Date, true), gettype($received_Date)), __LINE__);
        }
        $this->Received_Date = $received_Date;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\OCR_Supplier_Invoice_DataType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Assignee_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getAssignee_Reference()
    {
        return $this->Assignee_Reference;
    }
    /**
     * Set Assignee_Reference value
     * @param \StructType\WorkerObjectType $assignee_Reference
     * @return \StructType\OCR_Supplier_Invoice_DataType
     */
    public function setAssignee_Reference(\StructType\WorkerObjectType $assignee_Reference = null)
    {
        $this->Assignee_Reference = $assignee_Reference;
        return $this;
    }
    /**
     * Get Urgent value
     * @return bool|null
     */
    public function getUrgent()
    {
        return $this->Urgent;
    }
    /**
     * Set Urgent value
     * @param bool $urgent
     * @return \StructType\OCR_Supplier_Invoice_DataType
     */
    public function setUrgent($urgent = null)
    {
        // validation for constraint: boolean
        if (!is_null($urgent) && !is_bool($urgent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($urgent, true), gettype($urgent)), __LINE__);
        }
        $this->Urgent = $urgent;
        return $this;
    }
    /**
     * Get Attachment_Reference value
     * @return \StructType\Financials_Attachment_DataType|null
     */
    public function getAttachment_Reference()
    {
        return $this->Attachment_Reference;
    }
    /**
     * Set Attachment_Reference value
     * @param \StructType\Financials_Attachment_DataType $attachment_Reference
     * @return \StructType\OCR_Supplier_Invoice_DataType
     */
    public function setAttachment_Reference(\StructType\Financials_Attachment_DataType $attachment_Reference = null)
    {
        $this->Attachment_Reference = $attachment_Reference;
        return $this;
    }
    /**
     * Get External_Supplier_Invoice_Source_Reference value
     * @return \StructType\External_Transaction_Source__All_ObjectType|null
     */
    public function getExternal_Supplier_Invoice_Source_Reference()
    {
        return $this->External_Supplier_Invoice_Source_Reference;
    }
    /**
     * Set External_Supplier_Invoice_Source_Reference value
     * @param \StructType\External_Transaction_Source__All_ObjectType $external_Supplier_Invoice_Source_Reference
     * @return \StructType\OCR_Supplier_Invoice_DataType
     */
    public function setExternal_Supplier_Invoice_Source_Reference(\StructType\External_Transaction_Source__All_ObjectType $external_Supplier_Invoice_Source_Reference = null)
    {
        $this->External_Supplier_Invoice_Source_Reference = $external_Supplier_Invoice_Source_Reference;
        return $this;
    }
    /**
     * Get Work_Queue_Notes value
     * @return string|null
     */
    public function getWork_Queue_Notes()
    {
        return $this->Work_Queue_Notes;
    }
    /**
     * Set Work_Queue_Notes value
     * @param string $work_Queue_Notes
     * @return \StructType\OCR_Supplier_Invoice_DataType
     */
    public function setWork_Queue_Notes($work_Queue_Notes = null)
    {
        // validation for constraint: string
        if (!is_null($work_Queue_Notes) && !is_string($work_Queue_Notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($work_Queue_Notes, true), gettype($work_Queue_Notes)), __LINE__);
        }
        $this->Work_Queue_Notes = $work_Queue_Notes;
        return $this;
    }
    /**
     * Get Additional_Fields_Data value
     * @return \StructType\Configurable_Attributes_DataType[]|null
     */
    public function getAdditional_Fields_Data()
    {
        return $this->Additional_Fields_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditional_Fields_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditional_Fields_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditional_Fields_DataForArrayConstraintsFromSetAdditional_Fields_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $oCR_Supplier_Invoice_DataTypeAdditional_Fields_DataItem) {
            // validation for constraint: itemType
            if (!$oCR_Supplier_Invoice_DataTypeAdditional_Fields_DataItem instanceof \StructType\Configurable_Attributes_DataType) {
                $invalidValues[] = is_object($oCR_Supplier_Invoice_DataTypeAdditional_Fields_DataItem) ? get_class($oCR_Supplier_Invoice_DataTypeAdditional_Fields_DataItem) : sprintf('%s(%s)', gettype($oCR_Supplier_Invoice_DataTypeAdditional_Fields_DataItem), var_export($oCR_Supplier_Invoice_DataTypeAdditional_Fields_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Additional_Fields_Data property can only contain items of type \StructType\Configurable_Attributes_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Additional_Fields_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Configurable_Attributes_DataType[] $additional_Fields_Data
     * @return \StructType\OCR_Supplier_Invoice_DataType
     */
    public function setAdditional_Fields_Data(array $additional_Fields_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($additional_Fields_DataArrayErrorMessage = self::validateAdditional_Fields_DataForArrayConstraintsFromSetAdditional_Fields_Data($additional_Fields_Data))) {
            throw new \InvalidArgumentException($additional_Fields_DataArrayErrorMessage, __LINE__);
        }
        $this->Additional_Fields_Data = $additional_Fields_Data;
        return $this;
    }
    /**
     * Add item to Additional_Fields_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Configurable_Attributes_DataType $item
     * @return \StructType\OCR_Supplier_Invoice_DataType
     */
    public function addToAdditional_Fields_Data(\StructType\Configurable_Attributes_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Configurable_Attributes_DataType) {
            throw new \InvalidArgumentException(sprintf('The Additional_Fields_Data property can only contain items of type \StructType\Configurable_Attributes_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Additional_Fields_Data[] = $item;
        return $this;
    }
}
