<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Item_Tag_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: The response data for the item tag.
 * @subpackage Structs
 */
class Item_Tag_Response_DataType extends AbstractStructBase
{
    /**
     * The Item_Tag
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Item_TagType[]
     */
    public $Item_Tag;
    /**
     * Constructor method for Item_Tag_Response_DataType
     * @uses Item_Tag_Response_DataType::setItem_Tag()
     * @param \StructType\Item_TagType[] $item_Tag
     */
    public function __construct(array $item_Tag = array())
    {
        $this
            ->setItem_Tag($item_Tag);
    }
    /**
     * Get Item_Tag value
     * @return \StructType\Item_TagType[]|null
     */
    public function getItem_Tag()
    {
        return $this->Item_Tag;
    }
    /**
     * This method is responsible for validating the values passed to the setItem_Tag method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem_Tag method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItem_TagForArrayConstraintsFromSetItem_Tag(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $item_Tag_Response_DataTypeItem_TagItem) {
            // validation for constraint: itemType
            if (!$item_Tag_Response_DataTypeItem_TagItem instanceof \StructType\Item_TagType) {
                $invalidValues[] = is_object($item_Tag_Response_DataTypeItem_TagItem) ? get_class($item_Tag_Response_DataTypeItem_TagItem) : sprintf('%s(%s)', gettype($item_Tag_Response_DataTypeItem_TagItem), var_export($item_Tag_Response_DataTypeItem_TagItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item_Tag property can only contain items of type \StructType\Item_TagType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item_Tag value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_TagType[] $item_Tag
     * @return \StructType\Item_Tag_Response_DataType
     */
    public function setItem_Tag(array $item_Tag = array())
    {
        // validation for constraint: array
        if ('' !== ($item_TagArrayErrorMessage = self::validateItem_TagForArrayConstraintsFromSetItem_Tag($item_Tag))) {
            throw new \InvalidArgumentException($item_TagArrayErrorMessage, __LINE__);
        }
        $this->Item_Tag = $item_Tag;
        return $this;
    }
    /**
     * Add item to Item_Tag value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_TagType $item
     * @return \StructType\Item_Tag_Response_DataType
     */
    public function addToItem_Tag(\StructType\Item_TagType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Item_TagType) {
            throw new \InvalidArgumentException(sprintf('The Item_Tag property can only contain items of type \StructType\Item_TagType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item_Tag[] = $item;
        return $this;
    }
}
