<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Cancel_Requisition_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Cancel Requisition Request
 * @subpackage Structs
 */
class Cancel_Requisition_RequestType extends AbstractStructBase
{
    /**
     * The Requisition_to_Cancel_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference of Requisition to be Canceled.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RequisitionObjectType[]
     */
    public $Requisition_to_Cancel_Reference;
    /**
     * The Reason_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference of Reason Code for Requisition to be Canceled.
     * - minOccurs: 0
     * @var \StructType\Reason_CodeObjectType
     */
    public $Reason_Code_Reference;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - documentation: Comments for Requisition to be Canceled.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comments;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Cancel_Requisition_RequestType
     * @uses Cancel_Requisition_RequestType::setRequisition_to_Cancel_Reference()
     * @uses Cancel_Requisition_RequestType::setReason_Code_Reference()
     * @uses Cancel_Requisition_RequestType::setComments()
     * @uses Cancel_Requisition_RequestType::setVersion()
     * @param \StructType\RequisitionObjectType[] $requisition_to_Cancel_Reference
     * @param \StructType\Reason_CodeObjectType $reason_Code_Reference
     * @param string $comments
     * @param string $version
     */
    public function __construct(array $requisition_to_Cancel_Reference = array(), \StructType\Reason_CodeObjectType $reason_Code_Reference = null, $comments = null, $version = null)
    {
        $this
            ->setRequisition_to_Cancel_Reference($requisition_to_Cancel_Reference)
            ->setReason_Code_Reference($reason_Code_Reference)
            ->setComments($comments)
            ->setVersion($version);
    }
    /**
     * Get Requisition_to_Cancel_Reference value
     * @return \StructType\RequisitionObjectType[]|null
     */
    public function getRequisition_to_Cancel_Reference()
    {
        return $this->Requisition_to_Cancel_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRequisition_to_Cancel_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequisition_to_Cancel_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequisition_to_Cancel_ReferenceForArrayConstraintsFromSetRequisition_to_Cancel_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cancel_Requisition_RequestTypeRequisition_to_Cancel_ReferenceItem) {
            // validation for constraint: itemType
            if (!$cancel_Requisition_RequestTypeRequisition_to_Cancel_ReferenceItem instanceof \StructType\RequisitionObjectType) {
                $invalidValues[] = is_object($cancel_Requisition_RequestTypeRequisition_to_Cancel_ReferenceItem) ? get_class($cancel_Requisition_RequestTypeRequisition_to_Cancel_ReferenceItem) : sprintf('%s(%s)', gettype($cancel_Requisition_RequestTypeRequisition_to_Cancel_ReferenceItem), var_export($cancel_Requisition_RequestTypeRequisition_to_Cancel_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Requisition_to_Cancel_Reference property can only contain items of type \StructType\RequisitionObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Requisition_to_Cancel_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\RequisitionObjectType[] $requisition_to_Cancel_Reference
     * @return \StructType\Cancel_Requisition_RequestType
     */
    public function setRequisition_to_Cancel_Reference(array $requisition_to_Cancel_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($requisition_to_Cancel_ReferenceArrayErrorMessage = self::validateRequisition_to_Cancel_ReferenceForArrayConstraintsFromSetRequisition_to_Cancel_Reference($requisition_to_Cancel_Reference))) {
            throw new \InvalidArgumentException($requisition_to_Cancel_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Requisition_to_Cancel_Reference = $requisition_to_Cancel_Reference;
        return $this;
    }
    /**
     * Add item to Requisition_to_Cancel_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\RequisitionObjectType $item
     * @return \StructType\Cancel_Requisition_RequestType
     */
    public function addToRequisition_to_Cancel_Reference(\StructType\RequisitionObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RequisitionObjectType) {
            throw new \InvalidArgumentException(sprintf('The Requisition_to_Cancel_Reference property can only contain items of type \StructType\RequisitionObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Requisition_to_Cancel_Reference[] = $item;
        return $this;
    }
    /**
     * Get Reason_Code_Reference value
     * @return \StructType\Reason_CodeObjectType|null
     */
    public function getReason_Code_Reference()
    {
        return $this->Reason_Code_Reference;
    }
    /**
     * Set Reason_Code_Reference value
     * @param \StructType\Reason_CodeObjectType $reason_Code_Reference
     * @return \StructType\Cancel_Requisition_RequestType
     */
    public function setReason_Code_Reference(\StructType\Reason_CodeObjectType $reason_Code_Reference = null)
    {
        $this->Reason_Code_Reference = $reason_Code_Reference;
        return $this;
    }
    /**
     * Get Comments value
     * @return string|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param string $comments
     * @return \StructType\Cancel_Requisition_RequestType
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comments, true), gettype($comments)), __LINE__);
        }
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Cancel_Requisition_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
