<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Request_for_Quote_Response_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that contains criteria to search for RFQ Response Documents
 * @subpackage Structs
 */
class Request_for_Quote_Response_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company Reference
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType[]
     */
    public $Company_Reference;
    /**
     * The RFQ_Reference
     * Meta information extracted from the WSDL
     * - documentation: Request for Quote Reference to query RFQ Responses.
     * - minOccurs: 0
     * @var \StructType\Request_for_QuoteObjectType
     */
    public $RFQ_Reference;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Reference
     * - minOccurs: 0
     * @var \StructType\Abstract_Request_for_Quote_ParticipantObjectType
     */
    public $Supplier_Reference;
    /**
     * The Response_Date_On_or_After
     * Meta information extracted from the WSDL
     * - documentation: Response Date On or After
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Response_Date_On_or_After;
    /**
     * The Response_Date_On_or_Before
     * Meta information extracted from the WSDL
     * - documentation: Response Date On or Before
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Response_Date_On_or_Before;
    /**
     * The RFQ_Response_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: RFQ Response Status Reference
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $RFQ_Response_Status_Reference;
    /**
     * Constructor method for Request_for_Quote_Response_Request_CriteriaType
     * @uses Request_for_Quote_Response_Request_CriteriaType::setCompany_Reference()
     * @uses Request_for_Quote_Response_Request_CriteriaType::setRFQ_Reference()
     * @uses Request_for_Quote_Response_Request_CriteriaType::setSupplier_Reference()
     * @uses Request_for_Quote_Response_Request_CriteriaType::setResponse_Date_On_or_After()
     * @uses Request_for_Quote_Response_Request_CriteriaType::setResponse_Date_On_or_Before()
     * @uses Request_for_Quote_Response_Request_CriteriaType::setRFQ_Response_Status_Reference()
     * @param \StructType\CompanyObjectType[] $company_Reference
     * @param \StructType\Request_for_QuoteObjectType $rFQ_Reference
     * @param \StructType\Abstract_Request_for_Quote_ParticipantObjectType $supplier_Reference
     * @param string $response_Date_On_or_After
     * @param string $response_Date_On_or_Before
     * @param \StructType\Document_StatusObjectType $rFQ_Response_Status_Reference
     */
    public function __construct(array $company_Reference = array(), \StructType\Request_for_QuoteObjectType $rFQ_Reference = null, \StructType\Abstract_Request_for_Quote_ParticipantObjectType $supplier_Reference = null, $response_Date_On_or_After = null, $response_Date_On_or_Before = null, \StructType\Document_StatusObjectType $rFQ_Response_Status_Reference = null)
    {
        $this
            ->setCompany_Reference($company_Reference)
            ->setRFQ_Reference($rFQ_Reference)
            ->setSupplier_Reference($supplier_Reference)
            ->setResponse_Date_On_or_After($response_Date_On_or_After)
            ->setResponse_Date_On_or_Before($response_Date_On_or_Before)
            ->setRFQ_Response_Status_Reference($rFQ_Response_Status_Reference);
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType[]|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCompany_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $request_for_Quote_Response_Request_CriteriaTypeCompany_ReferenceItem) {
            // validation for constraint: itemType
            if (!$request_for_Quote_Response_Request_CriteriaTypeCompany_ReferenceItem instanceof \StructType\CompanyObjectType) {
                $invalidValues[] = is_object($request_for_Quote_Response_Request_CriteriaTypeCompany_ReferenceItem) ? get_class($request_for_Quote_Response_Request_CriteriaTypeCompany_ReferenceItem) : sprintf('%s(%s)', gettype($request_for_Quote_Response_Request_CriteriaTypeCompany_ReferenceItem), var_export($request_for_Quote_Response_Request_CriteriaTypeCompany_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Company_Reference property can only contain items of type \StructType\CompanyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyObjectType[] $company_Reference
     * @return \StructType\Request_for_Quote_Response_Request_CriteriaType
     */
    public function setCompany_Reference(array $company_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($company_ReferenceArrayErrorMessage = self::validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference($company_Reference))) {
            throw new \InvalidArgumentException($company_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Add item to Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyObjectType $item
     * @return \StructType\Request_for_Quote_Response_Request_CriteriaType
     */
    public function addToCompany_Reference(\StructType\CompanyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CompanyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Company_Reference property can only contain items of type \StructType\CompanyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Company_Reference[] = $item;
        return $this;
    }
    /**
     * Get RFQ_Reference value
     * @return \StructType\Request_for_QuoteObjectType|null
     */
    public function getRFQ_Reference()
    {
        return $this->RFQ_Reference;
    }
    /**
     * Set RFQ_Reference value
     * @param \StructType\Request_for_QuoteObjectType $rFQ_Reference
     * @return \StructType\Request_for_Quote_Response_Request_CriteriaType
     */
    public function setRFQ_Reference(\StructType\Request_for_QuoteObjectType $rFQ_Reference = null)
    {
        $this->RFQ_Reference = $rFQ_Reference;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Abstract_Request_for_Quote_ParticipantObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\Abstract_Request_for_Quote_ParticipantObjectType $supplier_Reference
     * @return \StructType\Request_for_Quote_Response_Request_CriteriaType
     */
    public function setSupplier_Reference(\StructType\Abstract_Request_for_Quote_ParticipantObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get Response_Date_On_or_After value
     * @return string|null
     */
    public function getResponse_Date_On_or_After()
    {
        return $this->Response_Date_On_or_After;
    }
    /**
     * Set Response_Date_On_or_After value
     * @param string $response_Date_On_or_After
     * @return \StructType\Request_for_Quote_Response_Request_CriteriaType
     */
    public function setResponse_Date_On_or_After($response_Date_On_or_After = null)
    {
        // validation for constraint: string
        if (!is_null($response_Date_On_or_After) && !is_string($response_Date_On_or_After)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($response_Date_On_or_After, true), gettype($response_Date_On_or_After)), __LINE__);
        }
        $this->Response_Date_On_or_After = $response_Date_On_or_After;
        return $this;
    }
    /**
     * Get Response_Date_On_or_Before value
     * @return string|null
     */
    public function getResponse_Date_On_or_Before()
    {
        return $this->Response_Date_On_or_Before;
    }
    /**
     * Set Response_Date_On_or_Before value
     * @param string $response_Date_On_or_Before
     * @return \StructType\Request_for_Quote_Response_Request_CriteriaType
     */
    public function setResponse_Date_On_or_Before($response_Date_On_or_Before = null)
    {
        // validation for constraint: string
        if (!is_null($response_Date_On_or_Before) && !is_string($response_Date_On_or_Before)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($response_Date_On_or_Before, true), gettype($response_Date_On_or_Before)), __LINE__);
        }
        $this->Response_Date_On_or_Before = $response_Date_On_or_Before;
        return $this;
    }
    /**
     * Get RFQ_Response_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getRFQ_Response_Status_Reference()
    {
        return $this->RFQ_Response_Status_Reference;
    }
    /**
     * Set RFQ_Response_Status_Reference value
     * @param \StructType\Document_StatusObjectType $rFQ_Response_Status_Reference
     * @return \StructType\Request_for_Quote_Response_Request_CriteriaType
     */
    public function setRFQ_Response_Status_Reference(\StructType\Document_StatusObjectType $rFQ_Response_Status_Reference = null)
    {
        $this->RFQ_Response_Status_Reference = $rFQ_Response_Status_Reference;
        return $this;
    }
}
