<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Item_Request_Line_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Remove the line, or select a different item or inventory site. You can't add items that are restricted from purchasing or inactive for the inventory site. | Only the issue Unit of Measure is valid. | Supplier Item Identifiers cannot
 * be set or updated for lines with no items or having non-catalog items. Catalog Items also have Supplier Item Identifiers, but we cannot change the existing value using this web service. For this web service, Web items will not trigger this
 * validation, but any entered Supplier Item Identifier will be ignored and the original value from the web item will be kept. | The field Tax Applicability is required and must have a value. | For stock items, only the Ordering, Base or Stocking Unit
 * of Measure is valid. | Only the purchase item unit of measure on the supplier contract line is valid. | Unit of measure is required on item lines. | Quantity must be greater than zero and cannot be partial when the document line's spend category is
 * Tracked (unless related to a supplier contract line). | Can not have any combination of Project, Project Phase or Project Task worktags for the same line. | Only one worktag for each type is allowed for each document line. | Please specify an Item or
 * a Spend Category. | Quantity cannot be negative | Element containing all Goods Requisition Line data. A Requisition may have multiple goods requisition lines.
 * @subpackage Structs
 */
class Item_Request_Line_DataType extends AbstractStructBase
{
    /**
     * The Requisition_Goods_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference of an existing Goods Requisition Line
     * - minOccurs: 0
     * @var \StructType\Item_Requisition_LineObjectType
     */
    public $Requisition_Goods_Line_Reference;
    /**
     * The Goods_Requisition_Line_ID
     * Meta information extracted from the WSDL
     * - documentation: Reference ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Goods_Requisition_Line_ID;
    /**
     * The Line_Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: The company at the line level that has an intercompany relationship with the company at the header level.
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Line_Company_Reference;
    /**
     * The Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference of an Item on the Requisition.
     * - minOccurs: 0
     * @var \StructType\Procurement_ItemObjectType
     */
    public $Item_Reference;
    /**
     * The Supplier_Item_Identifier
     * Meta information extracted from the WSDL
     * - documentation: The supplier item identifier for a Requisition Goods Line
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Item_Identifier;
    /**
     * The Item_Description
     * Meta information extracted from the WSDL
     * - documentation: An optional description of the item, especially useful if only a Spend Category is selected for this line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Item_Description;
    /**
     * The Commodity_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: The commodity code on spend transactions lines. This is a standard code that identifies a type of good or service you order. For example, the United Nations Standard Products and Services Code (UNSPSC) or the National Institute for
     * Governmental Purchasing (NIGP) code. For purchase items and catalog items, you can only submit active commodity codes already associated to the item. For ad hoc based lines, you can submit any active commodity code.
     * - minOccurs: 0
     * @var \StructType\Commodity_CodeObjectType
     */
    public $Commodity_Code_Reference;
    /**
     * The Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Spend Category must match the Spend Category for the Procurement Item. | Reference to the Spend Category. The Spend Category will default from the Purchase Item if the item is specified. This Spend Category must match the Spend
     * Category for the Purchase Item.
     * - minOccurs: 0
     * @var \StructType\Spend_CategoryObjectType
     */
    public $Spend_Category_Reference;
    /**
     * The Fulfillment_Source_Reference
     * Meta information extracted from the WSDL
     * - documentation: References to Fulfillment source on Requisition goods Line.
     * - minOccurs: 0
     * @var \StructType\Requisition_SourceObjectType
     */
    public $Fulfillment_Source_Reference;
    /**
     * The Inventory_Site_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: Inventory Site Location for the Requisition Line
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Inventory_Site_Location_Reference;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: Identifies the supplier on the requisition line. While the Create Requisition task sometimes populates a supplier automatically when you don't select one, this operation does not populate a value automatically.
     * - minOccurs: 0
     * @var \StructType\Resource_ProviderObjectType
     */
    public $Supplier_Reference;
    /**
     * The Order_From_Connection_Reference
     * Meta information extracted from the WSDL
     * - documentation: Identifies the order-from supplier connection on the requisition line. While the Create Requisition task sometimes populates an order-from supplier connection automatically when you don't select one, this operation does not populate
     * a value automatically.
     * - minOccurs: 0
     * @var \StructType\Order_From_Supplier_ConnectionObjectType
     */
    public $Order_From_Connection_Reference;
    /**
     * The Supplier_Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: Identifies the supplier contract on the requisition line. While the Create Requisition task sometimes populates a supplier contract automatically when you don't select one, this operation does not populate a value automatically.
     * - minOccurs: 0
     * @var \StructType\Supplier_ContractObjectType
     */
    public $Supplier_Contract_Reference;
    /**
     * The Tax_Applicability_Reference
     * Meta information extracted from the WSDL
     * - documentation: Tax Applicability Reference is required is Tax Code is specified. | Reference to the Tax Applicability for the Purchase Item. If the item has Tax Code defined, then the Tax Applicability is required.
     * - minOccurs: 0
     * @var \StructType\Tax_ApplicabilityObjectType
     */
    public $Tax_Applicability_Reference;
    /**
     * The Tax_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Tax Code for the Purchase Item. The Tax Code is defaulted from the Requisition Data element if one is specified.
     * - minOccurs: 0
     * @var \StructType\Tax_CodeObjectType
     */
    public $Tax_Code_Reference;
    /**
     * The Tax_Rate_Recoverabilities_Data
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Tax Rate Recoverabilities for the Tax Code. Tax Recoverability required for each Tax Rate in the Tax Code, otherwise defaulted.
     * - minOccurs: 0
     * @var \StructType\Tax_Rate_Options_DataType
     */
    public $Tax_Rate_Recoverabilities_Data;
    /**
     * The Packaging_String
     * Meta information extracted from the WSDL
     * - documentation: Packaging String associated with the Item specified on the Line. This information is for outbound purposes only and is not processed on inbound Workday Web Services requests.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Packaging_String;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: The quantity of the Purchase Item ordered. Quantity will be defaulted to 1 if left blank. | Quantity for the expense report line. Leave blank if you are entering a credit card transaction. | Quantity to receive | Number of units to
     * assign. | Quantity for the Spend Authorization Line | You must enter a Quantity when Line Split Allocation Reference is Split by Quantity. | Quantity must be empty when Line Split Allocation Reference is Split by Amount. | The number of units |
     * Quantity. If you supply this value as an override, you must also enable the Override Line flag. | Although Supplier Invoice Schedules may distribute installments by Amount or Quantity, Purchase Order Schedules always distribute by Quantity. |
     * Quantity of the asset component. | Quantity Returned | If this is blank, Workday will automatically calculate quantity from unit cost and extended amount. But if the line references either a Purchase Order or Contract Line, the quantity must be blank
     * and extended amount will not be calculated. | Quantity on Request for Quote Line. | The quantity for the split line. This is optional and should be absent when we split by amount. | Quantity on Award Line Split. | The quantity of the Purchase Item
     * ordered. For new line, quantity will be defaulted to 1 if left blank. | The quantity for the split line. This is optional and should be absent when splitting by amount. | Quantity on the Internal Service Delivery Line. | The quantity for the split
     * line. This is optional and will not be populated when the Internal Service Delivery Line is split by amount. | Quantity on the Internal Service Delivery Line. If the Internal Service Delivery Line references a Catalog Item, then Quantity cannot be
     * blank. | Quantity on the Internal Service Delivery Line Split. This is optional and must not be included when the Internal Service Delivery Line is split by Amount. | Quantity on the Supplier Invoice Request Line | The quantity for the split line.
     * This is optional and will not be populated when the Supplier Invoice Request Line is split by amount. | Quantity for the Supplier Invoice Request Line | Quantity on the Supplier Invoice Request Line Split. This is optional and must not be included
     * when the Supplier Invoice Request Line is split by Amount. | Shipped Quantity for Lot | Refers to the supplier item quantity for the POA line. | Quantity for Purchase Order LinecXML Notes:Request/OrderRequest/OrderRequestHeader/ItemOut@quantity |
     * Quantity for Requisition Line | Quantity | Item Lot Quantity
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Quantity;
    /**
     * The Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Unit of Measure
     * - minOccurs: 0
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Unit_of_Measure_Reference;
    /**
     * The Unit_Cost
     * Meta information extracted from the WSDL
     * - documentation: Unit Cost for the Spend Authorization Line | Installment Line Unit Cost. If you supply this value as an override, you must also enable the Override Line flag. The Unit Cost can only be entered for Supplier Invoice Schedules
     * distributed by Amount. | Unit Cost for Return. If not provided this will be derived from the parent document line. | Unit cost of the asset component. | This is the Unit Price. If this is blank, Workday will default the unit price from the item if
     * one is configured. If invoice line has a quantity and unit price, then Workday will automatically calculate extended amount.. But if the line references either a Service or Project-Based Purchase Order or Contract Line, the Unit Price must be blank.
     * | Unit Cost on RFQ Award Line | The unit cost of the item specified in the currency associated to the Purchase Order currency. | Unit Cost on the Internal Service Delivery line. | Unit Cost of the Service provided. This is required only if Quantity
     * is also specified on the Internal Service Delivery Line. | Unit Cost on the Supplier Invoice Request Line | This is the Unit Price. | Refers to the item unit cost on the POA line. | Purchase Order Line Unit CostcXML
     * Notes:Request/OrderRequest/OrderRequestHeader/ItemOut/ItemDetail/UnitPrice | Unit Cost for Requisition Line | Unit Cost | Unit Cost for Receipt Adjustment Line. This field is outbound only; any data submitted will be ignored.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Unit_Cost;
    /**
     * The No_Charge
     * Meta information extracted from the WSDL
     * - documentation: Submit the new No Charge field attribute to change the unit cost of an item to zero on goods lines. You must submit items on goods lines to also submit No Charge.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $No_Charge;
    /**
     * The Extended_Amount
     * Meta information extracted from the WSDL
     * - documentation: The Extended Amount for the Project-Based Order Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Order Line. | The Extended Amount for the Contingent Worker Order Line.
     * | The control value Entered for Extended Amount does not match calculated Extended Amount. Extended Amount is an optional field but it can be used to control the anticipated line amount. If you do not wish to control the line amount, please leave
     * this field blank. | The Extended Amount for the Project-Based Requisition Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Requisition Line. | This is the invoice line amount. If the
     * invoice line has a quantity and unit price, then Workday will automatically calculate extended amount. | Transaction Extended Amount | The Extended Amount for the Service Order Line. This value must be the same sign as the Requisition Line Reference
     * or zero, if present, and must be positive if there is a Supplier Contract Line Reference, if present. | The Extended Amount for the RFQ Goods line. This amount is automatically calculated by multiplying the Quantity by the Unit Cost in the currency
     * specified on the Goods Line. | Service Line Extended Amount should be greater than zero. | Amount to Receive | Extended amount for the split line. This is an optional field for split line. If value is present it must be equal to Quantity times Unit
     * Cost of parent line. | Extended Amount on Award Line Split | The extended amount for the split line. This is always required and must be correct (quantity * unit cost of parent line). | The Extended Amount for the Purchase Order line. This amount is
     * automatically calculated by multiplying the Quantity by the Unit Cost in the currency specified on the Purchase Order. | Extended Amount on the Internal Service Delivery Line. If Unit Cost and Quantity are present on the line, Extended Amount is
     * always equal to their product. | Extended amount for the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Internal Service Delivery Line. | Internal Service Delivery Line Amount. If Unit Cost and
     * Quantity are also specified on the Internal Service Delivery Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Internal Service Delivery Line Split. This is always required and the total Line Split amount must equal the
     * (Unit Cost * Quantity) of the parent Internal Service Delivery Line. | Extended Amount on the Supplier Invoice Request Line. If Unit Cost and Quantity are present on the line, Extended Amount is always equal to their product. | Extended amount for
     * the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Supplier Invoice Request Line. | Supplier Invoice Request Line Extended Amount. If Unit Cost and Quantity are also specified on the Supplier
     * Invoice Request Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Supplier Invoice Request Line Split. This is always required and the total Line Split amount must equal the (Unit Cost * Quantity) of the parent Supplier
     * Invoice Request Line. | Extended Amount on the Advanced Ship Notice Line. | Purchase Order Line Amount | The Extended Amount for the Service Line | The Extended Amount for the Requisition line. This amount is automatically calculated by multiplying
     * the Quantity by the Unit Cost in the currency specified on the Requisition. | Extended Amount | The Actual Quantity Received for this Line. | The Extended Amount for the Receipt Adjustment line. This amount is automatically calculated by multiplying
     * the Actual Quantity to Receive by the Unit Cost in the currency specified on the Receipt.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Extended_Amount;
    /**
     * The Lot_Serial_Information_Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Lot_Serial_Information_DataType
     */
    public $Lot_Serial_Information_Data;
    /**
     * The RFQ_Required
     * Meta information extracted from the WSDL
     * - documentation: Remove the RFQ Required option from the Requsition Line. You can't mark RFQ Required on requisition lines unless RFQ is configured for use. | Negative or zero amount lines can't be marked RFQ Required. | Remove the RFQ Required
     * option from the Requisition Line. You can't mark RFQ Required on requisition lines with related catalog or web items. | Request for Quote required for Requisition Line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $RFQ_Required;
    /**
     * The Requested_Delivery_Date
     * Meta information extracted from the WSDL
     * - documentation: Requested delivery date for a Goods Line on a Requisition
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Requested_Delivery_Date;
    /**
     * The Ship_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Address Reference for an existing Ship-To Address. If not specified on the Requisition Line, Workday will default the Ship-To Address Reference from the Requisition Header.
     * - minOccurs: 0
     * @var \StructType\Address_ReferenceObjectType
     */
    public $Ship_To_Address_Reference;
    /**
     * The Ship_To_Contact_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Worker, who will be the designated Ship-To contact. If not specified on the Requisition Line, Workday will default the Requisition Requester as the Ship-To Contact.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Ship_To_Contact_Reference;
    /**
     * The Deliver_To_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Location, where the Goods or Services will be delivered. If not specified on the Requisition Line, Workday will default the workspace or the business site of the Requisition Worker as the Deliver-To Location.
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Deliver_To_Location_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo for the Requisition Line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Worktags_Reference
     * Meta information extracted from the WSDL
     * - documentation: If Multi-Company is enabled, this validation compares against the Line Company and requires that the line Company is provided when Grant is supplied. | The Worktags provided are not valid for this transaction | Reference to existing
     * worktags. Worktags are a way to mark tasks and business objects to make them easier to access and summarize. Each transaction can include one value for each worktag type and is subject to configurable validation when submitted for approval.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Worktags_Reference;
    /**
     * The Source_This_Line
     * Meta information extracted from the WSDL
     * - documentation: Mark this line for auto-sourcing. A supplier reference must also be provided.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Source_This_Line;
    /**
     * The Purchase_Order_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Purchase Order Line sourced from the Requisition Line. This field is READ ONLY.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Purchase_Order_LineObjectType[]
     */
    public $Purchase_Order_Line_Reference;
    /**
     * The Mark_Purchase_Order_As_Issued
     * Meta information extracted from the WSDL
     * - documentation: Sets the resulting Purchase Order Issue Option to External which automatically issued the Purchase Order. This can only be used with "Source This Line". Additionally, all Requisition Lines for the resulting Purchase Order must have
     * this set or the Purchase Order will not be auto-issued.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Mark_Purchase_Order_As_Issued;
    /**
     * The Goods_Requisition_Line_Split_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Business_Document_Line_Split_DataType[]
     */
    public $Goods_Requisition_Line_Split_Data;
    /**
     * Constructor method for Item_Request_Line_DataType
     * @uses Item_Request_Line_DataType::setRequisition_Goods_Line_Reference()
     * @uses Item_Request_Line_DataType::setGoods_Requisition_Line_ID()
     * @uses Item_Request_Line_DataType::setLine_Company_Reference()
     * @uses Item_Request_Line_DataType::setItem_Reference()
     * @uses Item_Request_Line_DataType::setSupplier_Item_Identifier()
     * @uses Item_Request_Line_DataType::setItem_Description()
     * @uses Item_Request_Line_DataType::setCommodity_Code_Reference()
     * @uses Item_Request_Line_DataType::setSpend_Category_Reference()
     * @uses Item_Request_Line_DataType::setFulfillment_Source_Reference()
     * @uses Item_Request_Line_DataType::setInventory_Site_Location_Reference()
     * @uses Item_Request_Line_DataType::setSupplier_Reference()
     * @uses Item_Request_Line_DataType::setOrder_From_Connection_Reference()
     * @uses Item_Request_Line_DataType::setSupplier_Contract_Reference()
     * @uses Item_Request_Line_DataType::setTax_Applicability_Reference()
     * @uses Item_Request_Line_DataType::setTax_Code_Reference()
     * @uses Item_Request_Line_DataType::setTax_Rate_Recoverabilities_Data()
     * @uses Item_Request_Line_DataType::setPackaging_String()
     * @uses Item_Request_Line_DataType::setQuantity()
     * @uses Item_Request_Line_DataType::setUnit_of_Measure_Reference()
     * @uses Item_Request_Line_DataType::setUnit_Cost()
     * @uses Item_Request_Line_DataType::setNo_Charge()
     * @uses Item_Request_Line_DataType::setExtended_Amount()
     * @uses Item_Request_Line_DataType::setLot_Serial_Information_Data()
     * @uses Item_Request_Line_DataType::setRFQ_Required()
     * @uses Item_Request_Line_DataType::setRequested_Delivery_Date()
     * @uses Item_Request_Line_DataType::setShip_To_Address_Reference()
     * @uses Item_Request_Line_DataType::setShip_To_Contact_Reference()
     * @uses Item_Request_Line_DataType::setDeliver_To_Location_Reference()
     * @uses Item_Request_Line_DataType::setMemo()
     * @uses Item_Request_Line_DataType::setWorktags_Reference()
     * @uses Item_Request_Line_DataType::setSource_This_Line()
     * @uses Item_Request_Line_DataType::setPurchase_Order_Line_Reference()
     * @uses Item_Request_Line_DataType::setMark_Purchase_Order_As_Issued()
     * @uses Item_Request_Line_DataType::setGoods_Requisition_Line_Split_Data()
     * @param \StructType\Item_Requisition_LineObjectType $requisition_Goods_Line_Reference
     * @param string $goods_Requisition_Line_ID
     * @param \StructType\CompanyObjectType $line_Company_Reference
     * @param \StructType\Procurement_ItemObjectType $item_Reference
     * @param string $supplier_Item_Identifier
     * @param string $item_Description
     * @param \StructType\Commodity_CodeObjectType $commodity_Code_Reference
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @param \StructType\Requisition_SourceObjectType $fulfillment_Source_Reference
     * @param \StructType\LocationObjectType $inventory_Site_Location_Reference
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @param \StructType\Order_From_Supplier_ConnectionObjectType $order_From_Connection_Reference
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @param \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference
     * @param \StructType\Tax_CodeObjectType $tax_Code_Reference
     * @param \StructType\Tax_Rate_Options_DataType $tax_Rate_Recoverabilities_Data
     * @param string $packaging_String
     * @param float $quantity
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @param float $unit_Cost
     * @param bool $no_Charge
     * @param float $extended_Amount
     * @param \StructType\Lot_Serial_Information_DataType $lot_Serial_Information_Data
     * @param bool $rFQ_Required
     * @param string $requested_Delivery_Date
     * @param \StructType\Address_ReferenceObjectType $ship_To_Address_Reference
     * @param \StructType\WorkerObjectType $ship_To_Contact_Reference
     * @param \StructType\LocationObjectType $deliver_To_Location_Reference
     * @param string $memo
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @param bool $source_This_Line
     * @param \StructType\Purchase_Order_LineObjectType[] $purchase_Order_Line_Reference
     * @param bool $mark_Purchase_Order_As_Issued
     * @param \StructType\Business_Document_Line_Split_DataType[] $goods_Requisition_Line_Split_Data
     */
    public function __construct(\StructType\Item_Requisition_LineObjectType $requisition_Goods_Line_Reference = null, $goods_Requisition_Line_ID = null, \StructType\CompanyObjectType $line_Company_Reference = null, \StructType\Procurement_ItemObjectType $item_Reference = null, $supplier_Item_Identifier = null, $item_Description = null, \StructType\Commodity_CodeObjectType $commodity_Code_Reference = null, \StructType\Spend_CategoryObjectType $spend_Category_Reference = null, \StructType\Requisition_SourceObjectType $fulfillment_Source_Reference = null, \StructType\LocationObjectType $inventory_Site_Location_Reference = null, \StructType\Resource_ProviderObjectType $supplier_Reference = null, \StructType\Order_From_Supplier_ConnectionObjectType $order_From_Connection_Reference = null, \StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null, \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference = null, \StructType\Tax_CodeObjectType $tax_Code_Reference = null, \StructType\Tax_Rate_Options_DataType $tax_Rate_Recoverabilities_Data = null, $packaging_String = null, $quantity = null, \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null, $unit_Cost = null, $no_Charge = null, $extended_Amount = null, \StructType\Lot_Serial_Information_DataType $lot_Serial_Information_Data = null, $rFQ_Required = null, $requested_Delivery_Date = null, \StructType\Address_ReferenceObjectType $ship_To_Address_Reference = null, \StructType\WorkerObjectType $ship_To_Contact_Reference = null, \StructType\LocationObjectType $deliver_To_Location_Reference = null, $memo = null, array $worktags_Reference = array(), $source_This_Line = null, array $purchase_Order_Line_Reference = array(), $mark_Purchase_Order_As_Issued = null, array $goods_Requisition_Line_Split_Data = array())
    {
        $this
            ->setRequisition_Goods_Line_Reference($requisition_Goods_Line_Reference)
            ->setGoods_Requisition_Line_ID($goods_Requisition_Line_ID)
            ->setLine_Company_Reference($line_Company_Reference)
            ->setItem_Reference($item_Reference)
            ->setSupplier_Item_Identifier($supplier_Item_Identifier)
            ->setItem_Description($item_Description)
            ->setCommodity_Code_Reference($commodity_Code_Reference)
            ->setSpend_Category_Reference($spend_Category_Reference)
            ->setFulfillment_Source_Reference($fulfillment_Source_Reference)
            ->setInventory_Site_Location_Reference($inventory_Site_Location_Reference)
            ->setSupplier_Reference($supplier_Reference)
            ->setOrder_From_Connection_Reference($order_From_Connection_Reference)
            ->setSupplier_Contract_Reference($supplier_Contract_Reference)
            ->setTax_Applicability_Reference($tax_Applicability_Reference)
            ->setTax_Code_Reference($tax_Code_Reference)
            ->setTax_Rate_Recoverabilities_Data($tax_Rate_Recoverabilities_Data)
            ->setPackaging_String($packaging_String)
            ->setQuantity($quantity)
            ->setUnit_of_Measure_Reference($unit_of_Measure_Reference)
            ->setUnit_Cost($unit_Cost)
            ->setNo_Charge($no_Charge)
            ->setExtended_Amount($extended_Amount)
            ->setLot_Serial_Information_Data($lot_Serial_Information_Data)
            ->setRFQ_Required($rFQ_Required)
            ->setRequested_Delivery_Date($requested_Delivery_Date)
            ->setShip_To_Address_Reference($ship_To_Address_Reference)
            ->setShip_To_Contact_Reference($ship_To_Contact_Reference)
            ->setDeliver_To_Location_Reference($deliver_To_Location_Reference)
            ->setMemo($memo)
            ->setWorktags_Reference($worktags_Reference)
            ->setSource_This_Line($source_This_Line)
            ->setPurchase_Order_Line_Reference($purchase_Order_Line_Reference)
            ->setMark_Purchase_Order_As_Issued($mark_Purchase_Order_As_Issued)
            ->setGoods_Requisition_Line_Split_Data($goods_Requisition_Line_Split_Data);
    }
    /**
     * Get Requisition_Goods_Line_Reference value
     * @return \StructType\Item_Requisition_LineObjectType|null
     */
    public function getRequisition_Goods_Line_Reference()
    {
        return $this->Requisition_Goods_Line_Reference;
    }
    /**
     * Set Requisition_Goods_Line_Reference value
     * @param \StructType\Item_Requisition_LineObjectType $requisition_Goods_Line_Reference
     * @return \StructType\Item_Request_Line_DataType
     */
    public function setRequisition_Goods_Line_Reference(\StructType\Item_Requisition_LineObjectType $requisition_Goods_Line_Reference = null)
    {
        $this->Requisition_Goods_Line_Reference = $requisition_Goods_Line_Reference;
        return $this;
    }
    /**
     * Get Goods_Requisition_Line_ID value
     * @return string|null
     */
    public function getGoods_Requisition_Line_ID()
    {
        return $this->Goods_Requisition_Line_ID;
    }
    /**
     * Set Goods_Requisition_Line_ID value
     * @param string $goods_Requisition_Line_ID
     * @return \StructType\Item_Request_Line_DataType
     */
    public function setGoods_Requisition_Line_ID($goods_Requisition_Line_ID = null)
    {
        // validation for constraint: string
        if (!is_null($goods_Requisition_Line_ID) && !is_string($goods_Requisition_Line_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($goods_Requisition_Line_ID, true), gettype($goods_Requisition_Line_ID)), __LINE__);
        }
        $this->Goods_Requisition_Line_ID = $goods_Requisition_Line_ID;
        return $this;
    }
    /**
     * Get Line_Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getLine_Company_Reference()
    {
        return $this->Line_Company_Reference;
    }
    /**
     * Set Line_Company_Reference value
     * @param \StructType\CompanyObjectType $line_Company_Reference
     * @return \StructType\Item_Request_Line_DataType
     */
    public function setLine_Company_Reference(\StructType\CompanyObjectType $line_Company_Reference = null)
    {
        $this->Line_Company_Reference = $line_Company_Reference;
        return $this;
    }
    /**
     * Get Item_Reference value
     * @return \StructType\Procurement_ItemObjectType|null
     */
    public function getItem_Reference()
    {
        return $this->Item_Reference;
    }
    /**
     * Set Item_Reference value
     * @param \StructType\Procurement_ItemObjectType $item_Reference
     * @return \StructType\Item_Request_Line_DataType
     */
    public function setItem_Reference(\StructType\Procurement_ItemObjectType $item_Reference = null)
    {
        $this->Item_Reference = $item_Reference;
        return $this;
    }
    /**
     * Get Supplier_Item_Identifier value
     * @return string|null
     */
    public function getSupplier_Item_Identifier()
    {
        return $this->Supplier_Item_Identifier;
    }
    /**
     * Set Supplier_Item_Identifier value
     * @param string $supplier_Item_Identifier
     * @return \StructType\Item_Request_Line_DataType
     */
    public function setSupplier_Item_Identifier($supplier_Item_Identifier = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Item_Identifier) && !is_string($supplier_Item_Identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Item_Identifier, true), gettype($supplier_Item_Identifier)), __LINE__);
        }
        $this->Supplier_Item_Identifier = $supplier_Item_Identifier;
        return $this;
    }
    /**
     * Get Item_Description value
     * @return string|null
     */
    public function getItem_Description()
    {
        return $this->Item_Description;
    }
    /**
     * Set Item_Description value
     * @param string $item_Description
     * @return \StructType\Item_Request_Line_DataType
     */
    public function setItem_Description($item_Description = null)
    {
        // validation for constraint: string
        if (!is_null($item_Description) && !is_string($item_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_Description, true), gettype($item_Description)), __LINE__);
        }
        $this->Item_Description = $item_Description;
        return $this;
    }
    /**
     * Get Commodity_Code_Reference value
     * @return \StructType\Commodity_CodeObjectType|null
     */
    public function getCommodity_Code_Reference()
    {
        return $this->Commodity_Code_Reference;
    }
    /**
     * Set Commodity_Code_Reference value
     * @param \StructType\Commodity_CodeObjectType $commodity_Code_Reference
     * @return \StructType\Item_Request_Line_DataType
     */
    public function setCommodity_Code_Reference(\StructType\Commodity_CodeObjectType $commodity_Code_Reference = null)
    {
        $this->Commodity_Code_Reference = $commodity_Code_Reference;
        return $this;
    }
    /**
     * Get Spend_Category_Reference value
     * @return \StructType\Spend_CategoryObjectType|null
     */
    public function getSpend_Category_Reference()
    {
        return $this->Spend_Category_Reference;
    }
    /**
     * Set Spend_Category_Reference value
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @return \StructType\Item_Request_Line_DataType
     */
    public function setSpend_Category_Reference(\StructType\Spend_CategoryObjectType $spend_Category_Reference = null)
    {
        $this->Spend_Category_Reference = $spend_Category_Reference;
        return $this;
    }
    /**
     * Get Fulfillment_Source_Reference value
     * @return \StructType\Requisition_SourceObjectType|null
     */
    public function getFulfillment_Source_Reference()
    {
        return $this->Fulfillment_Source_Reference;
    }
    /**
     * Set Fulfillment_Source_Reference value
     * @param \StructType\Requisition_SourceObjectType $fulfillment_Source_Reference
     * @return \StructType\Item_Request_Line_DataType
     */
    public function setFulfillment_Source_Reference(\StructType\Requisition_SourceObjectType $fulfillment_Source_Reference = null)
    {
        $this->Fulfillment_Source_Reference = $fulfillment_Source_Reference;
        return $this;
    }
    /**
     * Get Inventory_Site_Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getInventory_Site_Location_Reference()
    {
        return $this->Inventory_Site_Location_Reference;
    }
    /**
     * Set Inventory_Site_Location_Reference value
     * @param \StructType\LocationObjectType $inventory_Site_Location_Reference
     * @return \StructType\Item_Request_Line_DataType
     */
    public function setInventory_Site_Location_Reference(\StructType\LocationObjectType $inventory_Site_Location_Reference = null)
    {
        $this->Inventory_Site_Location_Reference = $inventory_Site_Location_Reference;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @return \StructType\Item_Request_Line_DataType
     */
    public function setSupplier_Reference(\StructType\Resource_ProviderObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get Order_From_Connection_Reference value
     * @return \StructType\Order_From_Supplier_ConnectionObjectType|null
     */
    public function getOrder_From_Connection_Reference()
    {
        return $this->{'Order-From_Connection_Reference'};
    }
    /**
     * Set Order_From_Connection_Reference value
     * @param \StructType\Order_From_Supplier_ConnectionObjectType $order_From_Connection_Reference
     * @return \StructType\Item_Request_Line_DataType
     */
    public function setOrder_From_Connection_Reference(\StructType\Order_From_Supplier_ConnectionObjectType $order_From_Connection_Reference = null)
    {
        $this->Order_From_Connection_Reference = $this->{'Order-From_Connection_Reference'} = $order_From_Connection_Reference;
        return $this;
    }
    /**
     * Get Supplier_Contract_Reference value
     * @return \StructType\Supplier_ContractObjectType|null
     */
    public function getSupplier_Contract_Reference()
    {
        return $this->Supplier_Contract_Reference;
    }
    /**
     * Set Supplier_Contract_Reference value
     * @param \StructType\Supplier_ContractObjectType $supplier_Contract_Reference
     * @return \StructType\Item_Request_Line_DataType
     */
    public function setSupplier_Contract_Reference(\StructType\Supplier_ContractObjectType $supplier_Contract_Reference = null)
    {
        $this->Supplier_Contract_Reference = $supplier_Contract_Reference;
        return $this;
    }
    /**
     * Get Tax_Applicability_Reference value
     * @return \StructType\Tax_ApplicabilityObjectType|null
     */
    public function getTax_Applicability_Reference()
    {
        return $this->Tax_Applicability_Reference;
    }
    /**
     * Set Tax_Applicability_Reference value
     * @param \StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference
     * @return \StructType\Item_Request_Line_DataType
     */
    public function setTax_Applicability_Reference(\StructType\Tax_ApplicabilityObjectType $tax_Applicability_Reference = null)
    {
        $this->Tax_Applicability_Reference = $tax_Applicability_Reference;
        return $this;
    }
    /**
     * Get Tax_Code_Reference value
     * @return \StructType\Tax_CodeObjectType|null
     */
    public function getTax_Code_Reference()
    {
        return $this->Tax_Code_Reference;
    }
    /**
     * Set Tax_Code_Reference value
     * @param \StructType\Tax_CodeObjectType $tax_Code_Reference
     * @return \StructType\Item_Request_Line_DataType
     */
    public function setTax_Code_Reference(\StructType\Tax_CodeObjectType $tax_Code_Reference = null)
    {
        $this->Tax_Code_Reference = $tax_Code_Reference;
        return $this;
    }
    /**
     * Get Tax_Rate_Recoverabilities_Data value
     * @return \StructType\Tax_Rate_Options_DataType|null
     */
    public function getTax_Rate_Recoverabilities_Data()
    {
        return $this->Tax_Rate_Recoverabilities_Data;
    }
    /**
     * Set Tax_Rate_Recoverabilities_Data value
     * @param \StructType\Tax_Rate_Options_DataType $tax_Rate_Recoverabilities_Data
     * @return \StructType\Item_Request_Line_DataType
     */
    public function setTax_Rate_Recoverabilities_Data(\StructType\Tax_Rate_Options_DataType $tax_Rate_Recoverabilities_Data = null)
    {
        $this->Tax_Rate_Recoverabilities_Data = $tax_Rate_Recoverabilities_Data;
        return $this;
    }
    /**
     * Get Packaging_String value
     * @return string|null
     */
    public function getPackaging_String()
    {
        return $this->Packaging_String;
    }
    /**
     * Set Packaging_String value
     * @param string $packaging_String
     * @return \StructType\Item_Request_Line_DataType
     */
    public function setPackaging_String($packaging_String = null)
    {
        // validation for constraint: string
        if (!is_null($packaging_String) && !is_string($packaging_String)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packaging_String, true), gettype($packaging_String)), __LINE__);
        }
        $this->Packaging_String = $packaging_String;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\Item_Request_Line_DataType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($quantity) && mb_strlen(mb_substr($quantity, false !== mb_strpos($quantity, '.') ? mb_strpos($quantity, '.') + 1 : mb_strlen($quantity))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($quantity, true), mb_strlen(mb_substr($quantity, mb_strpos($quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($quantity) && mb_strlen(preg_replace('/(\D)/', '', $quantity)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($quantity, true), mb_strlen(preg_replace('/(\D)/', '', $quantity))), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Unit_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getUnit_of_Measure_Reference()
    {
        return $this->Unit_of_Measure_Reference;
    }
    /**
     * Set Unit_of_Measure_Reference value
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @return \StructType\Item_Request_Line_DataType
     */
    public function setUnit_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null)
    {
        $this->Unit_of_Measure_Reference = $unit_of_Measure_Reference;
        return $this;
    }
    /**
     * Get Unit_Cost value
     * @return float|null
     */
    public function getUnit_Cost()
    {
        return $this->Unit_Cost;
    }
    /**
     * Set Unit_Cost value
     * @param float $unit_Cost
     * @return \StructType\Item_Request_Line_DataType
     */
    public function setUnit_Cost($unit_Cost = null)
    {
        // validation for constraint: float
        if (!is_null($unit_Cost) && !(is_float($unit_Cost) || is_numeric($unit_Cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unit_Cost, true), gettype($unit_Cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($unit_Cost) && mb_strlen(mb_substr($unit_Cost, false !== mb_strpos($unit_Cost, '.') ? mb_strpos($unit_Cost, '.') + 1 : mb_strlen($unit_Cost))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($unit_Cost, true), mb_strlen(mb_substr($unit_Cost, mb_strpos($unit_Cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($unit_Cost) && mb_strlen(preg_replace('/(\D)/', '', $unit_Cost)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($unit_Cost, true), mb_strlen(preg_replace('/(\D)/', '', $unit_Cost))), __LINE__);
        }
        $this->Unit_Cost = $unit_Cost;
        return $this;
    }
    /**
     * Get No_Charge value
     * @return bool|null
     */
    public function getNo_Charge()
    {
        return $this->No_Charge;
    }
    /**
     * Set No_Charge value
     * @param bool $no_Charge
     * @return \StructType\Item_Request_Line_DataType
     */
    public function setNo_Charge($no_Charge = null)
    {
        // validation for constraint: boolean
        if (!is_null($no_Charge) && !is_bool($no_Charge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($no_Charge, true), gettype($no_Charge)), __LINE__);
        }
        $this->No_Charge = $no_Charge;
        return $this;
    }
    /**
     * Get Extended_Amount value
     * @return float|null
     */
    public function getExtended_Amount()
    {
        return $this->Extended_Amount;
    }
    /**
     * Set Extended_Amount value
     * @param float $extended_Amount
     * @return \StructType\Item_Request_Line_DataType
     */
    public function setExtended_Amount($extended_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($extended_Amount) && !(is_float($extended_Amount) || is_numeric($extended_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($extended_Amount, true), gettype($extended_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($extended_Amount) && mb_strlen(mb_substr($extended_Amount, false !== mb_strpos($extended_Amount, '.') ? mb_strpos($extended_Amount, '.') + 1 : mb_strlen($extended_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($extended_Amount, true), mb_strlen(mb_substr($extended_Amount, mb_strpos($extended_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($extended_Amount) && mb_strlen(preg_replace('/(\D)/', '', $extended_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($extended_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $extended_Amount))), __LINE__);
        }
        $this->Extended_Amount = $extended_Amount;
        return $this;
    }
    /**
     * Get Lot_Serial_Information_Data value
     * @return \StructType\Lot_Serial_Information_DataType|null
     */
    public function getLot_Serial_Information_Data()
    {
        return $this->Lot_Serial_Information_Data;
    }
    /**
     * Set Lot_Serial_Information_Data value
     * @param \StructType\Lot_Serial_Information_DataType $lot_Serial_Information_Data
     * @return \StructType\Item_Request_Line_DataType
     */
    public function setLot_Serial_Information_Data(\StructType\Lot_Serial_Information_DataType $lot_Serial_Information_Data = null)
    {
        $this->Lot_Serial_Information_Data = $lot_Serial_Information_Data;
        return $this;
    }
    /**
     * Get RFQ_Required value
     * @return bool|null
     */
    public function getRFQ_Required()
    {
        return $this->RFQ_Required;
    }
    /**
     * Set RFQ_Required value
     * @param bool $rFQ_Required
     * @return \StructType\Item_Request_Line_DataType
     */
    public function setRFQ_Required($rFQ_Required = null)
    {
        // validation for constraint: boolean
        if (!is_null($rFQ_Required) && !is_bool($rFQ_Required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($rFQ_Required, true), gettype($rFQ_Required)), __LINE__);
        }
        $this->RFQ_Required = $rFQ_Required;
        return $this;
    }
    /**
     * Get Requested_Delivery_Date value
     * @return string|null
     */
    public function getRequested_Delivery_Date()
    {
        return $this->Requested_Delivery_Date;
    }
    /**
     * Set Requested_Delivery_Date value
     * @param string $requested_Delivery_Date
     * @return \StructType\Item_Request_Line_DataType
     */
    public function setRequested_Delivery_Date($requested_Delivery_Date = null)
    {
        // validation for constraint: string
        if (!is_null($requested_Delivery_Date) && !is_string($requested_Delivery_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requested_Delivery_Date, true), gettype($requested_Delivery_Date)), __LINE__);
        }
        $this->Requested_Delivery_Date = $requested_Delivery_Date;
        return $this;
    }
    /**
     * Get Ship_To_Address_Reference value
     * @return \StructType\Address_ReferenceObjectType|null
     */
    public function getShip_To_Address_Reference()
    {
        return $this->Ship_To_Address_Reference;
    }
    /**
     * Set Ship_To_Address_Reference value
     * @param \StructType\Address_ReferenceObjectType $ship_To_Address_Reference
     * @return \StructType\Item_Request_Line_DataType
     */
    public function setShip_To_Address_Reference(\StructType\Address_ReferenceObjectType $ship_To_Address_Reference = null)
    {
        $this->Ship_To_Address_Reference = $ship_To_Address_Reference;
        return $this;
    }
    /**
     * Get Ship_To_Contact_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getShip_To_Contact_Reference()
    {
        return $this->Ship_To_Contact_Reference;
    }
    /**
     * Set Ship_To_Contact_Reference value
     * @param \StructType\WorkerObjectType $ship_To_Contact_Reference
     * @return \StructType\Item_Request_Line_DataType
     */
    public function setShip_To_Contact_Reference(\StructType\WorkerObjectType $ship_To_Contact_Reference = null)
    {
        $this->Ship_To_Contact_Reference = $ship_To_Contact_Reference;
        return $this;
    }
    /**
     * Get Deliver_To_Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getDeliver_To_Location_Reference()
    {
        return $this->Deliver_To_Location_Reference;
    }
    /**
     * Set Deliver_To_Location_Reference value
     * @param \StructType\LocationObjectType $deliver_To_Location_Reference
     * @return \StructType\Item_Request_Line_DataType
     */
    public function setDeliver_To_Location_Reference(\StructType\LocationObjectType $deliver_To_Location_Reference = null)
    {
        $this->Deliver_To_Location_Reference = $deliver_To_Location_Reference;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Item_Request_Line_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Worktags_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getWorktags_Reference()
    {
        return $this->Worktags_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktags_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktags_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $item_Request_Line_DataTypeWorktags_ReferenceItem) {
            // validation for constraint: itemType
            if (!$item_Request_Line_DataTypeWorktags_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($item_Request_Line_DataTypeWorktags_ReferenceItem) ? get_class($item_Request_Line_DataTypeWorktags_ReferenceItem) : sprintf('%s(%s)', gettype($item_Request_Line_DataTypeWorktags_ReferenceItem), var_export($item_Request_Line_DataTypeWorktags_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @return \StructType\Item_Request_Line_DataType
     */
    public function setWorktags_Reference(array $worktags_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktags_ReferenceArrayErrorMessage = self::validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference($worktags_Reference))) {
            throw new \InvalidArgumentException($worktags_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktags_Reference = $worktags_Reference;
        return $this;
    }
    /**
     * Add item to Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Item_Request_Line_DataType
     */
    public function addToWorktags_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktags_Reference[] = $item;
        return $this;
    }
    /**
     * Get Source_This_Line value
     * @return bool|null
     */
    public function getSource_This_Line()
    {
        return $this->Source_This_Line;
    }
    /**
     * Set Source_This_Line value
     * @param bool $source_This_Line
     * @return \StructType\Item_Request_Line_DataType
     */
    public function setSource_This_Line($source_This_Line = null)
    {
        // validation for constraint: boolean
        if (!is_null($source_This_Line) && !is_bool($source_This_Line)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($source_This_Line, true), gettype($source_This_Line)), __LINE__);
        }
        $this->Source_This_Line = $source_This_Line;
        return $this;
    }
    /**
     * Get Purchase_Order_Line_Reference value
     * @return \StructType\Purchase_Order_LineObjectType[]|null
     */
    public function getPurchase_Order_Line_Reference()
    {
        return $this->Purchase_Order_Line_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Order_Line_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Order_Line_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Order_Line_ReferenceForArrayConstraintsFromSetPurchase_Order_Line_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $item_Request_Line_DataTypePurchase_Order_Line_ReferenceItem) {
            // validation for constraint: itemType
            if (!$item_Request_Line_DataTypePurchase_Order_Line_ReferenceItem instanceof \StructType\Purchase_Order_LineObjectType) {
                $invalidValues[] = is_object($item_Request_Line_DataTypePurchase_Order_Line_ReferenceItem) ? get_class($item_Request_Line_DataTypePurchase_Order_Line_ReferenceItem) : sprintf('%s(%s)', gettype($item_Request_Line_DataTypePurchase_Order_Line_ReferenceItem), var_export($item_Request_Line_DataTypePurchase_Order_Line_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Order_Line_Reference property can only contain items of type \StructType\Purchase_Order_LineObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Order_Line_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Order_LineObjectType[] $purchase_Order_Line_Reference
     * @return \StructType\Item_Request_Line_DataType
     */
    public function setPurchase_Order_Line_Reference(array $purchase_Order_Line_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Order_Line_ReferenceArrayErrorMessage = self::validatePurchase_Order_Line_ReferenceForArrayConstraintsFromSetPurchase_Order_Line_Reference($purchase_Order_Line_Reference))) {
            throw new \InvalidArgumentException($purchase_Order_Line_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Order_Line_Reference = $purchase_Order_Line_Reference;
        return $this;
    }
    /**
     * Add item to Purchase_Order_Line_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Order_LineObjectType $item
     * @return \StructType\Item_Request_Line_DataType
     */
    public function addToPurchase_Order_Line_Reference(\StructType\Purchase_Order_LineObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_Order_LineObjectType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Order_Line_Reference property can only contain items of type \StructType\Purchase_Order_LineObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Order_Line_Reference[] = $item;
        return $this;
    }
    /**
     * Get Mark_Purchase_Order_As_Issued value
     * @return bool|null
     */
    public function getMark_Purchase_Order_As_Issued()
    {
        return $this->Mark_Purchase_Order_As_Issued;
    }
    /**
     * Set Mark_Purchase_Order_As_Issued value
     * @param bool $mark_Purchase_Order_As_Issued
     * @return \StructType\Item_Request_Line_DataType
     */
    public function setMark_Purchase_Order_As_Issued($mark_Purchase_Order_As_Issued = null)
    {
        // validation for constraint: boolean
        if (!is_null($mark_Purchase_Order_As_Issued) && !is_bool($mark_Purchase_Order_As_Issued)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mark_Purchase_Order_As_Issued, true), gettype($mark_Purchase_Order_As_Issued)), __LINE__);
        }
        $this->Mark_Purchase_Order_As_Issued = $mark_Purchase_Order_As_Issued;
        return $this;
    }
    /**
     * Get Goods_Requisition_Line_Split_Data value
     * @return \StructType\Business_Document_Line_Split_DataType[]|null
     */
    public function getGoods_Requisition_Line_Split_Data()
    {
        return $this->Goods_Requisition_Line_Split_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setGoods_Requisition_Line_Split_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGoods_Requisition_Line_Split_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGoods_Requisition_Line_Split_DataForArrayConstraintsFromSetGoods_Requisition_Line_Split_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $item_Request_Line_DataTypeGoods_Requisition_Line_Split_DataItem) {
            // validation for constraint: itemType
            if (!$item_Request_Line_DataTypeGoods_Requisition_Line_Split_DataItem instanceof \StructType\Business_Document_Line_Split_DataType) {
                $invalidValues[] = is_object($item_Request_Line_DataTypeGoods_Requisition_Line_Split_DataItem) ? get_class($item_Request_Line_DataTypeGoods_Requisition_Line_Split_DataItem) : sprintf('%s(%s)', gettype($item_Request_Line_DataTypeGoods_Requisition_Line_Split_DataItem), var_export($item_Request_Line_DataTypeGoods_Requisition_Line_Split_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Goods_Requisition_Line_Split_Data property can only contain items of type \StructType\Business_Document_Line_Split_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Goods_Requisition_Line_Split_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Line_Split_DataType[] $goods_Requisition_Line_Split_Data
     * @return \StructType\Item_Request_Line_DataType
     */
    public function setGoods_Requisition_Line_Split_Data(array $goods_Requisition_Line_Split_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($goods_Requisition_Line_Split_DataArrayErrorMessage = self::validateGoods_Requisition_Line_Split_DataForArrayConstraintsFromSetGoods_Requisition_Line_Split_Data($goods_Requisition_Line_Split_Data))) {
            throw new \InvalidArgumentException($goods_Requisition_Line_Split_DataArrayErrorMessage, __LINE__);
        }
        $this->Goods_Requisition_Line_Split_Data = $goods_Requisition_Line_Split_Data;
        return $this;
    }
    /**
     * Add item to Goods_Requisition_Line_Split_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Line_Split_DataType $item
     * @return \StructType\Item_Request_Line_DataType
     */
    public function addToGoods_Requisition_Line_Split_Data(\StructType\Business_Document_Line_Split_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business_Document_Line_Split_DataType) {
            throw new \InvalidArgumentException(sprintf('The Goods_Requisition_Line_Split_Data property can only contain items of type \StructType\Business_Document_Line_Split_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Goods_Requisition_Line_Split_Data[] = $item;
        return $this;
    }
}
