<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Expense_Credit_Card_Response_GroupType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element around a list of elements representing the amount of data that should be included in the Expense Credit Card response. If this element is not included then ALL of the Response Groups are included in the response.
 * @subpackage Structs
 */
class Expense_Credit_Card_Response_GroupType extends AbstractStructBase
{
    /**
     * The Include_Reference
     * Meta information extracted from the WSDL
     * - documentation: Flag indicating if the Expense Credit Card Reference data is to be included in the response
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Reference;
    /**
     * The Include_Expense_Credit_Card_Data
     * Meta information extracted from the WSDL
     * - documentation: Flag indicating if the Expense Credit Card data is to be included in the response
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Include_Expense_Credit_Card_Data;
    /**
     * Constructor method for Expense_Credit_Card_Response_GroupType
     * @uses Expense_Credit_Card_Response_GroupType::setInclude_Reference()
     * @uses Expense_Credit_Card_Response_GroupType::setInclude_Expense_Credit_Card_Data()
     * @param bool $include_Reference
     * @param bool $include_Expense_Credit_Card_Data
     */
    public function __construct($include_Reference = null, $include_Expense_Credit_Card_Data = null)
    {
        $this
            ->setInclude_Reference($include_Reference)
            ->setInclude_Expense_Credit_Card_Data($include_Expense_Credit_Card_Data);
    }
    /**
     * Get Include_Reference value
     * @return bool|null
     */
    public function getInclude_Reference()
    {
        return $this->Include_Reference;
    }
    /**
     * Set Include_Reference value
     * @param bool $include_Reference
     * @return \StructType\Expense_Credit_Card_Response_GroupType
     */
    public function setInclude_Reference($include_Reference = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Reference) && !is_bool($include_Reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Reference, true), gettype($include_Reference)), __LINE__);
        }
        $this->Include_Reference = $include_Reference;
        return $this;
    }
    /**
     * Get Include_Expense_Credit_Card_Data value
     * @return bool|null
     */
    public function getInclude_Expense_Credit_Card_Data()
    {
        return $this->Include_Expense_Credit_Card_Data;
    }
    /**
     * Set Include_Expense_Credit_Card_Data value
     * @param bool $include_Expense_Credit_Card_Data
     * @return \StructType\Expense_Credit_Card_Response_GroupType
     */
    public function setInclude_Expense_Credit_Card_Data($include_Expense_Credit_Card_Data = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_Expense_Credit_Card_Data) && !is_bool($include_Expense_Credit_Card_Data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($include_Expense_Credit_Card_Data, true), gettype($include_Expense_Credit_Card_Data)), __LINE__);
        }
        $this->Include_Expense_Credit_Card_Data = $include_Expense_Credit_Card_Data;
        return $this;
    }
}
