<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Commodity_Code_Type_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Commodity Code Type Data
 * @subpackage Structs
 */
class Commodity_Code_Type_DataType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: Reference ID for Commodity Code Type.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The Commodity_Code_Type_Name
     * Meta information extracted from the WSDL
     * - documentation: This is name of the Commodity Code Type and needs to be unique.
     * - maxOccurs: 1
     * @var string
     */
    public $Commodity_Code_Type_Name;
    /**
     * The Length
     * Meta information extracted from the WSDL
     * - documentation: Number of characters allowed in the commodity code. This should be the same as the sum of Level Length.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - totalDigits: 12
     * @var float
     */
    public $Length;
    /**
     * The Commodity_Code_Type_Level
     * Meta information extracted from the WSDL
     * - documentation: Commodity Code Type Level
     * - maxOccurs: unbounded
     * @var \StructType\Commodity_Code_Type_Level_DataType[]
     */
    public $Commodity_Code_Type_Level;
    /**
     * Constructor method for Commodity_Code_Type_DataType
     * @uses Commodity_Code_Type_DataType::setID()
     * @uses Commodity_Code_Type_DataType::setCommodity_Code_Type_Name()
     * @uses Commodity_Code_Type_DataType::setLength()
     * @uses Commodity_Code_Type_DataType::setCommodity_Code_Type_Level()
     * @param string $iD
     * @param string $commodity_Code_Type_Name
     * @param float $length
     * @param \StructType\Commodity_Code_Type_Level_DataType[] $commodity_Code_Type_Level
     */
    public function __construct($iD = null, $commodity_Code_Type_Name = null, $length = null, array $commodity_Code_Type_Level = array())
    {
        $this
            ->setID($iD)
            ->setCommodity_Code_Type_Name($commodity_Code_Type_Name)
            ->setLength($length)
            ->setCommodity_Code_Type_Level($commodity_Code_Type_Level);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\Commodity_Code_Type_DataType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Commodity_Code_Type_Name value
     * @return string|null
     */
    public function getCommodity_Code_Type_Name()
    {
        return $this->Commodity_Code_Type_Name;
    }
    /**
     * Set Commodity_Code_Type_Name value
     * @param string $commodity_Code_Type_Name
     * @return \StructType\Commodity_Code_Type_DataType
     */
    public function setCommodity_Code_Type_Name($commodity_Code_Type_Name = null)
    {
        // validation for constraint: string
        if (!is_null($commodity_Code_Type_Name) && !is_string($commodity_Code_Type_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commodity_Code_Type_Name, true), gettype($commodity_Code_Type_Name)), __LINE__);
        }
        $this->Commodity_Code_Type_Name = $commodity_Code_Type_Name;
        return $this;
    }
    /**
     * Get Length value
     * @return float|null
     */
    public function getLength()
    {
        return $this->Length;
    }
    /**
     * Set Length value
     * @param float $length
     * @return \StructType\Commodity_Code_Type_DataType
     */
    public function setLength($length = null)
    {
        // validation for constraint: float
        if (!is_null($length) && !(is_float($length) || is_numeric($length))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($length, true), gettype($length)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($length) && mb_strlen(mb_substr($length, false !== mb_strpos($length, '.') ? mb_strpos($length, '.') + 1 : mb_strlen($length))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($length, true), mb_strlen(mb_substr($length, mb_strpos($length, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($length) && $length < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($length, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($length) && mb_strlen(preg_replace('/(\D)/', '', $length)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($length, true), mb_strlen(preg_replace('/(\D)/', '', $length))), __LINE__);
        }
        $this->Length = $length;
        return $this;
    }
    /**
     * Get Commodity_Code_Type_Level value
     * @return \StructType\Commodity_Code_Type_Level_DataType[]|null
     */
    public function getCommodity_Code_Type_Level()
    {
        return $this->Commodity_Code_Type_Level;
    }
    /**
     * This method is responsible for validating the values passed to the setCommodity_Code_Type_Level method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommodity_Code_Type_Level method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommodity_Code_Type_LevelForArrayConstraintsFromSetCommodity_Code_Type_Level(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commodity_Code_Type_DataTypeCommodity_Code_Type_LevelItem) {
            // validation for constraint: itemType
            if (!$commodity_Code_Type_DataTypeCommodity_Code_Type_LevelItem instanceof \StructType\Commodity_Code_Type_Level_DataType) {
                $invalidValues[] = is_object($commodity_Code_Type_DataTypeCommodity_Code_Type_LevelItem) ? get_class($commodity_Code_Type_DataTypeCommodity_Code_Type_LevelItem) : sprintf('%s(%s)', gettype($commodity_Code_Type_DataTypeCommodity_Code_Type_LevelItem), var_export($commodity_Code_Type_DataTypeCommodity_Code_Type_LevelItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Commodity_Code_Type_Level property can only contain items of type \StructType\Commodity_Code_Type_Level_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Commodity_Code_Type_Level value
     * @throws \InvalidArgumentException
     * @param \StructType\Commodity_Code_Type_Level_DataType[] $commodity_Code_Type_Level
     * @return \StructType\Commodity_Code_Type_DataType
     */
    public function setCommodity_Code_Type_Level(array $commodity_Code_Type_Level = array())
    {
        // validation for constraint: array
        if ('' !== ($commodity_Code_Type_LevelArrayErrorMessage = self::validateCommodity_Code_Type_LevelForArrayConstraintsFromSetCommodity_Code_Type_Level($commodity_Code_Type_Level))) {
            throw new \InvalidArgumentException($commodity_Code_Type_LevelArrayErrorMessage, __LINE__);
        }
        $this->Commodity_Code_Type_Level = $commodity_Code_Type_Level;
        return $this;
    }
    /**
     * Add item to Commodity_Code_Type_Level value
     * @throws \InvalidArgumentException
     * @param \StructType\Commodity_Code_Type_Level_DataType $item
     * @return \StructType\Commodity_Code_Type_DataType
     */
    public function addToCommodity_Code_Type_Level(\StructType\Commodity_Code_Type_Level_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Commodity_Code_Type_Level_DataType) {
            throw new \InvalidArgumentException(sprintf('The Commodity_Code_Type_Level property can only contain items of type \StructType\Commodity_Code_Type_Level_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Commodity_Code_Type_Level[] = $item;
        return $this;
    }
}
