<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Catalog_Load_Item_Unit_of_Measure_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element used to capture multiple Units of Measure for a Catalog Load Item
 * @subpackage Structs
 */
class Catalog_Load_Item_Unit_of_Measure_DataType extends AbstractStructBase
{
    /**
     * The Catalog_Load_Item_UOM_Reference
     * Meta information extracted from the WSDL
     * - documentation: Catalog Load Item Unit of Measure Instance. Only applicable when invoked via Get Catalog Loads Web Service operation.
     * - minOccurs: 0
     * @var \StructType\Catalog_Load_Item_Unit_of_MeasureObjectType
     */
    public $Catalog_Load_Item_UOM_Reference;
    /**
     * The Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: Unit of Measure Reference for the Catalog Load Item.
     * - choice: Unit_of_Measure_Reference | UN_CEFACT_UOM_Code
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Unit_of_Measure_Reference;
    /**
     * The UN_CEFACT_UOM_Code
     * Meta information extracted from the WSDL
     * - documentation: UN CEFACT Common Code for Catalog Load Item.
     * - choice: Unit_of_Measure_Reference | UN_CEFACT_UOM_Code
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * @var string
     */
    public $UN_CEFACT_UOM_Code;
    /**
     * The Item_Unit_Price
     * Meta information extracted from the WSDL
     * - documentation: Currency field for Item Unit Price | Unit Price.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Item_Unit_Price;
    /**
     * The Conversion_Factor
     * Meta information extracted from the WSDL
     * - documentation: The conversion factor to be used when converting the unit of measure to the base unit of measure for the catalog item. | Conversion Factor for the ordering unit of measure to the base unit of measure of the catalog item. | Purchase
     * Item stocking Unit of measure Conversion factor | Positive numeric value used to calculate the Ordered Quantity that is shipped from Shipped Quantity provided at Advance Shipment Line. If Shipped Quantity is five and Conversion Factor is two , then
     * Quantity shipped is calculated as Ten. Default value for Conversion Factor is one. | Conversion Factor between the Ordering Unit of Measure and the Base Unit of Measure of Catalog Load Item. | Conversion factor to the base UOM. | Conversion Factor
     * from Ordering Unit of Measure to Purchase Item's Base Unit of Measure. | Conversion Factor for the JIT UOM of the Catalog or Supplier Item. | Conversion Factor for the Bulk UOM of the Catalog or Supplier Item. | The conversion factor of the web
     * item's ordering unit of measure to the linked purchase item's base unit of measure.
     * - base: xsd:decimal
     * - fractionDigits: 9
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 21
     * @var float
     */
    public $Conversion_Factor;
    /**
     * The Default
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether this Unit of Measure is the default UOM.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Default;
    /**
     * The Just_In_Time
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether the Unit Of Measure is applicable for Just In Time.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Just_In_Time;
    /**
     * The Lead_Time
     * Meta information extracted from the WSDL
     * - documentation: Catalog Item Lead Time | Catalog or Supplier Item Lead Time | Lead time for the UOM of the Catalog Item. | Lead time for the UOM of the supplier item. | Lead time for the supplier item | Lead time for the JIT UOM of the Catalog or
     * Supplier Item. For Supplier items, this field can be updated at anytime, but for Catalog Items, this field can only be updated when you enable catalog data and pricing for your purchase items. | Lead time for the Bulk UOM of the Catalog or Supplier
     * Item. For Supplier items, this field can be updated at anytime, but for Catalog Items, this field can only be updated when you enable catalog data and pricing for your purchase items.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Lead_Time;
    /**
     * The Minimum_Order_Quantity
     * Meta information extracted from the WSDL
     * - documentation: Minimum Order Quantity for the UOM for this Catalog Item | The Minimum Order Quantity for a given UOM for the Catalog Item Pricing History. | The minimum quantity per unit of measure for Item. A value of zero means that there is no
     * minimum order quantity. | Supplier requires this minimum quantity to be met when you order in this unit of measure to avoid penalties. If this is for a Just in Time unit of measure, no minimum quantity is allowed. | Minimum order quantity. This field
     * can only be updated for catalog items when you enable catalog data and pricing for your purchase items.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Minimum_Order_Quantity;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether the Unit of Measure is inactive.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * Constructor method for Catalog_Load_Item_Unit_of_Measure_DataType
     * @uses Catalog_Load_Item_Unit_of_Measure_DataType::setCatalog_Load_Item_UOM_Reference()
     * @uses Catalog_Load_Item_Unit_of_Measure_DataType::setUnit_of_Measure_Reference()
     * @uses Catalog_Load_Item_Unit_of_Measure_DataType::setUN_CEFACT_UOM_Code()
     * @uses Catalog_Load_Item_Unit_of_Measure_DataType::setItem_Unit_Price()
     * @uses Catalog_Load_Item_Unit_of_Measure_DataType::setConversion_Factor()
     * @uses Catalog_Load_Item_Unit_of_Measure_DataType::setDefault()
     * @uses Catalog_Load_Item_Unit_of_Measure_DataType::setJust_In_Time()
     * @uses Catalog_Load_Item_Unit_of_Measure_DataType::setLead_Time()
     * @uses Catalog_Load_Item_Unit_of_Measure_DataType::setMinimum_Order_Quantity()
     * @uses Catalog_Load_Item_Unit_of_Measure_DataType::setInactive()
     * @param \StructType\Catalog_Load_Item_Unit_of_MeasureObjectType $catalog_Load_Item_UOM_Reference
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @param string $uN_CEFACT_UOM_Code
     * @param float $item_Unit_Price
     * @param float $conversion_Factor
     * @param bool $default
     * @param bool $just_In_Time
     * @param float $lead_Time
     * @param float $minimum_Order_Quantity
     * @param bool $inactive
     */
    public function __construct(\StructType\Catalog_Load_Item_Unit_of_MeasureObjectType $catalog_Load_Item_UOM_Reference = null, \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null, $uN_CEFACT_UOM_Code = null, $item_Unit_Price = null, $conversion_Factor = null, $default = null, $just_In_Time = null, $lead_Time = null, $minimum_Order_Quantity = null, $inactive = null)
    {
        $this
            ->setCatalog_Load_Item_UOM_Reference($catalog_Load_Item_UOM_Reference)
            ->setUnit_of_Measure_Reference($unit_of_Measure_Reference)
            ->setUN_CEFACT_UOM_Code($uN_CEFACT_UOM_Code)
            ->setItem_Unit_Price($item_Unit_Price)
            ->setConversion_Factor($conversion_Factor)
            ->setDefault($default)
            ->setJust_In_Time($just_In_Time)
            ->setLead_Time($lead_Time)
            ->setMinimum_Order_Quantity($minimum_Order_Quantity)
            ->setInactive($inactive);
    }
    /**
     * Get Catalog_Load_Item_UOM_Reference value
     * @return \StructType\Catalog_Load_Item_Unit_of_MeasureObjectType|null
     */
    public function getCatalog_Load_Item_UOM_Reference()
    {
        return $this->Catalog_Load_Item_UOM_Reference;
    }
    /**
     * Set Catalog_Load_Item_UOM_Reference value
     * @param \StructType\Catalog_Load_Item_Unit_of_MeasureObjectType $catalog_Load_Item_UOM_Reference
     * @return \StructType\Catalog_Load_Item_Unit_of_Measure_DataType
     */
    public function setCatalog_Load_Item_UOM_Reference(\StructType\Catalog_Load_Item_Unit_of_MeasureObjectType $catalog_Load_Item_UOM_Reference = null)
    {
        $this->Catalog_Load_Item_UOM_Reference = $catalog_Load_Item_UOM_Reference;
        return $this;
    }
    /**
     * Get Unit_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getUnit_of_Measure_Reference()
    {
        return isset($this->Unit_of_Measure_Reference) ? $this->Unit_of_Measure_Reference : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUnit_of_Measure_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUnit_of_Measure_Reference method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUnit_of_Measure_ReferenceForChoiceConstraintsFromSetUnit_of_Measure_Reference($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'UN_CEFACT_UOM_Code',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Unit_of_Measure_Reference can\'t be set as the property %s is already set. Only one property must be set among these properties: Unit_of_Measure_Reference, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Unit_of_Measure_Reference value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @return \StructType\Catalog_Load_Item_Unit_of_Measure_DataType
     */
    public function setUnit_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null)
    {
        // validation for constraint: choice(Unit_of_Measure_Reference, UN_CEFACT_UOM_Code)
        if ('' !== ($unit_of_Measure_ReferenceChoiceErrorMessage = self::validateUnit_of_Measure_ReferenceForChoiceConstraintsFromSetUnit_of_Measure_Reference($unit_of_Measure_Reference))) {
            throw new \InvalidArgumentException($unit_of_Measure_ReferenceChoiceErrorMessage, __LINE__);
        }
        if (is_null($unit_of_Measure_Reference) || (is_array($unit_of_Measure_Reference) && empty($unit_of_Measure_Reference))) {
            unset($this->Unit_of_Measure_Reference);
        } else {
            $this->Unit_of_Measure_Reference = $unit_of_Measure_Reference;
        }
        return $this;
    }
    /**
     * Get UN_CEFACT_UOM_Code value
     * @return string|null
     */
    public function getUN_CEFACT_UOM_Code()
    {
        return isset($this->UN_CEFACT_UOM_Code) ? $this->UN_CEFACT_UOM_Code : null;
    }
    /**
     * This method is responsible for validating the value passed to the setUN_CEFACT_UOM_Code method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUN_CEFACT_UOM_Code method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateUN_CEFACT_UOM_CodeForChoiceConstraintsFromSetUN_CEFACT_UOM_Code($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Unit_of_Measure_Reference',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property UN_CEFACT_UOM_Code can\'t be set as the property %s is already set. Only one property must be set among these properties: UN_CEFACT_UOM_Code, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set UN_CEFACT_UOM_Code value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $uN_CEFACT_UOM_Code
     * @return \StructType\Catalog_Load_Item_Unit_of_Measure_DataType
     */
    public function setUN_CEFACT_UOM_Code($uN_CEFACT_UOM_Code = null)
    {
        // validation for constraint: string
        if (!is_null($uN_CEFACT_UOM_Code) && !is_string($uN_CEFACT_UOM_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uN_CEFACT_UOM_Code, true), gettype($uN_CEFACT_UOM_Code)), __LINE__);
        }
        // validation for constraint: choice(Unit_of_Measure_Reference, UN_CEFACT_UOM_Code)
        if ('' !== ($uN_CEFACT_UOM_CodeChoiceErrorMessage = self::validateUN_CEFACT_UOM_CodeForChoiceConstraintsFromSetUN_CEFACT_UOM_Code($uN_CEFACT_UOM_Code))) {
            throw new \InvalidArgumentException($uN_CEFACT_UOM_CodeChoiceErrorMessage, __LINE__);
        }
        if (is_null($uN_CEFACT_UOM_Code) || (is_array($uN_CEFACT_UOM_Code) && empty($uN_CEFACT_UOM_Code))) {
            unset($this->UN_CEFACT_UOM_Code);
        } else {
            $this->UN_CEFACT_UOM_Code = $uN_CEFACT_UOM_Code;
        }
        return $this;
    }
    /**
     * Get Item_Unit_Price value
     * @return float|null
     */
    public function getItem_Unit_Price()
    {
        return $this->Item_Unit_Price;
    }
    /**
     * Set Item_Unit_Price value
     * @param float $item_Unit_Price
     * @return \StructType\Catalog_Load_Item_Unit_of_Measure_DataType
     */
    public function setItem_Unit_Price($item_Unit_Price = null)
    {
        // validation for constraint: float
        if (!is_null($item_Unit_Price) && !(is_float($item_Unit_Price) || is_numeric($item_Unit_Price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($item_Unit_Price, true), gettype($item_Unit_Price)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($item_Unit_Price) && mb_strlen(mb_substr($item_Unit_Price, false !== mb_strpos($item_Unit_Price, '.') ? mb_strpos($item_Unit_Price, '.') + 1 : mb_strlen($item_Unit_Price))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($item_Unit_Price, true), mb_strlen(mb_substr($item_Unit_Price, mb_strpos($item_Unit_Price, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($item_Unit_Price) && mb_strlen(preg_replace('/(\D)/', '', $item_Unit_Price)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($item_Unit_Price, true), mb_strlen(preg_replace('/(\D)/', '', $item_Unit_Price))), __LINE__);
        }
        $this->Item_Unit_Price = $item_Unit_Price;
        return $this;
    }
    /**
     * Get Conversion_Factor value
     * @return float|null
     */
    public function getConversion_Factor()
    {
        return $this->Conversion_Factor;
    }
    /**
     * Set Conversion_Factor value
     * @param float $conversion_Factor
     * @return \StructType\Catalog_Load_Item_Unit_of_Measure_DataType
     */
    public function setConversion_Factor($conversion_Factor = null)
    {
        // validation for constraint: float
        if (!is_null($conversion_Factor) && !(is_float($conversion_Factor) || is_numeric($conversion_Factor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($conversion_Factor, true), gettype($conversion_Factor)), __LINE__);
        }
        // validation for constraint: fractionDigits(9)
        if (!is_null($conversion_Factor) && mb_strlen(mb_substr($conversion_Factor, false !== mb_strpos($conversion_Factor, '.') ? mb_strpos($conversion_Factor, '.') + 1 : mb_strlen($conversion_Factor))) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 9 fraction digits, %d given', var_export($conversion_Factor, true), mb_strlen(mb_substr($conversion_Factor, mb_strpos($conversion_Factor, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($conversion_Factor) && $conversion_Factor < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($conversion_Factor, true)), __LINE__);
        }
        // validation for constraint: totalDigits(21)
        if (!is_null($conversion_Factor) && mb_strlen(preg_replace('/(\D)/', '', $conversion_Factor)) > 21) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 21 digits, "%d" given', var_export($conversion_Factor, true), mb_strlen(preg_replace('/(\D)/', '', $conversion_Factor))), __LINE__);
        }
        $this->Conversion_Factor = $conversion_Factor;
        return $this;
    }
    /**
     * Get Default value
     * @return bool|null
     */
    public function getDefault()
    {
        return $this->Default;
    }
    /**
     * Set Default value
     * @param bool $default
     * @return \StructType\Catalog_Load_Item_Unit_of_Measure_DataType
     */
    public function setDefault($default = null)
    {
        // validation for constraint: boolean
        if (!is_null($default) && !is_bool($default)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($default, true), gettype($default)), __LINE__);
        }
        $this->Default = $default;
        return $this;
    }
    /**
     * Get Just_In_Time value
     * @return bool|null
     */
    public function getJust_In_Time()
    {
        return $this->Just_In_Time;
    }
    /**
     * Set Just_In_Time value
     * @param bool $just_In_Time
     * @return \StructType\Catalog_Load_Item_Unit_of_Measure_DataType
     */
    public function setJust_In_Time($just_In_Time = null)
    {
        // validation for constraint: boolean
        if (!is_null($just_In_Time) && !is_bool($just_In_Time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($just_In_Time, true), gettype($just_In_Time)), __LINE__);
        }
        $this->Just_In_Time = $just_In_Time;
        return $this;
    }
    /**
     * Get Lead_Time value
     * @return float|null
     */
    public function getLead_Time()
    {
        return $this->Lead_Time;
    }
    /**
     * Set Lead_Time value
     * @param float $lead_Time
     * @return \StructType\Catalog_Load_Item_Unit_of_Measure_DataType
     */
    public function setLead_Time($lead_Time = null)
    {
        // validation for constraint: float
        if (!is_null($lead_Time) && !(is_float($lead_Time) || is_numeric($lead_Time))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lead_Time, true), gettype($lead_Time)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($lead_Time) && mb_strlen(mb_substr($lead_Time, false !== mb_strpos($lead_Time, '.') ? mb_strpos($lead_Time, '.') + 1 : mb_strlen($lead_Time))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($lead_Time, true), mb_strlen(mb_substr($lead_Time, mb_strpos($lead_Time, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($lead_Time) && $lead_Time < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($lead_Time, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($lead_Time) && mb_strlen(preg_replace('/(\D)/', '', $lead_Time)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($lead_Time, true), mb_strlen(preg_replace('/(\D)/', '', $lead_Time))), __LINE__);
        }
        $this->Lead_Time = $lead_Time;
        return $this;
    }
    /**
     * Get Minimum_Order_Quantity value
     * @return float|null
     */
    public function getMinimum_Order_Quantity()
    {
        return $this->Minimum_Order_Quantity;
    }
    /**
     * Set Minimum_Order_Quantity value
     * @param float $minimum_Order_Quantity
     * @return \StructType\Catalog_Load_Item_Unit_of_Measure_DataType
     */
    public function setMinimum_Order_Quantity($minimum_Order_Quantity = null)
    {
        // validation for constraint: float
        if (!is_null($minimum_Order_Quantity) && !(is_float($minimum_Order_Quantity) || is_numeric($minimum_Order_Quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minimum_Order_Quantity, true), gettype($minimum_Order_Quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($minimum_Order_Quantity) && mb_strlen(mb_substr($minimum_Order_Quantity, false !== mb_strpos($minimum_Order_Quantity, '.') ? mb_strpos($minimum_Order_Quantity, '.') + 1 : mb_strlen($minimum_Order_Quantity))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($minimum_Order_Quantity, true), mb_strlen(mb_substr($minimum_Order_Quantity, mb_strpos($minimum_Order_Quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($minimum_Order_Quantity) && $minimum_Order_Quantity < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($minimum_Order_Quantity, true)), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($minimum_Order_Quantity) && mb_strlen(preg_replace('/(\D)/', '', $minimum_Order_Quantity)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($minimum_Order_Quantity, true), mb_strlen(preg_replace('/(\D)/', '', $minimum_Order_Quantity))), __LINE__);
        }
        $this->Minimum_Order_Quantity = $minimum_Order_Quantity;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Catalog_Load_Item_Unit_of_Measure_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
}
