<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_Depreciation_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains information about this asset related to depreciation.
 * @subpackage Structs
 */
class Asset_Depreciation_WWS_DataType extends AbstractStructBase
{
    /**
     * The Depreciation_Profile_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the depreciation profile used by this asset.
     * - minOccurs: 0
     * @var \StructType\Depreciation_ProfileObjectType
     */
    public $Depreciation_Profile_Reference;
    /**
     * The Depreciation_Method_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the depreciation method used by this asset, e.g. Straight Line, Sum of Years Digits
     * - minOccurs: 0
     * @var \StructType\Abstract_Depreciation_MethodObjectType
     */
    public $Depreciation_Method_Reference;
    /**
     * The Depreciation_Posting_Frequency_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the depreciation posting frequency for this asset.
     * - minOccurs: 0
     * @var \StructType\Depreciation_Posting_FrequencyObjectType
     */
    public $Depreciation_Posting_Frequency_Reference;
    /**
     * The Depreciation_Convention_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the depreciation convention for this asset, e.g. Current Period, Mid-Month
     * - minOccurs: 0
     * @var \StructType\Depreciation_ConventionObjectType
     */
    public $Depreciation_Convention_Reference;
    /**
     * The Depreciation_Start_Based_On_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to an indicator for when depreciation starts for this asset, e.g. Upon Acquisition, Manually/When Issued
     * - minOccurs: 0
     * @var \StructType\Abstract_Place_In_Service_Based_OnObjectType
     */
    public $Depreciation_Start_Based_On_Reference;
    /**
     * The Depreciation_Rate_Basis_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the rate bases for depreciation, e.g. Periods, Number of Days
     * - minOccurs: 0
     * @var \StructType\Depreciation_Rate_BasisObjectType
     */
    public $Depreciation_Rate_Basis_Reference;
    /**
     * The Depreciation_Start_Date
     * Meta information extracted from the WSDL
     * - documentation: The date depreciation started for this asset.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Depreciation_Start_Date;
    /**
     * The Useful_Life
     * Meta information extracted from the WSDL
     * - documentation: New value for useful life in periods | Useful Life cannot be more than 200 years. Useful life in years is useful life in periods divided by number of periods in the company's fiscal year. | When depreciation is based on the number of
     * days per period, all the fiscal years / periods for an asset's useful life must already be created in order to calculate the depreciation amount for each period correctly. In order to complete the accounting setup for this asset, you will first need
     * to create additional fiscal years / periods for the fiscal schedule of this asset's company. | The useful life, in periods, for this asset. | The new useful life for reclassification activity. Value is 0 if useful life did not change
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Useful_Life;
    /**
     * The Depreciation_Percent
     * Meta information extracted from the WSDL
     * - documentation: The depreciation percent for this asset. | Numeric value representing the depreciation percent for Declining Balance with Switch to Straight Line method. It is required when the depreciation method is declining balance. It left
     * blank, it will be defaulted from the depreciation profile. | Depreciation percent must be zero unless you are using Declining Balance or Declining Balance Switch to Straight Line Depreciation Methods. | Depreciation percent should be greater than 100
     * when the depreciation method is Declining Balance Switch to SL. | Depreciation percent must be greater than 0 and less than 100 when the depreciation method is Declining Balance. | Enter Depreciation Percent when overriding depreciation profile
     * information and depreciation method is Declining Balance (with and without switch to Straight Line).
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Depreciation_Percent;
    /**
     * The Depreciation_Threshold
     * Meta information extracted from the WSDL
     * - documentation: The depreciation threshold for this asset. | Depreciation Threshold. Enter only if method is declining balance. | Only Declining Balance Depreciation Method can have a threshold. | Declining Balance Depreciation Method must have a
     * threshold. | Depreciation Threshold is greater than Total Asset Cost.
     * - base: xsd:decimal
     * - fractionDigits: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 30
     * @var float
     */
    public $Depreciation_Threshold;
    /**
     * The Depreciation_Start_Date_At_Registration
     * Meta information extracted from the WSDL
     * - documentation: The deprecation start date as indicated for a converted asset when it was registered.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Depreciation_Start_Date_At_Registration;
    /**
     * The Accumulated_Depreciation_At_Registration
     * Meta information extracted from the WSDL
     * - documentation: The accumulated depreication as indicated for a converted asset when it was registered.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Accumulated_Depreciation_At_Registration;
    /**
     * The Remaining_Useful_Life_At_Registration
     * Meta information extracted from the WSDL
     * - documentation: The remaining useful life as indicated for a converted asset when it was registered.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Remaining_Useful_Life_At_Registration;
    /**
     * The Max_Bonus_Depreciable_Basis
     * Meta information extracted from the WSDL
     * - documentation: The maximum allowable bonus depreciation that can be taken for a particular asset, i.e. the upper limit for depreciation. | Numeric value representing the maximum bonus depreciation basis. Workday would use the lesser of this field
     * and asset cost that is applicable to bonus depreciation to calculated the bonus amount. | Max Depreciable Basis must be 0 when accounting treatment is not depreciable capital | The max bonus depreciable basis entered has too many digits beyond the
     * decimal point
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Max_Bonus_Depreciable_Basis;
    /**
     * The Bonus_Depreciation_Percent
     * Meta information extracted from the WSDL
     * - documentation: The percentage that will be used to calculate the depreciable basis for bonus depreciation. | Numeric value representing bonus depreciation percent for this asset depreciation schedule. Value cannot be more than 100. | Bonus
     * depreciation percent must be 0 when accounting treatment is not depreciable capital | Bonus depreciation percent cannot be more than 100
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 14
     * @var float
     */
    public $Bonus_Depreciation_Percent;
    /**
     * The Historical_Bonus_Depreciation_for_Depreciation_Schedule
     * Meta information extracted from the WSDL
     * - documentation: The total amount of bonus depreciation recorded for the asset.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Historical_Bonus_Depreciation_for_Depreciation_Schedule;
    /**
     * Constructor method for Asset_Depreciation_WWS_DataType
     * @uses Asset_Depreciation_WWS_DataType::setDepreciation_Profile_Reference()
     * @uses Asset_Depreciation_WWS_DataType::setDepreciation_Method_Reference()
     * @uses Asset_Depreciation_WWS_DataType::setDepreciation_Posting_Frequency_Reference()
     * @uses Asset_Depreciation_WWS_DataType::setDepreciation_Convention_Reference()
     * @uses Asset_Depreciation_WWS_DataType::setDepreciation_Start_Based_On_Reference()
     * @uses Asset_Depreciation_WWS_DataType::setDepreciation_Rate_Basis_Reference()
     * @uses Asset_Depreciation_WWS_DataType::setDepreciation_Start_Date()
     * @uses Asset_Depreciation_WWS_DataType::setUseful_Life()
     * @uses Asset_Depreciation_WWS_DataType::setDepreciation_Percent()
     * @uses Asset_Depreciation_WWS_DataType::setDepreciation_Threshold()
     * @uses Asset_Depreciation_WWS_DataType::setDepreciation_Start_Date_At_Registration()
     * @uses Asset_Depreciation_WWS_DataType::setAccumulated_Depreciation_At_Registration()
     * @uses Asset_Depreciation_WWS_DataType::setRemaining_Useful_Life_At_Registration()
     * @uses Asset_Depreciation_WWS_DataType::setMax_Bonus_Depreciable_Basis()
     * @uses Asset_Depreciation_WWS_DataType::setBonus_Depreciation_Percent()
     * @uses Asset_Depreciation_WWS_DataType::setHistorical_Bonus_Depreciation_for_Depreciation_Schedule()
     * @param \StructType\Depreciation_ProfileObjectType $depreciation_Profile_Reference
     * @param \StructType\Abstract_Depreciation_MethodObjectType $depreciation_Method_Reference
     * @param \StructType\Depreciation_Posting_FrequencyObjectType $depreciation_Posting_Frequency_Reference
     * @param \StructType\Depreciation_ConventionObjectType $depreciation_Convention_Reference
     * @param \StructType\Abstract_Place_In_Service_Based_OnObjectType $depreciation_Start_Based_On_Reference
     * @param \StructType\Depreciation_Rate_BasisObjectType $depreciation_Rate_Basis_Reference
     * @param string $depreciation_Start_Date
     * @param float $useful_Life
     * @param float $depreciation_Percent
     * @param float $depreciation_Threshold
     * @param string $depreciation_Start_Date_At_Registration
     * @param float $accumulated_Depreciation_At_Registration
     * @param float $remaining_Useful_Life_At_Registration
     * @param float $max_Bonus_Depreciable_Basis
     * @param float $bonus_Depreciation_Percent
     * @param float $historical_Bonus_Depreciation_for_Depreciation_Schedule
     */
    public function __construct(\StructType\Depreciation_ProfileObjectType $depreciation_Profile_Reference = null, \StructType\Abstract_Depreciation_MethodObjectType $depreciation_Method_Reference = null, \StructType\Depreciation_Posting_FrequencyObjectType $depreciation_Posting_Frequency_Reference = null, \StructType\Depreciation_ConventionObjectType $depreciation_Convention_Reference = null, \StructType\Abstract_Place_In_Service_Based_OnObjectType $depreciation_Start_Based_On_Reference = null, \StructType\Depreciation_Rate_BasisObjectType $depreciation_Rate_Basis_Reference = null, $depreciation_Start_Date = null, $useful_Life = null, $depreciation_Percent = null, $depreciation_Threshold = null, $depreciation_Start_Date_At_Registration = null, $accumulated_Depreciation_At_Registration = null, $remaining_Useful_Life_At_Registration = null, $max_Bonus_Depreciable_Basis = null, $bonus_Depreciation_Percent = null, $historical_Bonus_Depreciation_for_Depreciation_Schedule = null)
    {
        $this
            ->setDepreciation_Profile_Reference($depreciation_Profile_Reference)
            ->setDepreciation_Method_Reference($depreciation_Method_Reference)
            ->setDepreciation_Posting_Frequency_Reference($depreciation_Posting_Frequency_Reference)
            ->setDepreciation_Convention_Reference($depreciation_Convention_Reference)
            ->setDepreciation_Start_Based_On_Reference($depreciation_Start_Based_On_Reference)
            ->setDepreciation_Rate_Basis_Reference($depreciation_Rate_Basis_Reference)
            ->setDepreciation_Start_Date($depreciation_Start_Date)
            ->setUseful_Life($useful_Life)
            ->setDepreciation_Percent($depreciation_Percent)
            ->setDepreciation_Threshold($depreciation_Threshold)
            ->setDepreciation_Start_Date_At_Registration($depreciation_Start_Date_At_Registration)
            ->setAccumulated_Depreciation_At_Registration($accumulated_Depreciation_At_Registration)
            ->setRemaining_Useful_Life_At_Registration($remaining_Useful_Life_At_Registration)
            ->setMax_Bonus_Depreciable_Basis($max_Bonus_Depreciable_Basis)
            ->setBonus_Depreciation_Percent($bonus_Depreciation_Percent)
            ->setHistorical_Bonus_Depreciation_for_Depreciation_Schedule($historical_Bonus_Depreciation_for_Depreciation_Schedule);
    }
    /**
     * Get Depreciation_Profile_Reference value
     * @return \StructType\Depreciation_ProfileObjectType|null
     */
    public function getDepreciation_Profile_Reference()
    {
        return $this->Depreciation_Profile_Reference;
    }
    /**
     * Set Depreciation_Profile_Reference value
     * @param \StructType\Depreciation_ProfileObjectType $depreciation_Profile_Reference
     * @return \StructType\Asset_Depreciation_WWS_DataType
     */
    public function setDepreciation_Profile_Reference(\StructType\Depreciation_ProfileObjectType $depreciation_Profile_Reference = null)
    {
        $this->Depreciation_Profile_Reference = $depreciation_Profile_Reference;
        return $this;
    }
    /**
     * Get Depreciation_Method_Reference value
     * @return \StructType\Abstract_Depreciation_MethodObjectType|null
     */
    public function getDepreciation_Method_Reference()
    {
        return $this->Depreciation_Method_Reference;
    }
    /**
     * Set Depreciation_Method_Reference value
     * @param \StructType\Abstract_Depreciation_MethodObjectType $depreciation_Method_Reference
     * @return \StructType\Asset_Depreciation_WWS_DataType
     */
    public function setDepreciation_Method_Reference(\StructType\Abstract_Depreciation_MethodObjectType $depreciation_Method_Reference = null)
    {
        $this->Depreciation_Method_Reference = $depreciation_Method_Reference;
        return $this;
    }
    /**
     * Get Depreciation_Posting_Frequency_Reference value
     * @return \StructType\Depreciation_Posting_FrequencyObjectType|null
     */
    public function getDepreciation_Posting_Frequency_Reference()
    {
        return $this->Depreciation_Posting_Frequency_Reference;
    }
    /**
     * Set Depreciation_Posting_Frequency_Reference value
     * @param \StructType\Depreciation_Posting_FrequencyObjectType $depreciation_Posting_Frequency_Reference
     * @return \StructType\Asset_Depreciation_WWS_DataType
     */
    public function setDepreciation_Posting_Frequency_Reference(\StructType\Depreciation_Posting_FrequencyObjectType $depreciation_Posting_Frequency_Reference = null)
    {
        $this->Depreciation_Posting_Frequency_Reference = $depreciation_Posting_Frequency_Reference;
        return $this;
    }
    /**
     * Get Depreciation_Convention_Reference value
     * @return \StructType\Depreciation_ConventionObjectType|null
     */
    public function getDepreciation_Convention_Reference()
    {
        return $this->Depreciation_Convention_Reference;
    }
    /**
     * Set Depreciation_Convention_Reference value
     * @param \StructType\Depreciation_ConventionObjectType $depreciation_Convention_Reference
     * @return \StructType\Asset_Depreciation_WWS_DataType
     */
    public function setDepreciation_Convention_Reference(\StructType\Depreciation_ConventionObjectType $depreciation_Convention_Reference = null)
    {
        $this->Depreciation_Convention_Reference = $depreciation_Convention_Reference;
        return $this;
    }
    /**
     * Get Depreciation_Start_Based_On_Reference value
     * @return \StructType\Abstract_Place_In_Service_Based_OnObjectType|null
     */
    public function getDepreciation_Start_Based_On_Reference()
    {
        return $this->Depreciation_Start_Based_On_Reference;
    }
    /**
     * Set Depreciation_Start_Based_On_Reference value
     * @param \StructType\Abstract_Place_In_Service_Based_OnObjectType $depreciation_Start_Based_On_Reference
     * @return \StructType\Asset_Depreciation_WWS_DataType
     */
    public function setDepreciation_Start_Based_On_Reference(\StructType\Abstract_Place_In_Service_Based_OnObjectType $depreciation_Start_Based_On_Reference = null)
    {
        $this->Depreciation_Start_Based_On_Reference = $depreciation_Start_Based_On_Reference;
        return $this;
    }
    /**
     * Get Depreciation_Rate_Basis_Reference value
     * @return \StructType\Depreciation_Rate_BasisObjectType|null
     */
    public function getDepreciation_Rate_Basis_Reference()
    {
        return $this->Depreciation_Rate_Basis_Reference;
    }
    /**
     * Set Depreciation_Rate_Basis_Reference value
     * @param \StructType\Depreciation_Rate_BasisObjectType $depreciation_Rate_Basis_Reference
     * @return \StructType\Asset_Depreciation_WWS_DataType
     */
    public function setDepreciation_Rate_Basis_Reference(\StructType\Depreciation_Rate_BasisObjectType $depreciation_Rate_Basis_Reference = null)
    {
        $this->Depreciation_Rate_Basis_Reference = $depreciation_Rate_Basis_Reference;
        return $this;
    }
    /**
     * Get Depreciation_Start_Date value
     * @return string|null
     */
    public function getDepreciation_Start_Date()
    {
        return $this->Depreciation_Start_Date;
    }
    /**
     * Set Depreciation_Start_Date value
     * @param string $depreciation_Start_Date
     * @return \StructType\Asset_Depreciation_WWS_DataType
     */
    public function setDepreciation_Start_Date($depreciation_Start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($depreciation_Start_Date) && !is_string($depreciation_Start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depreciation_Start_Date, true), gettype($depreciation_Start_Date)), __LINE__);
        }
        $this->Depreciation_Start_Date = $depreciation_Start_Date;
        return $this;
    }
    /**
     * Get Useful_Life value
     * @return float|null
     */
    public function getUseful_Life()
    {
        return $this->Useful_Life;
    }
    /**
     * Set Useful_Life value
     * @param float $useful_Life
     * @return \StructType\Asset_Depreciation_WWS_DataType
     */
    public function setUseful_Life($useful_Life = null)
    {
        // validation for constraint: float
        if (!is_null($useful_Life) && !(is_float($useful_Life) || is_numeric($useful_Life))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($useful_Life, true), gettype($useful_Life)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($useful_Life) && mb_strlen(mb_substr($useful_Life, false !== mb_strpos($useful_Life, '.') ? mb_strpos($useful_Life, '.') + 1 : mb_strlen($useful_Life))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($useful_Life, true), mb_strlen(mb_substr($useful_Life, mb_strpos($useful_Life, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($useful_Life) && $useful_Life < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($useful_Life, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($useful_Life) && mb_strlen(preg_replace('/(\D)/', '', $useful_Life)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($useful_Life, true), mb_strlen(preg_replace('/(\D)/', '', $useful_Life))), __LINE__);
        }
        $this->Useful_Life = $useful_Life;
        return $this;
    }
    /**
     * Get Depreciation_Percent value
     * @return float|null
     */
    public function getDepreciation_Percent()
    {
        return $this->Depreciation_Percent;
    }
    /**
     * Set Depreciation_Percent value
     * @param float $depreciation_Percent
     * @return \StructType\Asset_Depreciation_WWS_DataType
     */
    public function setDepreciation_Percent($depreciation_Percent = null)
    {
        // validation for constraint: float
        if (!is_null($depreciation_Percent) && !(is_float($depreciation_Percent) || is_numeric($depreciation_Percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($depreciation_Percent, true), gettype($depreciation_Percent)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($depreciation_Percent) && mb_strlen(mb_substr($depreciation_Percent, false !== mb_strpos($depreciation_Percent, '.') ? mb_strpos($depreciation_Percent, '.') + 1 : mb_strlen($depreciation_Percent))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($depreciation_Percent, true), mb_strlen(mb_substr($depreciation_Percent, mb_strpos($depreciation_Percent, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($depreciation_Percent) && mb_strlen(preg_replace('/(\D)/', '', $depreciation_Percent)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($depreciation_Percent, true), mb_strlen(preg_replace('/(\D)/', '', $depreciation_Percent))), __LINE__);
        }
        $this->Depreciation_Percent = $depreciation_Percent;
        return $this;
    }
    /**
     * Get Depreciation_Threshold value
     * @return float|null
     */
    public function getDepreciation_Threshold()
    {
        return $this->Depreciation_Threshold;
    }
    /**
     * Set Depreciation_Threshold value
     * @param float $depreciation_Threshold
     * @return \StructType\Asset_Depreciation_WWS_DataType
     */
    public function setDepreciation_Threshold($depreciation_Threshold = null)
    {
        // validation for constraint: float
        if (!is_null($depreciation_Threshold) && !(is_float($depreciation_Threshold) || is_numeric($depreciation_Threshold))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($depreciation_Threshold, true), gettype($depreciation_Threshold)), __LINE__);
        }
        // validation for constraint: fractionDigits(10)
        if (!is_null($depreciation_Threshold) && mb_strlen(mb_substr($depreciation_Threshold, false !== mb_strpos($depreciation_Threshold, '.') ? mb_strpos($depreciation_Threshold, '.') + 1 : mb_strlen($depreciation_Threshold))) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 10 fraction digits, %d given', var_export($depreciation_Threshold, true), mb_strlen(mb_substr($depreciation_Threshold, mb_strpos($depreciation_Threshold, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(30)
        if (!is_null($depreciation_Threshold) && mb_strlen(preg_replace('/(\D)/', '', $depreciation_Threshold)) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 30 digits, "%d" given', var_export($depreciation_Threshold, true), mb_strlen(preg_replace('/(\D)/', '', $depreciation_Threshold))), __LINE__);
        }
        $this->Depreciation_Threshold = $depreciation_Threshold;
        return $this;
    }
    /**
     * Get Depreciation_Start_Date_At_Registration value
     * @return string|null
     */
    public function getDepreciation_Start_Date_At_Registration()
    {
        return $this->Depreciation_Start_Date_At_Registration;
    }
    /**
     * Set Depreciation_Start_Date_At_Registration value
     * @param string $depreciation_Start_Date_At_Registration
     * @return \StructType\Asset_Depreciation_WWS_DataType
     */
    public function setDepreciation_Start_Date_At_Registration($depreciation_Start_Date_At_Registration = null)
    {
        // validation for constraint: string
        if (!is_null($depreciation_Start_Date_At_Registration) && !is_string($depreciation_Start_Date_At_Registration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depreciation_Start_Date_At_Registration, true), gettype($depreciation_Start_Date_At_Registration)), __LINE__);
        }
        $this->Depreciation_Start_Date_At_Registration = $depreciation_Start_Date_At_Registration;
        return $this;
    }
    /**
     * Get Accumulated_Depreciation_At_Registration value
     * @return float|null
     */
    public function getAccumulated_Depreciation_At_Registration()
    {
        return $this->Accumulated_Depreciation_At_Registration;
    }
    /**
     * Set Accumulated_Depreciation_At_Registration value
     * @param float $accumulated_Depreciation_At_Registration
     * @return \StructType\Asset_Depreciation_WWS_DataType
     */
    public function setAccumulated_Depreciation_At_Registration($accumulated_Depreciation_At_Registration = null)
    {
        // validation for constraint: float
        if (!is_null($accumulated_Depreciation_At_Registration) && !(is_float($accumulated_Depreciation_At_Registration) || is_numeric($accumulated_Depreciation_At_Registration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($accumulated_Depreciation_At_Registration, true), gettype($accumulated_Depreciation_At_Registration)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($accumulated_Depreciation_At_Registration) && mb_strlen(mb_substr($accumulated_Depreciation_At_Registration, false !== mb_strpos($accumulated_Depreciation_At_Registration, '.') ? mb_strpos($accumulated_Depreciation_At_Registration, '.') + 1 : mb_strlen($accumulated_Depreciation_At_Registration))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($accumulated_Depreciation_At_Registration, true), mb_strlen(mb_substr($accumulated_Depreciation_At_Registration, mb_strpos($accumulated_Depreciation_At_Registration, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($accumulated_Depreciation_At_Registration) && mb_strlen(preg_replace('/(\D)/', '', $accumulated_Depreciation_At_Registration)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($accumulated_Depreciation_At_Registration, true), mb_strlen(preg_replace('/(\D)/', '', $accumulated_Depreciation_At_Registration))), __LINE__);
        }
        $this->Accumulated_Depreciation_At_Registration = $accumulated_Depreciation_At_Registration;
        return $this;
    }
    /**
     * Get Remaining_Useful_Life_At_Registration value
     * @return float|null
     */
    public function getRemaining_Useful_Life_At_Registration()
    {
        return $this->Remaining_Useful_Life_At_Registration;
    }
    /**
     * Set Remaining_Useful_Life_At_Registration value
     * @param float $remaining_Useful_Life_At_Registration
     * @return \StructType\Asset_Depreciation_WWS_DataType
     */
    public function setRemaining_Useful_Life_At_Registration($remaining_Useful_Life_At_Registration = null)
    {
        // validation for constraint: float
        if (!is_null($remaining_Useful_Life_At_Registration) && !(is_float($remaining_Useful_Life_At_Registration) || is_numeric($remaining_Useful_Life_At_Registration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($remaining_Useful_Life_At_Registration, true), gettype($remaining_Useful_Life_At_Registration)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($remaining_Useful_Life_At_Registration) && mb_strlen(mb_substr($remaining_Useful_Life_At_Registration, false !== mb_strpos($remaining_Useful_Life_At_Registration, '.') ? mb_strpos($remaining_Useful_Life_At_Registration, '.') + 1 : mb_strlen($remaining_Useful_Life_At_Registration))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($remaining_Useful_Life_At_Registration, true), mb_strlen(mb_substr($remaining_Useful_Life_At_Registration, mb_strpos($remaining_Useful_Life_At_Registration, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($remaining_Useful_Life_At_Registration) && $remaining_Useful_Life_At_Registration < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($remaining_Useful_Life_At_Registration, true)), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($remaining_Useful_Life_At_Registration) && mb_strlen(preg_replace('/(\D)/', '', $remaining_Useful_Life_At_Registration)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($remaining_Useful_Life_At_Registration, true), mb_strlen(preg_replace('/(\D)/', '', $remaining_Useful_Life_At_Registration))), __LINE__);
        }
        $this->Remaining_Useful_Life_At_Registration = $remaining_Useful_Life_At_Registration;
        return $this;
    }
    /**
     * Get Max_Bonus_Depreciable_Basis value
     * @return float|null
     */
    public function getMax_Bonus_Depreciable_Basis()
    {
        return $this->Max_Bonus_Depreciable_Basis;
    }
    /**
     * Set Max_Bonus_Depreciable_Basis value
     * @param float $max_Bonus_Depreciable_Basis
     * @return \StructType\Asset_Depreciation_WWS_DataType
     */
    public function setMax_Bonus_Depreciable_Basis($max_Bonus_Depreciable_Basis = null)
    {
        // validation for constraint: float
        if (!is_null($max_Bonus_Depreciable_Basis) && !(is_float($max_Bonus_Depreciable_Basis) || is_numeric($max_Bonus_Depreciable_Basis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($max_Bonus_Depreciable_Basis, true), gettype($max_Bonus_Depreciable_Basis)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($max_Bonus_Depreciable_Basis) && mb_strlen(mb_substr($max_Bonus_Depreciable_Basis, false !== mb_strpos($max_Bonus_Depreciable_Basis, '.') ? mb_strpos($max_Bonus_Depreciable_Basis, '.') + 1 : mb_strlen($max_Bonus_Depreciable_Basis))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($max_Bonus_Depreciable_Basis, true), mb_strlen(mb_substr($max_Bonus_Depreciable_Basis, mb_strpos($max_Bonus_Depreciable_Basis, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($max_Bonus_Depreciable_Basis) && mb_strlen(preg_replace('/(\D)/', '', $max_Bonus_Depreciable_Basis)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($max_Bonus_Depreciable_Basis, true), mb_strlen(preg_replace('/(\D)/', '', $max_Bonus_Depreciable_Basis))), __LINE__);
        }
        $this->Max_Bonus_Depreciable_Basis = $max_Bonus_Depreciable_Basis;
        return $this;
    }
    /**
     * Get Bonus_Depreciation_Percent value
     * @return float|null
     */
    public function getBonus_Depreciation_Percent()
    {
        return $this->Bonus_Depreciation_Percent;
    }
    /**
     * Set Bonus_Depreciation_Percent value
     * @param float $bonus_Depreciation_Percent
     * @return \StructType\Asset_Depreciation_WWS_DataType
     */
    public function setBonus_Depreciation_Percent($bonus_Depreciation_Percent = null)
    {
        // validation for constraint: float
        if (!is_null($bonus_Depreciation_Percent) && !(is_float($bonus_Depreciation_Percent) || is_numeric($bonus_Depreciation_Percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bonus_Depreciation_Percent, true), gettype($bonus_Depreciation_Percent)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($bonus_Depreciation_Percent) && mb_strlen(mb_substr($bonus_Depreciation_Percent, false !== mb_strpos($bonus_Depreciation_Percent, '.') ? mb_strpos($bonus_Depreciation_Percent, '.') + 1 : mb_strlen($bonus_Depreciation_Percent))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($bonus_Depreciation_Percent, true), mb_strlen(mb_substr($bonus_Depreciation_Percent, mb_strpos($bonus_Depreciation_Percent, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($bonus_Depreciation_Percent) && $bonus_Depreciation_Percent < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($bonus_Depreciation_Percent, true)), __LINE__);
        }
        // validation for constraint: totalDigits(14)
        if (!is_null($bonus_Depreciation_Percent) && mb_strlen(preg_replace('/(\D)/', '', $bonus_Depreciation_Percent)) > 14) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 14 digits, "%d" given', var_export($bonus_Depreciation_Percent, true), mb_strlen(preg_replace('/(\D)/', '', $bonus_Depreciation_Percent))), __LINE__);
        }
        $this->Bonus_Depreciation_Percent = $bonus_Depreciation_Percent;
        return $this;
    }
    /**
     * Get Historical_Bonus_Depreciation_for_Depreciation_Schedule value
     * @return float|null
     */
    public function getHistorical_Bonus_Depreciation_for_Depreciation_Schedule()
    {
        return $this->Historical_Bonus_Depreciation_for_Depreciation_Schedule;
    }
    /**
     * Set Historical_Bonus_Depreciation_for_Depreciation_Schedule value
     * @param float $historical_Bonus_Depreciation_for_Depreciation_Schedule
     * @return \StructType\Asset_Depreciation_WWS_DataType
     */
    public function setHistorical_Bonus_Depreciation_for_Depreciation_Schedule($historical_Bonus_Depreciation_for_Depreciation_Schedule = null)
    {
        // validation for constraint: float
        if (!is_null($historical_Bonus_Depreciation_for_Depreciation_Schedule) && !(is_float($historical_Bonus_Depreciation_for_Depreciation_Schedule) || is_numeric($historical_Bonus_Depreciation_for_Depreciation_Schedule))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($historical_Bonus_Depreciation_for_Depreciation_Schedule, true), gettype($historical_Bonus_Depreciation_for_Depreciation_Schedule)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($historical_Bonus_Depreciation_for_Depreciation_Schedule) && mb_strlen(mb_substr($historical_Bonus_Depreciation_for_Depreciation_Schedule, false !== mb_strpos($historical_Bonus_Depreciation_for_Depreciation_Schedule, '.') ? mb_strpos($historical_Bonus_Depreciation_for_Depreciation_Schedule, '.') + 1 : mb_strlen($historical_Bonus_Depreciation_for_Depreciation_Schedule))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($historical_Bonus_Depreciation_for_Depreciation_Schedule, true), mb_strlen(mb_substr($historical_Bonus_Depreciation_for_Depreciation_Schedule, mb_strpos($historical_Bonus_Depreciation_for_Depreciation_Schedule, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($historical_Bonus_Depreciation_for_Depreciation_Schedule) && mb_strlen(preg_replace('/(\D)/', '', $historical_Bonus_Depreciation_for_Depreciation_Schedule)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($historical_Bonus_Depreciation_for_Depreciation_Schedule, true), mb_strlen(preg_replace('/(\D)/', '', $historical_Bonus_Depreciation_for_Depreciation_Schedule))), __LINE__);
        }
        $this->Historical_Bonus_Depreciation_for_Depreciation_Schedule = $historical_Bonus_Depreciation_for_Depreciation_Schedule;
        return $this;
    }
}
